/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelinput;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.playlist.FilePlayListAll;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.spreadsheet.IKCell;
import org.apache.hop.core.spreadsheet.IKSheet;
import org.apache.hop.core.spreadsheet.KCellType;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.errorhandling.CompositeFileErrorHandler;
import org.apache.hop.pipeline.transform.errorhandling.FileErrorHandlerContentLineNumber;
import org.apache.hop.pipeline.transform.errorhandling.FileErrorHandlerMissingFiles;
import org.apache.hop.pipeline.transforms.excelinput.ExcelInputData;
import org.apache.hop.pipeline.transforms.excelinput.ExcelInputField;
import org.apache.hop.pipeline.transforms.excelinput.ExcelInputMeta;
import org.apache.hop.pipeline.transforms.excelinput.ExcelInputRow;
import org.apache.hop.pipeline.transforms.excelinput.HopCellValueException;
import org.apache.hop.pipeline.transforms.excelinput.WorkbookFactory;
import org.apache.poi.openxml4j.util.ZipSecureFile;

public class ExcelInput
extends BaseTransform<ExcelInputMeta, ExcelInputData>
implements ITransform<ExcelInputMeta, ExcelInputData> {
    private static final Class<?> PKG = ExcelInputMeta.class;

    public ExcelInput(TransformMeta transformMeta, ExcelInputMeta meta, ExcelInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
        this.setZipBombConfiguration();
    }

    private Object[] fillRow(int startcolumn, ExcelInputRow excelInputRow) throws HopException {
        Object[] r = new Object[((ExcelInputData)this.data).outputRowMeta.size()];
        boolean errorHandled = false;
        IKCell cell = null;
        for (int i = startcolumn; i < excelInputRow.cells.length && i - startcolumn < ((ExcelInputMeta)this.meta).getField().length; ++i) {
            IValueMeta sourceMeta;
            IValueMeta targetMeta;
            int rowcolumn;
            block43: {
                cell = excelInputRow.cells[i];
                rowcolumn = i - startcolumn;
                if (cell == null) {
                    r[rowcolumn] = null;
                    continue;
                }
                targetMeta = ((ExcelInputData)this.data).outputRowMeta.getValueMeta(rowcolumn);
                sourceMeta = null;
                try {
                    this.checkType(cell, targetMeta);
                }
                catch (HopException ex2) {
                    if (!((ExcelInputMeta)this.meta).isErrorIgnored()) {
                        HopCellValueException ex2 = new HopCellValueException(ex2, ((ExcelInputData)this.data).sheetnr, ((ExcelInputData)this.data).rownr, i, "");
                        throw ex2;
                    }
                    if (this.log.isBasic()) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"ExcelInput.Log.WarningProcessingExcelFile", (String[])new String[]{"" + targetMeta, "" + ((ExcelInputData)this.data).filename, ex2.getMessage()}));
                    }
                    if (!errorHandled) {
                        ((ExcelInputData)this.data).errorHandler.handleLineError((long)excelInputRow.rownr, excelInputRow.sheetName);
                        errorHandled = true;
                    }
                    if (!((ExcelInputMeta)this.meta).isErrorLineSkipped()) break block43;
                    return null;
                }
            }
            KCellType cellType = cell.getType();
            if (KCellType.BOOLEAN == cellType || KCellType.BOOLEAN_FORMULA == cellType) {
                r[rowcolumn] = cell.getValue();
                sourceMeta = ((ExcelInputData)this.data).valueMetaBoolean;
            } else if (KCellType.DATE.equals((Object)cellType) || KCellType.DATE_FORMULA.equals((Object)cellType)) {
                Date date = (Date)cell.getValue();
                long time = date.getTime();
                int offset = TimeZone.getDefault().getOffset(time);
                r[rowcolumn] = new Date(time - (long)offset);
                sourceMeta = ((ExcelInputData)this.data).valueMetaDate;
            } else if (KCellType.LABEL == cellType || KCellType.STRING_FORMULA == cellType) {
                String string = (String)cell.getValue();
                switch (((ExcelInputMeta)this.meta).getField()[rowcolumn].getTrimType()) {
                    case 1: {
                        string = Const.ltrim((String)string);
                        break;
                    }
                    case 2: {
                        string = Const.rtrim((String)string);
                        break;
                    }
                    case 3: {
                        string = Const.trim((String)string);
                        break;
                    }
                }
                r[rowcolumn] = string;
                sourceMeta = ((ExcelInputData)this.data).valueMetaString;
            } else if (KCellType.NUMBER == cellType || KCellType.NUMBER_FORMULA == cellType) {
                r[rowcolumn] = cell.getValue();
                sourceMeta = ((ExcelInputData)this.data).valueMetaNumber;
            } else {
                if (this.log.isDetailed()) {
                    KCellType ct = cell.getType();
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelInput.Log.UnknownType", (String[])new String[]{ct != null ? ct.toString() : "null", cell.getContents()}));
                }
                r[rowcolumn] = null;
            }
            ExcelInputField field = ((ExcelInputMeta)this.meta).getField()[rowcolumn];
            try {
                if (sourceMeta == null || sourceMeta.getType() == targetMeta.getType() || r[rowcolumn] == null) continue;
                IValueMeta sourceMetaCopy = sourceMeta.clone();
                sourceMetaCopy.setConversionMask(field.getFormat());
                sourceMetaCopy.setGroupingSymbol(field.getGroupSymbol());
                sourceMetaCopy.setDecimalSymbol(field.getDecimalSymbol());
                sourceMetaCopy.setCurrencySymbol(field.getCurrencySymbol());
                switch (targetMeta.getType()) {
                    case 1: 
                    case 5: {
                        if (field.getType() == 3) {
                            ValueMetaNumber valueMetaNumber = new ValueMetaNumber("num");
                            valueMetaNumber.setConversionMask("#");
                            Object string = sourceMetaCopy.convertData((IValueMeta)valueMetaNumber, r[rowcolumn]);
                            r[rowcolumn] = targetMeta.convertData(sourceMetaCopy, string);
                            break;
                        }
                        r[rowcolumn] = targetMeta.convertData(sourceMetaCopy, r[rowcolumn]);
                        break;
                    }
                    default: {
                        r[rowcolumn] = targetMeta.convertData(sourceMetaCopy, r[rowcolumn]);
                    }
                }
                continue;
            }
            catch (HopException ex3) {
                if (!((ExcelInputMeta)this.meta).isErrorIgnored()) {
                    HopCellValueException ex3 = new HopCellValueException(ex3, ((ExcelInputData)this.data).sheetnr, cell.getRow(), i, field.getName());
                    throw ex3;
                }
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ExcelInput.Log.WarningProcessingExcelFile", (String[])new String[]{"" + targetMeta, "" + ((ExcelInputData)this.data).filename, ex3.toString()}));
                }
                if (!errorHandled) {
                    ((ExcelInputData)this.data).errorHandler.handleLineError((long)excelInputRow.rownr, excelInputRow.sheetName);
                    errorHandled = true;
                }
                if (((ExcelInputMeta)this.meta).isErrorLineSkipped()) {
                    return null;
                }
                r[rowcolumn] = null;
            }
        }
        int rowIndex = ((ExcelInputMeta)this.meta).getField().length;
        if (!Utils.isEmpty((CharSequence)((ExcelInputMeta)this.meta).getFileField())) {
            r[rowIndex] = ((ExcelInputData)this.data).filename;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)((ExcelInputMeta)this.meta).getSheetField())) {
            r[rowIndex] = excelInputRow.sheetName;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)((ExcelInputMeta)this.meta).getSheetRowNumberField())) {
            r[rowIndex] = (long)((ExcelInputData)this.data).rownr;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)((ExcelInputMeta)this.meta).getRowNumberField())) {
            r[rowIndex] = this.getLinesWritten() + 1L;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)((ExcelInputMeta)this.meta).getShortFileNameField())) {
            r[rowIndex] = ((ExcelInputData)this.data).shortFilename;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)((ExcelInputMeta)this.meta).getExtensionField())) {
            r[rowIndex] = ((ExcelInputData)this.data).extension;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)((ExcelInputMeta)this.meta).getPathField())) {
            r[rowIndex] = ((ExcelInputData)this.data).path;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)((ExcelInputMeta)this.meta).getSizeField())) {
            r[rowIndex] = ((ExcelInputData)this.data).size;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)((ExcelInputMeta)this.meta).isHiddenField())) {
            r[rowIndex] = ((ExcelInputData)this.data).hidden;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)((ExcelInputMeta)this.meta).getLastModificationDateField())) {
            r[rowIndex] = ((ExcelInputData)this.data).lastModificationDateTime;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)((ExcelInputMeta)this.meta).getUriField())) {
            r[rowIndex] = ((ExcelInputData)this.data).uriName;
            ++rowIndex;
        }
        if (!Utils.isEmpty((CharSequence)((ExcelInputMeta)this.meta).getRootUriField())) {
            r[rowIndex] = ((ExcelInputData)this.data).rootUriName;
        }
        return r;
    }

    private void checkType(IKCell cell, IValueMeta v) throws HopException {
        if (!((ExcelInputMeta)this.meta).isStrictTypes()) {
            return;
        }
        switch (cell.getType()) {
            case BOOLEAN: {
                if (v.getType() == 2 || v.getType() == 0 || v.getType() == 4) break;
                throw new HopException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.InvalidTypeBoolean", (String[])new String[]{v.getTypeDesc()}));
            }
            case DATE: {
                if (v.getType() == 2 || v.getType() == 0 || v.getType() == 3) break;
                throw new HopException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.InvalidTypeDate", (String[])new String[]{cell.getContents(), v.getTypeDesc()}));
            }
            case LABEL: {
                if (v.getType() != 4 && v.getType() != 3 && v.getType() != 5 && v.getType() != 1) break;
                throw new HopException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.InvalidTypeLabel", (String[])new String[]{cell.getContents(), v.getTypeDesc()}));
            }
            case EMPTY: {
                break;
            }
            case NUMBER: {
                if (v.getType() == 2 || v.getType() == 0 || v.getType() == 5 || v.getType() == 6 || v.getType() == 1) break;
                throw new HopException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.InvalidTypeNumber", (String[])new String[]{cell.getContents(), v.getTypeDesc()}));
            }
            default: {
                throw new HopException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.UnsupportedType", (String[])new String[]{cell.getType().getDescription(), cell.getContents()}));
            }
        }
    }

    public boolean processRow() throws HopException {
        if (this.first) {
            this.first = false;
            ((ExcelInputData)this.data).outputRowMeta = new RowMeta();
            ((ExcelInputMeta)this.meta).getFields(((ExcelInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            if (((ExcelInputMeta)this.meta).isAcceptingFilenames()) {
                ((ExcelInputData)this.data).files.getFiles().clear();
                int idx = -1;
                IRowSet rowSet = this.findInputRowSet(((ExcelInputMeta)this.meta).getAcceptingTransformName());
                Object[] fileRow = this.getRowFrom(rowSet);
                while (fileRow != null) {
                    if (idx < 0 && (idx = rowSet.getRowMeta().indexOfValue(((ExcelInputMeta)this.meta).getAcceptingField())) < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"ExcelInput.Error.FilenameFieldNotFound", (String[])new String[]{"" + ((ExcelInputMeta)this.meta).getAcceptingField()}));
                        this.setErrors(1L);
                        this.stopAll();
                        return false;
                    }
                    String fileValue = rowSet.getRowMeta().getString(fileRow, idx);
                    try {
                        ((ExcelInputData)this.data).files.addFile(HopVfs.getFileObject((String)fileValue));
                    }
                    catch (HopFileException e) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.CanNotCreateFileObject", (String[])new String[]{fileValue}), (Throwable)e);
                    }
                    fileRow = this.getRowFrom(rowSet);
                }
            }
            this.handleMissingFiles();
        }
        if (((ExcelInputData)this.data).filenr >= ((ExcelInputData)this.data).files.nrOfFiles()) {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelInput.Log.NoMoreFiles", (String[])new String[]{"" + ((ExcelInputData)this.data).filenr}));
            }
            this.setOutputDone();
            return false;
        }
        if (((ExcelInputMeta)this.meta).getRowLimit() > 0L && this.getLinesInput() >= ((ExcelInputMeta)this.meta).getRowLimit()) {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelInput.Log.RowLimitReached", (String[])new String[]{"" + ((ExcelInputMeta)this.meta).getRowLimit()}));
            }
            this.setOutputDone();
            return false;
        }
        Object[] r = this.getRowFromWorkbooks();
        if (r != null) {
            this.incrementLinesInput();
            if (((ExcelInputData)this.data).previousRow != null) {
                for (int i = 0; i < ((ExcelInputMeta)this.meta).getField().length; ++i) {
                    Object valueData;
                    IValueMeta valueMeta = ((ExcelInputData)this.data).outputRowMeta.getValueMeta(i);
                    if (!valueMeta.isNull(valueData = r[i]) || !((ExcelInputMeta)this.meta).getField()[i].isRepeated()) continue;
                    r[i] = ((ExcelInputData)this.data).previousRow[i];
                }
            }
            ((ExcelInputData)this.data).previousRow = ((ExcelInputData)this.data).outputRowMeta.cloneRow(r);
            this.putRow(((ExcelInputData)this.data).outputRowMeta, r);
            return true;
        }
        return true;
    }

    private void handleMissingFiles() throws HopException {
        List nonAccessibleFiles;
        List nonExistantFiles = ((ExcelInputData)this.data).files.getNonExistantFiles();
        if (!nonExistantFiles.isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            if (this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"ExcelInput.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ExcelInput.Warning.MissingFiles", (String[])new String[]{message})});
            }
            if (((ExcelInputMeta)this.meta).isErrorIgnored()) {
                for (FileObject fileObject : nonExistantFiles) {
                    ((ExcelInputData)this.data).errorHandler.handleNonExistantFile(fileObject);
                }
            } else {
                throw new HopException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.MissingRequiredFiles", (String[])new String[]{message}));
            }
        }
        if (!(nonAccessibleFiles = ((ExcelInputData)this.data).files.getNonAccessibleFiles()).isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            if (this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"ExcelInput.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ExcelInput.Log.RequiredFilesMsgNotAccessible", (String[])new String[]{message})});
            }
            if (((ExcelInputMeta)this.meta).isErrorIgnored()) {
                for (FileObject fileObject : nonAccessibleFiles) {
                    ((ExcelInputData)this.data).errorHandler.handleNonAccessibleFile(fileObject);
                }
            } else {
                throw new HopException(BaseMessages.getString(PKG, (String)"ExcelInput.Exception.RequiredFilesNotAccessible", (String[])new String[]{message}));
            }
        }
    }

    public Object[] getRowFromWorkbooks() {
        Object[] retval = null;
        try {
            String sheetName;
            IKSheet sheet;
            if (((ExcelInputData)this.data).workbook == null) {
                ((ExcelInputData)this.data).file = ((ExcelInputData)this.data).files.getFile(((ExcelInputData)this.data).filenr);
                ((ExcelInputData)this.data).filename = HopVfs.getFilename((FileObject)((ExcelInputData)this.data).file);
                if (((ExcelInputMeta)this.meta).getShortFileNameField() != null && ((ExcelInputMeta)this.meta).getShortFileNameField().length() > 0) {
                    ((ExcelInputData)this.data).shortFilename = ((ExcelInputData)this.data).file.getName().getBaseName();
                }
                if (((ExcelInputMeta)this.meta).getPathField() != null && ((ExcelInputMeta)this.meta).getPathField().length() > 0) {
                    ((ExcelInputData)this.data).path = HopVfs.getFilename((FileObject)((ExcelInputData)this.data).file.getParent());
                }
                if (((ExcelInputMeta)this.meta).isHiddenField() != null && ((ExcelInputMeta)this.meta).isHiddenField().length() > 0) {
                    ((ExcelInputData)this.data).hidden = ((ExcelInputData)this.data).file.isHidden();
                }
                if (((ExcelInputMeta)this.meta).getExtensionField() != null && ((ExcelInputMeta)this.meta).getExtensionField().length() > 0) {
                    ((ExcelInputData)this.data).extension = ((ExcelInputData)this.data).file.getName().getExtension();
                }
                if (((ExcelInputMeta)this.meta).getLastModificationDateField() != null && ((ExcelInputMeta)this.meta).getLastModificationDateField().length() > 0) {
                    ((ExcelInputData)this.data).lastModificationDateTime = new Date(((ExcelInputData)this.data).file.getContent().getLastModifiedTime());
                }
                if (((ExcelInputMeta)this.meta).getUriField() != null && ((ExcelInputMeta)this.meta).getUriField().length() > 0) {
                    ((ExcelInputData)this.data).uriName = ((ExcelInputData)this.data).file.getName().getURI();
                }
                if (((ExcelInputMeta)this.meta).getRootUriField() != null && ((ExcelInputMeta)this.meta).getRootUriField().length() > 0) {
                    ((ExcelInputData)this.data).rootUriName = ((ExcelInputData)this.data).file.getName().getRootURI();
                }
                if (((ExcelInputMeta)this.meta).getSizeField() != null && ((ExcelInputMeta)this.meta).getSizeField().length() > 0) {
                    ((ExcelInputData)this.data).size = ((ExcelInputData)this.data).file.getContent().getSize();
                }
                if (((ExcelInputMeta)this.meta).isAddResultFile()) {
                    ResultFile resultFile = new ResultFile(0, ((ExcelInputData)this.data).file, this.getPipelineMeta().getName(), this.toString());
                    resultFile.setComment(BaseMessages.getString(PKG, (String)"ExcelInput.Log.FileReadByTransform", (String[])new String[0]));
                    this.addResultFile(resultFile);
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelInput.Log.OpeningFile", (String[])new String[]{"" + ((ExcelInputData)this.data).filenr + " : " + ((ExcelInputData)this.data).filename}));
                }
                ((ExcelInputData)this.data).workbook = WorkbookFactory.getWorkbook(((ExcelInputMeta)this.meta).getSpreadSheetType(), ((ExcelInputData)this.data).filename, ((ExcelInputMeta)this.meta).getEncoding());
                ((ExcelInputData)this.data).errorHandler.handleFile(((ExcelInputData)this.data).file);
                ((ExcelInputData)this.data).sheetnr = 0;
                if (((ExcelInputMeta)this.meta).readAllSheets()) {
                    ((ExcelInputData)this.data).sheetNames = ((ExcelInputData)this.data).workbook.getSheetNames();
                    ((ExcelInputData)this.data).startColumn = new int[((ExcelInputData)this.data).sheetNames.length];
                    ((ExcelInputData)this.data).startRow = new int[((ExcelInputData)this.data).sheetNames.length];
                    for (int i = 0; i < ((ExcelInputData)this.data).sheetNames.length; ++i) {
                        ((ExcelInputData)this.data).startColumn[i] = ((ExcelInputData)this.data).defaultStartColumn;
                        ((ExcelInputData)this.data).startRow[i] = ((ExcelInputData)this.data).defaultStartRow;
                    }
                }
            }
            boolean nextsheet = false;
            if (this.log.isDebug()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelInput.Log.GetSheet", (String[])new String[]{"" + ((ExcelInputData)this.data).filenr + "." + ((ExcelInputData)this.data).sheetnr}));
            }
            if ((sheet = ((ExcelInputData)this.data).workbook.getSheet(sheetName = ((ExcelInputData)this.data).sheetNames[((ExcelInputData)this.data).sheetnr])) != null) {
                if (((ExcelInputData)this.data).rownr < 0) {
                    ((ExcelInputData)this.data).rownr = ((ExcelInputData)this.data).startRow[((ExcelInputData)this.data).sheetnr];
                    if (((ExcelInputMeta)this.meta).startsWithHeader()) {
                        ++((ExcelInputData)this.data).rownr;
                    }
                }
                ((ExcelInputData)this.data).colnr = ((ExcelInputData)this.data).startColumn[((ExcelInputData)this.data).sheetnr];
                try {
                    IKCell[] line = sheet.getRow(((ExcelInputData)this.data).rownr);
                    int lineNr = ++((ExcelInputData)this.data).rownr;
                    if (!((ExcelInputData)this.data).filePlayList.isProcessingNeeded(((ExcelInputData)this.data).file, (long)lineNr, sheetName)) {
                        retval = null;
                    } else {
                        boolean isEmpty;
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(BaseMessages.getString(PKG, (String)"ExcelInput.Log.GetLine", (String[])new String[]{"" + lineNr, ((ExcelInputData)this.data).filenr + "." + ((ExcelInputData)this.data).sheetnr}));
                        }
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(BaseMessages.getString(PKG, (String)"ExcelInput.Log.ReadLineWith", (String[])new String[]{"" + line.length}));
                        }
                        ExcelInputRow excelInputRow = new ExcelInputRow(sheet.getName(), lineNr, line);
                        Object[] r = this.fillRow(((ExcelInputData)this.data).colnr, excelInputRow);
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(BaseMessages.getString(PKG, (String)"ExcelInput.Log.ConvertedLinToRow", (String[])new String[]{"" + lineNr, ((ExcelInputData)this.data).outputRowMeta.getString(r)}));
                        }
                        if (!(isEmpty = this.isLineEmpty(line)) || !((ExcelInputMeta)this.meta).ignoreEmptyRows()) {
                            retval = r;
                        } else if (((ExcelInputData)this.data).rownr > sheet.getRows()) {
                            nextsheet = true;
                        }
                        if (isEmpty && ((ExcelInputMeta)this.meta).stopOnEmpty()) {
                            nextsheet = true;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    if (this.log.isRowLevel()) {
                        this.logRowlevel(BaseMessages.getString(PKG, (String)"ExcelInput.Log.OutOfIndex", (String[])new String[0]));
                    }
                    nextsheet = true;
                }
            } else {
                nextsheet = true;
            }
            if (nextsheet) {
                ++((ExcelInputData)this.data).sheetnr;
                ((ExcelInputData)this.data).rownr = -1;
                ((ExcelInputData)this.data).previousRow = null;
                if (((ExcelInputData)this.data).sheetnr >= ((ExcelInputData)this.data).sheetNames.length) {
                    this.jumpToNextFile();
                }
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ExcelInput.Error.ProcessRowFromExcel", (String[])new String[]{((ExcelInputData)this.data).filename + "", e.toString()}), e);
            this.setErrors(1L);
            this.stopAll();
            return null;
        }
        return retval;
    }

    private boolean isLineEmpty(IKCell[] line) {
        if (line.length == 0) {
            return true;
        }
        boolean isEmpty = true;
        for (int i = 0; i < line.length && isEmpty; ++i) {
            if (line[i] == null || Utils.isEmpty((CharSequence)line[i].getContents())) continue;
            isEmpty = false;
        }
        return isEmpty;
    }

    private void jumpToNextFile() throws HopException {
        ((ExcelInputData)this.data).sheetnr = 0;
        ((ExcelInputData)this.data).rownr = -1;
        ((ExcelInputData)this.data).previousRow = null;
        ((ExcelInputData)this.data).workbook.close();
        ((ExcelInputData)this.data).workbook = null;
        ((ExcelInputData)this.data).errorHandler.close();
        ++((ExcelInputData)this.data).filenr;
    }

    private void initErrorHandling() {
        ArrayList<Object> errorHandlers = new ArrayList<Object>(2);
        if (((ExcelInputMeta)this.meta).getLineNumberFilesDestinationDirectory() != null) {
            errorHandlers.add(new FileErrorHandlerContentLineNumber(this.getPipeline().getExecutionStartDate(), this.resolve(((ExcelInputMeta)this.meta).getLineNumberFilesDestinationDirectory()), ((ExcelInputMeta)this.meta).getLineNumberFilesExtension(), "Latin1", (BaseTransform)this));
        }
        if (((ExcelInputMeta)this.meta).getErrorFilesDestinationDirectory() != null) {
            errorHandlers.add(new FileErrorHandlerMissingFiles(this.getPipeline().getExecutionStartDate(), this.resolve(((ExcelInputMeta)this.meta).getErrorFilesDestinationDirectory()), ((ExcelInputMeta)this.meta).getErrorFilesExtension(), "Latin1", (BaseTransform)this));
        }
        ((ExcelInputData)this.data).errorHandler = new CompositeFileErrorHandler(errorHandlers);
    }

    private void initReplayFactory() {
        ((ExcelInputData)this.data).filePlayList = FilePlayListAll.INSTANCE;
    }

    protected void setZipBombConfiguration() {
        long maxTextSize;
        long maxEntrySize;
        double minInflateRatio;
        String minInflateRatioVariable = EnvUtil.getSystemProperty((String)"HOP_ZIP_MIN_INFLATE_RATIO", (String)Const.HOP_ZIP_MIN_INFLATE_RATIO_DEFAULT_STRING);
        try {
            minInflateRatio = Double.parseDouble(minInflateRatioVariable);
        }
        catch (NullPointerException | NumberFormatException e) {
            minInflateRatio = Const.HOP_ZIP_MIN_INFLATE_RATIO_DEFAULT;
        }
        ZipSecureFile.setMinInflateRatio((double)minInflateRatio);
        String maxEntrySizeVariable = EnvUtil.getSystemProperty((String)"HOP_ZIP_MAX_ENTRY_SIZE", (String)Const.HOP_ZIP_MAX_ENTRY_SIZE_DEFAULT_STRING);
        try {
            maxEntrySize = Long.parseLong(maxEntrySizeVariable);
        }
        catch (NullPointerException | NumberFormatException e) {
            maxEntrySize = Const.HOP_ZIP_MAX_ENTRY_SIZE_DEFAULT;
        }
        ZipSecureFile.setMaxEntrySize((long)maxEntrySize);
        String maxTextSizeVariable = EnvUtil.getSystemProperty((String)"HOP_ZIP_MAX_TEXT_SIZE", (String)Const.HOP_ZIP_MAX_TEXT_SIZE_DEFAULT_STRING);
        try {
            maxTextSize = Long.parseLong(maxTextSizeVariable);
        }
        catch (NullPointerException | NumberFormatException e) {
            maxTextSize = Const.HOP_ZIP_MAX_TEXT_SIZE_DEFAULT;
        }
        ZipSecureFile.setMaxTextSize((long)maxTextSize);
    }

    public boolean init() {
        if (super.init()) {
            this.initErrorHandling();
            this.initReplayFactory();
            ((ExcelInputData)this.data).files = ((ExcelInputMeta)this.meta).getFileList((IVariables)this);
            if (((ExcelInputData)this.data).files.nrOfFiles() == 0 && ((ExcelInputData)this.data).files.nrOfMissingFiles() > 0 && !((ExcelInputMeta)this.meta).isAcceptingFilenames()) {
                this.logError(BaseMessages.getString(PKG, (String)"ExcelInput.Error.NoFileSpecified", (String[])new String[0]));
                return false;
            }
            if (((ExcelInputMeta)this.meta).getEmptyFields().size() > 0) {
                ((ExcelInputData)this.data).maxfilelength = -1;
                for (FileObject file : ((ExcelInputData)this.data).files.getFiles()) {
                    String name = HopVfs.getFilename((FileObject)file);
                    if (name.length() <= ((ExcelInputData)this.data).maxfilelength) continue;
                    ((ExcelInputData)this.data).maxfilelength = name.length();
                }
                ((ExcelInputData)this.data).maxsheetlength = -1;
                if (!((ExcelInputMeta)this.meta).readAllSheets()) {
                    ((ExcelInputData)this.data).sheetNames = new String[((ExcelInputMeta)this.meta).getSheetName().length];
                    ((ExcelInputData)this.data).startColumn = new int[((ExcelInputMeta)this.meta).getSheetName().length];
                    ((ExcelInputData)this.data).startRow = new int[((ExcelInputMeta)this.meta).getSheetName().length];
                    for (int i = 0; i < ((ExcelInputMeta)this.meta).getSheetName().length; ++i) {
                        ((ExcelInputData)this.data).sheetNames[i] = ((ExcelInputMeta)this.meta).getSheetName()[i];
                        ((ExcelInputData)this.data).startColumn[i] = ((ExcelInputMeta)this.meta).getStartColumn()[i];
                        ((ExcelInputData)this.data).startRow[i] = ((ExcelInputMeta)this.meta).getStartRow()[i];
                        if (((ExcelInputMeta)this.meta).getSheetName()[i].length() <= ((ExcelInputData)this.data).maxsheetlength) continue;
                        ((ExcelInputData)this.data).maxsheetlength = ((ExcelInputMeta)this.meta).getSheetName()[i].length();
                    }
                } else {
                    ((ExcelInputData)this.data).defaultStartRow = ((ExcelInputMeta)this.meta).getStartRow().length == 1 ? ((ExcelInputMeta)this.meta).getStartRow()[0] : 0;
                    ((ExcelInputData)this.data).defaultStartColumn = ((ExcelInputMeta)this.meta).getStartColumn().length == 1 ? ((ExcelInputMeta)this.meta).getStartColumn()[0] : 0;
                }
                return true;
            }
            this.logError(BaseMessages.getString(PKG, (String)"ExcelInput.Error.NotInputFieldsDefined", (String[])new String[0]));
        }
        return false;
    }

    public void dispose() {
        block6: {
            if (((ExcelInputData)this.data).workbook != null) {
                ((ExcelInputData)this.data).workbook.close();
            }
            if (((ExcelInputData)this.data).file != null) {
                try {
                    ((ExcelInputData)this.data).file.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                ((ExcelInputData)this.data).errorHandler.close();
            }
            catch (HopException e) {
                if (!this.log.isDebug()) break block6;
                this.logDebug(BaseMessages.getString(PKG, (String)"ExcelInput.Error.CouldNotCloseErrorHandler", (String[])new String[]{e.toString()}));
                this.logDebug(Const.getStackTracker((Throwable)e));
            }
        }
        super.dispose();
    }
}

