/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filelocked;

import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.filelocked.FileLockedData;
import org.apache.hop.pipeline.transforms.filelocked.FileLockedMeta;
import org.apache.hop.workflow.actions.checkfilelocked.LockFile;

public class FileLocked
extends BaseTransform<FileLockedMeta, FileLockedData>
implements ITransform<FileLockedMeta, FileLockedData> {
    private static final Class<?> PKG = FileLockedMeta.class;

    public FileLocked(TransformMeta transformMeta, FileLockedMeta meta, FileLockedData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block12: {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            boolean fileLocked = false;
            if (this.first) {
                this.first = false;
                ((FileLockedData)this.data).previousRowMeta = this.getInputRowMeta().clone();
                ((FileLockedData)this.data).NrPrevFields = ((FileLockedData)this.data).previousRowMeta.size();
                ((FileLockedData)this.data).outputRowMeta = ((FileLockedData)this.data).previousRowMeta;
                ((FileLockedMeta)this.meta).getFields(((FileLockedData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (Utils.isEmpty((CharSequence)((FileLockedMeta)this.meta).getFilenamefield())) {
                    this.logError(BaseMessages.getString(PKG, (String)"FileLocked.Error.FilenameFieldMissing", (String[])new String[0]));
                    throw new HopException(BaseMessages.getString(PKG, (String)"FileLocked.Error.FilenameFieldMissing", (String[])new String[0]));
                }
                if (((FileLockedData)this.data).indexOfFileename < 0) {
                    ((FileLockedData)this.data).indexOfFileename = ((FileLockedData)this.data).previousRowMeta.indexOfValue(((FileLockedMeta)this.meta).getFilenamefield());
                    if (((FileLockedData)this.data).indexOfFileename < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"FileLocked.Exception.CouldnotFindField", (String[])new String[0]) + "[" + ((FileLockedMeta)this.meta).getFilenamefield() + "]");
                        throw new HopException(BaseMessages.getString(PKG, (String)"FileLocked.Exception.CouldnotFindField", (String[])new String[]{((FileLockedMeta)this.meta).getFilenamefield()}));
                    }
                }
            }
            try {
                String filename = ((FileLockedData)this.data).previousRowMeta.getString(r, ((FileLockedData)this.data).indexOfFileename);
                if (!Utils.isEmpty((CharSequence)filename)) {
                    LockFile locked = new LockFile(filename);
                    fileLocked = locked.isLocked();
                    if (((FileLockedMeta)this.meta).isAddresultfilenames()) {
                        ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)filename), this.getPipelineMeta().getName(), this.getTransformName());
                        resultFile.setComment(BaseMessages.getString(PKG, (String)"FileLocked.Log.FileAddedResult", (String[])new String[0]));
                        this.addResultFile(resultFile);
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"FileLocked.Log.FilenameAddResult", (String[])new String[]{filename}));
                        }
                    }
                }
                this.putRow(((FileLockedData)this.data).outputRowMeta, RowDataUtil.addValueData((Object[])r, (int)((FileLockedData)this.data).NrPrevFields, (Object)fileLocked));
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"FileLocked.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"FileLocked.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block12;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, ((FileLockedMeta)this.meta).getResultfieldname(), "FileLocked001");
            }
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            if (Utils.isEmpty((CharSequence)((FileLockedMeta)this.meta).getResultfieldname())) {
                this.logError(BaseMessages.getString(PKG, (String)"FileLocked.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            return true;
        }
        return false;
    }
}

