/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.httppost;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.httppost.HttpPost;
import org.apache.hop.pipeline.transforms.httppost.HttpPostData;
import org.apache.hop.pipeline.transforms.httppost.HttpPostLoookupField;
import org.apache.hop.pipeline.transforms.httppost.HttpPostResultField;

@Transform(id="HttpPost", image="httppost.svg", name="i18n::BaseTransform.TypeLongDesc.HTTPPOST", description="i18n::BaseTransform.TypeTooltipDesc.HTTPPOST", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", documentationUrl="/pipeline/transforms/httppost.html")
public class HttpPostMeta
extends BaseTransformMeta
implements ITransformMeta<HttpPost, HttpPostData> {
    private static final Class<?> PKG = HttpPostMeta.class;
    public static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_CLOSE_CONNECTIONS_TIME = -1;
    public static final String DEFAULT_ENCODING = "UTF-8";
    @HopMetadataProperty(injectionKeyDescription="HTTPPOST.Injection.socketTimeout")
    private String socketTimeout;
    @HopMetadataProperty(injectionKeyDescription="HTTPPOST.Injection.connectionTimeout")
    private String connectionTimeout;
    @HopMetadataProperty(injectionKeyDescription="HTTPPOST.Injection.closeIdleConnectionsTime")
    private String closeIdleConnectionsTime;
    @HopMetadataProperty(injectionKeyDescription="HTTPPOST.Injection.url")
    private String url;
    @HopMetadataProperty(key="lookup", injectionGroupDescription="HTTPPOST.Injection.lookupfield")
    private List<HttpPostLoookupField> lookupfield = new ArrayList<HttpPostLoookupField>();
    @HopMetadataProperty(injectionKeyDescription="HTTPPOST.Injection.urlInField")
    private boolean urlInField;
    @HopMetadataProperty(injectionKeyDescription="HTTPPOST.Injection.urlField")
    private String urlField;
    @HopMetadataProperty(injectionKeyDescription="HTTPPOST.Injection.requestEntity")
    private String requestEntity;
    @HopMetadataProperty(injectionKeyDescription="HTTPPOST.Injection.encoding")
    private String encoding;
    @HopMetadataProperty(key="postafile", injectionKeyDescription="HTTPPOST.Injection.postAFile")
    private boolean postAFile;
    @HopMetadataProperty(injectionKeyDescription="HTTPPOST.Injection.proxyHost")
    private String proxyHost;
    @HopMetadataProperty(injectionKeyDescription="HTTPPOST.Injection.proxyPort")
    private String proxyPort;
    @HopMetadataProperty(injectionKeyDescription="HTTPPOST.Injection.httpLogin")
    private String httpLogin;
    @HopMetadataProperty(password=true, injectionKeyDescription="HTTPPOST.Injection.httpPassword")
    private String httpPassword;
    @HopMetadataProperty(key="result", injectionGroupDescription="HTTPPOST.Injection.httpPostResultField")
    private List<HttpPostResultField> httpPostResultField = new ArrayList<HttpPostResultField>();

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getCloseIdleConnectionsTime() {
        return this.closeIdleConnectionsTime;
    }

    public void setCloseIdleConnectionsTime(String closeIdleConnectionsTime) {
        this.closeIdleConnectionsTime = closeIdleConnectionsTime;
    }

    public String getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(String socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String procedure) {
        this.url = procedure;
    }

    public boolean isUrlInField() {
        return this.urlInField;
    }

    public boolean isPostAFile() {
        return this.postAFile;
    }

    public void setPostAFile(boolean postafile) {
        this.postAFile = postafile;
    }

    public void setUrlInField(boolean urlInField) {
        this.urlInField = urlInField;
    }

    public String getUrlField() {
        return this.urlField;
    }

    public void setUrlField(String urlField) {
        this.urlField = urlField;
    }

    public void setRequestEntity(String requestEntity) {
        this.requestEntity = requestEntity;
    }

    public String getRequestEntity() {
        return this.requestEntity;
    }

    public List<HttpPostLoookupField> getLookupfield() {
        return this.lookupfield;
    }

    public void setLookupfield(List<HttpPostLoookupField> lookupfield) {
        this.lookupfield = lookupfield;
    }

    public List<HttpPostResultField> getHttpPostResultField() {
        return this.httpPostResultField;
    }

    public void setHttpPostResultField(List<HttpPostResultField> httpPostResultField) {
        this.httpPostResultField = httpPostResultField;
    }

    public Object clone() {
        HttpPostMeta retval = (HttpPostMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.encoding = DEFAULT_ENCODING;
        this.postAFile = false;
        this.lookupfield.add(new HttpPostLoookupField());
        this.httpPostResultField.add(new HttpPostResultField());
        this.socketTimeout = String.valueOf(10000);
        this.connectionTimeout = String.valueOf(10000);
        this.closeIdleConnectionsTime = String.valueOf(-1);
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        String headerFieldName;
        ValueMetaString v;
        if (!Utils.isEmpty((CharSequence)this.httpPostResultField.get(0).getName())) {
            v = new ValueMetaString(this.httpPostResultField.get(0).getName());
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.httpPostResultField.get(0).getCode())) {
            v = new ValueMetaInteger(this.httpPostResultField.get(0).getCode());
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.httpPostResultField.get(0).getResponseTimeFieldName())) {
            v = new ValueMetaInteger(variables.resolve(this.httpPostResultField.get(0).getResponseTimeFieldName()));
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(headerFieldName = variables.resolve(this.httpPostResultField.get(0).getResponseHeaderFieldName())))) {
            ValueMetaString v2 = new ValueMetaString(headerFieldName);
            v2.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v2);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = this.urlInField ? (Utils.isEmpty((CharSequence)this.urlField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.CheckResult.UrlfieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.CheckResult.UrlfieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta)) : (Utils.isEmpty((CharSequence)this.url) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.CheckResult.UrlMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"HTTPPOSTMeta.CheckResult.UrlOk", (String[])new String[0]), (ICheckResultSource)transformMeta));
        remarks.add((ICheckResult)cr);
    }

    public HttpPost createTransform(TransformMeta transformMeta, HttpPostData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new HttpPost(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public HttpPostData getTransformData() {
        return new HttpPostData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setHttpLogin(String httpLogin) {
        this.httpLogin = httpLogin;
    }

    public String getHttpLogin() {
        return this.httpLogin;
    }

    public void setHttpPassword(String httpPassword) {
        this.httpPassword = httpPassword;
    }

    public String getHttpPassword() {
        return this.httpPassword;
    }
}

