/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.httppost;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.httppost.HttpPostArgumentField;
import org.apache.hop.pipeline.transforms.httppost.HttpPostLoookupField;
import org.apache.hop.pipeline.transforms.httppost.HttpPostMeta;
import org.apache.hop.pipeline.transforms.httppost.HttpPostQuery;
import org.apache.hop.pipeline.transforms.httppost.HttpPostResultField;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class HttpPostDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = HttpPostMeta.class;
    private static final String[] YES_NO_COMBO = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    private static final String YES = BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]);
    private static final String NO = BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]);
    private Label wlUrl;
    private TextVar wUrl;
    private TextVar wResult;
    private TextVar wResultCode;
    private TextVar wResponseTime;
    private TextVar wResponseHeader;
    private TableView wFields;
    private TableView wQuery;
    private Button wUrlInField;
    private Label wlUrlField;
    private ComboVar wUrlField;
    private ComboVar wRequestEntity;
    private TextVar wHttpLogin;
    private TextVar wHttpPassword;
    private TextVar wProxyHost;
    private TextVar wProxyPort;
    private final HttpPostMeta input;
    private final Map<String, Integer> inputFields;
    private ColumnInfo[] colinf;
    private ColumnInfo[] colinfquery;
    private String[] fieldNames;
    private boolean gotPreviousFields = false;
    private ComboVar wEncoding;
    private Button wPostAFile;
    private boolean gotEncodings = false;
    private TextVar wConnectionTimeOut;
    private TextVar wSocketTimeOut;
    private TextVar wCloseIdleConnectionsTime;

    public HttpPostDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (HttpPostMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.GeneralTab.Title", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wGeneralComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)fileLayout);
        Group gSettings = new Group(wGeneralComp, 16);
        gSettings.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.SettingsGroup.Label", (String[])new String[0]));
        FormLayout settingsLayout = new FormLayout();
        settingsLayout.marginWidth = 3;
        settingsLayout.marginHeight = 3;
        gSettings.setLayout((Layout)settingsLayout);
        this.props.setLook((Control)gSettings);
        this.wlUrl = new Label((Composite)gSettings, 131072);
        this.wlUrl.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.URL.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUrl);
        FormData fdlUrl = new FormData();
        fdlUrl.left = new FormAttachment(0, 0);
        fdlUrl.right = new FormAttachment(middle, -margin);
        fdlUrl.top = new FormAttachment((Control)this.wTransformName, margin);
        this.wlUrl.setLayoutData((Object)fdlUrl);
        this.wUrl = new TextVar(this.variables, (Composite)gSettings, 18436);
        this.props.setLook((Control)this.wUrl);
        this.wUrl.addModifyListener(lsMod);
        FormData fdUrl = new FormData();
        fdUrl.left = new FormAttachment(middle, 0);
        fdUrl.top = new FormAttachment((Control)this.wTransformName, margin);
        fdUrl.right = new FormAttachment(100, 0);
        this.wUrl.setLayoutData((Object)fdUrl);
        Label wlUrlInField = new Label((Composite)gSettings, 131072);
        wlUrlInField.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.UrlInField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUrlInField);
        FormData fdlUrlInField = new FormData();
        fdlUrlInField.left = new FormAttachment(0, 0);
        fdlUrlInField.top = new FormAttachment((Control)this.wUrl, margin);
        fdlUrlInField.right = new FormAttachment(middle, -margin);
        wlUrlInField.setLayoutData((Object)fdlUrlInField);
        this.wUrlInField = new Button((Composite)gSettings, 32);
        this.props.setLook((Control)this.wUrlInField);
        FormData fdUrlInField = new FormData();
        fdUrlInField.left = new FormAttachment(middle, 0);
        fdUrlInField.top = new FormAttachment((Control)wlUrlInField, 0, 0x1000000);
        fdUrlInField.right = new FormAttachment(100, 0);
        this.wUrlInField.setLayoutData((Object)fdUrlInField);
        this.wUrlInField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HttpPostDialog.this.input.setChanged();
                HttpPostDialog.this.activeUrlInfield();
            }
        });
        this.wlUrlField = new Label((Composite)gSettings, 131072);
        this.wlUrlField.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.UrlField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUrlField);
        FormData fdlUrlField = new FormData();
        fdlUrlField.left = new FormAttachment(0, 0);
        fdlUrlField.right = new FormAttachment(middle, -margin);
        fdlUrlField.top = new FormAttachment((Control)this.wUrlInField, margin);
        this.wlUrlField.setLayoutData((Object)fdlUrlField);
        this.wUrlField = new ComboVar(this.variables, (Composite)gSettings, 2056);
        this.wUrlField.setEditable(true);
        this.props.setLook((Control)this.wUrlField);
        this.wUrlField.addModifyListener(lsMod);
        FormData fdUrlField = new FormData();
        fdUrlField.left = new FormAttachment(middle, 0);
        fdUrlField.top = new FormAttachment((Control)this.wUrlInField, margin);
        fdUrlField.right = new FormAttachment(100, -margin);
        this.wUrlField.setLayoutData((Object)fdUrlField);
        this.wUrlField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)HttpPostDialog.this.shell.getDisplay(), 1);
                HttpPostDialog.this.shell.setCursor(busy);
                HttpPostDialog.this.setStreamFields();
                HttpPostDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlEncoding = new Label((Composite)gSettings, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.top = new FormAttachment((Control)this.wUrlField, margin);
        fdlEncoding.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new ComboVar(this.variables, (Composite)gSettings, 2056);
        this.wEncoding.setEditable(true);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        FormData fdEncoding = new FormData();
        fdEncoding.left = new FormAttachment(middle, 0);
        fdEncoding.top = new FormAttachment((Control)this.wUrlField, margin);
        fdEncoding.right = new FormAttachment(100, -margin);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)HttpPostDialog.this.shell.getDisplay(), 1);
                HttpPostDialog.this.shell.setCursor(busy);
                HttpPostDialog.this.setEncodings();
                HttpPostDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlRequestEntity = new Label((Composite)gSettings, 131072);
        wlRequestEntity.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.requestEntity.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRequestEntity);
        FormData fdlRequestEntity = new FormData();
        fdlRequestEntity.left = new FormAttachment(0, 0);
        fdlRequestEntity.right = new FormAttachment(middle, -margin);
        fdlRequestEntity.top = new FormAttachment((Control)this.wEncoding, margin);
        wlRequestEntity.setLayoutData((Object)fdlRequestEntity);
        this.wRequestEntity = new ComboVar(this.variables, (Composite)gSettings, 2056);
        this.wRequestEntity.setEditable(true);
        this.props.setLook((Control)this.wRequestEntity);
        this.wRequestEntity.addModifyListener(lsMod);
        FormData fdRequestEntity = new FormData();
        fdRequestEntity.left = new FormAttachment(middle, 0);
        fdRequestEntity.top = new FormAttachment((Control)this.wEncoding, margin);
        fdRequestEntity.right = new FormAttachment(100, -margin);
        this.wRequestEntity.setLayoutData((Object)fdRequestEntity);
        this.wRequestEntity.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)HttpPostDialog.this.shell.getDisplay(), 1);
                HttpPostDialog.this.shell.setCursor(busy);
                HttpPostDialog.this.setStreamFields();
                HttpPostDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlPostAFile = new Label((Composite)gSettings, 131072);
        wlPostAFile.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.postAFile.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPostAFile);
        FormData fdlPostAFile = new FormData();
        fdlPostAFile.left = new FormAttachment(0, 0);
        fdlPostAFile.right = new FormAttachment(middle, -margin);
        fdlPostAFile.top = new FormAttachment((Control)this.wRequestEntity, margin);
        wlPostAFile.setLayoutData((Object)fdlPostAFile);
        this.wPostAFile = new Button((Composite)gSettings, 32);
        this.wPostAFile.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.postAFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wPostAFile);
        FormData fdPostAFile = new FormData();
        fdPostAFile.left = new FormAttachment(middle, 0);
        fdPostAFile.top = new FormAttachment((Control)wlPostAFile, 0, 0x1000000);
        fdPostAFile.right = new FormAttachment(100, 0);
        this.wPostAFile.setLayoutData((Object)fdPostAFile);
        this.wPostAFile.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlConnectionTimeOut = new Label((Composite)gSettings, 131072);
        wlConnectionTimeOut.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ConnectionTimeOut.Label", (String[])new String[0]));
        this.props.setLook((Control)wlConnectionTimeOut);
        FormData fdlConnectionTimeOut = new FormData();
        fdlConnectionTimeOut.top = new FormAttachment((Control)this.wPostAFile, margin);
        fdlConnectionTimeOut.left = new FormAttachment(0, 0);
        fdlConnectionTimeOut.right = new FormAttachment(middle, -margin);
        wlConnectionTimeOut.setLayoutData((Object)fdlConnectionTimeOut);
        this.wConnectionTimeOut = new TextVar(this.variables, (Composite)gSettings, 18436);
        this.wConnectionTimeOut.addModifyListener(lsMod);
        this.wConnectionTimeOut.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ConnectionTimeOut.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wConnectionTimeOut);
        FormData fdConnectionTimeOut = new FormData();
        fdConnectionTimeOut.top = new FormAttachment((Control)this.wPostAFile, margin);
        fdConnectionTimeOut.left = new FormAttachment(middle, 0);
        fdConnectionTimeOut.right = new FormAttachment(100, 0);
        this.wConnectionTimeOut.setLayoutData((Object)fdConnectionTimeOut);
        Label wlSocketTimeOut = new Label((Composite)gSettings, 131072);
        wlSocketTimeOut.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.SocketTimeOut.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSocketTimeOut);
        FormData fdlSocketTimeOut = new FormData();
        fdlSocketTimeOut.top = new FormAttachment((Control)this.wConnectionTimeOut, margin);
        fdlSocketTimeOut.left = new FormAttachment(0, 0);
        fdlSocketTimeOut.right = new FormAttachment(middle, -margin);
        wlSocketTimeOut.setLayoutData((Object)fdlSocketTimeOut);
        this.wSocketTimeOut = new TextVar(this.variables, (Composite)gSettings, 18436);
        this.wSocketTimeOut.addModifyListener(lsMod);
        this.wSocketTimeOut.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.SocketTimeOut.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wSocketTimeOut);
        FormData fdSocketTimeOut = new FormData();
        fdSocketTimeOut.top = new FormAttachment((Control)this.wConnectionTimeOut, margin);
        fdSocketTimeOut.left = new FormAttachment(middle, 0);
        fdSocketTimeOut.right = new FormAttachment(100, 0);
        this.wSocketTimeOut.setLayoutData((Object)fdSocketTimeOut);
        Label wlCloseIdleConnectionsTime = new Label((Composite)gSettings, 131072);
        wlCloseIdleConnectionsTime.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.CloseIdleConnectionsTime.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCloseIdleConnectionsTime);
        FormData fdlCloseIdleConnectionsTime = new FormData();
        fdlCloseIdleConnectionsTime.top = new FormAttachment((Control)this.wSocketTimeOut, margin);
        fdlCloseIdleConnectionsTime.left = new FormAttachment(0, 0);
        fdlCloseIdleConnectionsTime.right = new FormAttachment(middle, -margin);
        wlCloseIdleConnectionsTime.setLayoutData((Object)fdlCloseIdleConnectionsTime);
        this.wCloseIdleConnectionsTime = new TextVar(this.variables, (Composite)gSettings, 18436);
        this.wCloseIdleConnectionsTime.addModifyListener(lsMod);
        this.wCloseIdleConnectionsTime.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.CloseIdleConnectionsTime.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCloseIdleConnectionsTime);
        FormData fdCloseIdleConnectionsTime = new FormData();
        fdCloseIdleConnectionsTime.top = new FormAttachment((Control)this.wSocketTimeOut, margin);
        fdCloseIdleConnectionsTime.left = new FormAttachment(middle, 0);
        fdCloseIdleConnectionsTime.right = new FormAttachment(100, 0);
        this.wCloseIdleConnectionsTime.setLayoutData((Object)fdCloseIdleConnectionsTime);
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0, 0);
        fdSettings.right = new FormAttachment(100, 0);
        fdSettings.top = new FormAttachment((Control)this.wTransformName, margin);
        gSettings.setLayoutData((Object)fdSettings);
        Group gOutputFields = new Group(wGeneralComp, 16);
        gOutputFields.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.OutputFieldsGroup.Label", (String[])new String[0]));
        FormLayout outputFieldsLayout = new FormLayout();
        outputFieldsLayout.marginWidth = 3;
        outputFieldsLayout.marginHeight = 3;
        gOutputFields.setLayout((Layout)outputFieldsLayout);
        this.props.setLook((Control)gOutputFields);
        Label wlResult = new Label((Composite)gOutputFields, 131072);
        wlResult.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.Result.Label", (String[])new String[0]));
        this.props.setLook((Control)wlResult);
        FormData fdlResult = new FormData();
        fdlResult.left = new FormAttachment(0, 0);
        fdlResult.right = new FormAttachment(middle, -margin);
        fdlResult.top = new FormAttachment((Control)this.wPostAFile, margin);
        wlResult.setLayoutData((Object)fdlResult);
        this.wResult = new TextVar(this.variables, (Composite)gOutputFields, 18436);
        this.props.setLook((Control)this.wResult);
        this.wResult.addModifyListener(lsMod);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment(middle, 0);
        fdResult.top = new FormAttachment((Control)this.wPostAFile, margin);
        fdResult.right = new FormAttachment(100, -margin);
        this.wResult.setLayoutData((Object)fdResult);
        Label wlResultCode = new Label((Composite)gOutputFields, 131072);
        wlResultCode.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ResultCode.Label", (String[])new String[0]));
        this.props.setLook((Control)wlResultCode);
        FormData fdlResultCode = new FormData();
        fdlResultCode.left = new FormAttachment(0, 0);
        fdlResultCode.right = new FormAttachment(middle, -margin);
        fdlResultCode.top = new FormAttachment((Control)this.wResult, margin);
        wlResultCode.setLayoutData((Object)fdlResultCode);
        this.wResultCode = new TextVar(this.variables, (Composite)gOutputFields, 18436);
        this.props.setLook((Control)this.wResultCode);
        this.wResultCode.addModifyListener(lsMod);
        FormData fdResultCode = new FormData();
        fdResultCode.left = new FormAttachment(middle, 0);
        fdResultCode.top = new FormAttachment((Control)this.wResult, margin);
        fdResultCode.right = new FormAttachment(100, -margin);
        this.wResultCode.setLayoutData((Object)fdResultCode);
        Label wlResponseTime = new Label((Composite)gOutputFields, 131072);
        wlResponseTime.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ResponseTime.Label", (String[])new String[0]));
        this.props.setLook((Control)wlResponseTime);
        FormData fdlResponseTime = new FormData();
        fdlResponseTime.left = new FormAttachment(0, 0);
        fdlResponseTime.right = new FormAttachment(middle, -margin);
        fdlResponseTime.top = new FormAttachment((Control)this.wResultCode, margin);
        wlResponseTime.setLayoutData((Object)fdlResponseTime);
        this.wResponseTime = new TextVar(this.variables, (Composite)gOutputFields, 18436);
        this.props.setLook((Control)this.wResponseTime);
        this.wResponseTime.addModifyListener(lsMod);
        FormData fdResponseTime = new FormData();
        fdResponseTime.left = new FormAttachment(middle, 0);
        fdResponseTime.top = new FormAttachment((Control)this.wResultCode, margin);
        fdResponseTime.right = new FormAttachment(100, 0);
        this.wResponseTime.setLayoutData((Object)fdResponseTime);
        Label wlResponseHeader = new Label((Composite)gOutputFields, 131072);
        wlResponseHeader.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ResponseHeader.Label", (String[])new String[0]));
        this.props.setLook((Control)wlResponseHeader);
        FormData fdlResponseHeader = new FormData();
        fdlResponseHeader.left = new FormAttachment(0, 0);
        fdlResponseHeader.right = new FormAttachment(middle, -margin);
        fdlResponseHeader.top = new FormAttachment((Control)this.wResponseTime, margin);
        wlResponseHeader.setLayoutData((Object)fdlResponseHeader);
        this.wResponseHeader = new TextVar(this.variables, (Composite)gOutputFields, 18436);
        this.props.setLook((Control)this.wResponseHeader);
        this.wResponseHeader.addModifyListener(lsMod);
        FormData fdResponseHeader = new FormData();
        fdResponseHeader.left = new FormAttachment(middle, 0);
        fdResponseHeader.top = new FormAttachment((Control)this.wResponseTime, margin);
        fdResponseHeader.right = new FormAttachment(100, 0);
        this.wResponseHeader.setLayoutData((Object)fdResponseHeader);
        FormData fdOutputFields = new FormData();
        fdOutputFields.left = new FormAttachment(0, 0);
        fdOutputFields.right = new FormAttachment(100, 0);
        fdOutputFields.top = new FormAttachment((Control)gSettings, margin);
        gOutputFields.setLayoutData((Object)fdOutputFields);
        Group gHttpAuth = new Group(wGeneralComp, 16);
        gHttpAuth.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.HttpAuthGroup.Label", (String[])new String[0]));
        FormLayout httpAuthLayout = new FormLayout();
        httpAuthLayout.marginWidth = 3;
        httpAuthLayout.marginHeight = 3;
        gHttpAuth.setLayout((Layout)httpAuthLayout);
        this.props.setLook((Control)gHttpAuth);
        Label wlHttpLogin = new Label((Composite)gHttpAuth, 131072);
        wlHttpLogin.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.HttpLogin.Label", (String[])new String[0]));
        this.props.setLook((Control)wlHttpLogin);
        FormData fdlHttpLogin = new FormData();
        fdlHttpLogin.top = new FormAttachment(0, margin);
        fdlHttpLogin.left = new FormAttachment(0, 0);
        fdlHttpLogin.right = new FormAttachment(middle, -margin);
        wlHttpLogin.setLayoutData((Object)fdlHttpLogin);
        this.wHttpLogin = new TextVar(this.variables, (Composite)gHttpAuth, 18436);
        this.wHttpLogin.addModifyListener(lsMod);
        this.wHttpLogin.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.HttpLogin.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wHttpLogin);
        FormData fdHttpLogin = new FormData();
        fdHttpLogin.top = new FormAttachment(0, margin);
        fdHttpLogin.left = new FormAttachment(middle, 0);
        fdHttpLogin.right = new FormAttachment(100, 0);
        this.wHttpLogin.setLayoutData((Object)fdHttpLogin);
        Label wlHttpPassword = new Label((Composite)gHttpAuth, 131072);
        wlHttpPassword.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.HttpPassword.Label", (String[])new String[0]));
        this.props.setLook((Control)wlHttpPassword);
        FormData fdlHttpPassword = new FormData();
        fdlHttpPassword.top = new FormAttachment((Control)this.wHttpLogin, margin);
        fdlHttpPassword.left = new FormAttachment(0, 0);
        fdlHttpPassword.right = new FormAttachment(middle, -margin);
        wlHttpPassword.setLayoutData((Object)fdlHttpPassword);
        this.wHttpPassword = new PasswordTextVar(this.variables, (Composite)gHttpAuth, 18436);
        this.wHttpPassword.addModifyListener(lsMod);
        this.wHttpPassword.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.HttpPassword.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wHttpPassword);
        FormData fdHttpPassword = new FormData();
        fdHttpPassword.top = new FormAttachment((Control)this.wHttpLogin, margin);
        fdHttpPassword.left = new FormAttachment(middle, 0);
        fdHttpPassword.right = new FormAttachment(100, 0);
        this.wHttpPassword.setLayoutData((Object)fdHttpPassword);
        FormData fdHttpAuth = new FormData();
        fdHttpAuth.left = new FormAttachment(0, 0);
        fdHttpAuth.right = new FormAttachment(100, 0);
        fdHttpAuth.top = new FormAttachment((Control)gOutputFields, margin);
        gHttpAuth.setLayoutData((Object)fdHttpAuth);
        Group gProxy = new Group(wGeneralComp, 16);
        gProxy.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ProxyGroup.Label", (String[])new String[0]));
        FormLayout proxyLayout = new FormLayout();
        proxyLayout.marginWidth = 3;
        proxyLayout.marginHeight = 3;
        gProxy.setLayout((Layout)proxyLayout);
        this.props.setLook((Control)gProxy);
        Label wlProxyHost = new Label((Composite)gProxy, 131072);
        wlProxyHost.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ProxyHost.Label", (String[])new String[0]));
        this.props.setLook((Control)wlProxyHost);
        FormData fdlProxyHost = new FormData();
        fdlProxyHost.top = new FormAttachment(0, margin);
        fdlProxyHost.left = new FormAttachment(0, 0);
        fdlProxyHost.right = new FormAttachment(middle, -margin);
        wlProxyHost.setLayoutData((Object)fdlProxyHost);
        this.wProxyHost = new TextVar(this.variables, (Composite)gProxy, 18436);
        this.wProxyHost.addModifyListener(lsMod);
        this.wProxyHost.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ProxyHost.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyHost);
        FormData fdProxyHost = new FormData();
        fdProxyHost.top = new FormAttachment(0, margin);
        fdProxyHost.left = new FormAttachment(middle, 0);
        fdProxyHost.right = new FormAttachment(100, 0);
        this.wProxyHost.setLayoutData((Object)fdProxyHost);
        Label wlProxyPort = new Label((Composite)gProxy, 131072);
        wlProxyPort.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ProxyPort.Label", (String[])new String[0]));
        this.props.setLook((Control)wlProxyPort);
        FormData fdlProxyPort = new FormData();
        fdlProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdlProxyPort.left = new FormAttachment(0, 0);
        fdlProxyPort.right = new FormAttachment(middle, -margin);
        wlProxyPort.setLayoutData((Object)fdlProxyPort);
        this.wProxyPort = new TextVar(this.variables, (Composite)gProxy, 18436);
        this.wProxyPort.addModifyListener(lsMod);
        this.wProxyPort.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ProxyPort.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyPort);
        FormData fdProxyPort = new FormData();
        fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdProxyPort.left = new FormAttachment(middle, 0);
        fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData((Object)fdProxyPort);
        FormData fdProxy = new FormData();
        fdProxy.left = new FormAttachment(0, 0);
        fdProxy.right = new FormAttachment(100, 0);
        fdProxy.top = new FormAttachment((Control)gHttpAuth, margin);
        gProxy.setLayoutData((Object)fdProxy);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        CTabItem wAdditionalTab = new CTabItem(wTabFolder, 0);
        wAdditionalTab.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.FieldsTab.Title", (String[])new String[0]));
        FormLayout addLayout = new FormLayout();
        addLayout.marginWidth = 5;
        addLayout.marginHeight = 5;
        Composite wAdditionalComp = new Composite((Composite)wTabFolder, 0);
        wAdditionalComp.setLayout((Layout)addLayout);
        this.props.setLook((Control)wAdditionalComp);
        Label wlFields = new Label(wAdditionalComp, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.Parameters.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)gProxy, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int fieldsRows = 0;
        if (this.input.getLookupfield().get(0).getArgumentField() != null) {
            fieldsRows = this.input.getLookupfield().get(0).getArgumentField().size();
        }
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ColumnInfo.Name", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ColumnInfo.Parameter", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ColumnInfo.Header", (String[])new String[0]), 2, YES_NO_COMBO)};
        this.colinf[1].setUsingVariables(true);
        this.wFields = new TableView(this.variables, wAdditionalComp, 67586, this.colinf, fieldsRows, lsMod, this.props);
        Button wGetBodyParam = new Button(wAdditionalComp, 8);
        wGetBodyParam.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGetBodyParam = new FormData();
        fdGetBodyParam.top = new FormAttachment((Control)wlFields, margin);
        fdGetBodyParam.right = new FormAttachment(100, 0);
        wGetBodyParam.setLayoutData((Object)fdGetBodyParam);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment((Control)wGetBodyParam, -margin);
        fdFields.bottom = new FormAttachment((Control)wlFields, 200);
        this.wFields.setLayoutData((Object)fdFields);
        Label wlQuery = new Label(wAdditionalComp, 0);
        wlQuery.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.QueryParameters.Label", (String[])new String[0]));
        this.props.setLook((Control)wlQuery);
        FormData fdlQuery = new FormData();
        fdlQuery.left = new FormAttachment(0, 0);
        fdlQuery.top = new FormAttachment((Control)this.wFields, margin);
        wlQuery.setLayoutData((Object)fdlQuery);
        int queryRows = 0;
        if (this.input.getLookupfield().get(0).getQueryField() != null) {
            queryRows = this.input.getLookupfield().get(0).getQueryField().size();
        }
        this.colinfquery = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ColumnInfo.QueryName", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.ColumnInfo.QueryParameter", (String[])new String[0]), 1, false)};
        this.colinfquery[1].setUsingVariables(true);
        this.wQuery = new TableView(this.variables, wAdditionalComp, 67586, this.colinfquery, queryRows, lsMod, this.props);
        this.wGet = new Button(wAdditionalComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.top = new FormAttachment((Control)wlQuery, margin);
        this.fdGet.right = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)this.fdGet);
        FormData fdQuery = new FormData();
        fdQuery.left = new FormAttachment(0, 0);
        fdQuery.top = new FormAttachment((Control)wlQuery, margin);
        fdQuery.right = new FormAttachment((Control)this.wGet, -margin);
        fdQuery.bottom = new FormAttachment(100, -margin);
        this.wQuery.setLayoutData((Object)fdQuery);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdAdditionalComp = new FormData();
        fdAdditionalComp.left = new FormAttachment(0, 0);
        fdAdditionalComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdAdditionalComp.right = new FormAttachment(100, 0);
        fdAdditionalComp.bottom = new FormAttachment(100, 0);
        wAdditionalComp.setLayoutData((Object)fdAdditionalComp);
        wAdditionalComp.layout();
        wAdditionalTab.setControl((Control)wAdditionalComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wGet.addListener(13, e -> this.getQueryFields());
        wGetBodyParam.addListener(13, e -> this.get());
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        wTabFolder.setSelection(0);
        this.getData();
        this.activeUrlInfield();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        this.fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])this.fieldNames);
        this.colinf[0].setComboValues(this.fieldNames);
        this.colinfquery[0].setComboValues(this.fieldNames);
    }

    private void setStreamFields() {
        if (!this.gotPreviousFields) {
            String urlfield = this.wUrlField.getText();
            this.wUrlField.removeAll();
            this.wUrlField.setItems(this.fieldNames);
            if (urlfield != null) {
                this.wUrlField.setText(urlfield);
            }
            String request = this.wRequestEntity.getText();
            this.wRequestEntity.removeAll();
            this.wRequestEntity.setItems(this.fieldNames);
            if (request != null) {
                this.wRequestEntity.setText(request);
            }
            this.gotPreviousFields = true;
        }
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (Charset charSet : values) {
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    private void activeUrlInfield() {
        this.wlUrlField.setEnabled(this.wUrlInField.getSelection());
        this.wUrlField.setEnabled(this.wUrlInField.getSelection());
        this.wlUrl.setEnabled(!this.wUrlInField.getSelection());
        this.wUrl.setEnabled(!this.wUrlInField.getSelection());
    }

    public void getData() {
        TableItem item;
        int i;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getLookupfield().get(0).getArgumentField() != null) {
            for (i = 0; i < this.input.getLookupfield().get(0).getArgumentField().size(); ++i) {
                item = this.wFields.table.getItem(i);
                if (this.input.getLookupfield().get(0).getArgumentField().get(i).getName() != null) {
                    item.setText(1, this.input.getLookupfield().get(0).getArgumentField().get(i).getName());
                }
                if (this.input.getLookupfield().get(0).getArgumentField().get(i).getParameter() != null) {
                    item.setText(2, this.input.getLookupfield().get(0).getArgumentField().get(i).getParameter());
                }
                item.setText(3, this.input.getLookupfield().get(0).getArgumentField().get(i).isHeader() ? YES : NO);
            }
        }
        if (this.input.getLookupfield().get(0).getQueryField() != null) {
            for (i = 0; i < this.input.getLookupfield().get(0).getQueryField().size(); ++i) {
                item = this.wQuery.table.getItem(i);
                if (this.input.getLookupfield().get(0).getQueryField().get(i).getName() != null) {
                    item.setText(1, this.input.getLookupfield().get(0).getQueryField().get(i).getName());
                }
                if (this.input.getLookupfield().get(0).getQueryField().get(i).getParameter() == null) continue;
                item.setText(2, this.input.getLookupfield().get(0).getQueryField().get(i).getParameter());
            }
        }
        if (this.input.getUrl() != null) {
            this.wUrl.setText(this.input.getUrl());
        }
        this.wUrlInField.setSelection(this.input.isUrlInField());
        if (this.input.getUrlField() != null) {
            this.wUrlField.setText(this.input.getUrlField());
        }
        if (this.input.getRequestEntity() != null) {
            this.wRequestEntity.setText(this.input.getRequestEntity());
        }
        if (this.input.getHttpPostResultField().get(0).getName() != null) {
            this.wResult.setText(this.input.getHttpPostResultField().get(0).getName());
        }
        if (this.input.getHttpPostResultField().get(0).getCode() != null) {
            this.wResultCode.setText(this.input.getHttpPostResultField().get(0).getCode());
        }
        if (this.input.getHttpPostResultField().get(0).getResponseTimeFieldName() != null) {
            this.wResponseTime.setText(this.input.getHttpPostResultField().get(0).getResponseTimeFieldName());
        }
        if (this.input.getEncoding() != null) {
            this.wEncoding.setText(this.input.getEncoding());
        }
        this.wPostAFile.setSelection(this.input.isPostAFile());
        if (this.input.getHttpLogin() != null) {
            this.wHttpLogin.setText(this.input.getHttpLogin());
        }
        if (this.input.getHttpPassword() != null) {
            this.wHttpPassword.setText(this.input.getHttpPassword());
        }
        if (this.input.getProxyHost() != null) {
            this.wProxyHost.setText(this.input.getProxyHost());
        }
        if (this.input.getProxyPort() != null) {
            this.wProxyPort.setText(this.input.getProxyPort());
        }
        if (this.input.getHttpPostResultField().get(0).getResponseHeaderFieldName() != null) {
            this.wResponseHeader.setText(this.input.getHttpPostResultField().get(0).getResponseHeaderFieldName());
        }
        this.wSocketTimeOut.setText(Const.NVL((String)this.input.getSocketTimeout(), (String)""));
        this.wConnectionTimeOut.setText(Const.NVL((String)this.input.getConnectionTimeout(), (String)""));
        this.wCloseIdleConnectionsTime.setText(Const.NVL((String)this.input.getCloseIdleConnectionsTime(), (String)""));
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        HttpPostLoookupField loookupField = new HttpPostLoookupField();
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        int nrargs = this.wFields.nrNonEmpty();
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.Log.FoundArguments", (String[])new String[]{String.valueOf(nrargs)}));
        }
        for (int i = 0; i < nrargs; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            HttpPostArgumentField argumentField = new HttpPostArgumentField(item.getText(1), item.getText(2), YES.equals(item.getText(3)));
            loookupField.getArgumentField().add(argumentField);
        }
        int nrqueryparams = this.wQuery.nrNonEmpty();
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.Log.FoundQueryParameters", (String[])new String[]{String.valueOf(nrqueryparams)}));
        }
        for (int i = 0; i < nrqueryparams; ++i) {
            TableItem item = this.wQuery.getNonEmpty(i);
            this.input.getLookupfield().get(0).getQueryField().clear();
            HttpPostQuery httpPostQuery = new HttpPostQuery(item.getText(1), item.getText(2));
            loookupField.getQueryField().add(httpPostQuery);
        }
        ArrayList<HttpPostLoookupField> listLookupField = new ArrayList<HttpPostLoookupField>();
        listLookupField.add(loookupField);
        this.input.setLookupfield(listLookupField);
        this.input.setUrl(this.wUrl.getText());
        this.input.setUrlField(this.wUrlField.getText());
        this.input.setRequestEntity(this.wRequestEntity.getText());
        this.input.setUrlInField(this.wUrlInField.getSelection());
        HttpPostResultField httpPostResultField = new HttpPostResultField(this.wResult.getText(), this.wResultCode.getText(), this.wResponseTime.getText(), this.wResponseHeader.getText());
        ArrayList<HttpPostResultField> listHttpPostResultField = new ArrayList<HttpPostResultField>();
        listHttpPostResultField.add(httpPostResultField);
        this.input.setHttpPostResultField(listHttpPostResultField);
        this.input.setEncoding(this.wEncoding.getText());
        this.input.setPostAFile(this.wPostAFile.getSelection());
        this.input.setHttpLogin(this.wHttpLogin.getText());
        this.input.setHttpPassword(this.wHttpPassword.getText());
        this.input.setProxyHost(this.wProxyHost.getText());
        this.input.setProxyPort(this.wProxyPort.getText());
        this.input.setSocketTimeout(this.wSocketTimeOut.getText());
        this.input.setConnectionTimeout(this.wConnectionTimeOut.getText());
        this.input.setCloseIdleConnectionsTime(this.wCloseIdleConnectionsTime.getText());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    tableItem.setText(3, NO);
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, null, (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getQueryFields() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wQuery, (int)1, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HTTPPOSTDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

