/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.workflow.actions.util.IFtpConnection;

public class FtpClientUtil {
    private static final Class<?> PKG = FtpClientUtil.class;

    public static final FTPClient connectAndLogin(ILogChannel log, IVariables variables, IFtpConnection connection, String actionName) throws HopException {
        FTPClient ftpClient = new FTPClient();
        try {
            String realServername = variables.resolve(connection.getServerName());
            String realServerPort = variables.resolve(connection.getServerPort());
            int realPort = 21;
            if (StringUtils.isNotEmpty((String)realServername)) {
                realPort = Const.toInt((String)realServerPort, (int)21);
            }
            ftpClient.connect(realServername, realPort);
            if (log.isDetailed()) {
                log.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.OpenedConnection", (String[])new String[]{realServername}));
            }
            Proxy proxy = Proxy.NO_PROXY;
            if (!Utils.isEmpty((CharSequence)connection.getProxyHost())) {
                String realProxyHost = variables.resolve(connection.getProxyHost());
                if (log.isDetailed()) {
                    log.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.OpenedProxyConnectionOn", (String[])new String[]{realProxyHost}));
                }
                int realProxyPort = Const.toInt((String)variables.resolve(connection.getProxyPort()), (int)21);
                proxy = new Proxy(Proxy.Type.DIRECT, new InetSocketAddress(realProxyHost, realProxyPort));
            }
            if (connection.isActiveConnection()) {
                ftpClient.enterLocalActiveMode();
                if (log.isDetailed()) {
                    log.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.SetActive", (String[])new String[0]));
                }
            } else {
                ftpClient.enterLocalPassiveMode();
                if (log.isDetailed()) {
                    log.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.SetPassive", (String[])new String[0]));
                }
            }
            if (connection.isBinaryMode()) {
                ftpClient.setFileType(2);
                if (log.isDetailed()) {
                    log.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.SetBinary", (String[])new String[0]));
                }
            } else {
                ftpClient.setFileType(0);
                if (log.isDetailed()) {
                    log.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.SetAscii", (String[])new String[0]));
                }
            }
            ftpClient.setConnectTimeout(connection.getTimeout());
            if (log.isDetailed()) {
                log.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.SetTimeout", (String[])new String[]{String.valueOf(connection.getTimeout())}));
            }
            if (StringUtils.isNotEmpty((String)connection.getControlEncoding())) {
                String realControlEncoding = variables.resolve(connection.getControlEncoding());
                ftpClient.setControlEncoding(realControlEncoding);
                if (log.isDetailed()) {
                    log.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.SetEncoding", (String[])new String[]{connection.getControlEncoding()}));
                }
            }
            if (!Utils.isEmpty((CharSequence)connection.getSocksProxyHost())) {
                if (Utils.isEmpty((CharSequence)connection.getSocksProxyPort())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionFTP.SocksProxy.PortMissingException", (String[])new String[]{variables.resolve(connection.getSocksProxyHost()), actionName}));
                }
                String realSocksProxyHost = variables.resolve(connection.getSocksProxyPort());
                int realSocksProxyPort = Const.toInt((String)variables.resolve(connection.getSocksProxyPort()), (int)21);
                proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(realSocksProxyHost, realSocksProxyPort));
                FtpClientUtil.clearSocksJvmSettings();
                if (!Utils.isEmpty((CharSequence)connection.getSocksProxyUsername()) && !Utils.isEmpty((CharSequence)connection.getSocksProxyPassword())) {
                    System.setProperty("java.net.socks.username", variables.resolve(connection.getSocksProxyUsername()));
                    System.setProperty("java.net.socks.password", variables.resolve(connection.getSocksProxyPassword()));
                } else if (!Utils.isEmpty((CharSequence)connection.getSocksProxyUsername()) && Utils.isEmpty((CharSequence)connection.getSocksProxyPassword()) || Utils.isEmpty((CharSequence)connection.getSocksProxyUsername()) && !Utils.isEmpty((CharSequence)connection.getSocksProxyPassword())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionFTP.SocksProxy.IncompleteCredentials", (String[])new String[]{variables.resolve(connection.getSocksProxyHost()), actionName}));
                }
            }
            String realUsername = variables.resolve(connection.getUserName()) + (!Utils.isEmpty((CharSequence)connection.getProxyHost()) ? "@" + realServername : "") + (!Utils.isEmpty((CharSequence)connection.getProxyUsername()) ? " " + variables.resolve(connection.getProxyUsername()) : "");
            String realPassword = Utils.resolvePassword((IVariables)variables, (String)connection.getPassword()) + (!Utils.isEmpty((CharSequence)connection.getProxyPassword()) ? " " + Utils.resolvePassword((IVariables)variables, (String)connection.getProxyPassword()) : "");
            ftpClient.login(realUsername, realPassword);
            if (log.isDetailed()) {
                log.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.LoggedIn", (String[])new String[]{realUsername}));
            }
        }
        catch (Exception e) {
            throw new HopException("Error creating FTP connection", (Throwable)e);
        }
        return ftpClient;
    }

    public static void clearSocksJvmSettings() {
        System.clearProperty("java.net.socks.username");
        System.clearProperty("java.net.socks.password");
    }

    public static boolean fileExists(FTPClient ftpClient, String filename) throws IOException {
        InputStream checkInputStream = ftpClient.retrieveFileStream(filename);
        if (checkInputStream == null) {
            return false;
        }
        int replyCode = ftpClient.getReplyCode();
        if (replyCode == 500) {
            return false;
        }
        checkInputStream.close();
        return true;
    }
}

