/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.ftpdelete;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.actions.sftp.SftpClient;
import org.apache.hop.workflow.actions.util.FtpClientUtil;
import org.apache.hop.workflow.actions.util.IFtpConnection;
import org.w3c.dom.Node;

@Action(id="FTP_DELETE", name="i18n::ActionFTPDelete.Name", description="i18n::ActionFTPDelete.Description", image="FTPDelete.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileTransfer", documentationUrl="/workflow/actions/ftpdelete.html")
public class ActionFtpDelete
extends ActionBase
implements Cloneable,
IAction,
IFtpConnection {
    private static final Class<?> PKG = ActionFtpDelete.class;
    private String serverName = null;
    private String serverPort = "21";
    private String userName;
    private String password;
    private String remoteDirectory;
    private String wildcard;
    private int timeout;
    private boolean activeConnection;
    private boolean publicPublicKey = false;
    private String keyFilename = null;
    private String keyFilePass = null;
    private boolean useProxy;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String socksProxyHost;
    private String socksProxyPort = "1080";
    private String socksProxyUsername;
    private String socksProxyPassword;
    private String protocol = "FTP";
    public static final String PROTOCOL_FTP = "FTP";
    public static final String PROTOCOL_SFTP = "SFTP";
    public String SUCCESS_IF_AT_LEAST_X_FILES_DOWNLOADED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_ALL_FILES_DOWNLOADED = "success_is_all_files_downloaded";
    private String nrLimitSuccess = "10";
    private String successCondition = this.SUCCESS_IF_ALL_FILES_DOWNLOADED;
    private boolean copyPrevious = false;
    long nrErrors = 0L;
    long nrFilesDeleted = 0L;
    boolean successConditionBroken = false;
    String targetFilename = null;
    int limitFiles = 0;
    FTPClient ftpclient = null;
    SftpClient sftpclient = null;

    public ActionFtpDelete(String n) {
        super(n, "");
    }

    public ActionFtpDelete() {
        this("");
    }

    public Object clone() {
        ActionFtpDelete je = (ActionFtpDelete)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(550);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"protocol", (String)this.protocol));
        retval.append("      ").append(XmlHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"port", (String)this.serverPort));
        retval.append("      ").append(XmlHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("      ").append(XmlHandler.addTagValue((String)"ftpdirectory", (String)this.remoteDirectory));
        retval.append("      ").append(XmlHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XmlHandler.addTagValue((String)"timeout", (int)this.timeout));
        retval.append("      ").append(XmlHandler.addTagValue((String)"active", (boolean)this.activeConnection));
        retval.append("      ").append(XmlHandler.addTagValue((String)"useproxy", (boolean)this.useProxy));
        retval.append("      ").append(XmlHandler.addTagValue((String)"proxy_host", (String)this.proxyHost));
        retval.append("      ").append(XmlHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        retval.append("      ").append(XmlHandler.addTagValue((String)"proxy_username", (String)this.proxyUsername));
        retval.append("      ").append(XmlHandler.addTagValue((String)"proxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        retval.append("      ").append(XmlHandler.addTagValue((String)"publicpublickey", (boolean)this.publicPublicKey));
        retval.append("      ").append(XmlHandler.addTagValue((String)"keyfilename", (String)this.keyFilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"keyfilepass", (String)this.keyFilePass));
        retval.append("      ").append(XmlHandler.addTagValue((String)"nr_limit_success", (String)this.nrLimitSuccess));
        retval.append("      ").append(XmlHandler.addTagValue((String)"success_condition", (String)this.successCondition));
        retval.append("      ").append(XmlHandler.addTagValue((String)"copyprevious", (boolean)this.copyPrevious));
        retval.append("      ").append(XmlHandler.addTagValue((String)"socksproxy_host", (String)this.socksProxyHost));
        retval.append("      ").append(XmlHandler.addTagValue((String)"socksproxy_port", (String)this.socksProxyPort));
        retval.append("      ").append(XmlHandler.addTagValue((String)"socksproxy_username", (String)this.socksProxyUsername));
        retval.append("      ").append(XmlHandler.addTagValue((String)"socksproxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getSocksProxyPassword())));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.protocol = XmlHandler.getTagValue((Node)entrynode, (String)"protocol");
            this.serverPort = XmlHandler.getTagValue((Node)entrynode, (String)"port");
            this.serverName = XmlHandler.getTagValue((Node)entrynode, (String)"servername");
            this.userName = XmlHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)"password"));
            this.remoteDirectory = XmlHandler.getTagValue((Node)entrynode, (String)"ftpdirectory");
            this.wildcard = XmlHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.timeout = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"timeout"), (int)10000);
            this.activeConnection = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"active"));
            this.useProxy = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"useproxy"));
            this.proxyHost = XmlHandler.getTagValue((Node)entrynode, (String)"proxy_host");
            this.proxyPort = XmlHandler.getTagValue((Node)entrynode, (String)"proxy_port");
            this.proxyUsername = XmlHandler.getTagValue((Node)entrynode, (String)"proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)"proxy_password"));
            this.publicPublicKey = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"publicpublickey"));
            this.keyFilename = XmlHandler.getTagValue((Node)entrynode, (String)"keyfilename");
            this.keyFilePass = XmlHandler.getTagValue((Node)entrynode, (String)"keyfilepass");
            this.nrLimitSuccess = XmlHandler.getTagValue((Node)entrynode, (String)"nr_limit_success");
            this.successCondition = XmlHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.copyPrevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"copyprevious"));
            this.socksProxyHost = XmlHandler.getTagValue((Node)entrynode, (String)"socksproxy_host");
            this.socksProxyPort = XmlHandler.getTagValue((Node)entrynode, (String)"socksproxy_port");
            this.socksProxyUsername = XmlHandler.getTagValue((Node)entrynode, (String)"socksproxy_username");
            this.socksProxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)"socksproxy_password"));
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load action of type 'ftp' from XML node", (Throwable)xe);
        }
    }

    private boolean getStatus() {
        boolean retval = false;
        if (this.nrErrors == 0L && this.getSuccessCondition().equals(this.SUCCESS_IF_ALL_FILES_DOWNLOADED) || this.nrFilesDeleted >= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_DOWNLOADED) || this.nrErrors <= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    public boolean isCopyPrevious() {
        return this.copyPrevious;
    }

    public void setCopyPrevious(boolean copyprevious) {
        this.copyPrevious = copyprevious;
    }

    public void setUsePublicKey(boolean publickey) {
        this.publicPublicKey = publickey;
    }

    public boolean isUsePublicKey() {
        return this.publicPublicKey;
    }

    public void setKeyFilename(String keyfilename) {
        this.keyFilename = keyfilename;
    }

    public String getKeyFilename() {
        return this.keyFilename;
    }

    public void setKeyFilePass(String keyFilePass) {
        this.keyFilePass = keyFilePass;
    }

    public String getKeyFilePass() {
        return this.keyFilePass;
    }

    public void setLimitSuccess(String nrLimitSuccessin) {
        this.nrLimitSuccess = nrLimitSuccessin;
    }

    public String getLimitSuccess() {
        return this.nrLimitSuccess;
    }

    public void setSuccessCondition(String successCondition) {
        this.successCondition = successCondition;
    }

    public String getSuccessCondition() {
        return this.successCondition;
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public void setRemoteDirectory(String directory) {
        this.remoteDirectory = directory;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean isBinaryMode() {
        return true;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public String getControlEncoding() {
        return null;
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void setUseProxy(boolean useproxy) {
        this.useProxy = useproxy;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @Override
    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    @Override
    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Override
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        String[] filelist;
        HashSet<String> listPreviousFiles;
        List rows;
        Result result;
        RowMetaAndData resultRow;
        block55: {
            int found;
            this.log.logBasic(BaseMessages.getString(PKG, (String)"ActionFTPDelete.Started", (String[])new String[]{this.serverName}));
            resultRow = null;
            result = previousResult;
            rows = result.getRows();
            result.setResult(false);
            this.nrErrors = 0L;
            this.nrFilesDeleted = 0L;
            this.successConditionBroken = false;
            listPreviousFiles = new HashSet<String>();
            String realServerName = this.resolve(this.serverName);
            String realServerPassword = Utils.resolvePassword((IVariables)this, (String)this.password);
            String realFtpDirectory = this.resolve(this.remoteDirectory);
            int realServerPort = Const.toInt((String)this.resolve(this.serverPort), (int)0);
            String realUsername = this.resolve(this.userName);
            String realPassword = Utils.resolvePassword((IVariables)this, (String)this.password);
            String realProxyHost = this.resolve(this.proxyHost);
            String realProxyUsername = this.resolve(this.proxyUsername);
            String realProxyPassword = Utils.resolvePassword((IVariables)this, (String)this.proxyPassword);
            int realProxyPort = Const.toInt((String)this.resolve(this.proxyPort), (int)0);
            String realKeyFilename = this.resolve(this.keyFilename);
            String realKeyPass = this.resolve(this.keyFilePass);
            String sourceFolder = "";
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTPDelete.Start", (String[])new String[0]));
            }
            if (this.copyPrevious && rows.size() == 0) {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTPDelete.ArgsFromPreviousNothing", (String[])new String[0]));
                }
                result.setResult(true);
                return result;
            }
            filelist = null;
            if (this.protocol.equals(PROTOCOL_FTP)) {
                String translatedWildcard;
                this.ftpConnect(realFtpDirectory);
                filelist = this.ftpclient.listNames();
                if (filelist.length == 1 && !Utils.isEmpty((CharSequence)(translatedWildcard = this.resolve(this.wildcard))) && filelist[0].startsWith(translatedWildcard)) {
                    throw new HopException(filelist[0]);
                }
            } else if (this.protocol.equals(PROTOCOL_SFTP)) {
                this.sftpConnect(realServerName, realUsername, realServerPort, realPassword, realFtpDirectory);
                filelist = this.sftpclient.dir();
            }
            if (this.isDetailed()) {
                this.logDetailed("ActionFTPDelete.FoundNFiles", new Object[]{String.valueOf(filelist.length)});
            }
            int n = found = filelist == null ? 0 : filelist.length;
            if (found != 0) break block55;
            result.setResult(true);
            Result result2 = result;
            if (this.ftpclient != null && this.ftpclient.isConnected()) {
                try {
                    this.ftpclient.quit();
                    this.ftpclient = null;
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionFTPDelete.ErrorQuitting", (String[])new String[]{e.getMessage()}));
                }
            }
            if (this.sftpclient != null) {
                try {
                    this.sftpclient.disconnect();
                    this.sftpclient = null;
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionFTPDelete.ErrorQuitting", (String[])new String[]{e.getMessage()}));
                }
            }
            FtpClientUtil.clearSocksJvmSettings();
            return result2;
        }
        try {
            Pattern pattern = null;
            if (this.copyPrevious) {
                for (int iteration = 0; iteration < rows.size(); ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    String filePrevious = resultRow.getString(0, null);
                    if (Utils.isEmpty((CharSequence)filePrevious)) continue;
                    listPreviousFiles.add(filePrevious);
                }
            } else if (!Utils.isEmpty((CharSequence)this.wildcard)) {
                String realWildcard = this.resolve(this.wildcard);
                pattern = Pattern.compile(realWildcard);
            }
            if (!this.getSuccessCondition().equals(this.SUCCESS_IF_ALL_FILES_DOWNLOADED)) {
                this.limitFiles = Const.toInt((String)this.resolve(this.getLimitSuccess()), (int)10);
            }
            for (int i = 0; i < filelist.length && !this.parentWorkflow.isStopped(); ++i) {
                if (this.successConditionBroken) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"ActionFTPDelete.SuccesConditionBroken", (String[])new String[0]));
                }
                boolean getIt = false;
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionFTPDelete.AnalysingFile", (String[])new String[]{filelist[i]}));
                }
                try {
                    if (this.copyPrevious) {
                        if (listPreviousFiles.contains(filelist[i])) {
                            getIt = true;
                        }
                    } else if (pattern != null) {
                        Matcher matcher = pattern.matcher(filelist[i]);
                        getIt = matcher.matches();
                    }
                    if (!getIt) continue;
                    if (this.protocol.equals(PROTOCOL_FTP)) {
                        this.ftpclient.deleteFile(filelist[i]);
                    } else if (this.protocol.equals(PROTOCOL_SFTP)) {
                        this.sftpclient.delete(filelist[i]);
                    }
                    if (this.isDetailed()) {
                        this.logDetailed("ActionFTPDelete.RemotefileDeleted", new Object[]{filelist[i]});
                    }
                    this.updateDeletedFiles();
                    continue;
                }
                catch (Exception e) {
                    this.updateErrors();
                    this.logError(BaseMessages.getString(PKG, (String)"ActionFtp.UnexpectedError", (String[])new String[]{e.getMessage()}));
                    if (!this.successConditionBroken) continue;
                    throw new Exception(BaseMessages.getString(PKG, (String)"ActionFTPDelete.SuccesConditionBroken", (String[])new String[0]));
                }
            }
        }
        catch (Exception e) {
            try {
                this.updateErrors();
                this.logError(BaseMessages.getString(PKG, (String)"ActionFTPDelete.ErrorGetting", (String[])new String[]{e.getMessage()}));
                this.logError(Const.getStackTracker((Throwable)e));
            }
            catch (Throwable throwable) {
                if (this.ftpclient != null && this.ftpclient.isConnected()) {
                    try {
                        this.ftpclient.quit();
                        this.ftpclient = null;
                    }
                    catch (Exception e2) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionFTPDelete.ErrorQuitting", (String[])new String[]{e2.getMessage()}));
                    }
                }
                if (this.sftpclient != null) {
                    try {
                        this.sftpclient.disconnect();
                        this.sftpclient = null;
                    }
                    catch (Exception e3) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionFTPDelete.ErrorQuitting", (String[])new String[]{e3.getMessage()}));
                    }
                }
                FtpClientUtil.clearSocksJvmSettings();
                throw throwable;
            }
            if (this.ftpclient != null && this.ftpclient.isConnected()) {
                try {
                    this.ftpclient.quit();
                    this.ftpclient = null;
                }
                catch (Exception e4) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionFTPDelete.ErrorQuitting", (String[])new String[]{e4.getMessage()}));
                }
            }
            if (this.sftpclient != null) {
                try {
                    this.sftpclient.disconnect();
                    this.sftpclient = null;
                }
                catch (Exception e5) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionFTPDelete.ErrorQuitting", (String[])new String[]{e5.getMessage()}));
                }
            }
            FtpClientUtil.clearSocksJvmSettings();
        }
        if (this.ftpclient != null && this.ftpclient.isConnected()) {
            try {
                this.ftpclient.quit();
                this.ftpclient = null;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionFTPDelete.ErrorQuitting", (String[])new String[]{e.getMessage()}));
            }
        }
        if (this.sftpclient != null) {
            try {
                this.sftpclient.disconnect();
                this.sftpclient = null;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionFTPDelete.ErrorQuitting", (String[])new String[]{e.getMessage()}));
            }
        }
        FtpClientUtil.clearSocksJvmSettings();
        result.setResult(!this.successConditionBroken);
        result.setNrFilesRetrieved(this.nrFilesDeleted);
        result.setNrErrors(this.nrErrors);
        return result;
    }

    public boolean isDirectory(SftpClient sftpClient, String filename) {
        try {
            return sftpClient.folderExists(filename);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void sftpConnect(String realservername, String realusername, int realport, String realpassword, String realFtpDirectory) throws Exception {
        this.sftpclient = new SftpClient(InetAddress.getByName(realservername), realport, realusername);
        this.sftpclient.login(realpassword);
        if (!Utils.isEmpty((CharSequence)realFtpDirectory)) {
            this.sftpclient.chdir(realFtpDirectory);
            if (this.isDetailed()) {
                this.logDetailed("Changed to directory [" + realFtpDirectory + "]");
            }
        }
    }

    private void ftpConnect(String realFtpDirectory) throws Exception {
        this.ftpclient = FtpClientUtil.connectAndLogin(this.log, (IVariables)this, this, this.getName());
        if (!Utils.isEmpty((CharSequence)realFtpDirectory)) {
            this.ftpclient.changeWorkingDirectory(realFtpDirectory);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTPDelete.ChangedDir", (String[])new String[]{realFtpDirectory}));
            }
        }
    }

    private void updateErrors() {
        ++this.nrErrors;
        if (!this.getStatus()) {
            this.successConditionBroken = true;
        }
    }

    private void updateDeletedFiles() {
        ++this.nrFilesDeleted;
    }

    public boolean isEvaluation() {
        return true;
    }

    @Override
    public boolean isActiveConnection() {
        return this.activeConnection;
    }

    public void setActiveConnection(boolean activeConnection) {
        this.activeConnection = activeConnection;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "serverName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "targetDirectory", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "userName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "password", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.serverName)) {
            String realServername = variables.resolve(this.serverName);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public String getSocksProxyHost() {
        return this.socksProxyHost;
    }

    @Override
    public String getSocksProxyPort() {
        return this.socksProxyPort;
    }

    @Override
    public String getSocksProxyUsername() {
        return this.socksProxyUsername;
    }

    @Override
    public String getSocksProxyPassword() {
        return this.socksProxyPassword;
    }

    public void setSocksProxyHost(String socksProxyHost) {
        this.socksProxyHost = socksProxyHost;
    }

    public void setSocksProxyPort(String socksProxyPort) {
        this.socksProxyPort = socksProxyPort;
    }

    public void setSocksProxyUsername(String socksProxyUsername) {
        this.socksProxyUsername = socksProxyUsername;
    }

    public void setSocksProxyPassword(String socksProxyPassword) {
        this.socksProxyPassword = socksProxyPassword;
    }
}

