/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.dataflow;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.dataflow.DataflowRequest;
import com.google.api.services.dataflow.DataflowRequestInitializer;
import com.google.api.services.dataflow.model.CreateJobFromTemplateRequest;
import com.google.api.services.dataflow.model.DeleteSnapshotResponse;
import com.google.api.services.dataflow.model.GetDebugConfigRequest;
import com.google.api.services.dataflow.model.GetDebugConfigResponse;
import com.google.api.services.dataflow.model.GetTemplateResponse;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.JobExecutionDetails;
import com.google.api.services.dataflow.model.JobMetrics;
import com.google.api.services.dataflow.model.LaunchFlexTemplateRequest;
import com.google.api.services.dataflow.model.LaunchFlexTemplateResponse;
import com.google.api.services.dataflow.model.LaunchTemplateParameters;
import com.google.api.services.dataflow.model.LaunchTemplateResponse;
import com.google.api.services.dataflow.model.LeaseWorkItemRequest;
import com.google.api.services.dataflow.model.LeaseWorkItemResponse;
import com.google.api.services.dataflow.model.ListJobMessagesResponse;
import com.google.api.services.dataflow.model.ListJobsResponse;
import com.google.api.services.dataflow.model.ListSnapshotsResponse;
import com.google.api.services.dataflow.model.ReportWorkItemStatusRequest;
import com.google.api.services.dataflow.model.ReportWorkItemStatusResponse;
import com.google.api.services.dataflow.model.SendDebugCaptureRequest;
import com.google.api.services.dataflow.model.SendDebugCaptureResponse;
import com.google.api.services.dataflow.model.SendWorkerMessagesRequest;
import com.google.api.services.dataflow.model.SendWorkerMessagesResponse;
import com.google.api.services.dataflow.model.Snapshot;
import com.google.api.services.dataflow.model.SnapshotJobRequest;
import com.google.api.services.dataflow.model.StageExecutionDetails;
import com.google.api.services.dataflow.model.ValidateResponse;
import java.io.IOException;

public class Dataflow
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://dataflow.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://dataflow.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://dataflow.googleapis.com/";

    public Dataflow(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Dataflow(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.31.0 of the Dataflow API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Dataflow.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://dataflow.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Dataflow.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Dataflow.DEFAULT_BATCH_PATH);
        }

        public Dataflow build() {
            return new Dataflow(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDataflowRequestInitializer(DataflowRequestInitializer dataflowRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)dataflowRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public DeleteSnapshots deleteSnapshots(String projectId) throws IOException {
            DeleteSnapshots result = new DeleteSnapshots(projectId);
            Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public WorkerMessages workerMessages(String projectId, SendWorkerMessagesRequest content) throws IOException {
            WorkerMessages result = new WorkerMessages(projectId, content);
            Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Jobs jobs() {
            return new Jobs();
        }

        public Locations locations() {
            return new Locations();
        }

        public Snapshots snapshots() {
            return new Snapshots();
        }

        public Templates templates() {
            return new Templates();
        }

        public class Templates {
            public Create create(String projectId, CreateJobFromTemplateRequest content) throws IOException {
                Create result = new Create(projectId, content);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String projectId) throws IOException {
                Get result = new Get(projectId);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Launch launch(String projectId, LaunchTemplateParameters content) throws IOException {
                Launch result = new Launch(projectId, content);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Launch
            extends DataflowRequest<LaunchTemplateResponse> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/templates:launch";
                @Key
                private String projectId;
                @Key(value="dynamicTemplate.gcsPath")
                private String dynamicTemplateGcsPath;
                @Key(value="dynamicTemplate.stagingLocation")
                private String dynamicTemplateStagingLocation;
                @Key
                private String gcsPath;
                @Key
                private String location;
                @Key
                private Boolean validateOnly;

                protected Launch(String projectId, LaunchTemplateParameters content) {
                    super(Dataflow.this, "POST", REST_PATH, (Object)content, LaunchTemplateResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public Launch set$Xgafv(String $Xgafv) {
                    return (Launch)super.set$Xgafv($Xgafv);
                }

                public Launch setAccessToken(String accessToken) {
                    return (Launch)super.setAccessToken(accessToken);
                }

                public Launch setAlt(String alt) {
                    return (Launch)super.setAlt(alt);
                }

                public Launch setCallback(String callback) {
                    return (Launch)super.setCallback(callback);
                }

                public Launch setFields(String fields) {
                    return (Launch)super.setFields(fields);
                }

                public Launch setKey(String key) {
                    return (Launch)super.setKey(key);
                }

                public Launch setOauthToken(String oauthToken) {
                    return (Launch)super.setOauthToken(oauthToken);
                }

                public Launch setPrettyPrint(Boolean prettyPrint) {
                    return (Launch)super.setPrettyPrint(prettyPrint);
                }

                public Launch setQuotaUser(String quotaUser) {
                    return (Launch)super.setQuotaUser(quotaUser);
                }

                public Launch setUploadType(String uploadType) {
                    return (Launch)super.setUploadType(uploadType);
                }

                public Launch setUploadProtocol(String uploadProtocol) {
                    return (Launch)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Launch setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getDynamicTemplateGcsPath() {
                    return this.dynamicTemplateGcsPath;
                }

                public Launch setDynamicTemplateGcsPath(String dynamicTemplateGcsPath) {
                    this.dynamicTemplateGcsPath = dynamicTemplateGcsPath;
                    return this;
                }

                public String getDynamicTemplateStagingLocation() {
                    return this.dynamicTemplateStagingLocation;
                }

                public Launch setDynamicTemplateStagingLocation(String dynamicTemplateStagingLocation) {
                    this.dynamicTemplateStagingLocation = dynamicTemplateStagingLocation;
                    return this;
                }

                public String getGcsPath() {
                    return this.gcsPath;
                }

                public Launch setGcsPath(String gcsPath) {
                    this.gcsPath = gcsPath;
                    return this;
                }

                public String getLocation() {
                    return this.location;
                }

                public Launch setLocation(String location) {
                    this.location = location;
                    return this;
                }

                public Boolean getValidateOnly() {
                    return this.validateOnly;
                }

                public Launch setValidateOnly(Boolean validateOnly) {
                    this.validateOnly = validateOnly;
                    return this;
                }

                @Override
                public Launch set(String parameterName, Object value) {
                    return (Launch)super.set(parameterName, value);
                }
            }

            public class Get
            extends DataflowRequest<GetTemplateResponse> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/templates:get";
                @Key
                private String projectId;
                @Key
                private String gcsPath;
                @Key
                private String location;
                @Key
                private String view;

                protected Get(String projectId) {
                    super(Dataflow.this, "GET", REST_PATH, null, GetTemplateResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getGcsPath() {
                    return this.gcsPath;
                }

                public Get setGcsPath(String gcsPath) {
                    this.gcsPath = gcsPath;
                    return this;
                }

                public String getLocation() {
                    return this.location;
                }

                public Get setLocation(String location) {
                    this.location = location;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public Get setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends DataflowRequest<Job> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/templates";
                @Key
                private String projectId;

                protected Create(String projectId, CreateJobFromTemplateRequest content) {
                    super(Dataflow.this, "POST", REST_PATH, (Object)content, Job.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Create setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Snapshots {
            public Get get(String projectId, String snapshotId) throws IOException {
                Get result = new Get(projectId, snapshotId);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String projectId) throws IOException {
                List result = new List(projectId);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends DataflowRequest<ListSnapshotsResponse> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/snapshots";
                @Key
                private String projectId;
                @Key
                private String jobId;
                @Key
                private String location;

                protected List(String projectId) {
                    super(Dataflow.this, "GET", REST_PATH, null, ListSnapshotsResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public List setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getJobId() {
                    return this.jobId;
                }

                public List setJobId(String jobId) {
                    this.jobId = jobId;
                    return this;
                }

                public String getLocation() {
                    return this.location;
                }

                public List setLocation(String location) {
                    this.location = location;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DataflowRequest<Snapshot> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/snapshots/{snapshotId}";
                @Key
                private String projectId;
                @Key
                private String snapshotId;
                @Key
                private String location;

                protected Get(String projectId, String snapshotId) {
                    super(Dataflow.this, "GET", REST_PATH, null, Snapshot.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.snapshotId = (String)Preconditions.checkNotNull((Object)snapshotId, (Object)"Required parameter snapshotId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getSnapshotId() {
                    return this.snapshotId;
                }

                public Get setSnapshotId(String snapshotId) {
                    this.snapshotId = snapshotId;
                    return this;
                }

                public String getLocation() {
                    return this.location;
                }

                public Get setLocation(String location) {
                    this.location = location;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Locations {
            public WorkerMessages workerMessages(String projectId, String location, SendWorkerMessagesRequest content) throws IOException {
                WorkerMessages result = new WorkerMessages(projectId, location, content);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public FlexTemplates flexTemplates() {
                return new FlexTemplates();
            }

            public Jobs jobs() {
                return new Jobs();
            }

            public Snapshots snapshots() {
                return new Snapshots();
            }

            public Sql sql() {
                return new Sql();
            }

            public Templates templates() {
                return new Templates();
            }

            public class Templates {
                public Create create(String projectId, String location, CreateJobFromTemplateRequest content) throws IOException {
                    Create result = new Create(projectId, location, content);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String projectId, String location) throws IOException {
                    Get result = new Get(projectId, location);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Launch launch(String projectId, String location, LaunchTemplateParameters content) throws IOException {
                    Launch result = new Launch(projectId, location, content);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Launch
                extends DataflowRequest<LaunchTemplateResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/templates:launch";
                    @Key
                    private String projectId;
                    @Key
                    private String location;
                    @Key(value="dynamicTemplate.gcsPath")
                    private String dynamicTemplateGcsPath;
                    @Key(value="dynamicTemplate.stagingLocation")
                    private String dynamicTemplateStagingLocation;
                    @Key
                    private String gcsPath;
                    @Key
                    private Boolean validateOnly;

                    protected Launch(String projectId, String location, LaunchTemplateParameters content) {
                        super(Dataflow.this, "POST", REST_PATH, (Object)content, LaunchTemplateResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                    }

                    public Launch set$Xgafv(String $Xgafv) {
                        return (Launch)super.set$Xgafv($Xgafv);
                    }

                    public Launch setAccessToken(String accessToken) {
                        return (Launch)super.setAccessToken(accessToken);
                    }

                    public Launch setAlt(String alt) {
                        return (Launch)super.setAlt(alt);
                    }

                    public Launch setCallback(String callback) {
                        return (Launch)super.setCallback(callback);
                    }

                    public Launch setFields(String fields) {
                        return (Launch)super.setFields(fields);
                    }

                    public Launch setKey(String key) {
                        return (Launch)super.setKey(key);
                    }

                    public Launch setOauthToken(String oauthToken) {
                        return (Launch)super.setOauthToken(oauthToken);
                    }

                    public Launch setPrettyPrint(Boolean prettyPrint) {
                        return (Launch)super.setPrettyPrint(prettyPrint);
                    }

                    public Launch setQuotaUser(String quotaUser) {
                        return (Launch)super.setQuotaUser(quotaUser);
                    }

                    public Launch setUploadType(String uploadType) {
                        return (Launch)super.setUploadType(uploadType);
                    }

                    public Launch setUploadProtocol(String uploadProtocol) {
                        return (Launch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Launch setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public Launch setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    public String getDynamicTemplateGcsPath() {
                        return this.dynamicTemplateGcsPath;
                    }

                    public Launch setDynamicTemplateGcsPath(String dynamicTemplateGcsPath) {
                        this.dynamicTemplateGcsPath = dynamicTemplateGcsPath;
                        return this;
                    }

                    public String getDynamicTemplateStagingLocation() {
                        return this.dynamicTemplateStagingLocation;
                    }

                    public Launch setDynamicTemplateStagingLocation(String dynamicTemplateStagingLocation) {
                        this.dynamicTemplateStagingLocation = dynamicTemplateStagingLocation;
                        return this;
                    }

                    public String getGcsPath() {
                        return this.gcsPath;
                    }

                    public Launch setGcsPath(String gcsPath) {
                        this.gcsPath = gcsPath;
                        return this;
                    }

                    public Boolean getValidateOnly() {
                        return this.validateOnly;
                    }

                    public Launch setValidateOnly(Boolean validateOnly) {
                        this.validateOnly = validateOnly;
                        return this;
                    }

                    @Override
                    public Launch set(String parameterName, Object value) {
                        return (Launch)super.set(parameterName, value);
                    }
                }

                public class Get
                extends DataflowRequest<GetTemplateResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/templates:get";
                    @Key
                    private String projectId;
                    @Key
                    private String location;
                    @Key
                    private String gcsPath;
                    @Key
                    private String view;

                    protected Get(String projectId, String location) {
                        super(Dataflow.this, "GET", REST_PATH, null, GetTemplateResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public Get setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    public String getGcsPath() {
                        return this.gcsPath;
                    }

                    public Get setGcsPath(String gcsPath) {
                        this.gcsPath = gcsPath;
                        return this;
                    }

                    public String getView() {
                        return this.view;
                    }

                    public Get setView(String view) {
                        this.view = view;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Create
                extends DataflowRequest<Job> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/templates";
                    @Key
                    private String projectId;
                    @Key
                    private String location;

                    protected Create(String projectId, String location, CreateJobFromTemplateRequest content) {
                        super(Dataflow.this, "POST", REST_PATH, (Object)content, Job.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Create setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public Create setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Sql {
                public Validate validate(String projectId, String location) throws IOException {
                    Validate result = new Validate(projectId, location);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Validate
                extends DataflowRequest<ValidateResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/sql:validate";
                    @Key
                    private String projectId;
                    @Key
                    private String location;
                    @Key
                    private String query;

                    protected Validate(String projectId, String location) {
                        super(Dataflow.this, "GET", REST_PATH, null, ValidateResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Validate set$Xgafv(String $Xgafv) {
                        return (Validate)super.set$Xgafv($Xgafv);
                    }

                    public Validate setAccessToken(String accessToken) {
                        return (Validate)super.setAccessToken(accessToken);
                    }

                    public Validate setAlt(String alt) {
                        return (Validate)super.setAlt(alt);
                    }

                    public Validate setCallback(String callback) {
                        return (Validate)super.setCallback(callback);
                    }

                    public Validate setFields(String fields) {
                        return (Validate)super.setFields(fields);
                    }

                    public Validate setKey(String key) {
                        return (Validate)super.setKey(key);
                    }

                    public Validate setOauthToken(String oauthToken) {
                        return (Validate)super.setOauthToken(oauthToken);
                    }

                    public Validate setPrettyPrint(Boolean prettyPrint) {
                        return (Validate)super.setPrettyPrint(prettyPrint);
                    }

                    public Validate setQuotaUser(String quotaUser) {
                        return (Validate)super.setQuotaUser(quotaUser);
                    }

                    public Validate setUploadType(String uploadType) {
                        return (Validate)super.setUploadType(uploadType);
                    }

                    public Validate setUploadProtocol(String uploadProtocol) {
                        return (Validate)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Validate setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public Validate setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    public String getQuery() {
                        return this.query;
                    }

                    public Validate setQuery(String query) {
                        this.query = query;
                        return this;
                    }

                    @Override
                    public Validate set(String parameterName, Object value) {
                        return (Validate)super.set(parameterName, value);
                    }
                }
            }

            public class Snapshots {
                public Delete delete(String projectId, String location, String snapshotId) throws IOException {
                    Delete result = new Delete(projectId, location, snapshotId);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String projectId, String location, String snapshotId) throws IOException {
                    Get result = new Get(projectId, location, snapshotId);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String projectId, String location) throws IOException {
                    List result = new List(projectId, location);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends DataflowRequest<ListSnapshotsResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/snapshots";
                    @Key
                    private String projectId;
                    @Key
                    private String location;
                    @Key
                    private String jobId;

                    protected List(String projectId, String location) {
                        super(Dataflow.this, "GET", REST_PATH, null, ListSnapshotsResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public List setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public List setJobId(String jobId) {
                        this.jobId = jobId;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends DataflowRequest<Snapshot> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/snapshots/{snapshotId}";
                    @Key
                    private String projectId;
                    @Key
                    private String location;
                    @Key
                    private String snapshotId;

                    protected Get(String projectId, String location, String snapshotId) {
                        super(Dataflow.this, "GET", REST_PATH, null, Snapshot.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                        this.snapshotId = (String)Preconditions.checkNotNull((Object)snapshotId, (Object)"Required parameter snapshotId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public Get setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    public String getSnapshotId() {
                        return this.snapshotId;
                    }

                    public Get setSnapshotId(String snapshotId) {
                        this.snapshotId = snapshotId;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends DataflowRequest<DeleteSnapshotResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/snapshots/{snapshotId}";
                    @Key
                    private String projectId;
                    @Key
                    private String location;
                    @Key
                    private String snapshotId;

                    protected Delete(String projectId, String location, String snapshotId) {
                        super(Dataflow.this, "DELETE", REST_PATH, null, DeleteSnapshotResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                        this.snapshotId = (String)Preconditions.checkNotNull((Object)snapshotId, (Object)"Required parameter snapshotId must be specified.");
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Delete setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public Delete setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    public String getSnapshotId() {
                        return this.snapshotId;
                    }

                    public Delete setSnapshotId(String snapshotId) {
                        this.snapshotId = snapshotId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }
            }

            public class Jobs {
                public Create create(String projectId, String location, Job content) throws IOException {
                    Create result = new Create(projectId, location, content);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String projectId, String location, String jobId) throws IOException {
                    Get result = new Get(projectId, location, jobId);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetExecutionDetails getExecutionDetails(String projectId, String location, String jobId) throws IOException {
                    GetExecutionDetails result = new GetExecutionDetails(projectId, location, jobId);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetMetrics getMetrics(String projectId, String location, String jobId) throws IOException {
                    GetMetrics result = new GetMetrics(projectId, location, jobId);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String projectId, String location) throws IOException {
                    List result = new List(projectId, location);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Snapshot snapshot(String projectId, String location, String jobId, SnapshotJobRequest content) throws IOException {
                    Snapshot result = new Snapshot(projectId, location, jobId, content);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Update update(String projectId, String location, String jobId, Job content) throws IOException {
                    Update result = new Update(projectId, location, jobId, content);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Debug debug() {
                    return new Debug();
                }

                public Messages messages() {
                    return new Messages();
                }

                public Snapshots snapshots() {
                    return new Snapshots();
                }

                public Stages stages() {
                    return new Stages();
                }

                public WorkItems workItems() {
                    return new WorkItems();
                }

                public class WorkItems {
                    public Lease lease(String projectId, String location, String jobId, LeaseWorkItemRequest content) throws IOException {
                        Lease result = new Lease(projectId, location, jobId, content);
                        Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public ReportStatus reportStatus(String projectId, String location, String jobId, ReportWorkItemStatusRequest content) throws IOException {
                        ReportStatus result = new ReportStatus(projectId, location, jobId, content);
                        Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class ReportStatus
                    extends DataflowRequest<ReportWorkItemStatusResponse> {
                        private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/workItems:reportStatus";
                        @Key
                        private String projectId;
                        @Key
                        private String location;
                        @Key
                        private String jobId;

                        protected ReportStatus(String projectId, String location, String jobId, ReportWorkItemStatusRequest content) {
                            super(Dataflow.this, "POST", REST_PATH, (Object)content, ReportWorkItemStatusResponse.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                            this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                        }

                        public ReportStatus set$Xgafv(String $Xgafv) {
                            return (ReportStatus)super.set$Xgafv($Xgafv);
                        }

                        public ReportStatus setAccessToken(String accessToken) {
                            return (ReportStatus)super.setAccessToken(accessToken);
                        }

                        public ReportStatus setAlt(String alt) {
                            return (ReportStatus)super.setAlt(alt);
                        }

                        public ReportStatus setCallback(String callback) {
                            return (ReportStatus)super.setCallback(callback);
                        }

                        public ReportStatus setFields(String fields) {
                            return (ReportStatus)super.setFields(fields);
                        }

                        public ReportStatus setKey(String key) {
                            return (ReportStatus)super.setKey(key);
                        }

                        public ReportStatus setOauthToken(String oauthToken) {
                            return (ReportStatus)super.setOauthToken(oauthToken);
                        }

                        public ReportStatus setPrettyPrint(Boolean prettyPrint) {
                            return (ReportStatus)super.setPrettyPrint(prettyPrint);
                        }

                        public ReportStatus setQuotaUser(String quotaUser) {
                            return (ReportStatus)super.setQuotaUser(quotaUser);
                        }

                        public ReportStatus setUploadType(String uploadType) {
                            return (ReportStatus)super.setUploadType(uploadType);
                        }

                        public ReportStatus setUploadProtocol(String uploadProtocol) {
                            return (ReportStatus)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public ReportStatus setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getLocation() {
                            return this.location;
                        }

                        public ReportStatus setLocation(String location) {
                            this.location = location;
                            return this;
                        }

                        public String getJobId() {
                            return this.jobId;
                        }

                        public ReportStatus setJobId(String jobId) {
                            this.jobId = jobId;
                            return this;
                        }

                        @Override
                        public ReportStatus set(String parameterName, Object value) {
                            return (ReportStatus)super.set(parameterName, value);
                        }
                    }

                    public class Lease
                    extends DataflowRequest<LeaseWorkItemResponse> {
                        private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/workItems:lease";
                        @Key
                        private String projectId;
                        @Key
                        private String location;
                        @Key
                        private String jobId;

                        protected Lease(String projectId, String location, String jobId, LeaseWorkItemRequest content) {
                            super(Dataflow.this, "POST", REST_PATH, (Object)content, LeaseWorkItemResponse.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                            this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                        }

                        public Lease set$Xgafv(String $Xgafv) {
                            return (Lease)super.set$Xgafv($Xgafv);
                        }

                        public Lease setAccessToken(String accessToken) {
                            return (Lease)super.setAccessToken(accessToken);
                        }

                        public Lease setAlt(String alt) {
                            return (Lease)super.setAlt(alt);
                        }

                        public Lease setCallback(String callback) {
                            return (Lease)super.setCallback(callback);
                        }

                        public Lease setFields(String fields) {
                            return (Lease)super.setFields(fields);
                        }

                        public Lease setKey(String key) {
                            return (Lease)super.setKey(key);
                        }

                        public Lease setOauthToken(String oauthToken) {
                            return (Lease)super.setOauthToken(oauthToken);
                        }

                        public Lease setPrettyPrint(Boolean prettyPrint) {
                            return (Lease)super.setPrettyPrint(prettyPrint);
                        }

                        public Lease setQuotaUser(String quotaUser) {
                            return (Lease)super.setQuotaUser(quotaUser);
                        }

                        public Lease setUploadType(String uploadType) {
                            return (Lease)super.setUploadType(uploadType);
                        }

                        public Lease setUploadProtocol(String uploadProtocol) {
                            return (Lease)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Lease setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getLocation() {
                            return this.location;
                        }

                        public Lease setLocation(String location) {
                            this.location = location;
                            return this;
                        }

                        public String getJobId() {
                            return this.jobId;
                        }

                        public Lease setJobId(String jobId) {
                            this.jobId = jobId;
                            return this;
                        }

                        @Override
                        public Lease set(String parameterName, Object value) {
                            return (Lease)super.set(parameterName, value);
                        }
                    }
                }

                public class Stages {
                    public GetExecutionDetails getExecutionDetails(String projectId, String location, String jobId, String stageId) throws IOException {
                        GetExecutionDetails result = new GetExecutionDetails(projectId, location, jobId, stageId);
                        Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class GetExecutionDetails
                    extends DataflowRequest<StageExecutionDetails> {
                        private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/stages/{stageId}/executionDetails";
                        @Key
                        private String projectId;
                        @Key
                        private String location;
                        @Key
                        private String jobId;
                        @Key
                        private String stageId;
                        @Key
                        private String endTime;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;
                        @Key
                        private String startTime;

                        protected GetExecutionDetails(String projectId, String location, String jobId, String stageId) {
                            super(Dataflow.this, "GET", REST_PATH, null, StageExecutionDetails.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                            this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                            this.stageId = (String)Preconditions.checkNotNull((Object)stageId, (Object)"Required parameter stageId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public GetExecutionDetails set$Xgafv(String $Xgafv) {
                            return (GetExecutionDetails)super.set$Xgafv($Xgafv);
                        }

                        public GetExecutionDetails setAccessToken(String accessToken) {
                            return (GetExecutionDetails)super.setAccessToken(accessToken);
                        }

                        public GetExecutionDetails setAlt(String alt) {
                            return (GetExecutionDetails)super.setAlt(alt);
                        }

                        public GetExecutionDetails setCallback(String callback) {
                            return (GetExecutionDetails)super.setCallback(callback);
                        }

                        public GetExecutionDetails setFields(String fields) {
                            return (GetExecutionDetails)super.setFields(fields);
                        }

                        public GetExecutionDetails setKey(String key) {
                            return (GetExecutionDetails)super.setKey(key);
                        }

                        public GetExecutionDetails setOauthToken(String oauthToken) {
                            return (GetExecutionDetails)super.setOauthToken(oauthToken);
                        }

                        public GetExecutionDetails setPrettyPrint(Boolean prettyPrint) {
                            return (GetExecutionDetails)super.setPrettyPrint(prettyPrint);
                        }

                        public GetExecutionDetails setQuotaUser(String quotaUser) {
                            return (GetExecutionDetails)super.setQuotaUser(quotaUser);
                        }

                        public GetExecutionDetails setUploadType(String uploadType) {
                            return (GetExecutionDetails)super.setUploadType(uploadType);
                        }

                        public GetExecutionDetails setUploadProtocol(String uploadProtocol) {
                            return (GetExecutionDetails)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public GetExecutionDetails setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getLocation() {
                            return this.location;
                        }

                        public GetExecutionDetails setLocation(String location) {
                            this.location = location;
                            return this;
                        }

                        public String getJobId() {
                            return this.jobId;
                        }

                        public GetExecutionDetails setJobId(String jobId) {
                            this.jobId = jobId;
                            return this;
                        }

                        public String getStageId() {
                            return this.stageId;
                        }

                        public GetExecutionDetails setStageId(String stageId) {
                            this.stageId = stageId;
                            return this;
                        }

                        public String getEndTime() {
                            return this.endTime;
                        }

                        public GetExecutionDetails setEndTime(String endTime) {
                            this.endTime = endTime;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public GetExecutionDetails setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public GetExecutionDetails setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        public String getStartTime() {
                            return this.startTime;
                        }

                        public GetExecutionDetails setStartTime(String startTime) {
                            this.startTime = startTime;
                            return this;
                        }

                        @Override
                        public GetExecutionDetails set(String parameterName, Object value) {
                            return (GetExecutionDetails)super.set(parameterName, value);
                        }
                    }
                }

                public class Snapshots {
                    public List list(String projectId, String location, String jobId) throws IOException {
                        List result = new List(projectId, location, jobId);
                        Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends DataflowRequest<ListSnapshotsResponse> {
                        private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/snapshots";
                        @Key
                        private String projectId;
                        @Key
                        private String location;
                        @Key
                        private String jobId;

                        protected List(String projectId, String location, String jobId) {
                            super(Dataflow.this, "GET", REST_PATH, null, ListSnapshotsResponse.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                            this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public List setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getLocation() {
                            return this.location;
                        }

                        public List setLocation(String location) {
                            this.location = location;
                            return this;
                        }

                        public String getJobId() {
                            return this.jobId;
                        }

                        public List setJobId(String jobId) {
                            this.jobId = jobId;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class Messages {
                    public List list(String projectId, String location, String jobId) throws IOException {
                        List result = new List(projectId, location, jobId);
                        Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends DataflowRequest<ListJobMessagesResponse> {
                        private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/messages";
                        @Key
                        private String projectId;
                        @Key
                        private String location;
                        @Key
                        private String jobId;
                        @Key
                        private String endTime;
                        @Key
                        private String minimumImportance;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;
                        @Key
                        private String startTime;

                        protected List(String projectId, String location, String jobId) {
                            super(Dataflow.this, "GET", REST_PATH, null, ListJobMessagesResponse.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                            this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public List setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getLocation() {
                            return this.location;
                        }

                        public List setLocation(String location) {
                            this.location = location;
                            return this;
                        }

                        public String getJobId() {
                            return this.jobId;
                        }

                        public List setJobId(String jobId) {
                            this.jobId = jobId;
                            return this;
                        }

                        public String getEndTime() {
                            return this.endTime;
                        }

                        public List setEndTime(String endTime) {
                            this.endTime = endTime;
                            return this;
                        }

                        public String getMinimumImportance() {
                            return this.minimumImportance;
                        }

                        public List setMinimumImportance(String minimumImportance) {
                            this.minimumImportance = minimumImportance;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        public String getStartTime() {
                            return this.startTime;
                        }

                        public List setStartTime(String startTime) {
                            this.startTime = startTime;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class Debug {
                    public GetConfig getConfig(String projectId, String location, String jobId, GetDebugConfigRequest content) throws IOException {
                        GetConfig result = new GetConfig(projectId, location, jobId, content);
                        Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SendCapture sendCapture(String projectId, String location, String jobId, SendDebugCaptureRequest content) throws IOException {
                        SendCapture result = new SendCapture(projectId, location, jobId, content);
                        Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class SendCapture
                    extends DataflowRequest<SendDebugCaptureResponse> {
                        private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/debug/sendCapture";
                        @Key
                        private String projectId;
                        @Key
                        private String location;
                        @Key
                        private String jobId;

                        protected SendCapture(String projectId, String location, String jobId, SendDebugCaptureRequest content) {
                            super(Dataflow.this, "POST", REST_PATH, (Object)content, SendDebugCaptureResponse.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                            this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                        }

                        public SendCapture set$Xgafv(String $Xgafv) {
                            return (SendCapture)super.set$Xgafv($Xgafv);
                        }

                        public SendCapture setAccessToken(String accessToken) {
                            return (SendCapture)super.setAccessToken(accessToken);
                        }

                        public SendCapture setAlt(String alt) {
                            return (SendCapture)super.setAlt(alt);
                        }

                        public SendCapture setCallback(String callback) {
                            return (SendCapture)super.setCallback(callback);
                        }

                        public SendCapture setFields(String fields) {
                            return (SendCapture)super.setFields(fields);
                        }

                        public SendCapture setKey(String key) {
                            return (SendCapture)super.setKey(key);
                        }

                        public SendCapture setOauthToken(String oauthToken) {
                            return (SendCapture)super.setOauthToken(oauthToken);
                        }

                        public SendCapture setPrettyPrint(Boolean prettyPrint) {
                            return (SendCapture)super.setPrettyPrint(prettyPrint);
                        }

                        public SendCapture setQuotaUser(String quotaUser) {
                            return (SendCapture)super.setQuotaUser(quotaUser);
                        }

                        public SendCapture setUploadType(String uploadType) {
                            return (SendCapture)super.setUploadType(uploadType);
                        }

                        public SendCapture setUploadProtocol(String uploadProtocol) {
                            return (SendCapture)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public SendCapture setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getLocation() {
                            return this.location;
                        }

                        public SendCapture setLocation(String location) {
                            this.location = location;
                            return this;
                        }

                        public String getJobId() {
                            return this.jobId;
                        }

                        public SendCapture setJobId(String jobId) {
                            this.jobId = jobId;
                            return this;
                        }

                        @Override
                        public SendCapture set(String parameterName, Object value) {
                            return (SendCapture)super.set(parameterName, value);
                        }
                    }

                    public class GetConfig
                    extends DataflowRequest<GetDebugConfigResponse> {
                        private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/debug/getConfig";
                        @Key
                        private String projectId;
                        @Key
                        private String location;
                        @Key
                        private String jobId;

                        protected GetConfig(String projectId, String location, String jobId, GetDebugConfigRequest content) {
                            super(Dataflow.this, "POST", REST_PATH, (Object)content, GetDebugConfigResponse.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                            this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                        }

                        public GetConfig set$Xgafv(String $Xgafv) {
                            return (GetConfig)super.set$Xgafv($Xgafv);
                        }

                        public GetConfig setAccessToken(String accessToken) {
                            return (GetConfig)super.setAccessToken(accessToken);
                        }

                        public GetConfig setAlt(String alt) {
                            return (GetConfig)super.setAlt(alt);
                        }

                        public GetConfig setCallback(String callback) {
                            return (GetConfig)super.setCallback(callback);
                        }

                        public GetConfig setFields(String fields) {
                            return (GetConfig)super.setFields(fields);
                        }

                        public GetConfig setKey(String key) {
                            return (GetConfig)super.setKey(key);
                        }

                        public GetConfig setOauthToken(String oauthToken) {
                            return (GetConfig)super.setOauthToken(oauthToken);
                        }

                        public GetConfig setPrettyPrint(Boolean prettyPrint) {
                            return (GetConfig)super.setPrettyPrint(prettyPrint);
                        }

                        public GetConfig setQuotaUser(String quotaUser) {
                            return (GetConfig)super.setQuotaUser(quotaUser);
                        }

                        public GetConfig setUploadType(String uploadType) {
                            return (GetConfig)super.setUploadType(uploadType);
                        }

                        public GetConfig setUploadProtocol(String uploadProtocol) {
                            return (GetConfig)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public GetConfig setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getLocation() {
                            return this.location;
                        }

                        public GetConfig setLocation(String location) {
                            this.location = location;
                            return this;
                        }

                        public String getJobId() {
                            return this.jobId;
                        }

                        public GetConfig setJobId(String jobId) {
                            this.jobId = jobId;
                            return this;
                        }

                        @Override
                        public GetConfig set(String parameterName, Object value) {
                            return (GetConfig)super.set(parameterName, value);
                        }
                    }
                }

                public class Update
                extends DataflowRequest<Job> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}";
                    @Key
                    private String projectId;
                    @Key
                    private String location;
                    @Key
                    private String jobId;

                    protected Update(String projectId, String location, String jobId, Job content) {
                        super(Dataflow.this, "PUT", REST_PATH, (Object)content, Job.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                    }

                    public Update set$Xgafv(String $Xgafv) {
                        return (Update)super.set$Xgafv($Xgafv);
                    }

                    public Update setAccessToken(String accessToken) {
                        return (Update)super.setAccessToken(accessToken);
                    }

                    public Update setAlt(String alt) {
                        return (Update)super.setAlt(alt);
                    }

                    public Update setCallback(String callback) {
                        return (Update)super.setCallback(callback);
                    }

                    public Update setFields(String fields) {
                        return (Update)super.setFields(fields);
                    }

                    public Update setKey(String key) {
                        return (Update)super.setKey(key);
                    }

                    public Update setOauthToken(String oauthToken) {
                        return (Update)super.setOauthToken(oauthToken);
                    }

                    public Update setPrettyPrint(Boolean prettyPrint) {
                        return (Update)super.setPrettyPrint(prettyPrint);
                    }

                    public Update setQuotaUser(String quotaUser) {
                        return (Update)super.setQuotaUser(quotaUser);
                    }

                    public Update setUploadType(String uploadType) {
                        return (Update)super.setUploadType(uploadType);
                    }

                    public Update setUploadProtocol(String uploadProtocol) {
                        return (Update)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Update setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public Update setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public Update setJobId(String jobId) {
                        this.jobId = jobId;
                        return this;
                    }

                    @Override
                    public Update set(String parameterName, Object value) {
                        return (Update)super.set(parameterName, value);
                    }
                }

                public class Snapshot
                extends DataflowRequest<com.google.api.services.dataflow.model.Snapshot> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}:snapshot";
                    @Key
                    private String projectId;
                    @Key
                    private String location;
                    @Key
                    private String jobId;

                    protected Snapshot(String projectId, String location, String jobId, SnapshotJobRequest content) {
                        super(Dataflow.this, "POST", REST_PATH, (Object)content, com.google.api.services.dataflow.model.Snapshot.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                    }

                    public Snapshot set$Xgafv(String $Xgafv) {
                        return (Snapshot)super.set$Xgafv($Xgafv);
                    }

                    public Snapshot setAccessToken(String accessToken) {
                        return (Snapshot)super.setAccessToken(accessToken);
                    }

                    public Snapshot setAlt(String alt) {
                        return (Snapshot)super.setAlt(alt);
                    }

                    public Snapshot setCallback(String callback) {
                        return (Snapshot)super.setCallback(callback);
                    }

                    public Snapshot setFields(String fields) {
                        return (Snapshot)super.setFields(fields);
                    }

                    public Snapshot setKey(String key) {
                        return (Snapshot)super.setKey(key);
                    }

                    public Snapshot setOauthToken(String oauthToken) {
                        return (Snapshot)super.setOauthToken(oauthToken);
                    }

                    public Snapshot setPrettyPrint(Boolean prettyPrint) {
                        return (Snapshot)super.setPrettyPrint(prettyPrint);
                    }

                    public Snapshot setQuotaUser(String quotaUser) {
                        return (Snapshot)super.setQuotaUser(quotaUser);
                    }

                    public Snapshot setUploadType(String uploadType) {
                        return (Snapshot)super.setUploadType(uploadType);
                    }

                    public Snapshot setUploadProtocol(String uploadProtocol) {
                        return (Snapshot)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Snapshot setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public Snapshot setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public Snapshot setJobId(String jobId) {
                        this.jobId = jobId;
                        return this;
                    }

                    @Override
                    public Snapshot set(String parameterName, Object value) {
                        return (Snapshot)super.set(parameterName, value);
                    }
                }

                public class List
                extends DataflowRequest<ListJobsResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs";
                    @Key
                    private String projectId;
                    @Key
                    private String location;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;
                    @Key
                    private String view;

                    protected List(String projectId, String location) {
                        super(Dataflow.this, "GET", REST_PATH, null, ListJobsResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public List setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public String getView() {
                        return this.view;
                    }

                    public List setView(String view) {
                        this.view = view;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class GetMetrics
                extends DataflowRequest<JobMetrics> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/metrics";
                    @Key
                    private String projectId;
                    @Key
                    private String location;
                    @Key
                    private String jobId;
                    @Key
                    private String startTime;

                    protected GetMetrics(String projectId, String location, String jobId) {
                        super(Dataflow.this, "GET", REST_PATH, null, JobMetrics.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetMetrics set$Xgafv(String $Xgafv) {
                        return (GetMetrics)super.set$Xgafv($Xgafv);
                    }

                    public GetMetrics setAccessToken(String accessToken) {
                        return (GetMetrics)super.setAccessToken(accessToken);
                    }

                    public GetMetrics setAlt(String alt) {
                        return (GetMetrics)super.setAlt(alt);
                    }

                    public GetMetrics setCallback(String callback) {
                        return (GetMetrics)super.setCallback(callback);
                    }

                    public GetMetrics setFields(String fields) {
                        return (GetMetrics)super.setFields(fields);
                    }

                    public GetMetrics setKey(String key) {
                        return (GetMetrics)super.setKey(key);
                    }

                    public GetMetrics setOauthToken(String oauthToken) {
                        return (GetMetrics)super.setOauthToken(oauthToken);
                    }

                    public GetMetrics setPrettyPrint(Boolean prettyPrint) {
                        return (GetMetrics)super.setPrettyPrint(prettyPrint);
                    }

                    public GetMetrics setQuotaUser(String quotaUser) {
                        return (GetMetrics)super.setQuotaUser(quotaUser);
                    }

                    public GetMetrics setUploadType(String uploadType) {
                        return (GetMetrics)super.setUploadType(uploadType);
                    }

                    public GetMetrics setUploadProtocol(String uploadProtocol) {
                        return (GetMetrics)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public GetMetrics setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public GetMetrics setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public GetMetrics setJobId(String jobId) {
                        this.jobId = jobId;
                        return this;
                    }

                    public String getStartTime() {
                        return this.startTime;
                    }

                    public GetMetrics setStartTime(String startTime) {
                        this.startTime = startTime;
                        return this;
                    }

                    @Override
                    public GetMetrics set(String parameterName, Object value) {
                        return (GetMetrics)super.set(parameterName, value);
                    }
                }

                public class GetExecutionDetails
                extends DataflowRequest<JobExecutionDetails> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/executionDetails";
                    @Key
                    private String projectId;
                    @Key
                    private String location;
                    @Key
                    private String jobId;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected GetExecutionDetails(String projectId, String location, String jobId) {
                        super(Dataflow.this, "GET", REST_PATH, null, JobExecutionDetails.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetExecutionDetails set$Xgafv(String $Xgafv) {
                        return (GetExecutionDetails)super.set$Xgafv($Xgafv);
                    }

                    public GetExecutionDetails setAccessToken(String accessToken) {
                        return (GetExecutionDetails)super.setAccessToken(accessToken);
                    }

                    public GetExecutionDetails setAlt(String alt) {
                        return (GetExecutionDetails)super.setAlt(alt);
                    }

                    public GetExecutionDetails setCallback(String callback) {
                        return (GetExecutionDetails)super.setCallback(callback);
                    }

                    public GetExecutionDetails setFields(String fields) {
                        return (GetExecutionDetails)super.setFields(fields);
                    }

                    public GetExecutionDetails setKey(String key) {
                        return (GetExecutionDetails)super.setKey(key);
                    }

                    public GetExecutionDetails setOauthToken(String oauthToken) {
                        return (GetExecutionDetails)super.setOauthToken(oauthToken);
                    }

                    public GetExecutionDetails setPrettyPrint(Boolean prettyPrint) {
                        return (GetExecutionDetails)super.setPrettyPrint(prettyPrint);
                    }

                    public GetExecutionDetails setQuotaUser(String quotaUser) {
                        return (GetExecutionDetails)super.setQuotaUser(quotaUser);
                    }

                    public GetExecutionDetails setUploadType(String uploadType) {
                        return (GetExecutionDetails)super.setUploadType(uploadType);
                    }

                    public GetExecutionDetails setUploadProtocol(String uploadProtocol) {
                        return (GetExecutionDetails)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public GetExecutionDetails setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public GetExecutionDetails setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public GetExecutionDetails setJobId(String jobId) {
                        this.jobId = jobId;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public GetExecutionDetails setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public GetExecutionDetails setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public GetExecutionDetails set(String parameterName, Object value) {
                        return (GetExecutionDetails)super.set(parameterName, value);
                    }
                }

                public class Get
                extends DataflowRequest<Job> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}";
                    @Key
                    private String projectId;
                    @Key
                    private String location;
                    @Key
                    private String jobId;
                    @Key
                    private String view;

                    protected Get(String projectId, String location, String jobId) {
                        super(Dataflow.this, "GET", REST_PATH, null, Job.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public Get setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public Get setJobId(String jobId) {
                        this.jobId = jobId;
                        return this;
                    }

                    public String getView() {
                        return this.view;
                    }

                    public Get setView(String view) {
                        this.view = view;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Create
                extends DataflowRequest<Job> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs";
                    @Key
                    private String projectId;
                    @Key
                    private String location;
                    @Key
                    private String replaceJobId;
                    @Key
                    private String view;

                    protected Create(String projectId, String location, Job content) {
                        super(Dataflow.this, "POST", REST_PATH, (Object)content, Job.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Create setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public Create setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    public String getReplaceJobId() {
                        return this.replaceJobId;
                    }

                    public Create setReplaceJobId(String replaceJobId) {
                        this.replaceJobId = replaceJobId;
                        return this;
                    }

                    public String getView() {
                        return this.view;
                    }

                    public Create setView(String view) {
                        this.view = view;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class FlexTemplates {
                public Launch launch(String projectId, String location, LaunchFlexTemplateRequest content) throws IOException {
                    Launch result = new Launch(projectId, location, content);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Launch
                extends DataflowRequest<LaunchFlexTemplateResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/flexTemplates:launch";
                    @Key
                    private String projectId;
                    @Key
                    private String location;

                    protected Launch(String projectId, String location, LaunchFlexTemplateRequest content) {
                        super(Dataflow.this, "POST", REST_PATH, (Object)content, LaunchFlexTemplateResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                    }

                    public Launch set$Xgafv(String $Xgafv) {
                        return (Launch)super.set$Xgafv($Xgafv);
                    }

                    public Launch setAccessToken(String accessToken) {
                        return (Launch)super.setAccessToken(accessToken);
                    }

                    public Launch setAlt(String alt) {
                        return (Launch)super.setAlt(alt);
                    }

                    public Launch setCallback(String callback) {
                        return (Launch)super.setCallback(callback);
                    }

                    public Launch setFields(String fields) {
                        return (Launch)super.setFields(fields);
                    }

                    public Launch setKey(String key) {
                        return (Launch)super.setKey(key);
                    }

                    public Launch setOauthToken(String oauthToken) {
                        return (Launch)super.setOauthToken(oauthToken);
                    }

                    public Launch setPrettyPrint(Boolean prettyPrint) {
                        return (Launch)super.setPrettyPrint(prettyPrint);
                    }

                    public Launch setQuotaUser(String quotaUser) {
                        return (Launch)super.setQuotaUser(quotaUser);
                    }

                    public Launch setUploadType(String uploadType) {
                        return (Launch)super.setUploadType(uploadType);
                    }

                    public Launch setUploadProtocol(String uploadProtocol) {
                        return (Launch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Launch setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public Launch setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    @Override
                    public Launch set(String parameterName, Object value) {
                        return (Launch)super.set(parameterName, value);
                    }
                }
            }

            public class WorkerMessages
            extends DataflowRequest<SendWorkerMessagesResponse> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/WorkerMessages";
                @Key
                private String projectId;
                @Key
                private String location;

                protected WorkerMessages(String projectId, String location, SendWorkerMessagesRequest content) {
                    super(Dataflow.this, "POST", REST_PATH, (Object)content, SendWorkerMessagesResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                }

                public WorkerMessages set$Xgafv(String $Xgafv) {
                    return (WorkerMessages)super.set$Xgafv($Xgafv);
                }

                public WorkerMessages setAccessToken(String accessToken) {
                    return (WorkerMessages)super.setAccessToken(accessToken);
                }

                public WorkerMessages setAlt(String alt) {
                    return (WorkerMessages)super.setAlt(alt);
                }

                public WorkerMessages setCallback(String callback) {
                    return (WorkerMessages)super.setCallback(callback);
                }

                public WorkerMessages setFields(String fields) {
                    return (WorkerMessages)super.setFields(fields);
                }

                public WorkerMessages setKey(String key) {
                    return (WorkerMessages)super.setKey(key);
                }

                public WorkerMessages setOauthToken(String oauthToken) {
                    return (WorkerMessages)super.setOauthToken(oauthToken);
                }

                public WorkerMessages setPrettyPrint(Boolean prettyPrint) {
                    return (WorkerMessages)super.setPrettyPrint(prettyPrint);
                }

                public WorkerMessages setQuotaUser(String quotaUser) {
                    return (WorkerMessages)super.setQuotaUser(quotaUser);
                }

                public WorkerMessages setUploadType(String uploadType) {
                    return (WorkerMessages)super.setUploadType(uploadType);
                }

                public WorkerMessages setUploadProtocol(String uploadProtocol) {
                    return (WorkerMessages)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public WorkerMessages setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getLocation() {
                    return this.location;
                }

                public WorkerMessages setLocation(String location) {
                    this.location = location;
                    return this;
                }

                @Override
                public WorkerMessages set(String parameterName, Object value) {
                    return (WorkerMessages)super.set(parameterName, value);
                }
            }
        }

        public class Jobs {
            public Aggregated aggregated(String projectId) throws IOException {
                Aggregated result = new Aggregated(projectId);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(String projectId, Job content) throws IOException {
                Create result = new Create(projectId, content);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String projectId, String jobId) throws IOException {
                Get result = new Get(projectId, jobId);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetMetrics getMetrics(String projectId, String jobId) throws IOException {
                GetMetrics result = new GetMetrics(projectId, jobId);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String projectId) throws IOException {
                List result = new List(projectId);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Snapshot snapshot(String projectId, String jobId, SnapshotJobRequest content) throws IOException {
                Snapshot result = new Snapshot(projectId, jobId, content);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String projectId, String jobId, Job content) throws IOException {
                Update result = new Update(projectId, jobId, content);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Debug debug() {
                return new Debug();
            }

            public Messages messages() {
                return new Messages();
            }

            public WorkItems workItems() {
                return new WorkItems();
            }

            public class WorkItems {
                public Lease lease(String projectId, String jobId, LeaseWorkItemRequest content) throws IOException {
                    Lease result = new Lease(projectId, jobId, content);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ReportStatus reportStatus(String projectId, String jobId, ReportWorkItemStatusRequest content) throws IOException {
                    ReportStatus result = new ReportStatus(projectId, jobId, content);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class ReportStatus
                extends DataflowRequest<ReportWorkItemStatusResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/workItems:reportStatus";
                    @Key
                    private String projectId;
                    @Key
                    private String jobId;

                    protected ReportStatus(String projectId, String jobId, ReportWorkItemStatusRequest content) {
                        super(Dataflow.this, "POST", REST_PATH, (Object)content, ReportWorkItemStatusResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                    }

                    public ReportStatus set$Xgafv(String $Xgafv) {
                        return (ReportStatus)super.set$Xgafv($Xgafv);
                    }

                    public ReportStatus setAccessToken(String accessToken) {
                        return (ReportStatus)super.setAccessToken(accessToken);
                    }

                    public ReportStatus setAlt(String alt) {
                        return (ReportStatus)super.setAlt(alt);
                    }

                    public ReportStatus setCallback(String callback) {
                        return (ReportStatus)super.setCallback(callback);
                    }

                    public ReportStatus setFields(String fields) {
                        return (ReportStatus)super.setFields(fields);
                    }

                    public ReportStatus setKey(String key) {
                        return (ReportStatus)super.setKey(key);
                    }

                    public ReportStatus setOauthToken(String oauthToken) {
                        return (ReportStatus)super.setOauthToken(oauthToken);
                    }

                    public ReportStatus setPrettyPrint(Boolean prettyPrint) {
                        return (ReportStatus)super.setPrettyPrint(prettyPrint);
                    }

                    public ReportStatus setQuotaUser(String quotaUser) {
                        return (ReportStatus)super.setQuotaUser(quotaUser);
                    }

                    public ReportStatus setUploadType(String uploadType) {
                        return (ReportStatus)super.setUploadType(uploadType);
                    }

                    public ReportStatus setUploadProtocol(String uploadProtocol) {
                        return (ReportStatus)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public ReportStatus setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public ReportStatus setJobId(String jobId) {
                        this.jobId = jobId;
                        return this;
                    }

                    @Override
                    public ReportStatus set(String parameterName, Object value) {
                        return (ReportStatus)super.set(parameterName, value);
                    }
                }

                public class Lease
                extends DataflowRequest<LeaseWorkItemResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/workItems:lease";
                    @Key
                    private String projectId;
                    @Key
                    private String jobId;

                    protected Lease(String projectId, String jobId, LeaseWorkItemRequest content) {
                        super(Dataflow.this, "POST", REST_PATH, (Object)content, LeaseWorkItemResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                    }

                    public Lease set$Xgafv(String $Xgafv) {
                        return (Lease)super.set$Xgafv($Xgafv);
                    }

                    public Lease setAccessToken(String accessToken) {
                        return (Lease)super.setAccessToken(accessToken);
                    }

                    public Lease setAlt(String alt) {
                        return (Lease)super.setAlt(alt);
                    }

                    public Lease setCallback(String callback) {
                        return (Lease)super.setCallback(callback);
                    }

                    public Lease setFields(String fields) {
                        return (Lease)super.setFields(fields);
                    }

                    public Lease setKey(String key) {
                        return (Lease)super.setKey(key);
                    }

                    public Lease setOauthToken(String oauthToken) {
                        return (Lease)super.setOauthToken(oauthToken);
                    }

                    public Lease setPrettyPrint(Boolean prettyPrint) {
                        return (Lease)super.setPrettyPrint(prettyPrint);
                    }

                    public Lease setQuotaUser(String quotaUser) {
                        return (Lease)super.setQuotaUser(quotaUser);
                    }

                    public Lease setUploadType(String uploadType) {
                        return (Lease)super.setUploadType(uploadType);
                    }

                    public Lease setUploadProtocol(String uploadProtocol) {
                        return (Lease)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Lease setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public Lease setJobId(String jobId) {
                        this.jobId = jobId;
                        return this;
                    }

                    @Override
                    public Lease set(String parameterName, Object value) {
                        return (Lease)super.set(parameterName, value);
                    }
                }
            }

            public class Messages {
                public List list(String projectId, String jobId) throws IOException {
                    List result = new List(projectId, jobId);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends DataflowRequest<ListJobMessagesResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/messages";
                    @Key
                    private String projectId;
                    @Key
                    private String jobId;
                    @Key
                    private String endTime;
                    @Key
                    private String location;
                    @Key
                    private String minimumImportance;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;
                    @Key
                    private String startTime;

                    protected List(String projectId, String jobId) {
                        super(Dataflow.this, "GET", REST_PATH, null, ListJobMessagesResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public List setJobId(String jobId) {
                        this.jobId = jobId;
                        return this;
                    }

                    public String getEndTime() {
                        return this.endTime;
                    }

                    public List setEndTime(String endTime) {
                        this.endTime = endTime;
                        return this;
                    }

                    public String getLocation() {
                        return this.location;
                    }

                    public List setLocation(String location) {
                        this.location = location;
                        return this;
                    }

                    public String getMinimumImportance() {
                        return this.minimumImportance;
                    }

                    public List setMinimumImportance(String minimumImportance) {
                        this.minimumImportance = minimumImportance;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public String getStartTime() {
                        return this.startTime;
                    }

                    public List setStartTime(String startTime) {
                        this.startTime = startTime;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class Debug {
                public GetConfig getConfig(String projectId, String jobId, GetDebugConfigRequest content) throws IOException {
                    GetConfig result = new GetConfig(projectId, jobId, content);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SendCapture sendCapture(String projectId, String jobId, SendDebugCaptureRequest content) throws IOException {
                    SendCapture result = new SendCapture(projectId, jobId, content);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class SendCapture
                extends DataflowRequest<SendDebugCaptureResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/debug/sendCapture";
                    @Key
                    private String projectId;
                    @Key
                    private String jobId;

                    protected SendCapture(String projectId, String jobId, SendDebugCaptureRequest content) {
                        super(Dataflow.this, "POST", REST_PATH, (Object)content, SendDebugCaptureResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                    }

                    public SendCapture set$Xgafv(String $Xgafv) {
                        return (SendCapture)super.set$Xgafv($Xgafv);
                    }

                    public SendCapture setAccessToken(String accessToken) {
                        return (SendCapture)super.setAccessToken(accessToken);
                    }

                    public SendCapture setAlt(String alt) {
                        return (SendCapture)super.setAlt(alt);
                    }

                    public SendCapture setCallback(String callback) {
                        return (SendCapture)super.setCallback(callback);
                    }

                    public SendCapture setFields(String fields) {
                        return (SendCapture)super.setFields(fields);
                    }

                    public SendCapture setKey(String key) {
                        return (SendCapture)super.setKey(key);
                    }

                    public SendCapture setOauthToken(String oauthToken) {
                        return (SendCapture)super.setOauthToken(oauthToken);
                    }

                    public SendCapture setPrettyPrint(Boolean prettyPrint) {
                        return (SendCapture)super.setPrettyPrint(prettyPrint);
                    }

                    public SendCapture setQuotaUser(String quotaUser) {
                        return (SendCapture)super.setQuotaUser(quotaUser);
                    }

                    public SendCapture setUploadType(String uploadType) {
                        return (SendCapture)super.setUploadType(uploadType);
                    }

                    public SendCapture setUploadProtocol(String uploadProtocol) {
                        return (SendCapture)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public SendCapture setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public SendCapture setJobId(String jobId) {
                        this.jobId = jobId;
                        return this;
                    }

                    @Override
                    public SendCapture set(String parameterName, Object value) {
                        return (SendCapture)super.set(parameterName, value);
                    }
                }

                public class GetConfig
                extends DataflowRequest<GetDebugConfigResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/debug/getConfig";
                    @Key
                    private String projectId;
                    @Key
                    private String jobId;

                    protected GetConfig(String projectId, String jobId, GetDebugConfigRequest content) {
                        super(Dataflow.this, "POST", REST_PATH, (Object)content, GetDebugConfigResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                    }

                    public GetConfig set$Xgafv(String $Xgafv) {
                        return (GetConfig)super.set$Xgafv($Xgafv);
                    }

                    public GetConfig setAccessToken(String accessToken) {
                        return (GetConfig)super.setAccessToken(accessToken);
                    }

                    public GetConfig setAlt(String alt) {
                        return (GetConfig)super.setAlt(alt);
                    }

                    public GetConfig setCallback(String callback) {
                        return (GetConfig)super.setCallback(callback);
                    }

                    public GetConfig setFields(String fields) {
                        return (GetConfig)super.setFields(fields);
                    }

                    public GetConfig setKey(String key) {
                        return (GetConfig)super.setKey(key);
                    }

                    public GetConfig setOauthToken(String oauthToken) {
                        return (GetConfig)super.setOauthToken(oauthToken);
                    }

                    public GetConfig setPrettyPrint(Boolean prettyPrint) {
                        return (GetConfig)super.setPrettyPrint(prettyPrint);
                    }

                    public GetConfig setQuotaUser(String quotaUser) {
                        return (GetConfig)super.setQuotaUser(quotaUser);
                    }

                    public GetConfig setUploadType(String uploadType) {
                        return (GetConfig)super.setUploadType(uploadType);
                    }

                    public GetConfig setUploadProtocol(String uploadProtocol) {
                        return (GetConfig)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public GetConfig setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public GetConfig setJobId(String jobId) {
                        this.jobId = jobId;
                        return this;
                    }

                    @Override
                    public GetConfig set(String parameterName, Object value) {
                        return (GetConfig)super.set(parameterName, value);
                    }
                }
            }

            public class Update
            extends DataflowRequest<Job> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}";
                @Key
                private String projectId;
                @Key
                private String jobId;
                @Key
                private String location;

                protected Update(String projectId, String jobId, Job content) {
                    super(Dataflow.this, "PUT", REST_PATH, (Object)content, Job.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Update setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getJobId() {
                    return this.jobId;
                }

                public Update setJobId(String jobId) {
                    this.jobId = jobId;
                    return this;
                }

                public String getLocation() {
                    return this.location;
                }

                public Update setLocation(String location) {
                    this.location = location;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Snapshot
            extends DataflowRequest<com.google.api.services.dataflow.model.Snapshot> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}:snapshot";
                @Key
                private String projectId;
                @Key
                private String jobId;

                protected Snapshot(String projectId, String jobId, SnapshotJobRequest content) {
                    super(Dataflow.this, "POST", REST_PATH, (Object)content, com.google.api.services.dataflow.model.Snapshot.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                }

                public Snapshot set$Xgafv(String $Xgafv) {
                    return (Snapshot)super.set$Xgafv($Xgafv);
                }

                public Snapshot setAccessToken(String accessToken) {
                    return (Snapshot)super.setAccessToken(accessToken);
                }

                public Snapshot setAlt(String alt) {
                    return (Snapshot)super.setAlt(alt);
                }

                public Snapshot setCallback(String callback) {
                    return (Snapshot)super.setCallback(callback);
                }

                public Snapshot setFields(String fields) {
                    return (Snapshot)super.setFields(fields);
                }

                public Snapshot setKey(String key) {
                    return (Snapshot)super.setKey(key);
                }

                public Snapshot setOauthToken(String oauthToken) {
                    return (Snapshot)super.setOauthToken(oauthToken);
                }

                public Snapshot setPrettyPrint(Boolean prettyPrint) {
                    return (Snapshot)super.setPrettyPrint(prettyPrint);
                }

                public Snapshot setQuotaUser(String quotaUser) {
                    return (Snapshot)super.setQuotaUser(quotaUser);
                }

                public Snapshot setUploadType(String uploadType) {
                    return (Snapshot)super.setUploadType(uploadType);
                }

                public Snapshot setUploadProtocol(String uploadProtocol) {
                    return (Snapshot)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Snapshot setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getJobId() {
                    return this.jobId;
                }

                public Snapshot setJobId(String jobId) {
                    this.jobId = jobId;
                    return this;
                }

                @Override
                public Snapshot set(String parameterName, Object value) {
                    return (Snapshot)super.set(parameterName, value);
                }
            }

            public class List
            extends DataflowRequest<ListJobsResponse> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/jobs";
                @Key
                private String projectId;
                @Key
                private String filter;
                @Key
                private String location;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String view;

                protected List(String projectId) {
                    super(Dataflow.this, "GET", REST_PATH, null, ListJobsResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public List setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getLocation() {
                    return this.location;
                }

                public List setLocation(String location) {
                    this.location = location;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetMetrics
            extends DataflowRequest<JobMetrics> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/metrics";
                @Key
                private String projectId;
                @Key
                private String jobId;
                @Key
                private String location;
                @Key
                private String startTime;

                protected GetMetrics(String projectId, String jobId) {
                    super(Dataflow.this, "GET", REST_PATH, null, JobMetrics.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetMetrics set$Xgafv(String $Xgafv) {
                    return (GetMetrics)super.set$Xgafv($Xgafv);
                }

                public GetMetrics setAccessToken(String accessToken) {
                    return (GetMetrics)super.setAccessToken(accessToken);
                }

                public GetMetrics setAlt(String alt) {
                    return (GetMetrics)super.setAlt(alt);
                }

                public GetMetrics setCallback(String callback) {
                    return (GetMetrics)super.setCallback(callback);
                }

                public GetMetrics setFields(String fields) {
                    return (GetMetrics)super.setFields(fields);
                }

                public GetMetrics setKey(String key) {
                    return (GetMetrics)super.setKey(key);
                }

                public GetMetrics setOauthToken(String oauthToken) {
                    return (GetMetrics)super.setOauthToken(oauthToken);
                }

                public GetMetrics setPrettyPrint(Boolean prettyPrint) {
                    return (GetMetrics)super.setPrettyPrint(prettyPrint);
                }

                public GetMetrics setQuotaUser(String quotaUser) {
                    return (GetMetrics)super.setQuotaUser(quotaUser);
                }

                public GetMetrics setUploadType(String uploadType) {
                    return (GetMetrics)super.setUploadType(uploadType);
                }

                public GetMetrics setUploadProtocol(String uploadProtocol) {
                    return (GetMetrics)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public GetMetrics setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getJobId() {
                    return this.jobId;
                }

                public GetMetrics setJobId(String jobId) {
                    this.jobId = jobId;
                    return this;
                }

                public String getLocation() {
                    return this.location;
                }

                public GetMetrics setLocation(String location) {
                    this.location = location;
                    return this;
                }

                public String getStartTime() {
                    return this.startTime;
                }

                public GetMetrics setStartTime(String startTime) {
                    this.startTime = startTime;
                    return this;
                }

                @Override
                public GetMetrics set(String parameterName, Object value) {
                    return (GetMetrics)super.set(parameterName, value);
                }
            }

            public class Get
            extends DataflowRequest<Job> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}";
                @Key
                private String projectId;
                @Key
                private String jobId;
                @Key
                private String location;
                @Key
                private String view;

                protected Get(String projectId, String jobId) {
                    super(Dataflow.this, "GET", REST_PATH, null, Job.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getJobId() {
                    return this.jobId;
                }

                public Get setJobId(String jobId) {
                    this.jobId = jobId;
                    return this;
                }

                public String getLocation() {
                    return this.location;
                }

                public Get setLocation(String location) {
                    this.location = location;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public Get setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends DataflowRequest<Job> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/jobs";
                @Key
                private String projectId;
                @Key
                private String location;
                @Key
                private String replaceJobId;
                @Key
                private String view;

                protected Create(String projectId, Job content) {
                    super(Dataflow.this, "POST", REST_PATH, (Object)content, Job.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Create setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getLocation() {
                    return this.location;
                }

                public Create setLocation(String location) {
                    this.location = location;
                    return this;
                }

                public String getReplaceJobId() {
                    return this.replaceJobId;
                }

                public Create setReplaceJobId(String replaceJobId) {
                    this.replaceJobId = replaceJobId;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public Create setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class Aggregated
            extends DataflowRequest<ListJobsResponse> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/jobs:aggregated";
                @Key
                private String projectId;
                @Key
                private String filter;
                @Key
                private String location;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String view;

                protected Aggregated(String projectId) {
                    super(Dataflow.this, "GET", REST_PATH, null, ListJobsResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Aggregated set$Xgafv(String $Xgafv) {
                    return (Aggregated)super.set$Xgafv($Xgafv);
                }

                public Aggregated setAccessToken(String accessToken) {
                    return (Aggregated)super.setAccessToken(accessToken);
                }

                public Aggregated setAlt(String alt) {
                    return (Aggregated)super.setAlt(alt);
                }

                public Aggregated setCallback(String callback) {
                    return (Aggregated)super.setCallback(callback);
                }

                public Aggregated setFields(String fields) {
                    return (Aggregated)super.setFields(fields);
                }

                public Aggregated setKey(String key) {
                    return (Aggregated)super.setKey(key);
                }

                public Aggregated setOauthToken(String oauthToken) {
                    return (Aggregated)super.setOauthToken(oauthToken);
                }

                public Aggregated setPrettyPrint(Boolean prettyPrint) {
                    return (Aggregated)super.setPrettyPrint(prettyPrint);
                }

                public Aggregated setQuotaUser(String quotaUser) {
                    return (Aggregated)super.setQuotaUser(quotaUser);
                }

                public Aggregated setUploadType(String uploadType) {
                    return (Aggregated)super.setUploadType(uploadType);
                }

                public Aggregated setUploadProtocol(String uploadProtocol) {
                    return (Aggregated)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Aggregated setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public Aggregated setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getLocation() {
                    return this.location;
                }

                public Aggregated setLocation(String location) {
                    this.location = location;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public Aggregated setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public Aggregated setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public Aggregated setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public Aggregated set(String parameterName, Object value) {
                    return (Aggregated)super.set(parameterName, value);
                }
            }
        }

        public class WorkerMessages
        extends DataflowRequest<SendWorkerMessagesResponse> {
            private static final String REST_PATH = "v1b3/projects/{projectId}/WorkerMessages";
            @Key
            private String projectId;

            protected WorkerMessages(String projectId, SendWorkerMessagesRequest content) {
                super(Dataflow.this, "POST", REST_PATH, (Object)content, SendWorkerMessagesResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public WorkerMessages set$Xgafv(String $Xgafv) {
                return (WorkerMessages)super.set$Xgafv($Xgafv);
            }

            public WorkerMessages setAccessToken(String accessToken) {
                return (WorkerMessages)super.setAccessToken(accessToken);
            }

            public WorkerMessages setAlt(String alt) {
                return (WorkerMessages)super.setAlt(alt);
            }

            public WorkerMessages setCallback(String callback) {
                return (WorkerMessages)super.setCallback(callback);
            }

            public WorkerMessages setFields(String fields) {
                return (WorkerMessages)super.setFields(fields);
            }

            public WorkerMessages setKey(String key) {
                return (WorkerMessages)super.setKey(key);
            }

            public WorkerMessages setOauthToken(String oauthToken) {
                return (WorkerMessages)super.setOauthToken(oauthToken);
            }

            public WorkerMessages setPrettyPrint(Boolean prettyPrint) {
                return (WorkerMessages)super.setPrettyPrint(prettyPrint);
            }

            public WorkerMessages setQuotaUser(String quotaUser) {
                return (WorkerMessages)super.setQuotaUser(quotaUser);
            }

            public WorkerMessages setUploadType(String uploadType) {
                return (WorkerMessages)super.setUploadType(uploadType);
            }

            public WorkerMessages setUploadProtocol(String uploadProtocol) {
                return (WorkerMessages)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public WorkerMessages setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public WorkerMessages set(String parameterName, Object value) {
                return (WorkerMessages)super.set(parameterName, value);
            }
        }

        public class DeleteSnapshots
        extends DataflowRequest<DeleteSnapshotResponse> {
            private static final String REST_PATH = "v1b3/projects/{projectId}/snapshots";
            @Key
            private String projectId;
            @Key
            private String location;
            @Key
            private String snapshotId;

            protected DeleteSnapshots(String projectId) {
                super(Dataflow.this, "DELETE", REST_PATH, null, DeleteSnapshotResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public DeleteSnapshots set$Xgafv(String $Xgafv) {
                return (DeleteSnapshots)super.set$Xgafv($Xgafv);
            }

            public DeleteSnapshots setAccessToken(String accessToken) {
                return (DeleteSnapshots)super.setAccessToken(accessToken);
            }

            public DeleteSnapshots setAlt(String alt) {
                return (DeleteSnapshots)super.setAlt(alt);
            }

            public DeleteSnapshots setCallback(String callback) {
                return (DeleteSnapshots)super.setCallback(callback);
            }

            public DeleteSnapshots setFields(String fields) {
                return (DeleteSnapshots)super.setFields(fields);
            }

            public DeleteSnapshots setKey(String key) {
                return (DeleteSnapshots)super.setKey(key);
            }

            public DeleteSnapshots setOauthToken(String oauthToken) {
                return (DeleteSnapshots)super.setOauthToken(oauthToken);
            }

            public DeleteSnapshots setPrettyPrint(Boolean prettyPrint) {
                return (DeleteSnapshots)super.setPrettyPrint(prettyPrint);
            }

            public DeleteSnapshots setQuotaUser(String quotaUser) {
                return (DeleteSnapshots)super.setQuotaUser(quotaUser);
            }

            public DeleteSnapshots setUploadType(String uploadType) {
                return (DeleteSnapshots)super.setUploadType(uploadType);
            }

            public DeleteSnapshots setUploadProtocol(String uploadProtocol) {
                return (DeleteSnapshots)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public DeleteSnapshots setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getLocation() {
                return this.location;
            }

            public DeleteSnapshots setLocation(String location) {
                this.location = location;
                return this;
            }

            public String getSnapshotId() {
                return this.snapshotId;
            }

            public DeleteSnapshots setSnapshotId(String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            @Override
            public DeleteSnapshots set(String parameterName, Object value) {
                return (DeleteSnapshots)super.set(parameterName, value);
            }
        }
    }
}

