/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.textfileoutput;

import com.google.common.annotations.VisibleForTesting;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.textfileoutput.TextFileField;
import org.apache.hop.pipeline.transforms.textfileoutput.TextFileOutput;
import org.apache.hop.pipeline.transforms.textfileoutput.TextFileOutputData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="TextFileOutput", image="textfileoutput.svg", name="i18n::BaseTransform.TypeLongDesc.TextFileOutput", description="i18n::BaseTransform.TypeTooltipDesc.TextFileOutput", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", documentationUrl="/pipeline/transforms/textfileoutput.html")
@InjectionSupported(localizationPrefix="TextFileOutput.Injection.", groups={"OUTPUT_FIELDS"})
public class TextFileOutputMeta
extends BaseTransformMeta
implements ITransformMeta<TextFileOutput, TextFileOutputData> {
    private static final Class<?> PKG = TextFileOutputMeta.class;
    protected static final int FILE_COMPRESSION_TYPE_NONE = 0;
    protected static final int FILE_COMPRESSION_TYPE_ZIP = 1;
    protected static final String[] fileCompressionTypeCodes = new String[]{"None", "Zip"};
    public static final String[] formatMapperLineTerminator = new String[]{"DOS", "UNIX", "CR", "None"};
    @Injection(name="INC_TRANSFORMNR_IN_FILENAME")
    protected boolean transformNrInFilename;
    @Injection(name="INC_PARTNR_IN_FILENAME")
    protected boolean partNrInFilename;
    @Injection(name="INC_DATE_IN_FILENAME")
    protected boolean dateInFilename;
    @Injection(name="INC_TIME_IN_FILENAME")
    protected boolean timeInFilename;
    @Injection(name="EXTENSION")
    protected String extension;
    @Injection(name="FILENAME")
    protected String fileName;
    @Injection(name="RUN_AS_COMMAND")
    private boolean fileAsCommand;
    @Injection(name="SPECIFY_DATE_FORMAT")
    private boolean specifyingFormat;
    @Injection(name="DATE_FORMAT")
    private String dateTimeFormat;
    @Injection(name="COMPRESSION")
    private String fileCompression;
    @Injection(name="PASS_TO_SERVLET")
    private boolean servletOutput;
    @Injection(name="CREATE_PARENT_FOLDER")
    private boolean createparentfolder = true;
    @Injection(name="SEPARATOR")
    private String separator;
    @Injection(name="ENCLOSURE")
    private String enclosure;
    @Injection(name="FORCE_ENCLOSURE")
    private boolean enclosureForced;
    @Injection(name="DISABLE_ENCLOSURE_FIX")
    private boolean disableEnclosureFix;
    @Injection(name="HEADER")
    private boolean headerEnabled;
    @Injection(name="FOOTER")
    private boolean footerEnabled;
    private String fileFormat;
    @Injection(name="SPLIT_EVERY")
    private String splitEveryRows;
    @Injection(name="APPEND")
    private boolean fileAppended;
    @Injection(name="RIGHT_PAD_FIELDS")
    private boolean padded;
    @Injection(name="FAST_DATA_DUMP")
    private boolean fastDump;
    @InjectionDeep
    private TextFileField[] outputFields;
    @Injection(name="ENCODING")
    private String encoding;
    @Injection(name="ADD_ENDING_LINE")
    private String endedLine;
    @Injection(name="FILENAME_IN_FIELD")
    private boolean fileNameInField;
    @Injection(name="FILENAME_FIELD")
    private String fileNameField;
    @Injection(name="NEW_LINE")
    private String newline;
    @Injection(name="ADD_TO_RESULT")
    private boolean addToResultFilenames;
    @Injection(name="DO_NOT_CREATE_FILE_AT_STARTUP")
    private boolean doNotOpenNewFileInit;

    public boolean isServletOutput() {
        return this.servletOutput;
    }

    public void setServletOutput(boolean servletOutput) {
        this.servletOutput = servletOutput;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public boolean isEnclosureForced() {
        return this.enclosureForced;
    }

    public void setEnclosureForced(boolean enclosureForced) {
        this.enclosureForced = enclosureForced;
    }

    public boolean isEnclosureFixDisabled() {
        return this.disableEnclosureFix;
    }

    public void setEnclosureFixDisabled(boolean disableEnclosureFix) {
        this.disableEnclosureFix = disableEnclosureFix;
    }

    public boolean isAddToResultFiles() {
        return this.addToResultFilenames;
    }

    public void setAddToResultFiles(boolean addtoresultfilenamesin) {
        this.addToResultFilenames = addtoresultfilenamesin;
    }

    public boolean isFileAppended() {
        return this.fileAppended;
    }

    public void setFileAppended(boolean fileAppended) {
        this.fileAppended = fileAppended;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    @Injection(name="FORMAT")
    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
        this.newline = this.getNewLine(fileFormat);
    }

    public boolean isFooterEnabled() {
        return this.footerEnabled;
    }

    public void setFooterEnabled(boolean footer) {
        this.footerEnabled = footer;
    }

    public boolean isHeaderEnabled() {
        return this.headerEnabled;
    }

    public void setHeaderEnabled(boolean header) {
        this.headerEnabled = header;
    }

    public String getNewline() {
        return this.newline;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }

    public boolean isPadded() {
        return this.padded;
    }

    public void setPadded(boolean padded) {
        this.padded = padded;
    }

    public boolean isFastDump() {
        return this.fastDump;
    }

    public void setFastDump(boolean fastDump) {
        this.fastDump = fastDump;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpenNewFileInit = doNotOpenNewFileInit;
    }

    public int getSplitEvery() {
        return Const.toInt((String)this.splitEveryRows, (int)0);
    }

    public int getSplitEvery(IVariables varSpace) {
        return Const.toInt((String)(varSpace == null ? this.splitEveryRows : varSpace.resolve(this.splitEveryRows)), (int)0);
    }

    public String getSplitEveryRows() {
        return this.splitEveryRows;
    }

    public void setSplitEveryRows(String value) {
        this.splitEveryRows = value;
    }

    public int getFooterShift() {
        return this.isFooterEnabled() ? 1 : 0;
    }

    public void setSplitEvery(int splitEvery) {
        this.splitEveryRows = Integer.toString(splitEvery);
    }

    public void setTransformNrInFilename(boolean transformNrInFilename) {
        this.transformNrInFilename = transformNrInFilename;
    }

    public void setPartNrInFilename(boolean partNrInFilename) {
        this.partNrInFilename = partNrInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public TextFileField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(TextFileField[] outputFields) {
        this.outputFields = outputFields;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEndedLine() {
        return this.endedLine;
    }

    public void setEndedLine(String endedLine) {
        this.endedLine = endedLine;
    }

    public boolean isFileNameInField() {
        return this.fileNameInField;
    }

    public void setFileNameInField(boolean fileNameInField) {
        this.fileNameInField = fileNameInField;
    }

    public String getFileNameField() {
        return this.fileNameField;
    }

    public void setFileNameField(String fileNameField) {
        this.fileNameField = fileNameField;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public void allocate(int nrFields) {
        this.outputFields = new TextFileField[nrFields];
    }

    public Object clone() {
        TextFileOutputMeta retval = (TextFileOutputMeta)((Object)super.clone());
        int nrFields = this.outputFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            retval.outputFields[i] = (TextFileField)this.outputFields[i].clone();
        }
        return retval;
    }

    protected void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.separator = XmlHandler.getTagValue((Node)transformNode, (String)"separator");
            if (this.separator == null) {
                this.separator = "";
            }
            this.enclosure = XmlHandler.getTagValue((Node)transformNode, (String)"enclosure");
            if (this.enclosure == null) {
                this.enclosure = "";
            }
            this.enclosureForced = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"enclosure_forced"));
            String sDisableEnclosureFix = XmlHandler.getTagValue((Node)transformNode, (String)"enclosure_fix_disabled");
            this.disableEnclosureFix = sDisableEnclosureFix == null ? true : "Y".equalsIgnoreCase(sDisableEnclosureFix);
            String createParentFolderTagValue = XmlHandler.getTagValue((Node)transformNode, (String)"create_parent_folder");
            this.createparentfolder = createParentFolderTagValue == null ? true : "Y".equalsIgnoreCase(createParentFolderTagValue);
            this.headerEnabled = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"header"));
            this.footerEnabled = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"footer"));
            this.fileFormat = XmlHandler.getTagValue((Node)transformNode, (String)"format");
            this.setFileCompression(XmlHandler.getTagValue((Node)transformNode, (String)"compression"));
            if (this.getFileCompression() == null) {
                if ("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"zipped"))) {
                    this.setFileCompression(fileCompressionTypeCodes[1]);
                } else {
                    this.setFileCompression(fileCompressionTypeCodes[0]);
                }
            }
            this.encoding = XmlHandler.getTagValue((Node)transformNode, (String)"encoding");
            this.endedLine = XmlHandler.getTagValue((Node)transformNode, (String)"endedLine");
            if (this.endedLine == null) {
                this.endedLine = "";
            }
            this.fileName = this.loadSource(transformNode, metadataProvider);
            this.servletOutput = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"servlet_output"));
            this.doNotOpenNewFileInit = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"do_not_open_new_file_init"));
            this.extension = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"extention");
            this.fileAppended = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"append"));
            this.transformNrInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"split"));
            this.partNrInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"haspartno"));
            this.dateInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"add_time"));
            this.setSpecifyingFormat("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"SpecifyFormat")));
            this.setDateTimeFormat(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"date_time_format"));
            String AddToResultFiles = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"add_to_result_filenames");
            this.addToResultFilenames = Utils.isEmpty((CharSequence)AddToResultFiles) ? true : "Y".equalsIgnoreCase(AddToResultFiles);
            this.padded = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"pad"));
            this.fastDump = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"fast_dump"));
            this.splitEveryRows = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"splitevery");
            this.newline = this.getNewLine(this.fileFormat);
            this.fileNameInField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"fileNameInField"));
            this.fileNameField = XmlHandler.getTagValue((Node)transformNode, (String)"fileNameField");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.outputFields[i] = new TextFileField();
                this.outputFields[i].setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                this.outputFields[i].setType(XmlHandler.getTagValue((Node)fnode, (String)"type"));
                this.outputFields[i].setFormat(XmlHandler.getTagValue((Node)fnode, (String)"format"));
                this.outputFields[i].setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
                this.outputFields[i].setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.outputFields[i].setGroupingSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
                this.outputFields[i].setTrimType(ValueMetaString.getTrimTypeByCode((String)XmlHandler.getTagValue((Node)fnode, (String)"trim_type")));
                this.outputFields[i].setNullString(XmlHandler.getTagValue((Node)fnode, (String)"nullif"));
                this.outputFields[i].setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.outputFields[i].setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void readData(Node transformNode) throws HopXmlException {
        this.readData(transformNode, null);
    }

    public String getNewLine(String fformat) {
        String nl = System.getProperty("line.separator");
        if (fformat != null) {
            if (fformat.equalsIgnoreCase("DOS")) {
                nl = "\r\n";
            } else if (fformat.equalsIgnoreCase("UNIX")) {
                nl = "\n";
            } else if (fformat.equalsIgnoreCase("CR")) {
                nl = "\r";
            } else if (fformat.equalsIgnoreCase("None")) {
                nl = "";
            }
        }
        return nl;
    }

    public void setDefault() {
        this.createparentfolder = true;
        this.separator = ";";
        this.enclosure = "\"";
        this.setSpecifyingFormat(false);
        this.setDateTimeFormat(null);
        this.enclosureForced = false;
        this.disableEnclosureFix = false;
        this.headerEnabled = true;
        this.footerEnabled = false;
        this.fileFormat = "DOS";
        this.setFileCompression(fileCompressionTypeCodes[0]);
        this.fileName = "file";
        this.servletOutput = false;
        this.doNotOpenNewFileInit = false;
        this.extension = "txt";
        this.transformNrInFilename = false;
        this.partNrInFilename = false;
        this.dateInFilename = false;
        this.timeInFilename = false;
        this.padded = false;
        this.fastDump = false;
        this.addToResultFilenames = true;
        this.newline = this.getNewLine(this.fileFormat);
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.outputFields[i] = new TextFileField();
            this.outputFields[i].setName("field" + i);
            this.outputFields[i].setType("Number");
            this.outputFields[i].setFormat(" 0,000,000.00;-0,000,000.00");
            this.outputFields[i].setCurrencySymbol("");
            this.outputFields[i].setDecimalSymbol(",");
            this.outputFields[i].setGroupingSymbol(".");
            this.outputFields[i].setNullString("");
            this.outputFields[i].setLength(-1);
            this.outputFields[i].setPrecision(-1);
        }
        this.fileAppended = false;
    }

    public String buildFilename(String filename, String extension, IVariables variables, int transformnr, String partnr, int splitnr, boolean ziparchive, TextFileOutputMeta meta) {
        String realFileName = variables.resolve(filename);
        String realExtension = variables.resolve(extension);
        return this.buildFilename(variables, realFileName, realExtension, Integer.toString(transformnr), partnr, Integer.toString(splitnr), new Date(), ziparchive, true, meta);
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.outputFields.length; ++i) {
            TextFileField field = this.outputFields[i];
            IValueMeta v = row.searchValueMeta(field.getName());
            if (v == null) continue;
            v.setLength(field.getLength());
            v.setPrecision(field.getPrecision());
            if (field.getFormat() != null) {
                v.setConversionMask(field.getFormat());
            }
            v.setDecimalSymbol(field.getDecimalSymbol());
            v.setGroupingSymbol(field.getGroupingSymbol());
            v.setCurrencySymbol(field.getCurrencySymbol());
            v.setOutputPaddingEnabled(this.isPadded());
            v.setTrimType(field.getTrimType());
            if (!Utils.isEmpty((CharSequence)this.getEncoding())) {
                v.setStringEncoding(this.getEncoding());
            }
            v.setOutputPaddingEnabled(true);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(800);
        retval.append("    ").append(XmlHandler.addTagValue((String)"separator", (String)this.separator));
        retval.append("    ").append(XmlHandler.addTagValue((String)"enclosure", (String)this.enclosure));
        retval.append("    ").append(XmlHandler.addTagValue((String)"enclosure_forced", (boolean)this.enclosureForced));
        retval.append("    ").append(XmlHandler.addTagValue((String)"enclosure_fix_disabled", (boolean)this.disableEnclosureFix));
        retval.append("    ").append(XmlHandler.addTagValue((String)"header", (boolean)this.headerEnabled));
        retval.append("    ").append(XmlHandler.addTagValue((String)"footer", (boolean)this.footerEnabled));
        retval.append("    ").append(XmlHandler.addTagValue((String)"format", (String)this.fileFormat));
        retval.append("    ").append(XmlHandler.addTagValue((String)"compression", (String)this.getFileCompression()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XmlHandler.addTagValue((String)"endedLine", (String)this.endedLine));
        retval.append("    " + XmlHandler.addTagValue((String)"fileNameInField", (boolean)this.fileNameInField));
        retval.append("    " + XmlHandler.addTagValue((String)"fileNameField", (String)this.fileNameField));
        retval.append("    " + XmlHandler.addTagValue((String)"create_parent_folder", (boolean)this.createparentfolder));
        retval.append("    <file>").append(Const.CR);
        this.saveFileOptions(retval);
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.length; ++i) {
            TextFileField field = this.outputFields[i];
            if (field.getName() == null || field.getName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"group", (String)field.getGroupingSymbol()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"nullif", (String)field.getNullString()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"trim_type", (String)field.getTrimTypeCode()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    protected void saveFileOptions(StringBuilder retval) {
        this.saveSource(retval, this.fileName);
        retval.append("      ").append(XmlHandler.addTagValue((String)"servlet_output", (boolean)this.servletOutput));
        retval.append("      ").append(XmlHandler.addTagValue((String)"do_not_open_new_file_init", (boolean)this.doNotOpenNewFileInit));
        retval.append("      ").append(XmlHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append("      ").append(XmlHandler.addTagValue((String)"append", (boolean)this.fileAppended));
        retval.append("      ").append(XmlHandler.addTagValue((String)"split", (boolean)this.transformNrInFilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"haspartno", (boolean)this.partNrInFilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"SpecifyFormat", (boolean)this.isSpecifyingFormat()));
        retval.append("      ").append(XmlHandler.addTagValue((String)"date_time_format", (String)this.getDateTimeFormat()));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.addToResultFilenames));
        retval.append("      ").append(XmlHandler.addTagValue((String)"pad", (boolean)this.padded));
        retval.append("      ").append(XmlHandler.addTagValue((String)"fast_dump", (boolean)this.fastDump));
        retval.append("      ").append(XmlHandler.addTagValue((String)"splitevery", (String)this.splitEveryRows));
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            String errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.outputFields.length; ++i) {
                int idx = prev.indexOfValue(this.outputFields[i].getName());
                if (idx >= 0) continue;
                errorMessage = errorMessage + "\t\t" + this.outputFields[i].getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public TextFileOutput createTransform(TransformMeta transformMeta, TextFileOutputData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new TextFileOutput<TextFileOutputMeta, TextFileOutputData>(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public TextFileOutputData getTransformData() {
        return new TextFileOutputData();
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.fileNameInField && !Utils.isEmpty((CharSequence)this.fileName)) {
                FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.fileName));
                this.fileName = iResourceNaming.nameResource(fileObject, variables, true);
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public void setFilename(String fileName) {
        this.fileName = fileName;
    }

    protected String loadSource(Node transformNode, IHopMetadataProvider metadataProvider) {
        return XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"name");
    }

    protected void saveSource(StringBuilder retVal, String value) {
        retVal.append("      ").append(XmlHandler.addTagValue((String)"name", (String)this.fileName));
    }

    public boolean passDataToServletOutput() {
        return this.servletOutput;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isFileAsCommand() {
        return this.fileAsCommand;
    }

    public void setFileAsCommand(boolean fileAsCommand) {
        this.fileAsCommand = fileAsCommand;
    }

    public boolean isSpecifyingFormat() {
        return this.specifyingFormat;
    }

    public void setSpecifyingFormat(boolean specifyingFormat) {
        this.specifyingFormat = specifyingFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public boolean isPartNrInFilename() {
        return this.partNrInFilename;
    }

    public boolean isTransformNrInFilename() {
        return this.transformNrInFilename;
    }

    public String getFileCompression() {
        return this.fileCompression;
    }

    public void setFileCompression(String fileCompression) {
        this.fileCompression = fileCompression;
    }

    public String[] getFiles(IVariables variables) {
        return this.getFiles(variables, true);
    }

    private String[] getFiles(IVariables variables, boolean showSamples) {
        String realFileName = variables.resolve(this.fileName);
        String realExtension = variables.resolve(this.extension);
        return this.getFiles(realFileName, realExtension, showSamples);
    }

    @VisibleForTesting
    String[] getFiles(String realFileName, String realExtension, boolean showSamples) {
        Date now = new Date();
        if (showSamples) {
            int nr;
            int copies = 1;
            int splits = 1;
            int parts = 1;
            if (this.isTransformNrInFilename()) {
                copies = 3;
            }
            if (this.isPartNrInFilename()) {
                parts = 3;
            }
            if (this.getSplitEvery() != 0) {
                splits = 3;
            }
            if ((nr = copies * parts * splits) > 1) {
                ++nr;
            }
            String[] retval = new String[nr];
            int i = 0;
            for (int transform = 0; transform < copies; ++transform) {
                for (int part = 0; part < parts; ++part) {
                    for (int split = 0; split < splits; ++split) {
                        retval[i] = this.buildFilename(realFileName, realExtension, transform + "", this.getPartPrefix() + part, split + "", now, false, showSamples);
                        ++i;
                    }
                }
            }
            if (i < nr) {
                retval[i] = "...";
            }
            return retval;
        }
        return new String[]{this.buildFilename(realFileName, realExtension, "<transform>", "<partition>", "<split>", now, false, showSamples)};
    }

    protected String getPartPrefix() {
        return "";
    }

    public String buildFilename(IVariables variables, String transformnr, String partnr, String splitnr, boolean ziparchive) {
        return this.buildFilename(variables, transformnr, partnr, splitnr, ziparchive, true);
    }

    public String buildFilename(IVariables variables, String transformnr, String partnr, String splitnr, boolean ziparchive, boolean showSamples) {
        String realFileName = variables.resolve(this.fileName);
        String realExtension = variables.resolve(this.extension);
        return this.buildFilename(realFileName, realExtension, transformnr, partnr, splitnr, new Date(), ziparchive, showSamples);
    }

    private String buildFilename(String realFileName, String realExtension, String transformnr, String partnr, String splitnr, Date date, boolean ziparchive, boolean showSamples) {
        return this.buildFilename(realFileName, realExtension, transformnr, partnr, splitnr, date, ziparchive, showSamples, this);
    }

    protected String buildFilename(String realFileName, String realExtension, String transformnr, String partnr, String splitnr, Date date, boolean ziparchive, boolean showSamples, TextFileOutputMeta meta) {
        return this.buildFilename(null, realFileName, realExtension, transformnr, partnr, splitnr, date, ziparchive, showSamples, meta);
    }

    protected String buildFilename(IVariables variables, String realFileName, String realExtension, String transformnr, String partnr, String splitnr, Date date, boolean ziparchive, boolean showSamples, TextFileOutputMeta meta) {
        Date now;
        SimpleDateFormat daf = new SimpleDateFormat();
        String retval = realFileName;
        if (meta.isFileAsCommand()) {
            return retval;
        }
        Date date2 = now = date == null ? new Date() : date;
        if (meta.isSpecifyingFormat() && !Utils.isEmpty((CharSequence)meta.getDateTimeFormat())) {
            daf.applyPattern(meta.getDateTimeFormat());
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (meta.isDateInFilename()) {
                if (showSamples) {
                    daf.applyPattern("yyyMMdd");
                    String d = daf.format(now);
                    retval = retval + "_" + d;
                } else {
                    retval = retval + "_<yyyMMdd>";
                }
            }
            if (meta.isTimeInFilename()) {
                if (showSamples) {
                    daf.applyPattern("HHmmss");
                    String t = daf.format(now);
                    retval = retval + "_" + t;
                } else {
                    retval = retval + "_<HHmmss>";
                }
            }
        }
        if (meta.isTransformNrInFilename()) {
            retval = retval + "_" + transformnr;
        }
        if (meta.isPartNrInFilename()) {
            retval = retval + "_" + partnr;
        }
        if (meta.getSplitEvery(variables) > 0) {
            retval = retval + "_" + splitnr;
        }
        if ("Zip".equals(meta.getFileCompression())) {
            if (ziparchive) {
                retval = retval + ".zip";
            } else if (realExtension != null && realExtension.length() != 0) {
                retval = retval + "." + realExtension;
            }
        } else {
            if (realExtension != null && realExtension.length() != 0) {
                retval = retval + "." + realExtension;
            }
            if ("GZip".equals(meta.getFileCompression())) {
                retval = retval + ".gz";
            }
        }
        return retval;
    }

    public String[] getFilePaths(IVariables variables, boolean showSamples) {
        PipelineMeta parentPipelineMeta;
        TransformMeta parentTransformMeta = this.getParentTransformMeta();
        if (parentTransformMeta != null && (parentPipelineMeta = parentTransformMeta.getParentPipelineMeta()) != null) {
            return this.getFiles(variables, showSamples);
        }
        return new String[0];
    }
}

