/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fileinput.text;

import java.util.Arrays;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileInputMeta;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.widget.IGetCaretPosition;
import org.apache.hop.ui.core.widget.IInsertText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class VariableButtonListenerFactory {
    private static final Class<?> PKG = TextFileInputMeta.class;

    public static final SelectionAdapter getSelectionAdapter(Composite composite, Text destination, IVariables variables) {
        return VariableButtonListenerFactory.getSelectionAdapter(composite, destination, null, null, variables);
    }

    public static final SelectionAdapter getSelectionAdapter(final Composite composite, final Text destination, final IGetCaretPosition getCaretPositionInterface, final IInsertText insertTextInterface, final IVariables variables) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterSelectionDialog esd;
                Object[] keys = variables.getVariableNames();
                Arrays.sort(keys);
                int size = keys.length;
                String[] key = new String[size];
                String[] val = new String[size];
                String[] str = new String[size];
                for (int i = 0; i < keys.length; ++i) {
                    key[i] = keys[i];
                    val[i] = variables.getVariable(key[i]);
                    str[i] = key[i] + "  [" + val[i] + "]";
                }
                int position = 0;
                if (getCaretPositionInterface != null) {
                    position = getCaretPositionInterface.getCaretPosition();
                }
                if ((esd = new EnterSelectionDialog(composite.getShell(), str, BaseMessages.getString((Class)PKG, (String)"System.Dialog.SelectEnvironmentVar.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.Dialog.SelectEnvironmentVar.Message", (String[])new String[0]))).open() != null) {
                    int nr = esd.getSelectionNr();
                    String var = "${" + key[nr] + "}";
                    if (insertTextInterface == null) {
                        destination.insert(var);
                        e.doit = false;
                    } else {
                        insertTextInterface.insertText(var, position);
                    }
                }
            }
        };
    }
}

