/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fileinput.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transform.errorhandling.IFileErrorHandler;
import org.apache.hop.pipeline.transforms.file.BaseFileField;
import org.apache.hop.pipeline.transforms.file.BaseFileInputAdditionalField;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileInputMeta;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileLine;

public class TextFileInputUtils {
    private static final Class<?> PKG = TextFileInputUtils.class;

    public static final String[] guessStringsFromLine(IVariables variables, ILogChannel log, String line, TextFileInputMeta inf, String delimiter, String enclosure, String escapeCharacter) throws HopException {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            if (line == null) {
                return null;
            }
            if (inf.content.fileType.equalsIgnoreCase("CSV")) {
                int lenEsc;
                int pos = 0;
                int length = line.length();
                boolean dencl = false;
                int lenEncl = enclosure == null ? 0 : enclosure.length();
                int n = lenEsc = escapeCharacter == null ? 0 : escapeCharacter.length();
                while (pos < length) {
                    String pol;
                    int next;
                    boolean enclFound;
                    int from = pos;
                    boolean containsEscapedEnclosures = false;
                    boolean containsEscapedSeparators = false;
                    boolean containsEscapedEscape = false;
                    if (lenEncl > 0 && line.substring(from, from + lenEncl).equalsIgnoreCase(enclosure)) {
                        String strnext;
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRow", (String[])new String[]{line.substring(from, from + lenEncl)})});
                        }
                        enclFound = true;
                        int p = from + lenEncl;
                        boolean isEnclosure = lenEncl > 0 && p + lenEncl < length && line.substring(p, p + lenEncl).equalsIgnoreCase(enclosure);
                        boolean isEscape = lenEsc > 0 && p + lenEsc < length && line.substring(p, p + lenEsc).equalsIgnoreCase(escapeCharacter);
                        boolean enclosureAfter = false;
                        if ((isEnclosure || isEscape) && p < length - 1) {
                            strnext = line.substring(p + lenEncl, p + 2 * lenEncl);
                            if (strnext.equalsIgnoreCase(enclosure)) {
                                ++p;
                                enclosureAfter = true;
                                dencl = true;
                                if (isEscape) {
                                    containsEscapedEnclosures = true;
                                }
                            } else if (strnext.equals(escapeCharacter)) {
                                ++p;
                                if (isEscape) {
                                    containsEscapedEscape = true;
                                }
                            }
                        }
                        while ((!isEnclosure || enclosureAfter) && p < line.length()) {
                            enclosureAfter = false;
                            isEnclosure = lenEncl > 0 && ++p + lenEncl < length && line.substring(p, p + lenEncl).equals(enclosure);
                            boolean bl = isEscape = lenEsc > 0 && p + lenEsc < length && line.substring(p, p + lenEsc).equals(escapeCharacter);
                            if (!isEnclosure && !isEscape || p >= length - 1) continue;
                            strnext = line.substring(p + lenEncl, p + 2 * lenEncl);
                            if (strnext.equals(enclosure)) {
                                ++p;
                                enclosureAfter = true;
                                dencl = true;
                                if (!isEscape) continue;
                                containsEscapedEnclosures = true;
                                continue;
                            }
                            if (!strnext.equals(escapeCharacter)) continue;
                            ++p;
                            if (!isEscape) continue;
                            containsEscapedEscape = true;
                        }
                        next = p >= length ? p : p + lenEncl;
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EndOfEnclosure", (String[])new String[]{"" + p})});
                        }
                    } else {
                        enclFound = false;
                        boolean found = false;
                        int startpoint = from;
                        do {
                            next = line.indexOf(delimiter, startpoint);
                            if (lenEsc > 0 && next - lenEsc > 0) {
                                String before = line.substring(next - lenEsc, next);
                                if (escapeCharacter.equals(before)) {
                                    startpoint = next + 1;
                                    containsEscapedSeparators = true;
                                    continue;
                                }
                                found = true;
                                continue;
                            }
                            found = true;
                        } while (!found && next >= 0);
                    }
                    if (next == -1) {
                        next = length;
                    }
                    if (enclFound) {
                        pol = line.substring(from + lenEncl, next - lenEncl);
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EnclosureFieldFound", (String[])new String[]{"" + pol})});
                        }
                    } else {
                        pol = line.substring(from, next);
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.NormalFieldFound", (String[])new String[]{"" + pol})});
                        }
                    }
                    if (dencl) {
                        StringBuilder sbpol = new StringBuilder(pol);
                        int idx = sbpol.indexOf(enclosure + enclosure);
                        while (idx >= 0) {
                            sbpol.delete(idx, idx + enclosure.length());
                            idx = sbpol.indexOf(enclosure + enclosure);
                        }
                        pol = sbpol.toString();
                    }
                    if (containsEscapedEnclosures) {
                        String replace = escapeCharacter + enclosure;
                        String replaceWith = enclosure;
                        pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                    }
                    if (containsEscapedSeparators) {
                        String replace = escapeCharacter + delimiter;
                        String replaceWith = delimiter;
                        pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                    }
                    if (containsEscapedEscape) {
                        String replace = escapeCharacter + escapeCharacter;
                        String replaceWith = escapeCharacter;
                        pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                    }
                    strings.add(pol);
                    pos = next + delimiter.length();
                }
                if (pos == length) {
                    if (log.isRowLevel()) {
                        log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EndOfEmptyLineFound", (String[])new String[0])});
                    }
                    strings.add("");
                }
            } else {
                for (int i = 0; i < inf.inputFields.length; ++i) {
                    BaseFileField field = inf.inputFields[i];
                    int length = line.length();
                    if (field.getPosition() + field.getLength() <= length) {
                        strings.add(line.substring(field.getPosition(), field.getPosition() + field.getLength()));
                        continue;
                    }
                    if (field.getPosition() < length) {
                        strings.add(line.substring(field.getPosition()));
                        continue;
                    }
                    strings.add("");
                }
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.ErrorConvertingLine", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static final Object[] convertLineToRow(ILogChannel log, TextFileLine textFileLine, TextFileInputMeta info, Object[] passThruFields, int nrPassThruFields, IRowMeta outputRowMeta, IRowMeta convertRowMeta, String fname, long rowNr, String delimiter, String enclosure, String escapeCharacter, IFileErrorHandler errorHandler, BaseFileInputAdditionalField additionalOutputFields, String shortFilename, String path, boolean hidden, Date modificationDateTime, String uri, String rooturi, String extension, Long size) throws HopException {
        return TextFileInputUtils.convertLineToRow(log, textFileLine, info, passThruFields, nrPassThruFields, outputRowMeta, convertRowMeta, fname, rowNr, delimiter, enclosure, escapeCharacter, errorHandler, additionalOutputFields, shortFilename, path, hidden, modificationDateTime, uri, rooturi, extension, size, true);
    }

    public static final Object[] convertLineToRow(ILogChannel log, TextFileLine textFileLine, TextFileInputMeta info, Object[] passThruFields, int nrPassThruFields, IRowMeta outputRowMeta, IRowMeta convertRowMeta, String fname, long rowNr, String delimiter, String enclosure, String escapeCharacter, IFileErrorHandler errorHandler, BaseFileInputAdditionalField additionalOutputFields, String shortFilename, String path, boolean hidden, Date modificationDateTime, String uri, String rooturi, String extension, Long size, boolean failOnParseError) throws HopException {
        if (textFileLine == null || textFileLine.line == null) {
            return null;
        }
        Object[] r = RowDataUtil.allocateRowData((int)outputRowMeta.size());
        int nrFields = info.inputFields.length;
        Long errorCount = null;
        if (info.errorHandling.errorIgnored && info.getErrorCountField() != null && info.getErrorCountField().length() > 0) {
            errorCount = 0L;
        }
        String errorFields = null;
        if (info.errorHandling.errorIgnored && info.getErrorFieldsField() != null && info.getErrorFieldsField().length() > 0) {
            errorFields = "";
        }
        String errorText = null;
        if (info.errorHandling.errorIgnored && info.getErrorTextField() != null && info.getErrorTextField().length() > 0) {
            errorText = "";
        }
        try {
            int fieldnr;
            String[] strings = TextFileInputUtils.convertLineToStrings(log, textFileLine.line, info, delimiter, enclosure, escapeCharacter);
            int shiftFields = passThruFields == null ? 0 : nrPassThruFields;
            for (fieldnr = 0; fieldnr < nrFields; ++fieldnr) {
                Object value;
                block39: {
                    int trimType;
                    BaseFileField f = info.inputFields[fieldnr];
                    int valuenr = shiftFields + fieldnr;
                    IValueMeta valueMeta = outputRowMeta.getValueMeta(valuenr);
                    IValueMeta convertMeta = convertRowMeta.getValueMeta(valuenr);
                    String nullif = fieldnr < nrFields ? f.getNullString() : "";
                    String ifnull = fieldnr < nrFields ? f.getIfNullValue() : "";
                    int n = trimType = fieldnr < nrFields ? f.getTrimType() : 0;
                    if (fieldnr < strings.length) {
                        String pol = strings[fieldnr];
                        try {
                            if (valueMeta.isNull((Object)pol) || !Utils.isEmpty((CharSequence)nullif) && nullif.equals(pol)) {
                                pol = null;
                            }
                            value = valueMeta.convertDataFromString(pol, convertMeta, nullif, ifnull, trimType);
                        }
                        catch (Exception e) {
                            if (failOnParseError) {
                                String message = BaseMessages.getString(PKG, (String)"TextFileInput.Log.CoundNotParseField", (String[])new String[]{valueMeta.toStringMeta(), "" + pol, valueMeta.getConversionMask(), "" + rowNr});
                                if (info.errorHandling.errorIgnored) {
                                    StringBuilder sb;
                                    log.logDetailed(fname, new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.Warning", (String[])new String[0]) + ": " + message + " : " + e.getMessage()});
                                    value = null;
                                    if (errorCount != null) {
                                        errorCount = errorCount + 1L;
                                    }
                                    if (errorFields != null) {
                                        sb = new StringBuilder(errorFields);
                                        if (sb.length() > 0) {
                                            sb.append("\t");
                                        }
                                        sb.append(valueMeta.getName());
                                        errorFields = sb.toString();
                                    }
                                    if (errorText != null) {
                                        sb = new StringBuilder(errorText);
                                        if (sb.length() > 0) {
                                            sb.append(Const.CR);
                                        }
                                        sb.append(message);
                                        errorText = sb.toString();
                                    }
                                    if (errorHandler != null) {
                                        errorHandler.handleLineError(textFileLine.lineNumber, "NO_PARTS");
                                    }
                                    if (info.isErrorLineSkipped()) {
                                        r = null;
                                    }
                                    break block39;
                                }
                                throw new HopException(message, (Throwable)e);
                            }
                            value = pol;
                        }
                    } else {
                        value = null;
                    }
                }
                if (r == null) continue;
                r[valuenr] = value;
            }
            if (r != null) {
                if (fieldnr < nrFields) {
                    for (int i = fieldnr; i < info.inputFields.length; ++i) {
                        r[shiftFields + i] = null;
                    }
                }
                int index = shiftFields + nrFields;
                if (errorCount != null) {
                    r[index] = errorCount;
                    ++index;
                }
                if (errorFields != null) {
                    r[index] = errorFields;
                    ++index;
                }
                if (errorText != null) {
                    r[index] = errorText;
                    ++index;
                }
                if (info.content.includeFilename) {
                    r[index] = fname;
                    ++index;
                }
                if (info.content.includeRowNumber) {
                    r[index] = rowNr;
                    ++index;
                }
                if (additionalOutputFields.shortFilenameField != null) {
                    r[index] = shortFilename;
                    ++index;
                }
                if (additionalOutputFields.extensionField != null) {
                    r[index] = extension;
                    ++index;
                }
                if (additionalOutputFields.pathField != null) {
                    r[index] = path;
                    ++index;
                }
                if (additionalOutputFields.sizeField != null) {
                    r[index] = size;
                    ++index;
                }
                if (additionalOutputFields.hiddenField != null) {
                    r[index] = hidden;
                    ++index;
                }
                if (additionalOutputFields.lastModificationField != null) {
                    r[index] = modificationDateTime;
                    ++index;
                }
                if (additionalOutputFields.uriField != null) {
                    r[index] = uri;
                    ++index;
                }
                if (additionalOutputFields.rootUriField != null) {
                    r[index] = rooturi;
                    ++index;
                }
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.ErrorConvertingLineText", (String[])new String[0]), (Throwable)e);
        }
        if (r != null && passThruFields != null) {
            for (int i = 0; i < nrPassThruFields; ++i) {
                r[i] = passThruFields[i];
            }
        }
        return r;
    }

    public static final String[] convertLineToStrings(ILogChannel log, String line, TextFileInputMeta inf, String delimiter, String enclosure, String escapeCharacters) throws HopException {
        String[] strings;
        block42: {
            strings = new String[inf.inputFields.length];
            try {
                if (line == null) {
                    return null;
                }
                if (inf.content.fileType.equalsIgnoreCase("CSV")) {
                    int lenEsc;
                    int fieldnr = 0;
                    int pos = 0;
                    int length = line.length();
                    boolean dencl = false;
                    int lenEncl = enclosure == null ? 0 : enclosure.length();
                    int n = lenEsc = escapeCharacters == null ? 0 : escapeCharacters.length();
                    while (pos < length) {
                        String pol;
                        int next;
                        boolean enclFound;
                        int from = pos;
                        boolean containsEscapedEnclosures = false;
                        boolean containsEscapedSeparators = false;
                        boolean containsEscapedEscape = false;
                        if (lenEncl > 0 && line.substring(from, from + lenEncl).equalsIgnoreCase(enclosure)) {
                            String strnext;
                            if (log.isRowLevel()) {
                                log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.Encloruse", (String[])new String[]{line.substring(from, from + lenEncl)})});
                            }
                            enclFound = true;
                            int p = from + lenEncl;
                            boolean isEnclosure = lenEncl > 0 && p + lenEncl < length && line.substring(p, p + lenEncl).equalsIgnoreCase(enclosure);
                            boolean isEscape = lenEsc > 0 && p + lenEsc < length && line.substring(p, p + lenEsc).equalsIgnoreCase(inf.content.escapeCharacter);
                            boolean enclosureAfter = false;
                            if ((isEnclosure || isEscape) && p < length - 1) {
                                strnext = line.substring(p + lenEncl, p + 2 * lenEncl);
                                if (strnext.equalsIgnoreCase(enclosure)) {
                                    ++p;
                                    enclosureAfter = true;
                                    dencl = true;
                                    if (isEscape) {
                                        containsEscapedEnclosures = true;
                                    }
                                } else if (strnext.equals(inf.content.escapeCharacter)) {
                                    ++p;
                                    if (isEscape) {
                                        containsEscapedEscape = true;
                                    }
                                }
                            }
                            while ((!isEnclosure || enclosureAfter) && p < line.length()) {
                                enclosureAfter = false;
                                isEnclosure = lenEncl > 0 && ++p + lenEncl < length && line.substring(p, p + lenEncl).equals(enclosure);
                                boolean bl = isEscape = lenEsc > 0 && p + lenEsc < length && line.substring(p, p + lenEsc).equals(inf.content.escapeCharacter);
                                if (!isEnclosure && !isEscape || p >= length - 1) continue;
                                strnext = line.substring(p + lenEncl, p + 2 * lenEncl);
                                if (strnext.equals(enclosure)) {
                                    ++p;
                                    enclosureAfter = true;
                                    dencl = true;
                                    if (!isEscape) continue;
                                    containsEscapedEnclosures = true;
                                    continue;
                                }
                                if (!strnext.equals(inf.content.escapeCharacter)) continue;
                                ++p;
                                if (!isEscape) continue;
                                containsEscapedEscape = true;
                            }
                            next = p >= length ? p : p + lenEncl;
                            if (log.isRowLevel()) {
                                log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EndOfEnclosure", (String[])new String[]{"" + p})});
                            }
                        } else {
                            enclFound = false;
                            boolean found = false;
                            int startpoint = from;
                            do {
                                next = line.indexOf(delimiter, startpoint);
                                if (lenEsc > 0 && next > 0) {
                                    String before = line.substring(next - lenEsc, next);
                                    if (inf.content.escapeCharacter.equals(before)) {
                                        int previousEscapes = 1;
                                        int start = next - lenEsc - 1;
                                        int end = next - 1;
                                        while (start >= 0 && inf.content.escapeCharacter.equals(line.substring(start, end))) {
                                            ++previousEscapes;
                                            --start;
                                            --end;
                                        }
                                        if (previousEscapes % 2 != 0) {
                                            startpoint = next + 1;
                                            containsEscapedSeparators = true;
                                            continue;
                                        }
                                        found = true;
                                        continue;
                                    }
                                    found = true;
                                    continue;
                                }
                                found = true;
                            } while (!found && next >= 0);
                        }
                        if (next == -1) {
                            next = length;
                        }
                        if (enclFound && from + lenEncl <= next - lenEncl) {
                            pol = line.substring(from + lenEncl, next - lenEncl);
                            if (log.isRowLevel()) {
                                log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EnclosureFieldFound", (String[])new String[]{"" + pol})});
                            }
                        } else {
                            pol = line.substring(from, next);
                            if (log.isRowLevel()) {
                                log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.NormalFieldFound", (String[])new String[]{"" + pol})});
                            }
                        }
                        if (dencl && Utils.isEmpty((CharSequence)inf.content.escapeCharacter)) {
                            StringBuilder sbpol = new StringBuilder(pol);
                            int idx = sbpol.indexOf(enclosure + enclosure);
                            while (idx >= 0) {
                                sbpol.delete(idx, idx + enclosure.length());
                                idx = sbpol.indexOf(enclosure + enclosure);
                            }
                            pol = sbpol.toString();
                        }
                        if (containsEscapedEnclosures) {
                            String replace = inf.content.escapeCharacter + enclosure;
                            String replaceWith = enclosure;
                            pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                        }
                        if (containsEscapedSeparators) {
                            String replace = inf.content.escapeCharacter + delimiter;
                            String replaceWith = delimiter;
                            pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                        }
                        if (containsEscapedEscape = pol.contains(inf.content.escapeCharacter + inf.content.escapeCharacter)) {
                            String replace = inf.content.escapeCharacter + inf.content.escapeCharacter;
                            String replaceWith = inf.content.escapeCharacter;
                            pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                        }
                        try {
                            strings[fieldnr] = pol;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            String[] newStrings = new String[strings.length];
                            for (int x = 0; x < strings.length; ++x) {
                                newStrings[x] = strings[x];
                            }
                            strings = newStrings;
                        }
                        pos = next + delimiter.length();
                        ++fieldnr;
                    }
                    if (pos == length) {
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EndOfEmptyLineFound", (String[])new String[0])});
                        }
                        if (fieldnr < strings.length) {
                            strings[fieldnr] = "";
                        }
                        ++fieldnr;
                    }
                    break block42;
                }
                boolean charBased = inf.content.length == null || inf.content.length.equalsIgnoreCase("Characters") || inf.getEncoding() == null;
                for (int i = 0; i < inf.inputFields.length; ++i) {
                    int length;
                    BaseFileField field = inf.inputFields[i];
                    int fPos = field.getPosition();
                    int fLength = field.getLength();
                    int fPl = fPos + fLength;
                    if (charBased) {
                        length = line.length();
                        if (fPl <= length) {
                            strings[i] = line.substring(fPos, fPl);
                            continue;
                        }
                        if (fPos < length) {
                            strings[i] = line.substring(fPos);
                            continue;
                        }
                        strings[i] = "";
                        continue;
                    }
                    byte[] b = null;
                    String enc = inf.getEncoding();
                    b = line.getBytes(enc);
                    length = b.length;
                    strings[i] = fPl <= length ? new String(Arrays.copyOfRange(b, fPos, fPl), enc) : (fPos < length ? new String(Arrays.copyOfRange(b, fPos, length - 1), enc) : "");
                }
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.ErrorConvertingLine", (String[])new String[]{e.toString()}), (Throwable)e);
            }
        }
        return strings;
    }
}

