/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fileinput;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.compress.CompressionProviderFactory;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.file.EncodingType;
import org.apache.hop.core.file.IInputFileMeta;
import org.apache.hop.core.file.TextFileInputField;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.playlist.FilePlayListAll;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.errorhandling.CompositeFileErrorHandler;
import org.apache.hop.pipeline.transform.errorhandling.FileErrorHandlerContentLineNumber;
import org.apache.hop.pipeline.transform.errorhandling.FileErrorHandlerMissingFiles;
import org.apache.hop.pipeline.transform.errorhandling.IFileErrorHandler;
import org.apache.hop.pipeline.transforms.fileinput.TextFileFilterProcessor;
import org.apache.hop.pipeline.transforms.fileinput.TextFileInputData;
import org.apache.hop.pipeline.transforms.fileinput.TextFileInputMeta;
import org.apache.hop.pipeline.transforms.fileinput.TextFileLine;

@Deprecated
public class TextFileInput
extends BaseTransform<TextFileInputMeta, TextFileInputData>
implements ITransform<TextFileInputMeta, TextFileInputData> {
    private static final Class<?> PKG = TextFileInputMeta.class;
    private static final int BUFFER_SIZE_INPUT_STREAM = 500;
    private long lineNumberInFile;

    public TextFileInput(TransformMeta transformMeta, TextFileInputMeta meta, TextFileInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public static final String getLine(ILogChannel log, InputStreamReader reader, int formatNr, StringBuilder line) throws HopFileException {
        EncodingType type = EncodingType.guessEncodingType((String)reader.getEncoding());
        return TextFileInput.getLine(log, reader, type, formatNr, line);
    }

    public static final String getLine(ILogChannel log, InputStreamReader reader, EncodingType encodingType, int formatNr, StringBuilder line) throws HopFileException {
        int c = 0;
        line.setLength(0);
        try {
            switch (formatNr) {
                case 0: {
                    while (c >= 0) {
                        c = reader.read();
                        if (encodingType.isReturn(c) || encodingType.isLinefeed(c)) {
                            c = reader.read();
                            if (!encodingType.isReturn(c) && !encodingType.isLinefeed(c)) {
                                throw new HopFileException(BaseMessages.getString(PKG, (String)"TextFileInput.Log.SingleLineFound", (String[])new String[0]));
                            }
                            return line.toString();
                        }
                        if (c < 0) continue;
                        line.append((char)c);
                    }
                    break;
                }
                case 1: {
                    while (c >= 0) {
                        c = reader.read();
                        if (encodingType.isLinefeed(c) || encodingType.isReturn(c)) {
                            return line.toString();
                        }
                        if (c < 0) continue;
                        line.append((char)c);
                    }
                    break;
                }
                case 2: {
                    while (c >= 0) {
                        c = reader.read();
                        if (encodingType.isLinefeed(c)) {
                            return line.toString();
                        }
                        if (encodingType.isReturn(c) || c < 0) continue;
                        line.append((char)c);
                    }
                    break;
                }
            }
        }
        catch (HopFileException e) {
            throw e;
        }
        catch (Exception e) {
            if (line.length() == 0) {
                throw new HopFileException(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.ExceptionReadingLine", (String[])new String[]{e.toString()}), (Throwable)e);
            }
            return line.toString();
        }
        if (line.length() > 0) {
            return line.toString();
        }
        return null;
    }

    @Deprecated
    public static final String[] guessStringsFromLine(ILogChannel log, String line, TextFileInputMeta inf, String delimiter) throws HopException {
        return TextFileInput.guessStringsFromLine((IVariables)new Variables(), log, line, inf, delimiter, StringUtil.substituteHex((String)inf.getEnclosure()), StringUtil.substituteHex((String)inf.getEscapeCharacter()));
    }

    public static final String[] guessStringsFromLine(IVariables variables, ILogChannel log, String line, TextFileInputMeta inf, String delimiter, String enclosure, String escapeCharacter) throws HopException {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            if (line == null) {
                return null;
            }
            if (inf.getFileType().equalsIgnoreCase("CSV")) {
                int lenEsc;
                int pos = 0;
                int length = line.length();
                boolean dencl = false;
                int len_encl = enclosure == null ? 0 : enclosure.length();
                int n = lenEsc = escapeCharacter == null ? 0 : escapeCharacter.length();
                while (pos < length) {
                    String pol;
                    int next;
                    boolean encl_found;
                    int from = pos;
                    boolean containsEscaped_enclosures = false;
                    boolean containsEscapedSeparators = false;
                    if (len_encl > 0 && line.substring(from, from + len_encl).equalsIgnoreCase(enclosure)) {
                        String strnext;
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRow", (String[])new String[]{line.substring(from, from + len_encl)})});
                        }
                        encl_found = true;
                        int p = from + len_encl;
                        boolean is_enclosure = len_encl > 0 && p + len_encl < length && line.substring(p, p + len_encl).equalsIgnoreCase(enclosure);
                        boolean isEscape = lenEsc > 0 && p + lenEsc < length && line.substring(p, p + lenEsc).equalsIgnoreCase(escapeCharacter);
                        boolean enclosure_after = false;
                        if ((is_enclosure || isEscape) && p < length - 1 && (strnext = line.substring(p + len_encl, p + 2 * len_encl)).equalsIgnoreCase(enclosure)) {
                            ++p;
                            enclosure_after = true;
                            dencl = true;
                            if (isEscape) {
                                containsEscaped_enclosures = true;
                            }
                        }
                        while ((!is_enclosure || enclosure_after) && p < line.length()) {
                            enclosure_after = false;
                            is_enclosure = len_encl > 0 && ++p + len_encl < length && line.substring(p, p + len_encl).equals(enclosure);
                            boolean bl = isEscape = lenEsc > 0 && p + lenEsc < length && line.substring(p, p + lenEsc).equals(escapeCharacter);
                            if (!is_enclosure && !isEscape || p >= length - 1 || !(strnext = line.substring(p + len_encl, p + 2 * len_encl)).equals(enclosure)) continue;
                            ++p;
                            enclosure_after = true;
                            dencl = true;
                            if (!isEscape) continue;
                            containsEscaped_enclosures = true;
                        }
                        next = p >= length ? p : p + len_encl;
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EndOfEnclosure", (String[])new String[]{"" + p})});
                        }
                    } else {
                        encl_found = false;
                        boolean found = false;
                        int startpoint = from;
                        do {
                            next = line.indexOf(delimiter, startpoint);
                            if (lenEsc > 0 && next - lenEsc > 0) {
                                String before = line.substring(next - lenEsc, next);
                                if (escapeCharacter.equals(before)) {
                                    startpoint = next + 1;
                                    containsEscapedSeparators = true;
                                    continue;
                                }
                                found = true;
                                continue;
                            }
                            found = true;
                        } while (!found && next >= 0);
                    }
                    if (next == -1) {
                        next = length;
                    }
                    if (encl_found) {
                        pol = line.substring(from + len_encl, next - len_encl);
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EnclosureFieldFound", (String[])new String[]{"" + pol})});
                        }
                    } else {
                        pol = line.substring(from, next);
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.NormalFieldFound", (String[])new String[]{"" + pol})});
                        }
                    }
                    if (dencl) {
                        StringBuilder sbpol = new StringBuilder(pol);
                        int idx = sbpol.indexOf(enclosure + enclosure);
                        while (idx >= 0) {
                            sbpol.delete(idx, idx + enclosure.length());
                            idx = sbpol.indexOf(enclosure + enclosure);
                        }
                        pol = sbpol.toString();
                    }
                    if (containsEscaped_enclosures) {
                        String replace = escapeCharacter + enclosure;
                        String replaceWith = enclosure;
                        pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                    }
                    if (containsEscapedSeparators) {
                        String replace = escapeCharacter + delimiter;
                        String replaceWith = delimiter;
                        pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                    }
                    strings.add(pol);
                    pos = next + delimiter.length();
                }
                if (pos == length) {
                    if (log.isRowLevel()) {
                        log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EndOfEmptyLineFound", (String[])new String[0])});
                    }
                    strings.add("");
                }
            } else {
                for (int i = 0; i < inf.getInputFields().length; ++i) {
                    TextFileInputField field = inf.getInputFields()[i];
                    int length = line.length();
                    if (field.getPosition() + field.getLength() <= length) {
                        strings.add(line.substring(field.getPosition(), field.getPosition() + field.getLength()));
                        continue;
                    }
                    if (field.getPosition() < length) {
                        strings.add(line.substring(field.getPosition()));
                        continue;
                    }
                    strings.add("");
                }
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.ErrorConvertingLine", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static final String[] convertLineToStrings(ILogChannel log, String line, IInputFileMeta inf, String delimiter, String enclosure, String escapeCharacters) throws HopException {
        String[] strings;
        block31: {
            strings = new String[inf.getInputFields().length];
            try {
                if (line == null) {
                    return null;
                }
                if (inf.getFileType().equalsIgnoreCase("CSV")) {
                    int lenEsc;
                    int fieldnr = 0;
                    int pos = 0;
                    int length = line.length();
                    boolean dencl = false;
                    int len_encl = enclosure == null ? 0 : enclosure.length();
                    int n = lenEsc = escapeCharacters == null ? 0 : escapeCharacters.length();
                    while (pos < length) {
                        String pol;
                        int next;
                        boolean encl_found;
                        int from = pos;
                        boolean containsEscaped_enclosures = false;
                        boolean containsEscapedSeparators = false;
                        if (len_encl > 0 && line.substring(from, from + len_encl).equalsIgnoreCase(enclosure)) {
                            String strnext;
                            if (log.isRowLevel()) {
                                log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.Encloruse", (String[])new String[]{line.substring(from, from + len_encl)})});
                            }
                            encl_found = true;
                            int p = from + len_encl;
                            boolean is_enclosure = len_encl > 0 && p + len_encl < length && line.substring(p, p + len_encl).equalsIgnoreCase(enclosure);
                            boolean isEscape = lenEsc > 0 && p + lenEsc < length && line.substring(p, p + lenEsc).equalsIgnoreCase(inf.getEscapeCharacter());
                            boolean enclosure_after = false;
                            if ((is_enclosure || isEscape) && p < length - 1 && (strnext = line.substring(p + len_encl, p + 2 * len_encl)).equalsIgnoreCase(enclosure)) {
                                ++p;
                                enclosure_after = true;
                                dencl = true;
                                if (isEscape) {
                                    containsEscaped_enclosures = true;
                                }
                            }
                            while ((!is_enclosure || enclosure_after) && p < line.length()) {
                                enclosure_after = false;
                                is_enclosure = len_encl > 0 && ++p + len_encl < length && line.substring(p, p + len_encl).equals(enclosure);
                                boolean bl = isEscape = lenEsc > 0 && p + lenEsc < length && line.substring(p, p + lenEsc).equals(inf.getEscapeCharacter());
                                if (!is_enclosure && !isEscape || p >= length - 1 || !(strnext = line.substring(p + len_encl, p + 2 * len_encl)).equals(enclosure)) continue;
                                ++p;
                                enclosure_after = true;
                                dencl = true;
                                if (!isEscape) continue;
                                containsEscaped_enclosures = true;
                            }
                            next = p >= length ? p : p + len_encl;
                            if (log.isRowLevel()) {
                                log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EndOfEnclosure", (String[])new String[]{"" + p})});
                            }
                        } else {
                            encl_found = false;
                            boolean found = false;
                            int startpoint = from;
                            do {
                                next = line.indexOf(delimiter, startpoint);
                                if (lenEsc > 0 && next - lenEsc > 0) {
                                    String before = line.substring(next - lenEsc, next);
                                    if (inf.getEscapeCharacter().equals(before)) {
                                        startpoint = next + 1;
                                        containsEscapedSeparators = true;
                                        continue;
                                    }
                                    found = true;
                                    continue;
                                }
                                found = true;
                            } while (!found && next >= 0);
                        }
                        if (next == -1) {
                            next = length;
                        }
                        if (encl_found && from + len_encl <= next - len_encl) {
                            pol = line.substring(from + len_encl, next - len_encl);
                            if (log.isRowLevel()) {
                                log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EnclosureFieldFound", (String[])new String[]{"" + pol})});
                            }
                        } else {
                            pol = line.substring(from, next);
                            if (log.isRowLevel()) {
                                log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.NormalFieldFound", (String[])new String[]{"" + pol})});
                            }
                        }
                        if (dencl && Utils.isEmpty((CharSequence)inf.getEscapeCharacter())) {
                            StringBuilder sbpol = new StringBuilder(pol);
                            int idx = sbpol.indexOf(enclosure + enclosure);
                            while (idx >= 0) {
                                sbpol.delete(idx, idx + enclosure.length());
                                idx = sbpol.indexOf(enclosure + enclosure);
                            }
                            pol = sbpol.toString();
                        }
                        if (containsEscaped_enclosures) {
                            String replace = inf.getEscapeCharacter() + enclosure;
                            String replaceWith = enclosure;
                            pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                        }
                        if (containsEscapedSeparators) {
                            String replace = inf.getEscapeCharacter() + delimiter;
                            String replaceWith = delimiter;
                            pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                        }
                        try {
                            strings[fieldnr] = pol;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            String[] newStrings = new String[strings.length];
                            for (int x = 0; x < strings.length; ++x) {
                                newStrings[x] = strings[x];
                            }
                            strings = newStrings;
                        }
                        pos = next + delimiter.length();
                        ++fieldnr;
                    }
                    if (pos == length) {
                        if (log.isRowLevel()) {
                            log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileInput.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.EndOfEmptyLineFound", (String[])new String[0])});
                        }
                        if (fieldnr < strings.length) {
                            strings[fieldnr] = "";
                        }
                        ++fieldnr;
                    }
                    break block31;
                }
                for (int i = 0; i < inf.getInputFields().length; ++i) {
                    TextFileInputField field = inf.getInputFields()[i];
                    int length = line.length();
                    strings[i] = field.getPosition() + field.getLength() <= length ? line.substring(field.getPosition(), field.getPosition() + field.getLength()) : (field.getPosition() < length ? line.substring(field.getPosition()) : "");
                }
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.ErrorConvertingLine", (String[])new String[]{e.toString()}), (Throwable)e);
            }
        }
        return strings;
    }

    @Deprecated
    public static final Object[] convertLineToRow(ILogChannel log, TextFileLine textFileLine, IInputFileMeta info, IRowMeta outputRowMeta, IRowMeta convertRowMeta, String fname, long rowNr, String delimiter, IFileErrorHandler errorHandler, boolean addShortFilename, boolean addExtension, boolean addPath, boolean addSize, boolean addIsHidden, boolean addLastModificationDate, boolean addUri, boolean addRootUri, String shortFilename, String path, boolean hidden, Date modificationDateTime, String uri, String rooturi, String extension, long size) throws HopException {
        return TextFileInput.convertLineToRow(log, textFileLine, info, null, 0, outputRowMeta, convertRowMeta, fname, rowNr, delimiter, StringUtil.substituteHex((String)info.getEnclosure()), StringUtil.substituteHex((String)info.getEscapeCharacter()), errorHandler, addShortFilename, addExtension, addPath, addSize, addIsHidden, addLastModificationDate, addUri, addRootUri, shortFilename, path, hidden, modificationDateTime, uri, rooturi, extension, size);
    }

    public static Object[] convertLineToRow(ILogChannel log, TextFileLine textFileLine, IInputFileMeta info, Object[] passThruFields, int nrPassThruFields, IRowMeta outputRowMeta, IRowMeta convertRowMeta, String fname, long rowNr, String delimiter, String enclosure, String escapeCharacter, IFileErrorHandler errorHandler, boolean addShortFilename, boolean addExtension, boolean addPath, boolean addSize, boolean addIsHidden, boolean addLastModificationDate, boolean addUri, boolean addRootUri, String shortFilename, String path, boolean hidden, Date modificationDateTime, String uri, String rooturi, String extension, long size) throws HopException {
        return TextFileInput.convertLineToRow(log, textFileLine, info, passThruFields, nrPassThruFields, outputRowMeta, convertRowMeta, fname, rowNr, delimiter, enclosure, escapeCharacter, errorHandler, addShortFilename, addExtension, addPath, addSize, addIsHidden, addLastModificationDate, addUri, addRootUri, shortFilename, path, hidden, modificationDateTime, uri, rooturi, extension, size, true);
    }

    public static Object[] convertLineToRow(ILogChannel log, TextFileLine textFileLine, IInputFileMeta info, Object[] passThruFields, int nrPassThruFields, IRowMeta outputRowMeta, IRowMeta convertRowMeta, String fname, long rowNr, String delimiter, String enclosure, String escapeCharacter, IFileErrorHandler errorHandler, boolean addShortFilename, boolean addExtension, boolean addPath, boolean addSize, boolean addIsHidden, boolean addLastModificationDate, boolean addUri, boolean addRootUri, String shortFilename, String path, boolean hidden, Date modificationDateTime, String uri, String rooturi, String extension, long size, boolean failOnParseError) throws HopException {
        if (textFileLine == null || textFileLine.line == null) {
            return null;
        }
        Object[] r = RowDataUtil.allocateRowData((int)outputRowMeta.size());
        int nrFields = info.getInputFields().length;
        Long errorCount = null;
        if (info.isErrorIgnored() && info.getErrorCountField() != null && info.getErrorCountField().length() > 0) {
            errorCount = new Long(0L);
        }
        String errorFields = null;
        if (info.isErrorIgnored() && info.getErrorFieldsField() != null && info.getErrorFieldsField().length() > 0) {
            errorFields = "";
        }
        String errorText = null;
        if (info.isErrorIgnored() && info.getErrorTextField() != null && info.getErrorTextField().length() > 0) {
            errorText = "";
        }
        try {
            int fieldnr;
            String[] strings = TextFileInput.convertLineToStrings(log, textFileLine.line, info, delimiter, enclosure, escapeCharacter);
            int shiftFields = passThruFields == null ? 0 : nrPassThruFields;
            for (fieldnr = 0; fieldnr < nrFields; ++fieldnr) {
                Object value;
                block39: {
                    int trimType;
                    TextFileInputField f = info.getInputFields()[fieldnr];
                    int valuenr = shiftFields + fieldnr;
                    IValueMeta valueMeta = outputRowMeta.getValueMeta(valuenr);
                    IValueMeta convertMeta = convertRowMeta.getValueMeta(valuenr);
                    value = null;
                    String nullif = fieldnr < nrFields ? f.getNullString() : "";
                    String ifnull = fieldnr < nrFields ? f.getIfNullValue() : "";
                    int n = trimType = fieldnr < nrFields ? f.getTrimType() : 0;
                    if (fieldnr < strings.length) {
                        String pol = strings[fieldnr];
                        try {
                            if (valueMeta.isNull((Object)pol)) {
                                pol = null;
                            }
                            value = valueMeta.convertDataFromString(pol, convertMeta, nullif, ifnull, trimType);
                        }
                        catch (Exception e) {
                            if (failOnParseError) {
                                String message = BaseMessages.getString(PKG, (String)"TextFileInput.Log.CoundNotParseField", (String[])new String[]{valueMeta.toStringMeta(), "" + pol, valueMeta.getConversionMask(), "" + rowNr});
                                if (info.isErrorIgnored()) {
                                    StringBuilder sb;
                                    log.logDetailed(fname, new Object[]{BaseMessages.getString(PKG, (String)"TextFileInput.Log.Warning", (String[])new String[0]) + ": " + message + " : " + e.getMessage()});
                                    value = null;
                                    if (errorCount != null) {
                                        errorCount = new Long(errorCount + 1L);
                                    }
                                    if (errorFields != null) {
                                        sb = new StringBuilder(errorFields);
                                        if (sb.length() > 0) {
                                            sb.append("\t");
                                        }
                                        sb.append(valueMeta.getName());
                                        errorFields = sb.toString();
                                    }
                                    if (errorText != null) {
                                        sb = new StringBuilder(errorText);
                                        if (sb.length() > 0) {
                                            sb.append(Const.CR);
                                        }
                                        sb.append(message);
                                        errorText = sb.toString();
                                    }
                                    if (errorHandler != null) {
                                        errorHandler.handleLineError(textFileLine.lineNumber, "NO_PARTS");
                                    }
                                    if (info.isErrorLineSkipped()) {
                                        r = null;
                                    }
                                    break block39;
                                }
                                throw new HopException(message, (Throwable)e);
                            }
                            value = pol;
                        }
                    } else {
                        value = null;
                    }
                }
                if (r == null) continue;
                r[valuenr] = value;
            }
            if (r != null) {
                if (fieldnr < nrFields) {
                    for (int i = fieldnr; i < info.getInputFields().length; ++i) {
                        r[shiftFields + i] = null;
                    }
                }
                int index = shiftFields + nrFields;
                if (errorCount != null) {
                    r[index] = errorCount;
                    ++index;
                }
                if (errorFields != null) {
                    r[index] = errorFields;
                    ++index;
                }
                if (errorText != null) {
                    r[index] = errorText;
                    ++index;
                }
                if (info.includeFilename()) {
                    r[index] = fname;
                    ++index;
                }
                if (info.includeRowNumber()) {
                    r[index] = new Long(rowNr);
                    ++index;
                }
                if (addShortFilename) {
                    r[index] = shortFilename;
                    ++index;
                }
                if (addExtension) {
                    r[index] = extension;
                    ++index;
                }
                if (addPath) {
                    r[index] = path;
                    ++index;
                }
                if (addSize) {
                    r[index] = new Long(size);
                    ++index;
                }
                if (addIsHidden) {
                    r[index] = hidden;
                    ++index;
                }
                if (addLastModificationDate) {
                    r[index] = modificationDateTime;
                    ++index;
                }
                if (addUri) {
                    r[index] = uri;
                    ++index;
                }
                if (addRootUri) {
                    r[index] = rooturi;
                    ++index;
                }
                if (passThruFields != null) {
                    for (int i = 0; i < nrPassThruFields; ++i) {
                        r[i] = passThruFields[i];
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.ErrorConvertingLineText", (String[])new String[0]), (Throwable)e);
        }
        return r;
    }

    public boolean processRow() throws HopException {
        String extra;
        int i;
        Object[] r = null;
        boolean retval = true;
        boolean putrow = false;
        if (this.first) {
            this.first = false;
            ((TextFileInputData)this.data).outputRowMeta = new RowMeta();
            IRowMeta[] infoTransform = null;
            if (((TextFileInputMeta)this.meta).isAcceptingFilenames()) {
                ((TextFileInputData)this.data).getFiles().getFiles().clear();
                int idx = -1;
                ((TextFileInputData)this.data).rowSet = this.findInputRowSet(((TextFileInputMeta)this.meta).getAcceptingTransformName());
                Object[] fileRow = this.getRowFrom(((TextFileInputData)this.data).rowSet);
                while (fileRow != null) {
                    IRowMeta prevInfoFields = ((TextFileInputData)this.data).rowSet.getRowMeta();
                    if (idx < 0) {
                        if (((TextFileInputMeta)this.meta).isPassingThruFields()) {
                            ((TextFileInputData)this.data).passThruFields = new HashMap();
                            infoTransform = new IRowMeta[]{prevInfoFields};
                            ((TextFileInputData)this.data).nrPassThruFields = prevInfoFields.size();
                        }
                        if ((idx = prevInfoFields.indexOfValue(((TextFileInputMeta)this.meta).getAcceptingField())) < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.UnableToFindFilenameField", (String[])new String[]{((TextFileInputMeta)this.meta).getAcceptingField()}));
                            this.setErrors(this.getErrors() + 1L);
                            this.stopAll();
                            return false;
                        }
                    }
                    String fileValue = prevInfoFields.getString(fileRow, idx);
                    try {
                        FileObject fileObject = HopVfs.getFileObject((String)fileValue);
                        ((TextFileInputData)this.data).getFiles().addFile(fileObject);
                        if (((TextFileInputMeta)this.meta).isPassingThruFields()) {
                            ((TextFileInputData)this.data).passThruFields.put(fileObject, fileRow);
                        }
                    }
                    catch (HopFileException e) {
                        this.logError(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.UnableToCreateFileObject", (String[])new String[]{fileValue}), e);
                    }
                    fileRow = this.getRowFrom(((TextFileInputData)this.data).rowSet);
                }
                if (((TextFileInputData)this.data).getFiles().nrOfFiles() == 0) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.NoFilesSpecified", (String[])new String[0]));
                    }
                    this.setOutputDone();
                    return false;
                }
            }
            ((TextFileInputMeta)this.meta).getFields(((TextFileInputData)this.data).outputRowMeta, this.getTransformName(), infoTransform, null, (IVariables)this, this.metadataProvider);
            ((TextFileInputData)this.data).convertRowMeta = ((TextFileInputData)this.data).outputRowMeta.cloneToType(2);
            this.handleMissingFiles();
            if (!this.openNextFile() && this.failAfterBadFile(null)) {
                this.closeLastFile();
                this.setOutputDone();
                return false;
            }
            for (i = 0; i < ((TextFileInputMeta)this.meta).getInputFields().length; ++i) {
                if (!((TextFileInputMeta)this.meta).getInputFields()[i].isRepeated()) continue;
                ++((TextFileInputData)this.data).nr_repeats;
            }
        } else if (!((TextFileInputData)this.data).doneReading) {
            int repeats = 1;
            if (((TextFileInputMeta)this.meta).isLineWrapped()) {
                int n = repeats = ((TextFileInputMeta)this.meta).getNrWraps() > 0 ? ((TextFileInputMeta)this.meta).getNrWraps() : repeats;
            }
            if (!((TextFileInputData)this.data).doneWithHeader && ((TextFileInputData)this.data).headerLinesRead == 0) {
                repeats += ((TextFileInputMeta)this.meta).getNrHeaderLines() + 1;
            }
            for (i = 0; i < repeats && !((TextFileInputData)this.data).doneReading; ++i) {
                if (this.tryToReadLine(true)) continue;
                ++repeats;
            }
        }
        while (((TextFileInputData)this.data).lineBuffer.size() == 0) {
            if (this.openNextFile() || !this.failAfterBadFile(null)) continue;
            this.closeLastFile();
            this.setOutputDone();
            return false;
        }
        TextFileLine textLine = ((TextFileInputData)this.data).lineBuffer.get(0);
        this.incrementLinesInput();
        ++this.lineNumberInFile;
        ((TextFileInputData)this.data).lineBuffer.remove(0);
        if (((TextFileInputMeta)this.meta).isLayoutPaged()) {
            if (!((TextFileInputData)this.data).doneWithHeader && ((TextFileInputData)this.data).pageLinesRead == 0) {
                if (this.log.isRowLevel()) {
                    this.logRowlevel("P-HEADER (" + ((TextFileInputData)this.data).headerLinesRead + ") : " + textLine.line);
                }
                ++((TextFileInputData)this.data).headerLinesRead;
                if (((TextFileInputData)this.data).headerLinesRead >= ((TextFileInputMeta)this.meta).getNrHeaderLines()) {
                    ((TextFileInputData)this.data).doneWithHeader = true;
                }
            } else if (((TextFileInputData)this.data).pageLinesRead < ((TextFileInputMeta)this.meta).getNrLinesPerPage()) {
                if (((TextFileInputMeta)this.meta).isLineWrapped()) {
                    for (i = 0; i < ((TextFileInputMeta)this.meta).getNrWraps(); ++i) {
                        extra = "";
                        if (((TextFileInputData)this.data).lineBuffer.size() > 0) {
                            extra = ((TextFileInputData)this.data).lineBuffer.get((int)0).line;
                            ((TextFileInputData)this.data).lineBuffer.remove(0);
                        }
                        textLine.line = textLine.line + extra;
                    }
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel("P-DATA: " + textLine.line);
                }
                ++((TextFileInputData)this.data).pageLinesRead;
                ++((TextFileInputData)this.data).lineInFile;
                long useNumber = ((TextFileInputMeta)this.meta).isRowNumberByFile() ? (long)((TextFileInputData)this.data).lineInFile : this.getLinesWritten() + 1L;
                r = TextFileInput.convertLineToRow(this.log, textLine, (IInputFileMeta)this.meta, ((TextFileInputData)this.data).currentPassThruFieldsRow, ((TextFileInputData)this.data).nrPassThruFields, ((TextFileInputData)this.data).outputRowMeta, ((TextFileInputData)this.data).convertRowMeta, ((TextFileInputData)this.data).filename, useNumber, ((TextFileInputData)this.data).separator, ((TextFileInputData)this.data).enclosure, ((TextFileInputData)this.data).escapeCharacter, ((TextFileInputData)this.data).dataErrorLineHandler, ((TextFileInputData)this.data).addShortFilename, ((TextFileInputData)this.data).addExtension, ((TextFileInputData)this.data).addPath, ((TextFileInputData)this.data).addSize, ((TextFileInputData)this.data).addIsHidden, ((TextFileInputData)this.data).addLastModificationDate, ((TextFileInputData)this.data).addUri, ((TextFileInputData)this.data).addRootUri, ((TextFileInputData)this.data).shortFilename, ((TextFileInputData)this.data).path, ((TextFileInputData)this.data).hidden, ((TextFileInputData)this.data).lastModificationDateTime, ((TextFileInputData)this.data).uriName, ((TextFileInputData)this.data).rootUriName, ((TextFileInputData)this.data).extension, ((TextFileInputData)this.data).size);
                if (r != null) {
                    putrow = true;
                }
                if (!((TextFileInputMeta)this.meta).hasFooter() && ((TextFileInputData)this.data).pageLinesRead == ((TextFileInputMeta)this.meta).getNrLinesPerPage()) {
                    ((TextFileInputData)this.data).doneWithHeader = false;
                    ((TextFileInputData)this.data).headerLinesRead = 0;
                    ((TextFileInputData)this.data).pageLinesRead = 0;
                    ((TextFileInputData)this.data).footerLinesRead = 0;
                    if (this.log.isRowLevel()) {
                        this.logRowlevel("RESTART PAGE");
                    }
                }
            } else {
                if (((TextFileInputMeta)this.meta).hasFooter() && ((TextFileInputData)this.data).footerLinesRead < ((TextFileInputMeta)this.meta).getNrFooterLines()) {
                    if (this.log.isRowLevel()) {
                        this.logRowlevel("P-FOOTER: " + textLine.line);
                    }
                    ++((TextFileInputData)this.data).footerLinesRead;
                }
                if (!((TextFileInputMeta)this.meta).hasFooter() || ((TextFileInputData)this.data).footerLinesRead >= ((TextFileInputMeta)this.meta).getNrFooterLines()) {
                    ((TextFileInputData)this.data).doneWithHeader = false;
                    ((TextFileInputData)this.data).headerLinesRead = 0;
                    ((TextFileInputData)this.data).pageLinesRead = 0;
                    ((TextFileInputData)this.data).footerLinesRead = 0;
                    if (this.log.isRowLevel()) {
                        this.logRowlevel("RESTART PAGE");
                    }
                }
            }
        } else if (!((TextFileInputData)this.data).doneWithHeader) {
            ++((TextFileInputData)this.data).headerLinesRead;
            if (((TextFileInputData)this.data).headerLinesRead >= ((TextFileInputMeta)this.meta).getNrHeaderLines()) {
                ((TextFileInputData)this.data).doneWithHeader = true;
            }
        } else if (((TextFileInputData)this.data).doneReading && ((TextFileInputMeta)this.meta).hasFooter() && ((TextFileInputData)this.data).lineBuffer.size() < ((TextFileInputMeta)this.meta).getNrFooterLines()) {
            ((TextFileInputData)this.data).lineBuffer.clear();
        } else {
            if (((TextFileInputMeta)this.meta).isLineWrapped()) {
                for (i = 0; i < ((TextFileInputMeta)this.meta).getNrWraps(); ++i) {
                    extra = "";
                    if (((TextFileInputData)this.data).lineBuffer.size() > 0) {
                        extra = ((TextFileInputData)this.data).lineBuffer.get((int)0).line;
                        ((TextFileInputData)this.data).lineBuffer.remove(0);
                    } else {
                        this.tryToReadLine(true);
                        if (!((TextFileInputData)this.data).lineBuffer.isEmpty()) {
                            extra = ((TextFileInputData)this.data).lineBuffer.remove((int)0).line;
                        }
                    }
                    textLine.line = textLine.line + extra;
                }
            }
            if (((TextFileInputData)this.data).filePlayList.isProcessingNeeded(textLine.file, textLine.lineNumber, "NO_PARTS")) {
                ++((TextFileInputData)this.data).lineInFile;
                long useNumber = ((TextFileInputMeta)this.meta).isRowNumberByFile() ? (long)((TextFileInputData)this.data).lineInFile : this.getLinesWritten() + 1L;
                r = TextFileInput.convertLineToRow(this.log, textLine, (IInputFileMeta)this.meta, ((TextFileInputData)this.data).currentPassThruFieldsRow, ((TextFileInputData)this.data).nrPassThruFields, ((TextFileInputData)this.data).outputRowMeta, ((TextFileInputData)this.data).convertRowMeta, ((TextFileInputData)this.data).filename, useNumber, ((TextFileInputData)this.data).separator, ((TextFileInputData)this.data).enclosure, ((TextFileInputData)this.data).escapeCharacter, ((TextFileInputData)this.data).dataErrorLineHandler, ((TextFileInputData)this.data).addShortFilename, ((TextFileInputData)this.data).addExtension, ((TextFileInputData)this.data).addPath, ((TextFileInputData)this.data).addSize, ((TextFileInputData)this.data).addIsHidden, ((TextFileInputData)this.data).addLastModificationDate, ((TextFileInputData)this.data).addUri, ((TextFileInputData)this.data).addRootUri, ((TextFileInputData)this.data).shortFilename, ((TextFileInputData)this.data).path, ((TextFileInputData)this.data).hidden, ((TextFileInputData)this.data).lastModificationDateTime, ((TextFileInputData)this.data).uriName, ((TextFileInputData)this.data).rootUriName, ((TextFileInputData)this.data).extension, ((TextFileInputData)this.data).size);
                if (r != null) {
                    if (this.log.isRowLevel()) {
                        this.logRowlevel("Found data row: " + ((TextFileInputData)this.data).outputRowMeta.getString(r));
                    }
                    putrow = true;
                }
            } else {
                putrow = false;
            }
        }
        if (putrow && r != null) {
            if (((TextFileInputData)this.data).nr_repeats > 0) {
                if (((TextFileInputData)this.data).previousRow == null) {
                    ((TextFileInputData)this.data).previousRow = ((TextFileInputData)this.data).outputRowMeta.cloneRow(r);
                } else {
                    for (int i2 = 0; i2 < ((TextFileInputMeta)this.meta).getInputFields().length; ++i2) {
                        if (!((TextFileInputMeta)this.meta).getInputFields()[i2].isRepeated()) continue;
                        if (r[i2] == null) {
                            r[i2] = ((TextFileInputData)this.data).previousRow[i2];
                            continue;
                        }
                        ((TextFileInputData)this.data).previousRow[i2] = r[i2];
                    }
                }
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel("Putting row: " + ((TextFileInputData)this.data).outputRowMeta.getString(r));
            }
            this.putRow(((TextFileInputData)this.data).outputRowMeta, r);
            if (this.getLinesInput() >= ((TextFileInputMeta)this.meta).getRowLimit() && ((TextFileInputMeta)this.meta).getRowLimit() > 0L) {
                this.closeLastFile();
                this.setOutputDone();
                return false;
            }
        }
        if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
            this.logBasic("linenr " + this.getLinesInput());
        }
        return retval;
    }

    private boolean failAfterBadFile(String errorMsg) {
        if (this.getTransformMeta().isDoingErrorHandling() && ((TextFileInputData)this.data).filename != null && !((TextFileInputData)this.data).rejectedFiles.containsKey(((TextFileInputData)this.data).filename)) {
            ((TextFileInputData)this.data).rejectedFiles.put(((TextFileInputData)this.data).filename, true);
            this.rejectCurrentFile(errorMsg);
        }
        return !((TextFileInputMeta)this.meta).isErrorIgnored() || !((TextFileInputMeta)this.meta).isSkipBadFiles() || ((TextFileInputData)this.data).isLastFile;
    }

    private void rejectCurrentFile(String errorMsg) {
        if (StringUtils.isNotBlank((String)((TextFileInputMeta)this.meta).getFileErrorField()) || StringUtils.isNotBlank((String)((TextFileInputMeta)this.meta).getFileErrorMessageField())) {
            IRowMeta rowMeta = this.getInputRowMeta();
            if (rowMeta == null) {
                rowMeta = new RowMeta();
            }
            int errorFileIndex = StringUtils.isBlank((String)((TextFileInputMeta)this.meta).getFileErrorField()) ? -1 : this.addValueMeta(rowMeta, this.resolve(((TextFileInputMeta)this.meta).getFileErrorField()));
            int errorMessageIndex = StringUtils.isBlank((String)((TextFileInputMeta)this.meta).getFileErrorMessageField()) ? -1 : this.addValueMeta(rowMeta, this.resolve(((TextFileInputMeta)this.meta).getFileErrorMessageField()));
            try {
                Object[] rowData = this.getRow();
                if (rowData == null) {
                    rowData = RowDataUtil.allocateRowData((int)rowMeta.size());
                }
                if (errorFileIndex >= 0) {
                    rowData[errorFileIndex] = ((TextFileInputData)this.data).filename;
                }
                if (errorMessageIndex >= 0) {
                    rowData[errorMessageIndex] = errorMsg;
                }
                this.putError(rowMeta, rowData, this.getErrors(), ((TextFileInputData)this.data).filename, null, "ERROR_CODE");
            }
            catch (Exception e) {
                this.logError("Error sending error row", e);
            }
        }
    }

    private int addValueMeta(IRowMeta rowMeta, String fieldName) {
        ValueMetaString valueMeta = new ValueMetaString(fieldName);
        valueMeta.setOrigin(this.getTransformName());
        int index = -1;
        if (!rowMeta.exists((IValueMeta)valueMeta)) {
            index = rowMeta.size();
            rowMeta.addValueMeta((IValueMeta)valueMeta);
        } else {
            index = rowMeta.indexOfValue(fieldName);
        }
        return index;
    }

    private boolean checkFilterRow(String line, boolean isFilterLastLine) {
        boolean filterOK = true;
        if (((TextFileInputMeta)this.meta).noEmptyLines() && line.length() == 0) {
            filterOK = false;
        } else {
            filterOK = ((TextFileInputData)this.data).filterProcessor.doFilters(line);
            if (!filterOK && ((TextFileInputData)this.data).filterProcessor.isStopProcessing()) {
                ((TextFileInputData)this.data).doneReading = true;
            }
        }
        return filterOK;
    }

    private void handleMissingFiles() throws HopException {
        List nonAccessibleFiles;
        List nonExistantFiles = ((TextFileInputData)this.data).getFiles().getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            if (this.log.isBasic()) {
                this.log.logBasic("Required files", new Object[]{"WARNING: Missing " + message});
            }
            if (((TextFileInputMeta)this.meta).isErrorIgnored()) {
                for (FileObject fileObject : nonExistantFiles) {
                    ((TextFileInputData)this.data).dataErrorLineHandler.handleNonExistantFile(fileObject);
                }
            } else {
                throw new HopException("Following required files are missing: " + message);
            }
        }
        if ((nonAccessibleFiles = ((TextFileInputData)this.data).getFiles().getNonAccessibleFiles()).size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            if (this.log.isBasic()) {
                this.log.logBasic("Required files", new Object[]{"WARNING: Not accessible " + message});
            }
            if (((TextFileInputMeta)this.meta).isErrorIgnored()) {
                for (FileObject fileObject : nonAccessibleFiles) {
                    ((TextFileInputData)this.data).dataErrorLineHandler.handleNonAccessibleFile(fileObject);
                }
            } else {
                throw new HopException("Following required files are not accessible: " + message);
            }
        }
    }

    private boolean closeLastFile() {
        try {
            if (((TextFileInputData)this.data).filename != null) {
                this.incrementLinesUpdated();
                ((TextFileInputData)this.data).in.close();
                ((TextFileInputData)this.data).isr.close();
                ((TextFileInputData)this.data).filename = null;
                if (((TextFileInputData)this.data).file != null) {
                    ((TextFileInputData)this.data).file.close();
                    ((TextFileInputData)this.data).file = null;
                }
            }
            ((TextFileInputData)this.data).dataErrorLineHandler.close();
        }
        catch (Exception e) {
            String errorMsg = "Couldn't close file : " + ((TextFileInputData)this.data).file.getName().getFriendlyURI() + " --> " + e.toString();
            this.logError(errorMsg);
            if (this.failAfterBadFile(errorMsg)) {
                this.stopAll();
            }
            this.setErrors(this.getErrors() + 1L);
            return false;
        }
        return !((TextFileInputData)this.data).isLastFile;
    }

    private boolean openNextFile() {
        try {
            int i;
            this.lineNumberInFile = 0L;
            if (!this.closeLastFile() && this.failAfterBadFile(null)) {
                return false;
            }
            if (((TextFileInputData)this.data).getFiles().nrOfFiles() == 0) {
                return false;
            }
            ((TextFileInputData)this.data).isLastFile = ((TextFileInputData)this.data).filenr == ((TextFileInputData)this.data).getFiles().nrOfFiles() - 1;
            ((TextFileInputData)this.data).file = ((TextFileInputData)this.data).getFiles().getFile(((TextFileInputData)this.data).filenr);
            ((TextFileInputData)this.data).filename = HopVfs.getFilename((FileObject)((TextFileInputData)this.data).file);
            ++((TextFileInputData)this.data).filenr;
            if (((TextFileInputData)this.data).addShortFilename) {
                ((TextFileInputData)this.data).shortFilename = ((TextFileInputData)this.data).file.getName().getBaseName();
            }
            if (((TextFileInputData)this.data).addPath) {
                ((TextFileInputData)this.data).path = HopVfs.getFilename((FileObject)((TextFileInputData)this.data).file.getParent());
            }
            if (((TextFileInputData)this.data).addIsHidden) {
                ((TextFileInputData)this.data).hidden = ((TextFileInputData)this.data).file.isHidden();
            }
            if (((TextFileInputData)this.data).addExtension) {
                ((TextFileInputData)this.data).extension = ((TextFileInputData)this.data).file.getName().getExtension();
            }
            if (((TextFileInputData)this.data).addLastModificationDate) {
                ((TextFileInputData)this.data).lastModificationDateTime = new Date(((TextFileInputData)this.data).file.getContent().getLastModifiedTime());
            }
            if (((TextFileInputData)this.data).addUri) {
                ((TextFileInputData)this.data).uriName = ((TextFileInputData)this.data).file.getName().getURI();
            }
            if (((TextFileInputData)this.data).addRootUri) {
                ((TextFileInputData)this.data).rootUriName = ((TextFileInputData)this.data).file.getName().getRootURI();
            }
            if (((TextFileInputData)this.data).addSize) {
                ((TextFileInputData)this.data).size = new Long(((TextFileInputData)this.data).file.getContent().getSize());
            }
            ((TextFileInputData)this.data).lineInFile = 0;
            if (((TextFileInputMeta)this.meta).isPassingThruFields()) {
                ((TextFileInputData)this.data).currentPassThruFieldsRow = ((TextFileInputData)this.data).passThruFields.get(((TextFileInputData)this.data).file);
            }
            if (((TextFileInputMeta)this.meta).isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, ((TextFileInputData)this.data).file, this.getPipelineMeta().getName(), this.toString());
                resultFile.setComment("File was read by an Text File input transform");
                this.addResultFile(resultFile);
            }
            if (this.log.isBasic()) {
                this.logBasic("Opening file: " + ((TextFileInputData)this.data).file.getName().getFriendlyURI());
            }
            ICompressionProvider provider = CompressionProviderFactory.getInstance().getCompressionProviderByName(((TextFileInputMeta)this.meta).getFileCompression());
            ((TextFileInputData)this.data).in = provider.createInputStream(HopVfs.getInputStream((FileObject)((TextFileInputData)this.data).file));
            ((TextFileInputData)this.data).dataErrorLineHandler.handleFile(((TextFileInputData)this.data).file);
            ((TextFileInputData)this.data).in.nextEntry();
            if (this.log.isDetailed()) {
                this.logDetailed("This is a compressed file being handled by the " + provider.getName() + " provider");
            }
            ((TextFileInputData)this.data).isr = ((TextFileInputMeta)this.meta).getEncoding() != null && ((TextFileInputMeta)this.meta).getEncoding().length() > 0 ? new InputStreamReader((InputStream)new BufferedInputStream((InputStream)((TextFileInputData)this.data).in, 500), ((TextFileInputMeta)this.meta).getEncoding()) : new InputStreamReader(new BufferedInputStream((InputStream)((TextFileInputData)this.data).in, 500));
            String encoding = ((TextFileInputData)this.data).isr.getEncoding();
            ((TextFileInputData)this.data).encodingType = EncodingType.guessEncodingType((String)encoding);
            ((TextFileInputData)this.data).doneReading = false;
            int bufferSize = 1;
            bufferSize += ((TextFileInputMeta)this.meta).hasHeader() ? ((TextFileInputMeta)this.meta).getNrHeaderLines() : 0;
            bufferSize += ((TextFileInputMeta)this.meta).isLayoutPaged() ? ((TextFileInputMeta)this.meta).getNrLinesPerPage() * (Math.max(0, ((TextFileInputMeta)this.meta).getNrWraps()) + 1) : Math.max(0, ((TextFileInputMeta)this.meta).getNrWraps());
            bufferSize += ((TextFileInputMeta)this.meta).hasFooter() ? ((TextFileInputMeta)this.meta).getNrFooterLines() : 0;
            if (((TextFileInputMeta)this.meta).isLayoutPaged()) {
                for (i = 0; i < ((TextFileInputMeta)this.meta).getNrLinesDocHeader(); ++i) {
                    TextFileInput.getLine(this.log, ((TextFileInputData)this.data).isr, ((TextFileInputData)this.data).encodingType, ((TextFileInputData)this.data).fileFormatType, ((TextFileInputData)this.data).lineStringBuilder);
                    ++this.lineNumberInFile;
                }
            }
            for (i = 0; i < bufferSize && !((TextFileInputData)this.data).doneReading; ++i) {
                boolean wasNotFiltered = this.tryToReadLine(!((TextFileInputMeta)this.meta).hasHeader() || i >= ((TextFileInputMeta)this.meta).getNrHeaderLines());
                if (wasNotFiltered) continue;
                ++bufferSize;
            }
            ((TextFileInputData)this.data).headerLinesRead = 0;
            ((TextFileInputData)this.data).footerLinesRead = 0;
            ((TextFileInputData)this.data).pageLinesRead = 0;
            ((TextFileInputData)this.data).doneWithHeader = !((TextFileInputMeta)this.meta).hasHeader();
        }
        catch (Exception e) {
            String errorMsg = "Couldn't open file #" + ((TextFileInputData)this.data).filenr + " : " + ((TextFileInputData)this.data).file.getName().getFriendlyURI() + " --> " + e.toString();
            this.logError(errorMsg);
            if (this.failAfterBadFile(errorMsg)) {
                this.stopAll();
            }
            this.setErrors(this.getErrors() + 1L);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryToReadLine(boolean applyFilter) throws HopFileException {
        String line = TextFileInput.getLine(this.log, ((TextFileInputData)this.data).isr, ((TextFileInputData)this.data).encodingType, ((TextFileInputData)this.data).fileFormatType, ((TextFileInputData)this.data).lineStringBuilder);
        if (line != null) {
            if (applyFilter) {
                boolean isFilterLastLine = false;
                boolean filterOK = this.checkFilterRow(line, isFilterLastLine);
                if (!filterOK) return false;
                ((TextFileInputData)this.data).lineBuffer.add(new TextFileLine(line, this.lineNumberInFile, ((TextFileInputData)this.data).file));
                return true;
            } else {
                if (((TextFileInputMeta)this.meta).noEmptyLines() && line.length() == 0) return true;
                ((TextFileInputData)this.data).lineBuffer.add(new TextFileLine(line, this.lineNumberInFile, ((TextFileInputData)this.data).file));
            }
            return true;
        } else {
            ((TextFileInputData)this.data).doneReading = true;
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            Map resultFiles;
            this.initErrorHandling();
            this.initReplayFactory();
            ((TextFileInputData)this.data).setFiles(((TextFileInputMeta)this.meta).getTextFileList((IVariables)this));
            ((TextFileInputData)this.data).filterProcessor = new TextFileFilterProcessor(((TextFileInputMeta)this.meta).getFilter());
            Result previousResult = this.getPipeline().getPreviousResult();
            Map map = resultFiles = previousResult != null ? previousResult.getResultFiles() : null;
            if (!(previousResult != null && resultFiles != null && resultFiles.size() != 0 || ((TextFileInputData)this.data).getFiles().nrOfMissingFiles() <= 0 || ((TextFileInputMeta)this.meta).isAcceptingFilenames() || ((TextFileInputMeta)this.meta).isErrorIgnored())) {
                this.logError(BaseMessages.getString(PKG, (String)"TextFileInput.Log.Error.NoFilesSpecified", (String[])new String[0]));
                return false;
            }
            ((TextFileInputData)this.data).fileFormatType = ((TextFileInputMeta)this.meta).getFileFormatTypeNr();
            ((TextFileInputData)this.data).fileType = ((TextFileInputMeta)this.meta).getFileTypeNr();
            ((TextFileInputData)this.data).separator = this.resolve(((TextFileInputMeta)this.meta).getSeparator());
            ((TextFileInputData)this.data).enclosure = this.resolve(((TextFileInputMeta)this.meta).getEnclosure());
            ((TextFileInputData)this.data).escapeCharacter = this.resolve(((TextFileInputMeta)this.meta).getEscapeCharacter());
            if (!Utils.isEmpty((CharSequence)((TextFileInputMeta)this.meta).getShortFileNameField())) {
                ((TextFileInputData)this.data).addShortFilename = true;
            }
            if (!Utils.isEmpty((CharSequence)((TextFileInputMeta)this.meta).getPathField())) {
                ((TextFileInputData)this.data).addPath = true;
            }
            if (!Utils.isEmpty((CharSequence)((TextFileInputMeta)this.meta).getExtensionField())) {
                ((TextFileInputData)this.data).addExtension = true;
            }
            if (!Utils.isEmpty((CharSequence)((TextFileInputMeta)this.meta).getSizeField())) {
                ((TextFileInputData)this.data).addSize = true;
            }
            if (!Utils.isEmpty((CharSequence)((TextFileInputMeta)this.meta).isHiddenField())) {
                ((TextFileInputData)this.data).addIsHidden = true;
            }
            if (!Utils.isEmpty((CharSequence)((TextFileInputMeta)this.meta).getLastModificationDateField())) {
                ((TextFileInputData)this.data).addLastModificationDate = true;
            }
            if (!Utils.isEmpty((CharSequence)((TextFileInputMeta)this.meta).getUriField())) {
                ((TextFileInputData)this.data).addUri = true;
            }
            if (!Utils.isEmpty((CharSequence)((TextFileInputMeta)this.meta).getRootUriField())) {
                ((TextFileInputData)this.data).addRootUri = true;
            }
            return true;
        }
        return false;
    }

    private void initReplayFactory() {
        ((TextFileInputData)this.data).filePlayList = FilePlayListAll.INSTANCE;
    }

    private void initErrorHandling() {
        ArrayList<Object> dataErrorLineHandlers = new ArrayList<Object>(2);
        if (((TextFileInputMeta)this.meta).getLineNumberFilesDestinationDirectory() != null) {
            dataErrorLineHandlers.add(new FileErrorHandlerContentLineNumber(this.getPipeline().getExecutionStartDate(), this.resolve(((TextFileInputMeta)this.meta).getLineNumberFilesDestinationDirectory()), ((TextFileInputMeta)this.meta).getLineNumberFilesExtension(), ((TextFileInputMeta)this.meta).getEncoding(), (BaseTransform)this));
        }
        if (((TextFileInputMeta)this.meta).getErrorFilesDestinationDirectory() != null) {
            dataErrorLineHandlers.add(new FileErrorHandlerMissingFiles(this.getPipeline().getExecutionStartDate(), this.resolve(((TextFileInputMeta)this.meta).getErrorFilesDestinationDirectory()), ((TextFileInputMeta)this.meta).getErrorLineFilesExtension(), ((TextFileInputMeta)this.meta).getEncoding(), (BaseTransform)this));
        }
        ((TextFileInputData)this.data).dataErrorLineHandler = new CompositeFileErrorHandler(dataErrorLineHandlers);
    }

    public void dispose() {
        if (((TextFileInputData)this.data).file != null) {
            try {
                ((TextFileInputData)this.data).file.close();
                ((TextFileInputData)this.data).file = null;
            }
            catch (Exception e) {
                this.log.logError("Error closing file", (Throwable)e);
            }
        }
        if (((TextFileInputData)this.data).in != null) {
            BaseTransform.closeQuietly((Closeable)((TextFileInputData)this.data).in);
            ((TextFileInputData)this.data).in = null;
        }
        super.dispose();
    }
}

