/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.ingres;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;

@DatabaseMetaPlugin(type="INGRES", typeDescription="Ingres")
@GuiPlugin(id="GUI-IngresDatabaseMeta")
public class IngresDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return -1;
        }
        return -1;
    }

    public String getDriverClass() {
        return "com.ingres.jdbc.IngresDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (Utils.isEmpty((CharSequence)port)) {
            return "jdbc:ingres://" + hostname + ":II7/" + databaseName;
        }
        return "jdbc:ingres://" + hostname + ":" + port + "/" + databaseName;
    }

    public boolean supportsBitmapIndex() {
        return false;
    }

    public boolean supportsSynonyms() {
        return false;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " DROP COLUMN " + v.getName() + Const.CR;
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 9: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 3: {
                retval = retval + "DATE";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (useAutoinc) {
                        retval = retval + "BIGINT PRIMARY KEY IDENTITY(0,1)";
                        break;
                    }
                    retval = retval + "BIGINT PRIMARY KEY NOT NULL";
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        retval = retval + "BIGINT";
                        break;
                    }
                    if (length > 4) {
                        retval = retval + "INTEGER";
                        break;
                    }
                    if (length > 2) {
                        retval = retval + "SMALLINT";
                        break;
                    }
                    retval = retval + "INTEGER1";
                    break;
                }
                retval = retval + "FLOAT";
                break;
            }
            case 2: {
                if (length > 0) {
                    retval = retval + "VARCHAR(" + length + ")";
                    break;
                }
                retval = retval + "VARCHAR(2000)";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    public boolean supportsGetBlob() {
        return false;
    }
}

