/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.sapdb;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="SAPDB", typeDescription="MaxDB (SAP DB)")
@GuiPlugin(id="GUI-SAPDBDatabaseMeta")
public class SAPDBDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        return -1;
    }

    public boolean supportsAutoInc() {
        return false;
    }

    public String getDriverClass() {
        return "com.sap.dbtech.jdbc.DriverSapDB";
    }

    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:sapdb://" + hostname + "/" + databaseName;
    }

    public boolean supportsBitmapIndex() {
        return false;
    }

    public boolean supportsSynonyms() {
        return false;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + v.getName() + " TYPE " + this.getFieldDefinition(v, tk, pk, useAutoinc, false, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = Const.indexOfString((String)fieldname, (String[])this.getReservedWords()) >= 0 ? retval + this.getStartQuote() + fieldname + this.getEndQuote() : retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = retval + "BIGINT NOT NULL PRIMARY KEY";
                    break;
                }
                if (length > 0) {
                    if (precision > 0 || length > 18) {
                        retval = retval + "DECIMAL(" + length;
                        if (precision > 0) {
                            retval = retval + ", " + precision;
                        }
                        retval = retval + ")";
                        break;
                    }
                    if (length > 9) {
                        retval = retval + "INT64";
                        break;
                    }
                    if (length < 5) {
                        retval = retval + "SMALLINT";
                        break;
                    }
                    retval = retval + "INTEGER";
                    break;
                }
                retval = retval + "DOUBLE";
                break;
            }
            case 2: {
                if (length < 32720) {
                    retval = retval + "VARCHAR";
                    if (length > 0) {
                        retval = retval + "(" + length + ")";
                        break;
                    }
                    retval = retval + "(8000)";
                    break;
                }
                retval = retval + "BLOB SUB_TYPE TEXT";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public String[] getReservedWords() {
        return new String[]{"ABS", "ABSOLUTE", "ACOS", "ADDDATE", "ADDTIME", "ALL", "ALPHA", "ALTER", "ANY", "ASCII", "ASIN", "ATAN", "ATAN2", "AVG", "BINARY", "BIT", "BOOLEAN", "BYTE", "CASE", "CEIL", "CEILING", "CHAR", "CHARACTER", "CHECK", "CHR", "COLUMN", "CONCAT", "CONSTRAINT", "COS", "COSH", "COT", "COUNT", "CROSS", "CURDATE", "CURRENT", "CURTIME", "DATABASE", "DATE", "DATEDIFF", "DAY", "DAYNAME", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "DEC", "DECIMAL", "DECODE", "DEFAULT", "DEGREES", "DELETE", "DIGITS", "DISTINCT", "DOUBLE", "EXCEPT", "EXISTS", "EXP", "EXPAND", "FIRST", "FIXED", "FLOAT", "FLOOR", "FOR", "FROM", "FULL", "GET_OBJECTNAME", "GET_SCHEMA", "GRAPHIC", "GREATEST", "GROUP", "HAVING", "HEX", "HEXTORAW", "HOUR", "IFNULL", "IGNORE", "INDEX", "INITCAP", "INNER", "INSERT", "INT", "INTEGER", "INTERNAL", "INTERSECT", "INTO", "JOIN", "KEY", "LAST", "LCASE", "LEAST", "LEFT", "LENGTH", "LFILL", "LIST", "LN", "LOCATE", "LOG", "LOG10", "LONG", "LONGFILE", "LOWER", "LPAD", "LTRIM", "MAKEDATE", "MAKETIME", "MAPCHAR", "MAX", "MBCS", "MICROSECOND", "MIN", "MINUTE", "MOD", "MONTH", "MONTHNAME", "NATURAL", "NCHAR", "NEXT", "NO", "NOROUND", "NOT", "NOW", "NULL", "NUM", "NUMERIC", "OBJECT", "OF", "ON", "ORDER", "PACKED", "PI", "POWER", "PREV", "PRIMARY", "RADIANS", "REAL", "REJECT", "RELATIVE", "REPLACE", "RFILL", "RIGHT", "ROUND", "ROWID", "ROWNO", "RPAD", "RTRIM", "SECOND", "SELECT", "SELUPD", "SERIAL", "SET", "SHOW", "SIGN", "SIN", "SINH", "SMALLINT", "SOME", "SOUNDEX", "SPACE", "SQRT", "STAMP", "STATISTICS", "STDDEV", "SUBDATE", "SUBSTR", "SUBSTRING", "SUBTIME", "SUM", "SYSDBA", "TABLE", "TAN", "TANH", "TIME", "TIMEDIFF", "TIMESTAMP", "TIMEZONE", "TO", "TOIDENTIFIER", "TRANSACTION", "TRANSLATE", "TRIM", "TRUNC", "TRUNCATE", "UCASE", "UID", "UNICODE", "UNION", "UPDATE", "UPPER", "USER", "USERGROUP", "USING", "UTCDATE", "UTCDIFF", "VALUE", "VALUES", "VARCHAR", "VARGRAPHIC", "VARIANCE", "WEEK", "WEEKOFYEAR", "WHEN", "WHERE", "WITH", "YEAR", "ZONED"};
    }
}

