/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.append;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.errorhandling.IStream;
import org.apache.hop.pipeline.transform.errorhandling.Stream;
import org.apache.hop.pipeline.transform.errorhandling.StreamIcon;
import org.apache.hop.pipeline.transforms.append.Append;
import org.apache.hop.pipeline.transforms.append.AppendData;

@Transform(id="Append", image="append.svg", name="i18n::Append.Name", description="i18n::Append.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", documentationUrl="/pipeline/transforms/append.html")
@InjectionSupported(localizationPrefix="AppendMeta.Injection.")
public class AppendMeta
extends BaseTransformMeta
implements ITransformMeta<Append, AppendData> {
    private static final Class<?> PKG = Append.class;
    @Injection(name="HEAD_TRANSFORM")
    @HopMetadataProperty(key="head_name")
    public String headTransformName;
    @Injection(name="TAIL_TRANSFORM")
    @HopMetadataProperty(key="tail_name")
    public String tailTransformName;

    public String getXml() throws HopException {
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        this.headTransformName = ((IStream)infoStreams.get(0)).getTransformName();
        this.tailTransformName = ((IStream)infoStreams.get(1)).getTransformName();
        return super.getXml();
    }

    public void convertIOMetaToTransformNames() {
        List streams = this.getTransformIOMeta().getInfoStreams();
        this.headTransformName = ((IStream)streams.get(0)).getTransformName();
        this.tailTransformName = ((IStream)streams.get(1)).getTransformName();
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List streams = this.getTransformIOMeta().getInfoStreams();
        ((IStream)streams.get(0)).setTransformMeta(TransformMeta.findTransform(transforms, (String)this.headTransformName));
        ((IStream)streams.get(1)).setTransformMeta(TransformMeta.findTransform(transforms, (String)this.tailTransformName));
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (info != null && info.length > 0 && info[0] != null) {
            r.mergeRowMeta(info[0]);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        IStream headStream = (IStream)infoStreams.get(0);
        IStream tailStream = (IStream)infoStreams.get(1);
        if (headStream.getTransformName() != null && tailStream.getTransformName() != null) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AppendMeta.CheckResult.SourceTransformsOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else if (headStream.getTransformName() == null && tailStream.getTransformName() == null) {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AppendMeta.CheckResult.SourceTransformsMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AppendMeta.CheckResult.OneSourceTransformMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public Append createTransform(TransformMeta transformMeta, AppendData data, int cnr, PipelineMeta tr, Pipeline pipeline) {
        return new Append(transformMeta, this, data, cnr, tr, pipeline);
    }

    public AppendData getTransformData() {
        return new AppendData();
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            Stream headStream = new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"AppendMeta.InfoStream.FirstStream.Description", (String[])new String[0]), StreamIcon.INFO, null);
            ioMeta.addStream((IStream)headStream);
            Stream tailStream = new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"AppendMeta.InfoStream.SecondStream.Description", (String[])new String[0]), StreamIcon.INFO, null);
            ioMeta.addStream((IStream)tailStream);
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void resetTransformIoMeta() {
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }

    public String getHeadTransformName() {
        return this.headTransformName;
    }

    public void setHeadTransformName(String headTransformName) {
        this.headTransformName = headTransformName;
    }

    public String getTailTransformName() {
        return this.tailTransformName;
    }

    public void setTailTransformName(String tailTransformName) {
        this.tailTransformName = tailTransformName;
    }
}

