/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xsdvalidator;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transforms.xml.xsdvalidator.XsdValidatorMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class XsdValidatorDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = XsdValidatorMeta.class;
    private LabelTextVar wResultField;
    private LabelTextVar wValidationMsg;
    private LabelTextVar wIfXMLValid;
    private LabelTextVar wIfXMLUnValid;
    private CCombo wXMLStream;
    private CCombo wXSDSource;
    private CCombo wXSDDefinedColumn;
    private Label wlFilename;
    private Label wlXSDDefinedColumn;
    private Button wbbFilename;
    private Button wAddValidationMsg;
    private Button wOutputStringField;
    private Button wXMLSourceFile;
    private final XsdValidatorMeta input;
    private TextVar wFilename;
    private Button wAllowExternalEntities;
    private boolean gotPrevious = false;

    public XsdValidatorDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (XsdValidatorMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.GeneralTab.TabTitle", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wXML = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wXML);
        wXML.setText("XML source");
        FormLayout groupXML = new FormLayout();
        groupXML.marginWidth = 10;
        groupXML.marginHeight = 10;
        wXML.setLayout((Layout)groupXML);
        Label wlXMLSourceFile = new Label((Composite)wXML, 131072);
        wlXMLSourceFile.setText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.XMLSourceFile.Label", (String[])new String[0]));
        this.props.setLook((Control)wlXMLSourceFile);
        FormData fdlXMLSourceFile = new FormData();
        fdlXMLSourceFile.left = new FormAttachment(0, 0);
        fdlXMLSourceFile.top = new FormAttachment((Control)this.wTransformName, 2 * margin);
        fdlXMLSourceFile.right = new FormAttachment(middle, -margin);
        wlXMLSourceFile.setLayoutData((Object)fdlXMLSourceFile);
        this.wXMLSourceFile = new Button((Composite)wXML, 32);
        this.props.setLook((Control)this.wXMLSourceFile);
        this.wXMLSourceFile.setToolTipText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.XMLSourceFile.Tooltip", (String[])new String[0]));
        FormData fdXMLSourceFile = new FormData();
        fdXMLSourceFile.left = new FormAttachment(middle, margin);
        fdXMLSourceFile.top = new FormAttachment((Control)wlXMLSourceFile, 0, 0x1000000);
        this.wXMLSourceFile.setLayoutData((Object)fdXMLSourceFile);
        this.wXMLSourceFile.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlXMLStream = new Label((Composite)wXML, 131072);
        wlXMLStream.setText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.XMLStream.Label", (String[])new String[0]));
        this.props.setLook((Control)wlXMLStream);
        FormData fdlXMLStream = new FormData();
        fdlXMLStream.left = new FormAttachment(0, 0);
        fdlXMLStream.top = new FormAttachment((Control)this.wXMLSourceFile, margin);
        fdlXMLStream.right = new FormAttachment(middle, -margin);
        wlXMLStream.setLayoutData((Object)fdlXMLStream);
        this.wXMLStream = new CCombo((Composite)wXML, 2056);
        this.wXMLStream.setEditable(true);
        this.props.setLook((Control)this.wXMLStream);
        this.wXMLStream.addModifyListener(lsMod);
        FormData fdXMLStream = new FormData();
        fdXMLStream.left = new FormAttachment(middle, margin);
        fdXMLStream.top = new FormAttachment((Control)this.wXMLSourceFile, margin);
        fdXMLStream.right = new FormAttachment(100, -margin);
        this.wXMLStream.setLayoutData((Object)fdXMLStream);
        this.wXMLStream.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)XsdValidatorDialog.this.shell.getDisplay(), 1);
                XsdValidatorDialog.this.shell.setCursor(busy);
                XsdValidatorDialog.this.PopulateFields();
                XsdValidatorDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        FormData fdXML = new FormData();
        fdXML.left = new FormAttachment(0, margin);
        fdXML.top = new FormAttachment((Control)this.wTransformName, margin);
        fdXML.right = new FormAttachment(100, -margin);
        wXML.setLayoutData((Object)fdXML);
        Group wOutputFields = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wOutputFields);
        wOutputFields.setText("Output Fields");
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        wOutputFields.setLayout((Layout)groupLayout);
        this.wResultField = new LabelTextVar(this.variables, (Composite)wOutputFields, BaseMessages.getString(PKG, (String)"XsdValidatorDialog.ResultField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XsdValidatorDialog.ResultField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wResultField);
        this.wResultField.addModifyListener(lsMod);
        FormData fdResultField = new FormData();
        fdResultField.left = new FormAttachment(0, 0);
        fdResultField.top = new FormAttachment((Control)wXML, margin);
        fdResultField.right = new FormAttachment(100, 0);
        this.wResultField.setLayoutData((Object)fdResultField);
        Label wlOutputStringField = new Label((Composite)wOutputFields, 131072);
        wlOutputStringField.setText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.OutputStringField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOutputStringField);
        FormData fdlOutputStringField = new FormData();
        fdlOutputStringField.left = new FormAttachment(0, 0);
        fdlOutputStringField.top = new FormAttachment((Control)this.wResultField, 2 * margin);
        fdlOutputStringField.right = new FormAttachment(middle, -margin);
        wlOutputStringField.setLayoutData((Object)fdlOutputStringField);
        this.wOutputStringField = new Button((Composite)wOutputFields, 32);
        this.props.setLook((Control)this.wOutputStringField);
        this.wOutputStringField.setToolTipText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.OutputStringField.Tooltip", (String[])new String[0]));
        FormData fdOutputStringField = new FormData();
        fdOutputStringField.left = new FormAttachment(middle, margin);
        fdOutputStringField.top = new FormAttachment((Control)wlOutputStringField, 0, 0x1000000);
        this.wOutputStringField.setLayoutData((Object)fdOutputStringField);
        this.wOutputStringField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XsdValidatorDialog.this.activateOutputStringField();
                XsdValidatorDialog.this.input.setChanged();
            }
        });
        this.wIfXMLValid = new LabelTextVar(this.variables, (Composite)wOutputFields, BaseMessages.getString(PKG, (String)"XsdValidatorDialog.IfXMLValid.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XsdValidatorDialog.IfXMLValid.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wIfXMLValid);
        this.wIfXMLValid.addModifyListener(lsMod);
        FormData fdIfXMLValid = new FormData();
        fdIfXMLValid.left = new FormAttachment(0, 0);
        fdIfXMLValid.top = new FormAttachment((Control)this.wOutputStringField, margin);
        fdIfXMLValid.right = new FormAttachment(100, 0);
        this.wIfXMLValid.setLayoutData((Object)fdIfXMLValid);
        this.wIfXMLUnValid = new LabelTextVar(this.variables, (Composite)wOutputFields, BaseMessages.getString(PKG, (String)"XsdValidatorDialog.IfXMLUnValid.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XsdValidatorDialog.IfXMLUnValid.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wIfXMLUnValid);
        this.wIfXMLUnValid.addModifyListener(lsMod);
        FormData fdIfXMLUnValid = new FormData();
        fdIfXMLUnValid.left = new FormAttachment(0, 0);
        fdIfXMLUnValid.top = new FormAttachment((Control)this.wIfXMLValid, margin);
        fdIfXMLUnValid.right = new FormAttachment(100, 0);
        this.wIfXMLUnValid.setLayoutData((Object)fdIfXMLUnValid);
        Label wlAddValidationMsg = new Label((Composite)wOutputFields, 131072);
        wlAddValidationMsg.setText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.AddValidationMsg.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddValidationMsg);
        FormData fdlAddValidationMsg = new FormData();
        fdlAddValidationMsg.left = new FormAttachment(0, 0);
        fdlAddValidationMsg.top = new FormAttachment((Control)this.wIfXMLUnValid, 2 * margin);
        fdlAddValidationMsg.right = new FormAttachment(middle, -margin);
        wlAddValidationMsg.setLayoutData((Object)fdlAddValidationMsg);
        this.wAddValidationMsg = new Button((Composite)wOutputFields, 32);
        this.props.setLook((Control)this.wAddValidationMsg);
        this.wAddValidationMsg.setToolTipText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.AddValidationMsg.Tooltip", (String[])new String[0]));
        FormData fdAddValidationMsg = new FormData();
        fdAddValidationMsg.left = new FormAttachment(middle, margin);
        fdAddValidationMsg.top = new FormAttachment((Control)wlAddValidationMsg, 0, 0x1000000);
        this.wAddValidationMsg.setLayoutData((Object)fdAddValidationMsg);
        this.wAddValidationMsg.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XsdValidatorDialog.this.activateValidationMsg();
                XsdValidatorDialog.this.input.setChanged();
            }
        });
        this.wValidationMsg = new LabelTextVar(this.variables, (Composite)wOutputFields, BaseMessages.getString(PKG, (String)"XsdValidatorDialog.ValidationMsg.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XsdValidatorDialog.ValidationMsg.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wValidationMsg);
        this.wValidationMsg.addModifyListener(lsMod);
        FormData fdValidationMsg = new FormData();
        fdValidationMsg.left = new FormAttachment(0, 0);
        fdValidationMsg.top = new FormAttachment((Control)this.wAddValidationMsg, margin);
        fdValidationMsg.right = new FormAttachment(100, 0);
        this.wValidationMsg.setLayoutData((Object)fdValidationMsg);
        FormData fdOutputFields = new FormData();
        fdOutputFields.left = new FormAttachment(0, margin);
        fdOutputFields.top = new FormAttachment((Control)wXML, margin);
        fdOutputFields.right = new FormAttachment(100, -margin);
        wOutputFields.setLayoutData((Object)fdOutputFields);
        Group wXSD = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wXSD);
        wXSD.setText("XML Schema Definition");
        FormLayout groupXSD = new FormLayout();
        groupXSD.marginWidth = 10;
        groupXSD.marginHeight = 10;
        wXSD.setLayout((Layout)groupLayout);
        Label wlAllowExternalEntities = new Label((Composite)wXSD, 131072);
        wlAllowExternalEntities.setText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.AllowExternalEntities.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAllowExternalEntities);
        FormData fdlAllowExternalEntities = new FormData();
        fdlAllowExternalEntities.left = new FormAttachment(0, 0);
        fdlAllowExternalEntities.right = new FormAttachment(middle, -margin);
        fdlAllowExternalEntities.top = new FormAttachment((Control)this.wTransformName, margin);
        wlAllowExternalEntities.setLayoutData((Object)fdlAllowExternalEntities);
        this.wAllowExternalEntities = new Button((Composite)wXSD, 32);
        this.props.setLook((Control)this.wAllowExternalEntities);
        FormData fdAllowExternalEntities = new FormData();
        fdAllowExternalEntities.left = new FormAttachment(middle, margin);
        fdAllowExternalEntities.top = new FormAttachment((Control)wlAllowExternalEntities, 0, 0x1000000);
        fdAllowExternalEntities.right = new FormAttachment(100, -margin);
        this.wAllowExternalEntities.setLayoutData((Object)fdAllowExternalEntities);
        this.wAllowExternalEntities.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XsdValidatorDialog.this.input.setChanged();
            }
        });
        Label wlXSDSource = new Label((Composite)wXSD, 131072);
        wlXSDSource.setText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.XSDSource.Label", (String[])new String[0]));
        this.props.setLook((Control)wlXSDSource);
        FormData fdlXSDSource = new FormData();
        fdlXSDSource.left = new FormAttachment(0, 0);
        fdlXSDSource.top = new FormAttachment((Control)this.wAllowExternalEntities, margin);
        fdlXSDSource.right = new FormAttachment(middle, -margin);
        wlXSDSource.setLayoutData((Object)fdlXSDSource);
        this.wXSDSource = new CCombo((Composite)wXSD, 2056);
        this.wXSDSource.setEditable(true);
        this.props.setLook((Control)this.wXSDSource);
        this.wXSDSource.addModifyListener(lsMod);
        FormData fdXSDSource = new FormData();
        fdXSDSource.left = new FormAttachment(middle, margin);
        fdXSDSource.top = new FormAttachment((Control)this.wAllowExternalEntities, margin);
        fdXSDSource.right = new FormAttachment(100, -margin);
        this.wXSDSource.setLayoutData((Object)fdXSDSource);
        this.wXSDSource.add(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.XSDSource.IS_A_FILE", (String[])new String[0]));
        this.wXSDSource.add(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.XSDSource.IS_A_FIELD", (String[])new String[0]));
        this.wXSDSource.add(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.XSDSource.NO_NEED", (String[])new String[0]));
        this.wXSDSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XsdValidatorDialog.this.setXSDSource();
            }
        });
        this.wlFilename = new Label((Composite)wXSD, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.XSDFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)this.wXSDSource, margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)fdlFilename);
        this.wbbFilename = new Button((Composite)wXSD, 0x1000008);
        this.props.setLook((Control)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.FilenameBrowse.Button", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wXSDSource, margin);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wFilename = new TextVar(this.variables, (Composite)wXSD, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, margin);
        fdFilename.right = new FormAttachment((Control)this.wbbFilename, -margin);
        fdFilename.top = new FormAttachment((Control)this.wXSDSource, margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wlXSDDefinedColumn = new Label((Composite)wXSD, 131072);
        this.wlXSDDefinedColumn.setText(BaseMessages.getString(PKG, (String)"XsdValidatorDialog.XSDDefinedColumn.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlXSDDefinedColumn);
        FormData fdlXSDDefinedColumn = new FormData();
        fdlXSDDefinedColumn.left = new FormAttachment(0, 0);
        fdlXSDDefinedColumn.top = new FormAttachment((Control)this.wFilename, 2 * margin);
        fdlXSDDefinedColumn.right = new FormAttachment(middle, -margin);
        this.wlXSDDefinedColumn.setLayoutData((Object)fdlXSDDefinedColumn);
        this.wXSDDefinedColumn = new CCombo((Composite)wXSD, 2056);
        this.wXSDDefinedColumn.setEditable(true);
        this.props.setLook((Control)this.wXSDDefinedColumn);
        this.wXSDDefinedColumn.addModifyListener(lsMod);
        FormData fdXSDDefinedColumn = new FormData();
        fdXSDDefinedColumn.left = new FormAttachment(middle, margin);
        fdXSDDefinedColumn.top = new FormAttachment((Control)this.wFilename, 2 * margin);
        fdXSDDefinedColumn.right = new FormAttachment(100, -margin);
        this.wXSDDefinedColumn.setLayoutData((Object)fdXSDDefinedColumn);
        this.wXSDDefinedColumn.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)XsdValidatorDialog.this.shell.getDisplay(), 1);
                XsdValidatorDialog.this.shell.setCursor(busy);
                XsdValidatorDialog.this.PopulateFields();
                XsdValidatorDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        FormData fdXSD = new FormData();
        fdXSD.left = new FormAttachment(0, margin);
        fdXSD.top = new FormAttachment((Control)wOutputFields, margin);
        fdXSD.right = new FormAttachment(100, -margin);
        wXSD.setLayoutData((Object)fdXSD);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        this.props.setLook((Control)wGeneralComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.variables.resolve(this.wFilename.getText())));
        this.wbbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(XsdValidatorDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*xsd;*.XSD", "*"});
                if (XsdValidatorDialog.this.wFilename.getText() != null) {
                    String fname = XsdValidatorDialog.this.variables.resolve(XsdValidatorDialog.this.wFilename.getText());
                    dialog.setFileName(fname);
                }
                dialog.setFilterNames(new String[]{BaseMessages.getString((Class)PKG, (String)"XsdValidatorDialog.FileType", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                if (dialog.open() != null) {
                    String str = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                    XsdValidatorDialog.this.wFilename.setText(str);
                }
            }
        });
        wTabFolder.setSelection(0);
        this.getData();
        this.activateValidationMsg();
        this.activateOutputStringField();
        this.setXSDSource();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setXSDSource() {
        if (this.wXSDSource.getSelectionIndex() == 0) {
            this.wFilename.setEnabled(true);
            this.wlFilename.setEnabled(true);
            this.wbbFilename.setEnabled(true);
            this.wlXSDDefinedColumn.setEnabled(false);
            this.wXSDDefinedColumn.setEnabled(false);
        } else if (this.wXSDSource.getSelectionIndex() == 1) {
            this.wFilename.setEnabled(false);
            this.wlFilename.setEnabled(false);
            this.wbbFilename.setEnabled(false);
            this.wlXSDDefinedColumn.setEnabled(true);
            this.wXSDDefinedColumn.setEnabled(true);
        } else {
            this.wFilename.setEnabled(false);
            this.wlFilename.setEnabled(false);
            this.wbbFilename.setEnabled(false);
            this.wlXSDDefinedColumn.setEnabled(false);
            this.wXSDDefinedColumn.setEnabled(false);
        }
    }

    private void PopulateFields() {
        if (!this.gotPrevious) {
            this.gotPrevious = true;
            String fieldXML = this.wXMLStream.getText();
            String fieldXSD = this.wXSDDefinedColumn.getText();
            try {
                this.wXMLStream.removeAll();
                this.wXSDDefinedColumn.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wXMLStream.setItems(r.getFieldNames());
                    this.wXSDDefinedColumn.setItems(r.getFieldNames());
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"XsdValidatorDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XsdValidatorDialogMod.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            if (fieldXML != null) {
                this.wXMLStream.setText(fieldXML);
            }
            if (fieldXSD != null) {
                this.wXSDDefinedColumn.setText(fieldXSD);
            }
        }
    }

    public void getData() {
        if (this.input.getXSDFilename() != null) {
            this.wFilename.setText(this.input.getXSDFilename());
        }
        this.wXMLSourceFile.setSelection(this.input.getXMLSourceFile());
        if (this.input.getXMLStream() != null) {
            this.wXMLStream.setText(this.input.getXMLStream());
        }
        if (this.input.getXSDDefinedField() != null) {
            this.wXSDDefinedColumn.setText(this.input.getXSDDefinedField());
        }
        if (this.input.getResultfieldname() != null) {
            this.wResultField.setText(this.input.getResultfieldname());
        }
        this.wAddValidationMsg.setSelection(this.input.useAddValidationMessage());
        if (this.input.getValidationMessageField() != null) {
            this.wValidationMsg.setText(this.input.getValidationMessageField());
        } else {
            this.wValidationMsg.setText("ValidationMsgField");
        }
        this.wOutputStringField.setSelection(this.input.getOutputStringField());
        if (this.input.getIfXmlValid() != null) {
            this.wIfXMLValid.setText(this.input.getIfXmlValid());
        }
        if (this.input.getIfXmlInvalid() != null) {
            this.wIfXMLUnValid.setText(this.input.getIfXmlInvalid());
        }
        this.wAllowExternalEntities.setSelection(this.input.isAllowExternalEntities());
        if (this.input.getXSDSource() != null) {
            if (this.input.getXSDSource().equals(this.input.SPECIFY_FILENAME)) {
                this.wXSDSource.select(0);
            } else if (this.input.getXSDSource().equals(this.input.SPECIFY_FIELDNAME)) {
                this.wXSDSource.select(1);
            } else {
                this.wXSDSource.select(2);
            }
        } else {
            this.wXSDSource.select(0);
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void activateValidationMsg() {
        this.wValidationMsg.setEnabled(this.wAddValidationMsg.getSelection());
    }

    private void activateOutputStringField() {
        this.wIfXMLValid.setEnabled(this.wOutputStringField.getSelection());
        this.wIfXMLUnValid.setEnabled(this.wOutputStringField.getSelection());
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        this.transformName = this.wTransformName.getText();
        this.input.setXSDfilename(this.wFilename.getText());
        this.input.setResultfieldname(this.wResultField.getText());
        this.input.setXMLStream(this.wXMLStream.getText());
        this.input.setXSDDefinedField(this.wXSDDefinedColumn.getText());
        this.input.setOutputStringField(this.wOutputStringField.getSelection());
        this.input.setAddValidationMessage(this.wAddValidationMsg.getSelection());
        this.input.setValidationMessageField(this.wValidationMsg.getText());
        this.input.setIfXMLValid(this.wIfXMLValid.getText());
        this.input.setIfXmlInvalid(this.wIfXMLUnValid.getText());
        this.input.setXMLSourceFile(this.wXMLSourceFile.getSelection());
        this.input.setAllowExternalEntities(this.wAllowExternalEntities.getSelection());
        if (this.wXSDSource.getSelectionIndex() == 0) {
            this.input.setXSDSource(this.input.SPECIFY_FILENAME);
        } else if (this.wXSDSource.getSelectionIndex() == 1) {
            this.input.setXSDSource(this.input.SPECIFY_FIELDNAME);
        } else {
            this.input.setXSDSource(this.input.NO_NEED);
        }
        this.dispose();
    }
}

