/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xsdvalidator;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.xsdvalidator.XsdValidatorData;
import org.apache.hop.pipeline.transforms.xml.xsdvalidator.XsdValidatorMeta;
import org.xml.sax.SAXException;

public class XsdValidator
extends BaseTransform<XsdValidatorMeta, XsdValidatorData>
implements ITransform<XsdValidatorMeta, XsdValidatorData> {
    private static final Class<?> PKG = XsdValidatorMeta.class;
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public XsdValidator(TransformMeta transformMeta, XsdValidatorMeta meta, XsdValidatorData data, int copyNr, PipelineMeta pipelineMeta, Pipeline trans) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((XsdValidatorData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((XsdValidatorMeta)this.meta).getFields(((XsdValidatorData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            if (((XsdValidatorMeta)this.meta).getXMLStream() != null) {
                ((XsdValidatorData)this.data).xmlindex = this.getInputRowMeta().indexOfValue(((XsdValidatorMeta)this.meta).getXMLStream());
                if (((XsdValidatorData)this.data).xmlindex < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.ErrorFindingField", (String[])new String[0]) + "[" + ((XsdValidatorMeta)this.meta).getXMLStream() + "]");
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.CouldnotFindField", (String[])new String[]{((XsdValidatorMeta)this.meta).getXMLStream()}));
                }
                if (((XsdValidatorMeta)this.meta).getResultfieldname() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.ErrorResultFieldMissing", (String[])new String[0]));
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.ErrorResultFieldMissing", (String[])new String[0]));
                }
                if (((XsdValidatorMeta)this.meta).getXSDSource().equals(((XsdValidatorMeta)this.meta).SPECIFY_FILENAME)) {
                    if (((XsdValidatorMeta)this.meta).getXSDFilename() == null) {
                        this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.ErrorXSDFileMissing", (String[])new String[0]));
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.ErrorXSDFileMissing", (String[])new String[0]));
                    }
                    FileObject xsdfile = null;
                    try {
                        xsdfile = HopVfs.getFileObject((String)this.resolve(((XsdValidatorMeta)this.meta).getXSDFilename()));
                        if (!xsdfile.exists()) {
                            this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.Error.XSDFileNotExists", (String[])new String[0]));
                            throw new HopTransformException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.XSDFileNotExists", (String[])new String[0]));
                        }
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.Error.GettingXSDFile", (String[])new String[0]));
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.GettingXSDFile", (String[])new String[0]));
                    }
                    finally {
                        try {
                            if (xsdfile != null) {
                                xsdfile.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (((XsdValidatorMeta)this.meta).getXSDSource().equals(((XsdValidatorMeta)this.meta).SPECIFY_FIELDNAME)) {
                    if (((XsdValidatorMeta)this.meta).getXSDDefinedField() == null) {
                        this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.Error.XSDFieldMissing", (String[])new String[0]));
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.XSDFieldMissing", (String[])new String[0]));
                    }
                    ((XsdValidatorData)this.data).xsdindex = this.getInputRowMeta().indexOfValue(((XsdValidatorMeta)this.meta).getXSDDefinedField());
                    if (((XsdValidatorData)this.data).xsdindex < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.ErrorFindingXSDField", (String[])new String[]{((XsdValidatorMeta)this.meta).getXSDDefinedField()}));
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.ErrorFindingXSDField", (String[])new String[]{((XsdValidatorMeta)this.meta).getXSDDefinedField()}));
                    }
                }
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.Error.XmlStreamFieldMissing", (String[])new String[0]));
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.XmlStreamFieldMissing", (String[])new String[0]));
            }
        }
        try {
            String XMLFieldvalue = this.getInputRowMeta().getString(row, ((XsdValidatorData)this.data).xmlindex);
            boolean isvalid = false;
            String xsdfilename = null;
            if (((XsdValidatorMeta)this.meta).getXSDSource().equals(((XsdValidatorMeta)this.meta).SPECIFY_FILENAME)) {
                xsdfilename = this.resolve(((XsdValidatorMeta)this.meta).getXSDFilename());
            } else if (((XsdValidatorMeta)this.meta).getXSDSource().equals(((XsdValidatorMeta)this.meta).SPECIFY_FIELDNAME)) {
                xsdfilename = this.getInputRowMeta().getString(row, ((XsdValidatorData)this.data).xsdindex);
            }
            FileObject xsdfile = null;
            String validationmsg = null;
            try {
                SchemaFactory factoryXSDValidator = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                xsdfile = HopVfs.getFileObject((String)xsdfilename);
                StreamSource sourceXML = new StreamSource(new StringReader(XMLFieldvalue));
                if (((XsdValidatorMeta)this.meta).getXMLSourceFile()) {
                    FileObject xmlfileValidator = HopVfs.getFileObject((String)XMLFieldvalue);
                    if (xmlfileValidator == null || !xmlfileValidator.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.Error.XMLfileMissing", (String[])new String[]{XMLFieldvalue}));
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.XMLfileMissing", (String[])new String[]{XMLFieldvalue}));
                    }
                    sourceXML = new StreamSource(xmlfileValidator.getContent().getInputStream());
                }
                Schema SchematXSD = null;
                if (xsdfile instanceof AbstractFileObject) {
                    SchematXSD = xsdfile.getName().getURI().contains("ram:///") ? factoryXSDValidator.newSchema(new StreamSource(xsdfile.getContent().getInputStream())) : factoryXSDValidator.newSchema(new File(HopVfs.getFilename((FileObject)xsdfile)));
                } else {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.CannotCreateSchema", (String[])new String[]{xsdfile.getClass().getName()}));
                }
                if (((XsdValidatorMeta)this.meta).getXSDSource().equals(((XsdValidatorMeta)this.meta).NO_NEED)) {
                    SchematXSD = factoryXSDValidator.newSchema();
                }
                Validator xsdValidator = SchematXSD.newValidator();
                if (!((XsdValidatorMeta)this.meta).isAllowExternalEntities()) {
                    xsdValidator.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    xsdValidator.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    xsdValidator.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    xsdValidator.setProperty("http://apache.org/xml/properties/internal/entity-resolver", xmlResourceIdentifier -> {
                        String message = BaseMessages.getString(PKG, (String)"XsdValidator.Exception.DisallowedDocType", (String[])new String[0]);
                        throw new IOException(message);
                    });
                }
                xsdValidator.validate(sourceXML);
                isvalid = true;
            }
            catch (SAXException ex) {
                validationmsg = ex.getMessage();
            }
            catch (IOException ex) {
                validationmsg = ex.getMessage();
            }
            finally {
                try {
                    if (xsdfile != null) {
                        xsdfile.close();
                    }
                }
                catch (IOException ex) {}
            }
            Object[] outputRowData = null;
            Object[] outputRowData2 = null;
            outputRowData = ((XsdValidatorMeta)this.meta).getOutputStringField() ? (isvalid ? RowDataUtil.addValueData((Object[])row, (int)this.getInputRowMeta().size(), (Object)this.resolve(((XsdValidatorMeta)this.meta).getIfXmlValid())) : RowDataUtil.addValueData((Object[])row, (int)this.getInputRowMeta().size(), (Object)this.resolve(((XsdValidatorMeta)this.meta).getIfXmlInvalid()))) : RowDataUtil.addValueData((Object[])row, (int)this.getInputRowMeta().size(), (Object)isvalid);
            outputRowData2 = ((XsdValidatorMeta)this.meta).useAddValidationMessage() ? RowDataUtil.addValueData((Object[])outputRowData, (int)(this.getInputRowMeta().size() + 1), (Object)validationmsg) : outputRowData;
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"XsdValidator.Log.ReadRow", (String[])new String[0]) + " " + this.getInputRowMeta().getString(row));
            }
            this.putRow(((XsdValidatorData)this.data).outputRowMeta, outputRowData2);
        }
        catch (HopException e) {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (this.getTransformMeta().isDoingErrorHandling()) {
                sendToErrorRow = true;
                errorMessage = e.toString();
            }
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, null, "XSD001");
            }
            this.logError(BaseMessages.getString(PKG, (String)("XsdValidator.ErrorProcesing : " + e.getMessage()), (String[])new String[0]));
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"XsdValidator.ErrorProcesing", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    public boolean init() {
        return super.init();
    }

    public void dispose() {
        super.dispose();
    }
}

