/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xmloutput;

import java.io.File;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.xmloutput.XmlField;
import org.apache.hop.pipeline.transforms.xml.xmloutput.XmlOutputData;
import org.apache.hop.pipeline.transforms.xml.xmloutput.XmlOutputMeta;

public class XmlOutput
extends BaseTransform<XmlOutputMeta, XmlOutputData>
implements ITransform<XmlOutputMeta, XmlOutputData> {
    private static final String EOL = "\n";
    private static final XMLOutputFactory XML_OUT_FACTORY = XMLOutputFactory.newInstance();
    private OutputStream outputStream;

    public XmlOutput(TransformMeta transformMeta, XmlOutputMeta meta, XmlOutputData transformDataInterface, int copyNr, PipelineMeta pipelineMeta, Pipeline trans) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)transformDataInterface, copyNr, pipelineMeta, trans);
    }

    public boolean processRow() throws HopException {
        boolean result = true;
        Object[] r = this.getRow();
        if (this.first && ((XmlOutputMeta)this.meta).isDoNotOpenNewFileInit()) {
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.openNewFile()) {
                ((XmlOutputData)this.data).OpenedNewFile = true;
            } else {
                this.logError("Couldn't open file " + ((XmlOutputMeta)this.meta).getFileName());
                this.setErrors(1L);
                return false;
            }
        }
        if (r != null && this.getLinesOutput() > 0L && ((XmlOutputMeta)this.meta).getSplitEvery() > 0 && this.getLinesOutput() % (long)((XmlOutputMeta)this.meta).getSplitEvery() == 0L) {
            this.closeFile();
            if (r != null && !this.openNewFile()) {
                this.logError("Unable to open new file (split #" + ((XmlOutputData)this.data).splitnr + "...");
                this.setErrors(1L);
                return false;
            }
        }
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        this.writeRowToFile(this.getInputRowMeta(), r);
        ((XmlOutputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
        ((XmlOutputMeta)this.meta).getFields(((XmlOutputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        this.putRow(((XmlOutputData)this.data).outputRowMeta, r);
        if (this.checkFeedback(this.getLinesOutput())) {
            this.logBasic("linenr " + this.getLinesOutput());
        }
        return result;
    }

    private void writeRowToFile(IRowMeta rowMeta, Object[] r) throws HopException {
        try {
            IValueMeta valueMeta;
            int i;
            if (this.first) {
                ((XmlOutputData)this.data).formatRowMeta = rowMeta.clone();
                this.first = false;
                ((XmlOutputData)this.data).fieldnrs = new int[((XmlOutputMeta)this.meta).getOutputFields().length];
                for (i = 0; i < ((XmlOutputMeta)this.meta).getOutputFields().length; ++i) {
                    ((XmlOutputData)this.data).fieldnrs[i] = ((XmlOutputData)this.data).formatRowMeta.indexOfValue(((XmlOutputMeta)this.meta).getOutputFields()[i].getFieldName());
                    if (((XmlOutputData)this.data).fieldnrs[i] < 0) {
                        throw new HopException("Field [" + ((XmlOutputMeta)this.meta).getOutputFields()[i].getFieldName() + "] couldn't be found in the input stream!");
                    }
                    valueMeta = ((XmlOutputData)this.data).formatRowMeta.getValueMeta(((XmlOutputData)this.data).fieldnrs[i]);
                    XmlField field = ((XmlOutputMeta)this.meta).getOutputFields()[i];
                    valueMeta.setConversionMask(field.getFormat());
                    valueMeta.setLength(field.getLength(), field.getPrecision());
                    valueMeta.setDecimalSymbol(field.getDecimalSymbol());
                    valueMeta.setGroupingSymbol(field.getGroupingSymbol());
                    valueMeta.setCurrencySymbol(field.getCurrencySymbol());
                }
            }
            if (((XmlOutputMeta)this.meta).getOutputFields() == null || ((XmlOutputMeta)this.meta).getOutputFields().length == 0) {
                ((XmlOutputData)this.data).writer.writeStartElement(((XmlOutputMeta)this.meta).getRepeatElement());
                for (i = 0; i < ((XmlOutputData)this.data).formatRowMeta.size(); ++i) {
                    if (i > 0) {
                        ((XmlOutputData)this.data).writer.writeCharacters(" ");
                    }
                    valueMeta = ((XmlOutputData)this.data).formatRowMeta.getValueMeta(i);
                    Object valueData = r[i];
                    this.writeField(valueMeta, valueData, valueMeta.getName());
                }
            } else {
                ((XmlOutputData)this.data).writer.writeStartElement(((XmlOutputMeta)this.meta).getRepeatElement());
                this.writeRowAttributes(r);
                for (i = 0; i < ((XmlOutputMeta)this.meta).getOutputFields().length; ++i) {
                    XmlField outputField = ((XmlOutputMeta)this.meta).getOutputFields()[i];
                    if (outputField.getContentType() != XmlField.ContentType.Element) continue;
                    if (i > 0) {
                        ((XmlOutputData)this.data).writer.writeCharacters(" ");
                    }
                    IValueMeta valueMeta2 = ((XmlOutputData)this.data).formatRowMeta.getValueMeta(((XmlOutputData)this.data).fieldnrs[i]);
                    Object valueData = r[((XmlOutputData)this.data).fieldnrs[i]];
                    String elementName = outputField.getElementName();
                    if (Utils.isEmpty((CharSequence)elementName)) {
                        elementName = outputField.getFieldName();
                    }
                    if (valueMeta2.isNull(valueData) && ((XmlOutputMeta)this.meta).isOmitNullValues()) continue;
                    this.writeField(valueMeta2, valueData, elementName);
                }
            }
            ((XmlOutputData)this.data).writer.writeEndElement();
            ((XmlOutputData)this.data).writer.writeCharacters(EOL);
        }
        catch (Exception e) {
            throw new HopException("Error writing XML row :" + e.toString() + Const.CR + "Row: " + this.getInputRowMeta().getString(r), (Throwable)e);
        }
        this.incrementLinesOutput();
    }

    void writeRowAttributes(Object[] r) throws HopValueException, XMLStreamException {
        for (int i = 0; i < ((XmlOutputMeta)this.meta).getOutputFields().length; ++i) {
            XmlField xmlField = ((XmlOutputMeta)this.meta).getOutputFields()[i];
            if (xmlField.getContentType() != XmlField.ContentType.Attribute) continue;
            IValueMeta valueMeta = ((XmlOutputData)this.data).formatRowMeta.getValueMeta(((XmlOutputData)this.data).fieldnrs[i]);
            Object valueData = r[((XmlOutputData)this.data).fieldnrs[i]];
            String elementName = xmlField.getElementName();
            if (Utils.isEmpty((CharSequence)elementName)) {
                elementName = xmlField.getFieldName();
            }
            if (valueData != null) {
                ((XmlOutputData)this.data).writer.writeAttribute(elementName, valueMeta.getString(valueData));
                continue;
            }
            if (!this.isNullValueAllowed(valueMeta.getType())) continue;
            ((XmlOutputData)this.data).writer.writeAttribute(elementName, "null");
        }
    }

    private boolean isNullValueAllowed(int valueMetaType) {
        String val = this.getVariable("HOP_COMPATIBILITY_XML_OUTPUT_NULL_VALUES", "N");
        return ValueMetaBase.convertStringToBoolean((String)Const.NVL((String)val, (String)"N")) != false && valueMetaType == 2;
    }

    private void writeField(IValueMeta valueMeta, Object valueData, String element) throws HopTransformException {
        try {
            String value = valueMeta.getString(valueData);
            if (value != null) {
                ((XmlOutputData)this.data).writer.writeStartElement(element);
                ((XmlOutputData)this.data).writer.writeCharacters(value);
                ((XmlOutputData)this.data).writer.writeEndElement();
            } else {
                ((XmlOutputData)this.data).writer.writeEmptyElement(element);
            }
        }
        catch (Exception e) {
            throw new HopTransformException("Error writing line :", (Throwable)e);
        }
    }

    public String buildFilename(boolean ziparchive) {
        return ((XmlOutputMeta)this.meta).buildFilename((IVariables)this, this.getCopy(), ((XmlOutputData)this.data).splitnr, ziparchive);
    }

    public boolean openNewFile() {
        boolean retval = false;
        ((XmlOutputData)this.data).writer = null;
        try {
            FileObject file = HopVfs.getFileObject((String)this.buildFilename(true));
            if (((XmlOutputMeta)this.meta).isAddToResultFiles()) {
                ResultFile resultFile = new ResultFile(0, file, this.getPipelineMeta().getName(), this.getTransformName());
                resultFile.setComment("This file was created with a xml output transform");
                this.addResultFile(resultFile);
            }
            if (((XmlOutputMeta)this.meta).isZipped()) {
                OutputStream fos = HopVfs.getOutputStream((FileObject)file, (boolean)false);
                ((XmlOutputData)this.data).zip = new ZipOutputStream(fos);
                File entry = new File(this.buildFilename(false));
                ZipEntry zipentry = new ZipEntry(entry.getName());
                zipentry.setComment("Compressed by Apache Hop");
                ((XmlOutputData)this.data).zip.putNextEntry(zipentry);
                this.outputStream = ((XmlOutputData)this.data).zip;
            } else {
                this.outputStream = HopVfs.getOutputStream((FileObject)file, (boolean)false);
            }
            if (((XmlOutputMeta)this.meta).getEncoding() != null && ((XmlOutputMeta)this.meta).getEncoding().length() > 0) {
                this.logBasic("Opening output stream in encoding: " + ((XmlOutputMeta)this.meta).getEncoding());
                ((XmlOutputData)this.data).writer = XML_OUT_FACTORY.createXMLStreamWriter(this.outputStream, ((XmlOutputMeta)this.meta).getEncoding());
                ((XmlOutputData)this.data).writer.writeStartDocument(((XmlOutputMeta)this.meta).getEncoding(), "1.0");
            } else {
                this.logBasic("Opening output stream in default encoding : UTF-8");
                ((XmlOutputData)this.data).writer = XML_OUT_FACTORY.createXMLStreamWriter(this.outputStream);
                ((XmlOutputData)this.data).writer.writeStartDocument("UTF-8", "1.0");
            }
            ((XmlOutputData)this.data).writer.writeCharacters(EOL);
            ((XmlOutputData)this.data).writer.writeStartElement(((XmlOutputMeta)this.meta).getMainElement());
            if (((XmlOutputMeta)this.meta).getNameSpace() != null && !"".equals(((XmlOutputMeta)this.meta).getNameSpace())) {
                ((XmlOutputData)this.data).writer.writeDefaultNamespace(((XmlOutputMeta)this.meta).getNameSpace());
            }
            ((XmlOutputData)this.data).writer.writeCharacters(EOL);
            retval = true;
        }
        catch (Exception e) {
            this.logError("Error opening new file : " + e.toString());
        }
        ++((XmlOutputData)this.data).splitnr;
        return retval;
    }

    void closeOutputStream(OutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception e) {
            this.logError("Error closing output stream : " + e.toString());
        }
    }

    private boolean closeFile() {
        boolean retval = false;
        if (((XmlOutputData)this.data).OpenedNewFile) {
            try {
                ((XmlOutputData)this.data).writer.writeEndElement();
                ((XmlOutputData)this.data).writer.writeCharacters(EOL);
                ((XmlOutputData)this.data).writer.writeEndDocument();
                ((XmlOutputData)this.data).writer.close();
                if (((XmlOutputMeta)this.meta).isZipped()) {
                    ((XmlOutputData)this.data).zip.closeEntry();
                    ((XmlOutputData)this.data).zip.finish();
                    ((XmlOutputData)this.data).zip.close();
                }
                this.closeOutputStream(this.outputStream);
                retval = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public boolean init() {
        if (super.init()) {
            ((XmlOutputData)this.data).splitnr = 0;
            if (!((XmlOutputMeta)this.meta).isDoNotOpenNewFileInit()) {
                if (this.openNewFile()) {
                    ((XmlOutputData)this.data).OpenedNewFile = true;
                    return true;
                }
                this.logError("Couldn't open file " + ((XmlOutputMeta)this.meta).getFileName());
                this.setErrors(1L);
                this.stopAll();
            } else {
                return true;
            }
        }
        return false;
    }

    public void dispose() {
        this.closeFile();
        super.dispose();
    }
}

