/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xmlinputstream;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.xmlinputstream.XmlInputStream;
import org.apache.hop.pipeline.transforms.xml.xmlinputstream.XmlInputStreamData;
import org.w3c.dom.Node;

@Transform(id="XMLInputStream", image="xml_input_stream.svg", name="i18n::XMLInputStream.name", description="i18n::XMLInputStream.description", categoryDescription="i18n::XMLInputStream.category", documentationUrl="/pipeline/transforms/xmlinputstream.html")
public class XmlInputStreamMeta
extends BaseTransformMeta
implements ITransformMeta<XmlInputStream, XmlInputStreamData> {
    private static final int DEFAULT_STRING_LEN_FILENAME = 256;
    private static final int DEFAULT_STRING_LEN_PATH = 1024;
    public static final String DEFAULT_STRING_LEN = "1024";
    public static final String DEFAULT_ENCODING = "UTF-8";
    private String filename;
    private boolean addResultFile;
    private String nrRowsToSkip;
    private String rowLimit;
    private String defaultStringLen;
    private String encoding;
    private boolean enableNamespaces;
    private boolean enableTrim;
    private boolean includeFilenameField;
    private String filenameField;
    private boolean includeRowNumberField;
    private String rowNumberField;
    private boolean includeXmlDataTypeNumericField;
    private String xmlDataTypeNumericField;
    private boolean includeXmlDataTypeDescriptionField;
    private String xmlDataTypeDescriptionField;
    private boolean includeXmlLocationLineField;
    private String xmlLocationLineField;
    private boolean includeXmlLocationColumnField;
    private String xmlLocationColumnField;
    private boolean includeXmlElementIDField;
    private String xmlElementIDField;
    private boolean includeXmlParentElementIDField;
    private String xmlParentElementIDField;
    private boolean includeXmlElementLevelField;
    private String xmlElementLevelField;
    private boolean includeXmlPathField;
    private String xmlPathField;
    private boolean includeXmlParentPathField;
    private String xmlParentPathField;
    private boolean includeXmlDataNameField;
    private String xmlDataNameField;
    private boolean includeXmlDataValueField;
    private String xmlDataValueField;
    public boolean sourceFromInput;
    public String sourceFieldName;

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValueMetaString v;
        int defaultStringLenNameValueElements = Const.toInt((String)variables.resolve(this.defaultStringLen), (int)Integer.valueOf(DEFAULT_STRING_LEN));
        if (this.includeFilenameField) {
            v = new ValueMetaString(variables.resolve(this.filenameField));
            v.setLength(256);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeRowNumberField) {
            v = new ValueMetaInteger(variables.resolve(this.rowNumberField));
            v.setLength(10);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeXmlDataTypeNumericField) {
            ValueMetaInteger vdtn = new ValueMetaInteger(variables.resolve(this.xmlDataTypeNumericField));
            vdtn.setLength(10);
            vdtn.setOrigin(name);
            r.addValueMeta((IValueMeta)vdtn);
        }
        if (this.includeXmlDataTypeDescriptionField) {
            ValueMetaString vdtd = new ValueMetaString(variables.resolve(this.xmlDataTypeDescriptionField));
            vdtd.setLength(25);
            vdtd.setOrigin(name);
            r.addValueMeta((IValueMeta)vdtd);
        }
        if (this.includeXmlLocationLineField) {
            ValueMetaInteger vline = new ValueMetaInteger(variables.resolve(this.xmlLocationLineField));
            vline.setLength(10);
            vline.setOrigin(name);
            r.addValueMeta((IValueMeta)vline);
        }
        if (this.includeXmlLocationColumnField) {
            ValueMetaInteger vcol = new ValueMetaInteger(variables.resolve(this.xmlLocationColumnField));
            vcol.setLength(10);
            vcol.setOrigin(name);
            r.addValueMeta((IValueMeta)vcol);
        }
        if (this.includeXmlElementIDField) {
            ValueMetaInteger vdid = new ValueMetaInteger("xml_element_id");
            vdid.setLength(10);
            vdid.setOrigin(name);
            r.addValueMeta((IValueMeta)vdid);
        }
        if (this.includeXmlParentElementIDField) {
            ValueMetaInteger vdparentid = new ValueMetaInteger("xml_parent_element_id");
            vdparentid.setLength(10);
            vdparentid.setOrigin(name);
            r.addValueMeta((IValueMeta)vdparentid);
        }
        if (this.includeXmlElementLevelField) {
            ValueMetaInteger vdlevel = new ValueMetaInteger("xml_element_level");
            vdlevel.setLength(10);
            vdlevel.setOrigin(name);
            r.addValueMeta((IValueMeta)vdlevel);
        }
        if (this.includeXmlPathField) {
            ValueMetaString vdparentxp = new ValueMetaString("xml_path");
            vdparentxp.setLength(1024);
            vdparentxp.setOrigin(name);
            r.addValueMeta((IValueMeta)vdparentxp);
        }
        if (this.includeXmlParentPathField) {
            ValueMetaString vdparentpxp = new ValueMetaString("xml_parent_path");
            vdparentpxp.setLength(1024);
            vdparentpxp.setOrigin(name);
            r.addValueMeta((IValueMeta)vdparentpxp);
        }
        if (this.includeXmlDataNameField) {
            ValueMetaString vdname = new ValueMetaString("xml_data_name");
            vdname.setLength(defaultStringLenNameValueElements);
            vdname.setOrigin(name);
            r.addValueMeta((IValueMeta)vdname);
        }
        if (this.includeXmlDataValueField) {
            ValueMetaString vdval = new ValueMetaString("xml_data_value");
            vdval.setLength(defaultStringLenNameValueElements);
            vdval.setOrigin(name);
            r.addValueMeta((IValueMeta)vdval);
        }
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.sourceFromInput = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"sourceFromInput"));
            this.sourceFieldName = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"sourceFieldName"), (String)"");
            this.filename = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"filename"), (String)"");
            this.addResultFile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"addResultFile"));
            this.nrRowsToSkip = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"nrRowsToSkip"), (String)"0");
            this.rowLimit = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"rowLimit"), (String)"0");
            this.defaultStringLen = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"defaultStringLen"), (String)DEFAULT_STRING_LEN);
            this.encoding = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"encoding"), (String)DEFAULT_ENCODING);
            this.enableNamespaces = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"enableNamespaces"));
            this.enableTrim = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"enableTrim"));
            this.includeFilenameField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeFilenameField"));
            this.filenameField = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"filenameField"), (String)this.filenameField);
            this.includeRowNumberField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeRowNumberField"));
            this.rowNumberField = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"rowNumberField"), (String)this.rowNumberField);
            this.includeXmlDataTypeNumericField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeDataTypeNumericField"));
            this.xmlDataTypeNumericField = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"dataTypeNumericField"), (String)this.xmlDataTypeNumericField);
            this.includeXmlDataTypeDescriptionField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeDataTypeDescriptionField"));
            this.xmlDataTypeDescriptionField = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"dataTypeDescriptionField"), (String)this.xmlDataTypeDescriptionField);
            this.includeXmlLocationLineField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeXmlLocationLineField"));
            this.xmlLocationLineField = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"xmlLocationLineField"), (String)this.xmlLocationLineField);
            this.includeXmlLocationColumnField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeXmlLocationColumnField"));
            this.xmlLocationColumnField = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"xmlLocationColumnField"), (String)this.xmlLocationColumnField);
            this.includeXmlElementIDField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeXmlElementIDField"));
            this.xmlElementIDField = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"xmlElementIDField"), (String)this.xmlElementIDField);
            this.includeXmlParentElementIDField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeXmlParentElementIDField"));
            this.xmlParentElementIDField = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"xmlParentElementIDField"), (String)this.xmlParentElementIDField);
            this.includeXmlElementLevelField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeXmlElementLevelField"));
            this.xmlElementLevelField = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"xmlElementLevelField"), (String)this.xmlElementLevelField);
            this.includeXmlPathField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeXmlPathField"));
            this.xmlPathField = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"xmlPathField"), (String)this.xmlPathField);
            this.includeXmlParentPathField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeXmlParentPathField"));
            this.xmlParentPathField = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"xmlParentPathField"), (String)this.xmlParentPathField);
            this.includeXmlDataNameField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeXmlDataNameField"));
            this.xmlDataNameField = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"xmlDataNameField"), (String)this.xmlDataNameField);
            this.includeXmlDataValueField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeXmlDataValueField"));
            this.xmlDataValueField = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"xmlDataValueField"), (String)this.xmlDataValueField);
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public Object clone() {
        XmlInputStreamMeta retval = (XmlInputStreamMeta)((Object)super.clone());
        return retval;
    }

    public ITransform createTransform(TransformMeta transformMeta, XmlInputStreamData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new XmlInputStream(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public XmlInputStreamData getTransformData() {
        return new XmlInputStreamData();
    }

    public String getXml() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XmlHandler.addTagValue((String)"sourceFromInput", (boolean)this.sourceFromInput));
        retval.append("    " + XmlHandler.addTagValue((String)"sourceFieldName", (String)this.sourceFieldName));
        retval.append("    " + XmlHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("    " + XmlHandler.addTagValue((String)"addResultFile", (boolean)this.addResultFile));
        retval.append("    " + XmlHandler.addTagValue((String)"nrRowsToSkip", (String)this.nrRowsToSkip));
        retval.append("    " + XmlHandler.addTagValue((String)"rowLimit", (String)this.rowLimit));
        retval.append("    " + XmlHandler.addTagValue((String)"defaultStringLen", (String)this.defaultStringLen));
        retval.append("    " + XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XmlHandler.addTagValue((String)"enableNamespaces", (boolean)this.enableNamespaces));
        retval.append("    " + XmlHandler.addTagValue((String)"enableTrim", (boolean)this.enableTrim));
        retval.append("    " + XmlHandler.addTagValue((String)"includeFilenameField", (boolean)this.includeFilenameField));
        retval.append("    " + XmlHandler.addTagValue((String)"filenameField", (String)this.filenameField));
        retval.append("    " + XmlHandler.addTagValue((String)"includeRowNumberField", (boolean)this.includeRowNumberField));
        retval.append("    " + XmlHandler.addTagValue((String)"rowNumberField", (String)this.rowNumberField));
        retval.append("    " + XmlHandler.addTagValue((String)"includeDataTypeNumericField", (boolean)this.includeXmlDataTypeNumericField));
        retval.append("    " + XmlHandler.addTagValue((String)"dataTypeNumericField", (String)this.xmlDataTypeNumericField));
        retval.append("    " + XmlHandler.addTagValue((String)"includeDataTypeDescriptionField", (boolean)this.includeXmlDataTypeDescriptionField));
        retval.append("    " + XmlHandler.addTagValue((String)"dataTypeDescriptionField", (String)this.xmlDataTypeDescriptionField));
        retval.append("    " + XmlHandler.addTagValue((String)"includeXmlLocationLineField", (boolean)this.includeXmlLocationLineField));
        retval.append("    " + XmlHandler.addTagValue((String)"xmlLocationLineField", (String)this.xmlLocationLineField));
        retval.append("    " + XmlHandler.addTagValue((String)"includeXmlLocationColumnField", (boolean)this.includeXmlLocationColumnField));
        retval.append("    " + XmlHandler.addTagValue((String)"xmlLocationColumnField", (String)this.xmlLocationColumnField));
        retval.append("    " + XmlHandler.addTagValue((String)"includeXmlElementIDField", (boolean)this.includeXmlElementIDField));
        retval.append("    " + XmlHandler.addTagValue((String)"xmlElementIDField", (String)this.xmlElementIDField));
        retval.append("    " + XmlHandler.addTagValue((String)"includeXmlParentElementIDField", (boolean)this.includeXmlParentElementIDField));
        retval.append("    " + XmlHandler.addTagValue((String)"xmlParentElementIDField", (String)this.xmlParentElementIDField));
        retval.append("    " + XmlHandler.addTagValue((String)"includeXmlElementLevelField", (boolean)this.includeXmlElementLevelField));
        retval.append("    " + XmlHandler.addTagValue((String)"xmlElementLevelField", (String)this.xmlElementLevelField));
        retval.append("    " + XmlHandler.addTagValue((String)"includeXmlPathField", (boolean)this.includeXmlPathField));
        retval.append("    " + XmlHandler.addTagValue((String)"xmlPathField", (String)this.xmlPathField));
        retval.append("    " + XmlHandler.addTagValue((String)"includeXmlParentPathField", (boolean)this.includeXmlParentPathField));
        retval.append("    " + XmlHandler.addTagValue((String)"xmlParentPathField", (String)this.xmlParentPathField));
        retval.append("    " + XmlHandler.addTagValue((String)"includeXmlDataNameField", (boolean)this.includeXmlDataNameField));
        retval.append("    " + XmlHandler.addTagValue((String)"xmlDataNameField", (String)this.xmlDataNameField));
        retval.append("    " + XmlHandler.addTagValue((String)"includeXmlDataValueField", (boolean)this.includeXmlDataValueField));
        retval.append("    " + XmlHandler.addTagValue((String)"xmlDataValueField", (String)this.xmlDataValueField));
        return retval.toString();
    }

    public void setDefault() {
        this.filename = "";
        this.addResultFile = false;
        this.nrRowsToSkip = "0";
        this.rowLimit = "0";
        this.defaultStringLen = DEFAULT_STRING_LEN;
        this.encoding = DEFAULT_ENCODING;
        this.enableNamespaces = false;
        this.enableTrim = true;
        this.includeFilenameField = false;
        this.filenameField = "xml_filename";
        this.includeRowNumberField = false;
        this.rowNumberField = "xml_row_number";
        this.includeXmlDataTypeNumericField = false;
        this.xmlDataTypeNumericField = "xml_data_type_numeric";
        this.includeXmlDataTypeDescriptionField = true;
        this.xmlDataTypeDescriptionField = "xml_data_type_description";
        this.includeXmlLocationLineField = false;
        this.xmlLocationLineField = "xml_location_line";
        this.includeXmlLocationColumnField = false;
        this.xmlLocationColumnField = "xml_location_column";
        this.includeXmlElementIDField = true;
        this.xmlElementIDField = "xml_element_id";
        this.includeXmlParentElementIDField = true;
        this.xmlParentElementIDField = "xml_parent_element_id";
        this.includeXmlElementLevelField = true;
        this.xmlElementLevelField = "xml_element_level";
        this.includeXmlPathField = true;
        this.xmlPathField = "xml_path";
        this.includeXmlParentPathField = true;
        this.xmlParentPathField = "xml_parent_path";
        this.includeXmlDataNameField = true;
        this.xmlDataNameField = "xml_data_name";
        this.includeXmlDataValueField = true;
        this.xmlDataValueField = "xml_data_value";
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = Utils.isEmpty((CharSequence)this.filename) ? new CheckResult(4, "Filename is not given", (ICheckResultSource)transformMeta) : new CheckResult(1, "Filename is given", (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (pipelineMeta.findPreviousTransforms(transformMeta).size() > 0) {
            try {
                IRowMeta previousFields = pipelineMeta.getPrevTransformFields(variables, transformMeta);
                cr = null == previousFields.searchValueMeta(this.filename) ? new CheckResult(4, "Field name is not in previous transform", (ICheckResultSource)transformMeta) : new CheckResult(1, "Field name is in previous transform", (ICheckResultSource)transformMeta);
            }
            catch (HopTransformException e) {
                cr = new CheckResult(4, "Could not find previous transform", (ICheckResultSource)transformMeta);
            }
            remarks.add((ICheckResult)cr);
        }
        cr = this.includeXmlDataTypeNumericField || this.includeXmlDataTypeDescriptionField ? new CheckResult(2, "At least one Data Type field (numeric or description) is in the data stream", (ICheckResultSource)transformMeta) : new CheckResult(3, "Data Type field (numeric or description) is missing in the data stream", (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = this.includeXmlDataValueField && this.includeXmlDataNameField ? new CheckResult(2, "Data Name and Data Value fields are in the data stream", (ICheckResultSource)transformMeta) : new CheckResult(3, "Both Data Name and Data Value fields should be in the data stream", (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isAddResultFile() {
        return this.addResultFile;
    }

    public void setAddResultFile(boolean addResultFile) {
        this.addResultFile = addResultFile;
    }

    public String getNrRowsToSkip() {
        return this.nrRowsToSkip;
    }

    public void setNrRowsToSkip(String nrRowsToSkip) {
        this.nrRowsToSkip = nrRowsToSkip;
    }

    public String getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getDefaultStringLen() {
        return this.defaultStringLen;
    }

    public void setDefaultStringLen(String defaultStringLen) {
        this.defaultStringLen = defaultStringLen;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isEnableNamespaces() {
        return this.enableNamespaces;
    }

    public void setEnableNamespaces(boolean enableNamespaces) {
        this.enableNamespaces = enableNamespaces;
    }

    public boolean isEnableTrim() {
        return this.enableTrim;
    }

    public void setEnableTrim(boolean enableTrim) {
        this.enableTrim = enableTrim;
    }

    public boolean isIncludeFilenameField() {
        return this.includeFilenameField;
    }

    public void setIncludeFilenameField(boolean includeFilenameField) {
        this.includeFilenameField = includeFilenameField;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean isIncludeRowNumberField() {
        return this.includeRowNumberField;
    }

    public void setIncludeRowNumberField(boolean includeRowNumberField) {
        this.includeRowNumberField = includeRowNumberField;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public boolean isIncludeXmlDataTypeNumericField() {
        return this.includeXmlDataTypeNumericField;
    }

    public void setIncludeXmlDataTypeNumericField(boolean includeXmlDataTypeNumericField) {
        this.includeXmlDataTypeNumericField = includeXmlDataTypeNumericField;
    }

    public String getXmlDataTypeNumericField() {
        return this.xmlDataTypeNumericField;
    }

    public void setXmlDataTypeNumericField(String xmlDataTypeNumericField) {
        this.xmlDataTypeNumericField = xmlDataTypeNumericField;
    }

    public boolean isIncludeXmlDataTypeDescriptionField() {
        return this.includeXmlDataTypeDescriptionField;
    }

    public void setIncludeXmlDataTypeDescriptionField(boolean includeXmlDataTypeDescriptionField) {
        this.includeXmlDataTypeDescriptionField = includeXmlDataTypeDescriptionField;
    }

    public String getXmlDataTypeDescriptionField() {
        return this.xmlDataTypeDescriptionField;
    }

    public void setXmlDataTypeDescriptionField(String xmlDataTypeDescriptionField) {
        this.xmlDataTypeDescriptionField = xmlDataTypeDescriptionField;
    }

    public boolean isIncludeXmlLocationLineField() {
        return this.includeXmlLocationLineField;
    }

    public void setIncludeXmlLocationLineField(boolean includeXmlLocationLineField) {
        this.includeXmlLocationLineField = includeXmlLocationLineField;
    }

    public String getXmlLocationLineField() {
        return this.xmlLocationLineField;
    }

    public void setXmlLocationLineField(String xmlLocationLineField) {
        this.xmlLocationLineField = xmlLocationLineField;
    }

    public boolean isIncludeXmlLocationColumnField() {
        return this.includeXmlLocationColumnField;
    }

    public void setIncludeXmlLocationColumnField(boolean includeXmlLocationColumnField) {
        this.includeXmlLocationColumnField = includeXmlLocationColumnField;
    }

    public String getXmlLocationColumnField() {
        return this.xmlLocationColumnField;
    }

    public void setXmlLocationColumnField(String xmlLocationColumnField) {
        this.xmlLocationColumnField = xmlLocationColumnField;
    }

    public boolean isIncludeXmlElementIDField() {
        return this.includeXmlElementIDField;
    }

    public void setIncludeXmlElementIDField(boolean includeXmlElementIDField) {
        this.includeXmlElementIDField = includeXmlElementIDField;
    }

    public String getXmlElementIDField() {
        return this.xmlElementIDField;
    }

    public void setXmlElementIDField(String xmlElementIDField) {
        this.xmlElementIDField = xmlElementIDField;
    }

    public boolean isIncludeXmlParentElementIDField() {
        return this.includeXmlParentElementIDField;
    }

    public void setIncludeXmlParentElementIDField(boolean includeXmlParentElementIDField) {
        this.includeXmlParentElementIDField = includeXmlParentElementIDField;
    }

    public String getXmlParentElementIDField() {
        return this.xmlParentElementIDField;
    }

    public void setXmlParentElementIDField(String xmlParentElementIDField) {
        this.xmlParentElementIDField = xmlParentElementIDField;
    }

    public boolean isIncludeXmlElementLevelField() {
        return this.includeXmlElementLevelField;
    }

    public void setIncludeXmlElementLevelField(boolean includeXmlElementLevelField) {
        this.includeXmlElementLevelField = includeXmlElementLevelField;
    }

    public String getXmlElementLevelField() {
        return this.xmlElementLevelField;
    }

    public void setXmlElementLevelField(String xmlElementLevelField) {
        this.xmlElementLevelField = xmlElementLevelField;
    }

    public boolean isIncludeXmlPathField() {
        return this.includeXmlPathField;
    }

    public void setIncludeXmlPathField(boolean includeXmlPathField) {
        this.includeXmlPathField = includeXmlPathField;
    }

    public String getXmlPathField() {
        return this.xmlPathField;
    }

    public void setXmlPathField(String xmlPathField) {
        this.xmlPathField = xmlPathField;
    }

    public boolean isIncludeXmlParentPathField() {
        return this.includeXmlParentPathField;
    }

    public void setIncludeXmlParentPathField(boolean includeXmlParentPathField) {
        this.includeXmlParentPathField = includeXmlParentPathField;
    }

    public String getXmlParentPathField() {
        return this.xmlParentPathField;
    }

    public void setXmlParentPathField(String xmlParentPathField) {
        this.xmlParentPathField = xmlParentPathField;
    }

    public boolean isIncludeXmlDataNameField() {
        return this.includeXmlDataNameField;
    }

    public void setIncludeXmlDataNameField(boolean includeXmlDataNameField) {
        this.includeXmlDataNameField = includeXmlDataNameField;
    }

    public String getXmlDataNameField() {
        return this.xmlDataNameField;
    }

    public void setXmlDataNameField(String xmlDataNameField) {
        this.xmlDataNameField = xmlDataNameField;
    }

    public boolean isIncludeXmlDataValueField() {
        return this.includeXmlDataValueField;
    }

    public void setIncludeXmlDataValueField(boolean includeXmlDataValueField) {
        this.includeXmlDataValueField = includeXmlDataValueField;
    }

    public String getXmlDataValueField() {
        return this.xmlDataValueField;
    }

    public void setXmlDataValueField(String xmlDataValueField) {
        this.xmlDataValueField = xmlDataValueField;
    }
}

