/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.getxmldata;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.xml.getxmldata.GetXmlDataMeta;
import org.w3c.dom.Node;

public class GetXmlDataField
implements Cloneable {
    private static final Class<?> PKG = GetXmlDataMeta.class;
    public static final int RESULT_TYPE_VALUE_OF = 0;
    public static final int RESULT_TYPE_TYPE_SINGLE_NODE = 1;
    public static final String[] ResultTypeCode = new String[]{"valueof", "singlenode"};
    public static final String[] ResultTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"GetXMLDataField.ResultType.ValueOf", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDataField.ResultType.SingleNode", (String[])new String[0])};
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final int ELEMENT_TYPE_NODE = 0;
    public static final int ELEMENT_TYPE_ATTRIBUT = 1;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"GetXMLDataField.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDataField.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDataField.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDataField.TrimType.Both", (String[])new String[0])};
    public static final String[] ElementTypeCode = new String[]{"node", "attribute"};
    public static final String[] ElementOldTypeCode = new String[]{"node", "attribut"};
    public static final String[] ElementTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"GetXMLDataField.ElementType.Node", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDataField.ElementType.Attribute", (String[])new String[0])};
    private String name;
    private String xpath;
    private String resolvedXpath;
    private int type;
    private int length;
    private String format;
    private int trimtype;
    private int elementtype;
    private int resulttype;
    private int precision;
    private String currencySymbol;
    private String decimalSymbol;
    private String groupSymbol;
    private boolean repeat;

    public GetXmlDataField(String fieldname) {
        this.name = fieldname;
        this.xpath = "";
        this.length = -1;
        this.type = 2;
        this.format = "";
        this.trimtype = 0;
        this.elementtype = 0;
        this.resulttype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeat = false;
    }

    public GetXmlDataField() {
        this("");
    }

    public String getXml() {
        StringBuffer xml = new StringBuffer(400);
        xml.append("      <field>").append(Const.CR);
        xml.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.getName()));
        xml.append("        ").append(XmlHandler.addTagValue((String)"xpath", (String)this.getXPath()));
        xml.append("        ").append(XmlHandler.addTagValue((String)"element_type", (String)this.getElementTypeCode()));
        xml.append("        ").append(XmlHandler.addTagValue((String)"result_type", (String)this.getResultTypeCode()));
        xml.append("        ").append(XmlHandler.addTagValue((String)"type", (String)this.getTypeDesc()));
        xml.append("        ").append(XmlHandler.addTagValue((String)"format", (String)this.getFormat()));
        xml.append("        ").append(XmlHandler.addTagValue((String)"currency", (String)this.getCurrencySymbol()));
        xml.append("        ").append(XmlHandler.addTagValue((String)"decimal", (String)this.getDecimalSymbol()));
        xml.append("        ").append(XmlHandler.addTagValue((String)"group", (String)this.getGroupSymbol()));
        xml.append("        ").append(XmlHandler.addTagValue((String)"length", (int)this.getLength()));
        xml.append("        ").append(XmlHandler.addTagValue((String)"precision", (int)this.getPrecision()));
        xml.append("        ").append(XmlHandler.addTagValue((String)"trim_type", (String)this.getTrimTypeCode()));
        xml.append("        ").append(XmlHandler.addTagValue((String)"repeat", (boolean)this.isRepeated()));
        xml.append("      </field>").append(Const.CR);
        return xml.toString();
    }

    public GetXmlDataField(Node fnode) throws HopValueException {
        this.setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
        this.setXPath(XmlHandler.getTagValue((Node)fnode, (String)"xpath"));
        this.setElementType(GetXmlDataField.getElementTypeByCode(XmlHandler.getTagValue((Node)fnode, (String)"element_type")));
        this.setResultType(GetXmlDataField.getResultTypeByCode(XmlHandler.getTagValue((Node)fnode, (String)"result_type")));
        this.setType(ValueMetaBase.getType((String)XmlHandler.getTagValue((Node)fnode, (String)"type")));
        this.setFormat(XmlHandler.getTagValue((Node)fnode, (String)"format"));
        this.setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
        this.setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
        this.setGroupSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
        this.setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
        this.setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
        this.setTrimType(GetXmlDataField.getTrimTypeByCode(XmlHandler.getTagValue((Node)fnode, (String)"trim_type")));
        this.setRepeated(!"N".equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)"repeat")));
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getElementTypeByCode(String tt) {
        int i;
        if (tt == null) {
            return 0;
        }
        for (i = 0; i < ElementOldTypeCode.length; ++i) {
            if (!ElementOldTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        for (i = 0; i < ElementTypeCode.length; ++i) {
            if (!ElementTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getElementTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < ElementTypeDesc.length; ++i) {
            if (!ElementTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    public static final String getElementTypeCode(int i) {
        if (i < 0 || i >= ElementOldTypeCode.length) {
            return ElementOldTypeCode[0];
        }
        return ElementOldTypeCode[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public static final String getElementTypeDesc(int i) {
        if (i < 0 || i >= ElementTypeDesc.length) {
            return ElementTypeDesc[0];
        }
        return ElementTypeDesc[i];
    }

    public Object clone() {
        try {
            GetXmlDataField retval = (GetXmlDataField)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public String getXPath() {
        return this.xpath;
    }

    protected String getResolvedXPath() {
        return this.resolvedXpath;
    }

    public void setXPath(String fieldxpath) {
        this.xpath = fieldxpath;
    }

    protected void setResolvedXPath(String resolvedXpath) {
        this.resolvedXpath = resolvedXpath;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return ValueMetaBase.getTypeDesc((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public int getElementType() {
        return this.elementtype;
    }

    public String getTrimTypeCode() {
        return GetXmlDataField.getTrimTypeCode(this.trimtype);
    }

    public String getElementTypeCode() {
        return GetXmlDataField.getElementTypeCode(this.elementtype);
    }

    public String getTrimTypeDesc() {
        return GetXmlDataField.getTrimTypeDesc(this.trimtype);
    }

    public String getElementTypeDesc() {
        return GetXmlDataField.getElementTypeDesc(this.elementtype);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    public void setElementType(int elementType) {
        this.elementtype = elementType;
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String group_symbol) {
        this.groupSymbol = group_symbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimal_symbol) {
        this.decimalSymbol = decimal_symbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currency_symbol) {
        this.currencySymbol = currency_symbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public void setRepeated(boolean repeat) {
        this.repeat = repeat;
    }

    public void flipRepeated() {
        this.repeat = !this.repeat;
    }

    public static final int getResultTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < ResultTypeDesc.length; ++i) {
            if (!ResultTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public String getResultTypeDesc() {
        return GetXmlDataField.getResultTypeDesc(this.resulttype);
    }

    public static final String getResultTypeDesc(int i) {
        if (i < 0 || i >= ResultTypeDesc.length) {
            return ResultTypeDesc[0];
        }
        return ResultTypeDesc[i];
    }

    public int getResultType() {
        return this.resulttype;
    }

    public void setResultType(int resulttype) {
        this.resulttype = resulttype;
    }

    public static final int getResultTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < ResultTypeCode.length; ++i) {
            if (!ResultTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final String getResultTypeCode(int i) {
        if (i < 0 || i >= ResultTypeCode.length) {
            return ResultTypeCode[0];
        }
        return ResultTypeCode[i];
    }

    public String getResultTypeCode() {
        return GetXmlDataField.getResultTypeCode(this.resulttype);
    }
}

