/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.addxml;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlParserFactoryProducer;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.addxml.AddXmlData;
import org.apache.hop.pipeline.transforms.xml.addxml.AddXmlMeta;
import org.apache.hop.pipeline.transforms.xml.addxml.XmlField;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AddXml
extends BaseTransform<AddXmlMeta, AddXmlData>
implements ITransform<AddXmlMeta, AddXmlData> {
    private static final Class<?> PKG = AddXml.class;
    private DOMImplementation domImplentation;
    private Transformer serializer;

    public AddXml(TransformMeta transformMeta, AddXmlMeta meta, AddXmlData sdi, int copyNr, PipelineMeta tm, Pipeline trans) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)sdi, copyNr, tm, trans);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((AddXmlData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((AddXmlMeta)this.meta).getFields(((AddXmlData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((AddXmlData)this.data).fieldIndexes = new int[((AddXmlMeta)this.meta).getOutputFields().length];
            for (int i = 0; i < ((AddXmlData)this.data).fieldIndexes.length; ++i) {
                String fieldsName = ((AddXmlMeta)this.meta).getOutputFields()[i].getFieldName();
                ((AddXmlData)this.data).fieldIndexes[i] = this.getInputRowMeta().indexOfValue(fieldsName);
                if (((AddXmlData)this.data).fieldIndexes[i] >= 0) continue;
                throw new HopException(BaseMessages.getString(PKG, (String)"AddXML.Exception.FieldNotFound", (String[])new String[]{fieldsName}));
            }
        }
        Document xmldoc = this.getDomImplentation().createDocument(null, ((AddXmlMeta)this.meta).getRootNode(), null);
        Element root = xmldoc.getDocumentElement();
        for (int i = 0; i < ((AddXmlMeta)this.meta).getOutputFields().length; ++i) {
            XmlField outputField = ((AddXmlMeta)this.meta).getOutputFields()[i];
            String fieldname = outputField.getFieldName();
            IValueMeta v = this.getInputRowMeta().getValueMeta(((AddXmlData)this.data).fieldIndexes[i]);
            Object valueData = r[((AddXmlData)this.data).fieldIndexes[i]];
            if (((AddXmlMeta)this.meta).isOmitNullValues() && v.isNull(valueData)) continue;
            String value = this.formatField(v, valueData, outputField);
            String element = outputField.getElementName();
            if (element == null || element.length() == 0) {
                element = fieldname;
            }
            if (element == null || element.length() == 0) {
                throw new HopException("XML does not allow empty strings for element names.");
            }
            if (outputField.isAttribute()) {
                NodeList nodelist;
                String attributeParentName = outputField.getAttributeParentName();
                Element node = attributeParentName == null || attributeParentName.length() == 0 ? root : ((nodelist = root.getElementsByTagName(attributeParentName)).getLength() > 0 ? (Element)nodelist.item(0) : root);
                node.setAttribute(element, value);
                continue;
            }
            if (!element.equals(((AddXmlMeta)this.meta).getRootNode())) {
                Element e = xmldoc.createElement(element);
                Text n = xmldoc.createTextNode(value);
                e.appendChild(n);
                root.appendChild(e);
                continue;
            }
            Text n = xmldoc.createTextNode(value);
            root.appendChild(n);
        }
        StringWriter sw = new StringWriter();
        DOMSource domSource = new DOMSource(xmldoc);
        try {
            this.getSerializer().transform(domSource, new StreamResult(sw));
        }
        catch (TransformerException e) {
            throw new HopException((Throwable)e);
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
        Object[] outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.getInputRowMeta().size(), (Object)sw.toString());
        this.putRow(((AddXmlData)this.data).outputRowMeta, outputRowData);
        return true;
    }

    private String formatField(IValueMeta valueMeta, Object valueData, XmlField field) throws HopValueException {
        String retval = "";
        if (field == null) {
            return "";
        }
        if (valueMeta == null || valueMeta.isNull(valueData)) {
            String defaultNullValue = field.getNullString();
            return Utils.isEmpty((CharSequence)defaultNullValue) ? "" : defaultNullValue;
        }
        if (valueMeta.isNumeric()) {
            if (!Utils.isEmpty((CharSequence)field.getFormat())) {
                ((AddXmlData)this.data).df.applyPattern(field.getFormat());
            } else {
                ((AddXmlData)this.data).df.applyPattern(((AddXmlData)this.data).defaultDecimalFormat.toPattern());
            }
            if (!Utils.isEmpty((CharSequence)field.getDecimalSymbol())) {
                ((AddXmlData)this.data).dfs.setDecimalSeparator(field.getDecimalSymbol().charAt(0));
            } else {
                ((AddXmlData)this.data).dfs.setDecimalSeparator(((AddXmlData)this.data).defaultDecimalFormatSymbols.getDecimalSeparator());
            }
            if (!Utils.isEmpty((CharSequence)field.getGroupingSymbol())) {
                ((AddXmlData)this.data).dfs.setGroupingSeparator(field.getGroupingSymbol().charAt(0));
            } else {
                ((AddXmlData)this.data).dfs.setGroupingSeparator(((AddXmlData)this.data).defaultDecimalFormatSymbols.getGroupingSeparator());
            }
            if (!Utils.isEmpty((CharSequence)field.getCurrencySymbol())) {
                ((AddXmlData)this.data).dfs.setCurrencySymbol(field.getCurrencySymbol());
            } else {
                ((AddXmlData)this.data).dfs.setCurrencySymbol(((AddXmlData)this.data).defaultDecimalFormatSymbols.getCurrencySymbol());
            }
            ((AddXmlData)this.data).df.setDecimalFormatSymbols(((AddXmlData)this.data).dfs);
            retval = valueMeta.isBigNumber() ? ((AddXmlData)this.data).df.format(valueMeta.getBigNumber(valueData)) : (valueMeta.isNumber() ? ((AddXmlData)this.data).df.format(valueMeta.getNumber(valueData)) : ((AddXmlData)this.data).df.format(valueMeta.getInteger(valueData)));
        } else if (valueMeta.isDate()) {
            if (field != null && !Utils.isEmpty((CharSequence)field.getFormat()) && valueMeta.getDate(valueData) != null) {
                if (!Utils.isEmpty((CharSequence)field.getFormat())) {
                    ((AddXmlData)this.data).daf.applyPattern(field.getFormat());
                } else {
                    ((AddXmlData)this.data).daf.applyPattern(((AddXmlData)this.data).defaultDateFormat.toLocalizedPattern());
                }
                ((AddXmlData)this.data).daf.setDateFormatSymbols(((AddXmlData)this.data).dafs);
                retval = ((AddXmlData)this.data).daf.format(valueMeta.getDate(valueData));
            } else if (valueMeta.isNull(valueData)) {
                if (field != null && !Utils.isEmpty((CharSequence)field.getNullString())) {
                    retval = field.getNullString();
                }
            } else {
                retval = valueMeta.getString(valueData);
            }
        } else if (valueMeta.isString()) {
            retval = valueMeta.getString(valueData);
        } else if (valueMeta.isBinary()) {
            if (valueMeta.isNull(valueData)) {
                retval = !Utils.isEmpty((CharSequence)field.getNullString()) ? field.getNullString() : "";
            } else {
                try {
                    retval = new String(valueMeta.getBinary(valueData), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    retval = "";
                }
            }
        } else {
            retval = valueMeta.getString(valueData);
        }
        return retval;
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        try {
            this.setSerializer(TransformerFactory.newInstance().newTransformer());
            this.setDomImplentation(XmlParserFactoryProducer.createSecureDocBuilderFactory().newDocumentBuilder().getDOMImplementation());
            if (((AddXmlMeta)this.meta).getEncoding() != null) {
                this.getSerializer().setOutputProperty("encoding", ((AddXmlMeta)this.meta).getEncoding());
            }
            if (((AddXmlMeta)this.meta).isOmitXMLheader()) {
                this.getSerializer().setOutputProperty("omit-xml-declaration", "yes");
            }
        }
        catch (TransformerConfigurationException e) {
            return false;
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        return true;
    }

    public void dispose(ITransformMeta smi, ITransformData sdi) {
        this.meta = (AddXmlMeta)smi;
        this.data = (AddXmlData)sdi;
        super.dispose();
    }

    private void setDomImplentation(DOMImplementation domImplentation) {
        this.domImplentation = domImplentation;
    }

    private DOMImplementation getDomImplentation() {
        return this.domImplentation;
    }

    private void setSerializer(Transformer serializer) {
        this.serializer = serializer;
    }

    private Transformer getSerializer() {
        return this.serializer;
    }
}

