/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tableexists;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tableexists.TableExists;
import org.apache.hop.pipeline.transforms.tableexists.TableExistsData;

@Transform(id="TableExists", image="tableexists.svg", name="i18n::TableExists.Name", description="i18n::TableExists.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", documentationUrl="/pipeline/transforms/tableexists.html")
public class TableExistsMeta
extends BaseTransformMeta
implements ITransformMeta<TableExists, TableExistsData> {
    private static final Class<?> PKG = TableExistsMeta.class;
    @HopMetadataProperty(key="connection", storeWithName=true, injectionKeyDescription="TableExistsMeta.Injection.Connection")
    private DatabaseMeta database;
    @HopMetadataProperty(key="tablenamefield", injectionKeyDescription="TableExistsMeta.Injection.TableNameField")
    private String tableNameField;
    @HopMetadataProperty(key="resultfieldname", injectionKeyDescription="TableExistsMeta.Injection.ResultFieldName")
    private String resultFieldName;
    @HopMetadataProperty(key="schemaname", injectionKeyDescription="TableExistsMeta.Injection.SchemaName")
    private String schemaName;

    public DatabaseMeta getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseMeta database) {
        this.database = database;
    }

    public String getTableNameField() {
        return this.tableNameField;
    }

    public void setTableNameField(String tablenamefield) {
        this.tableNameField = tablenamefield;
    }

    public String getResultFieldName() {
        return this.resultFieldName;
    }

    public void setResultFieldName(String name) {
        this.resultFieldName = name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String name) {
        this.schemaName = name;
    }

    public TableExists createTransform(TransformMeta transformMeta, TableExistsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new TableExists(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public void setDefault() {
        this.database = null;
        this.schemaName = null;
        this.resultFieldName = "result";
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!Utils.isEmpty((CharSequence)this.resultFieldName)) {
            ValueMetaBoolean v = new ValueMetaBoolean(variables.resolve(this.resultFieldName));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (this.database == null) {
            errorMessage = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.resultFieldName)) {
            errorMessage = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.tableNameField)) {
            errorMessage = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.TableFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.TableFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public TableExistsData getTransformData() {
        return new TableExistsData();
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.database != null) {
            return new DatabaseMeta[]{this.database};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

