/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.googledrive;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.FileList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.hop.vfs.googledrive.GoogleDriveFileSystem;
import org.apache.hop.vfs.googledrive.config.GoogleDriveConfigSingleton;
import org.apache.hop.vfs.googledrive.util.CustomDataStoreFactory;

public class GoogleDriveFileObject
extends AbstractFileObject {
    public static final String APPLICATION_NAME = "Apache-Hop-Google-Drive-VFS";
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/drive");
    private CustomDataStoreFactory DATA_STORE_FACTORY;
    private static JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static NetHttpTransport HTTP_TRANSPORT;
    private Drive driveService;
    private FileType mimeType;
    private String id;

    protected GoogleDriveFileObject(AbstractFileName fileName, GoogleDriveFileSystem fileSystem) throws FileSystemException {
        super(fileName, (AbstractFileSystem)fileSystem);
        try {
            HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            this.DATA_STORE_FACTORY = new CustomDataStoreFactory(GoogleDriveFileObject.getTokensFolder());
            this.driveService = this.getDriveService();
            this.resolveFileMetadata();
        }
        catch (Exception e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    protected String[] doListChildren() throws Exception {
        String[] children = null;
        if (this.isFolder()) {
            this.id = this.id == null ? "root" : this.id;
            String fileQuery = "'" + this.id + "' in parents and trashed=false";
            FileList files = (FileList)this.driveService.files().list().setQ(fileQuery).execute();
            ArrayList<String> fileNames = new ArrayList<String>();
            for (com.google.api.services.drive.model.File file : files.getFiles()) {
                fileNames.add(file.getName());
            }
            children = fileNames.toArray(new String[0]);
        }
        return children;
    }

    protected void doCreateFolder() throws Exception {
        if (!this.getName().getBaseName().isEmpty()) {
            com.google.api.services.drive.model.File folder = new com.google.api.services.drive.model.File();
            folder.setName(this.getName().getBaseName());
            folder.setMimeType(MIME_TYPES.FOLDER.mimeType);
            folder = (com.google.api.services.drive.model.File)this.driveService.files().create(folder).execute();
            if (folder != null) {
                this.id = folder.getId();
                this.mimeType = MIME_TYPES.get(folder.getMimeType());
            }
        }
    }

    protected void doDelete() throws Exception {
        this.driveService.files().delete(this.id).execute();
        this.id = null;
        this.mimeType = null;
    }

    protected long doGetContentSize() throws Exception {
        return -1L;
    }

    protected FileType doGetType() throws Exception {
        return this.mimeType;
    }

    protected InputStream doGetInputStream() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.driveService.files().get(this.id).executeMediaAndDownloadTo((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        return in;
    }

    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        final com.google.api.services.drive.model.File parent = this.getName().getParent() != null ? this.searchFile(this.getName().getParent().getBaseName(), null) : null;
        ByteArrayOutputStream out = new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                com.google.api.services.drive.model.File file = new com.google.api.services.drive.model.File();
                file.setName(GoogleDriveFileObject.this.getName().getBaseName());
                if (parent != null) {
                    file.setParents(Collections.singletonList(parent.getId()));
                }
                ByteArrayContent fileContent = new ByteArrayContent("application/octet-stream", this.toByteArray());
                if (this.count > 0) {
                    GoogleDriveFileObject.this.driveService.files().create(file, (AbstractInputStreamContent)fileContent).execute();
                    ((GoogleDriveFileSystem)GoogleDriveFileObject.this.getFileSystem()).clearFileFromCache(GoogleDriveFileObject.this.getName());
                }
            }
        };
        return out;
    }

    protected long doGetLastModifiedTime() throws Exception {
        return -1L;
    }

    private void resolveFileMetadata() throws Exception {
        String fileName;
        com.google.api.services.drive.model.File file;
        FileType mime;
        com.google.api.services.drive.model.File parent;
        String parentId = null;
        if (this.getName().getParent() != null && (parent = this.searchFile(this.getName().getParent().getBaseName(), null)) != null && (mime = MIME_TYPES.get(parent.getMimeType())).equals((Object)FileType.FOLDER)) {
            parentId = parent.getId();
        }
        if ((file = this.searchFile(fileName = this.getName().getBaseName(), parentId)) != null) {
            this.mimeType = MIME_TYPES.get(file.getMimeType());
            this.id = file.getId();
        } else if (this.getName().getURI().equals("googledrive:///")) {
            this.mimeType = FileType.FOLDER;
        }
    }

    private com.google.api.services.drive.model.File searchFile(String fileName, String parentId) throws Exception {
        FileList fileList;
        com.google.api.services.drive.model.File file = null;
        StringBuffer fileQuery = new StringBuffer();
        fileQuery.append("name = '" + fileName + "'");
        if (parentId != null) {
            fileQuery.append(" and '" + parentId + "' in parents and trashed=false");
        }
        if (!(fileList = (FileList)this.driveService.files().list().setQ(fileQuery.toString()).execute()).getFiles().isEmpty()) {
            file = (com.google.api.services.drive.model.File)fileList.getFiles().get(0);
        }
        return file;
    }

    private static Credential getCredentials(NetHttpTransport HTTP_TRANSPORT) throws IOException {
        FileInputStream in = new FileInputStream(GoogleDriveFileObject.getCredentialsFile());
        if (in == null) {
            throw new FileNotFoundException("Resource not found: " + GoogleDriveFileObject.getCredentialsFile());
        }
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)JSON_FACTORY, (Reader)new InputStreamReader(in));
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)HTTP_TRANSPORT, JSON_FACTORY, clientSecrets, SCOPES).setDataStoreFactory((DataStoreFactory)new FileDataStoreFactory(GoogleDriveFileObject.getTokensFolder())).setAccessType("offline").build();
        LocalServerReceiver receiver = new LocalServerReceiver.Builder().setPort(8888).build();
        return new AuthorizationCodeInstalledApp((AuthorizationCodeFlow)flow, (VerificationCodeReceiver)receiver).authorize("user");
    }

    private Drive getDriveService() throws IOException {
        Credential credential = GoogleDriveFileObject.getCredentials(HTTP_TRANSPORT);
        return new Drive.Builder((HttpTransport)HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName(APPLICATION_NAME).build();
    }

    private static File getTokensFolder() throws FileSystemException {
        String tokensFolder = GoogleDriveConfigSingleton.getConfig().getTokensFolder();
        if (tokensFolder == null) {
            throw new FileSystemException("Google Drive VFS: please specify a local folder to store tokens in the configuration.  You can do this in the 'Google Drive' tab of the options dialog in the GUI or using the Hop Config script.");
        }
        return new File(tokensFolder);
    }

    public static String getCredentialsFile() throws FileSystemException {
        String credentialsFile = GoogleDriveConfigSingleton.getConfig().getCredentialsFile();
        if (credentialsFile == null) {
            throw new FileSystemException("Google Drive VFS: please specify a credentials JSON file in the configuration. You can do this in the 'Google Drive' tab of the options dialog in the GUI or using the Hop Config script.");
        }
        return credentialsFile;
    }

    public static enum MIME_TYPES {
        FILE("application/vnd.google-apps.file", FileType.FILE),
        FOLDER("application/vnd.google-apps.folder", FileType.FOLDER);

        private final String mimeType;
        private final FileType fileType;

        private MIME_TYPES(String mimeType, FileType fileType) {
            this.mimeType = mimeType;
            this.fileType = fileType;
        }

        public static FileType get(String type) {
            FileType fileType = null;
            fileType = MIME_TYPES.FOLDER.mimeType.equals(type) ? MIME_TYPES.FOLDER.fileType : MIME_TYPES.FILE.fileType;
            return fileType;
        }
    }
}

