/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.setvalueconstant;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.setvalueconstant.SetValueConstant;
import org.apache.hop.pipeline.transforms.setvalueconstant.SetValueConstantData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="SetValueConstant.Injection.", groups={"FIELDS", "OPTIONS"})
@Transform(id="SetValueConstant", image="setvalueconstant.svg", name="i18n::BaseTransform.TypeLongDesc.SetValueConstant", description="i18n::BaseTransform.TypeTooltipDesc.SetValueConstant", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", documentationUrl="/pipeline/transforms/setvalueconstant.html")
public class SetValueConstantMeta
extends BaseTransformMeta
implements ITransformMeta<SetValueConstant, SetValueConstantData> {
    private static final Class<?> PKG = SetValueConstantMeta.class;
    @InjectionDeep
    private List<Field> fields = new ArrayList<Field>();
    @Injection(name="USE_VARIABLE", group="OPTIONS")
    private boolean usevar;

    public Field getField(int i) {
        return this.fields.get(i);
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public void setUseVars(boolean usevar) {
        this.usevar = usevar;
    }

    public boolean isUseVars() {
        return this.usevar;
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.usevar = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"usevar"));
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                Field field = new Field();
                field.setFieldName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                field.setReplaceValue(XmlHandler.getTagValue((Node)fnode, (String)"value"));
                field.setReplaceMask(XmlHandler.getTagValue((Node)fnode, (String)"mask"));
                String emptyString = XmlHandler.getTagValue((Node)fnode, (String)"set_empty_string");
                field.setEmptyString(!Utils.isEmpty((CharSequence)emptyString) && "Y".equalsIgnoreCase(emptyString));
                fieldList.add(field);
            }
            this.setFields(fieldList);
        }
        catch (Exception e) {
            throw new HopXmlException("It was not possible to load the metadata for this transform from XML", (Throwable)e);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("   " + XmlHandler.addTagValue((String)"usevar", (boolean)this.usevar));
        retval.append("    <fields>" + Const.CR);
        this.fields.forEach(field -> {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XmlHandler.addTagValue((String)"name", (String)field.getFieldName()));
            retval.append("        " + XmlHandler.addTagValue((String)"value", (String)field.getReplaceValue()));
            retval.append("        " + XmlHandler.addTagValue((String)"mask", (String)field.getReplaceMask()));
            retval.append("        " + XmlHandler.addTagValue((String)"set_empty_string", (boolean)field.isEmptyString()));
            retval.append("        </field>" + Const.CR);
        });
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    public void setDefault() {
        this.usevar = false;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.TransformRecevingData", (String[])new String[]{prev.size() + ""}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            String errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.fields.size(); ++i) {
                int idx = prev.indexOfValue(this.fields.get(i).getFieldName());
                if (idx >= 0) continue;
                errorMessage = errorMessage + "\t\t" + this.fields.get(i).getFieldName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.FieldsFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = Utils.isEmpty(this.fields) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.NoFieldsEntered", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"SetValueConstantMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public ITransform createTransform(TransformMeta transformMeta, SetValueConstantData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new SetValueConstant(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public SetValueConstantData getTransformData() {
        return new SetValueConstantData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public static class Field {
        @Injection(name="FIELD_NAME", group="FIELDS")
        private String fieldName;
        @Injection(name="REPLACE_VALUE", group="FIELDS")
        private String replaceValue;
        @Injection(name="REPLACE_MASK", group="FIELDS")
        private String replaceMask;
        @Injection(name="EMPTY_STRING", group="FIELDS")
        private boolean setEmptyString;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getReplaceValue() {
            return this.replaceValue;
        }

        public void setReplaceValue(String replaceValue) {
            this.replaceValue = replaceValue;
        }

        public String getReplaceMask() {
            return this.replaceMask;
        }

        public void setReplaceMask(String replaceMask) {
            this.replaceMask = replaceMask;
        }

        public boolean isEmptyString() {
            return this.setEmptyString;
        }

        public void setEmptyString(boolean setEmptyString) {
            this.setEmptyString = setEmptyString;
        }

        public boolean equals(Object obj) {
            return this.fieldName.equals(((Field)obj).getFieldName()) && this.replaceValue.equals(((Field)obj).getReplaceValue()) && this.replaceMask.equals(((Field)obj).getReplaceMask()) && this.setEmptyString == ((Field)obj).isEmptyString();
        }
    }
}

