/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.rest;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.rest.RestData;
import org.apache.hop.pipeline.transforms.rest.RestMeta;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.json.simple.JSONObject;

public class Rest
extends BaseTransform<RestMeta, RestData>
implements ITransform<RestMeta, RestData> {
    private static final Class<?> PKG = RestMeta.class;

    public Rest(TransformMeta transformMeta, RestMeta meta, RestData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    MultivaluedMapImpl createMultivalueMap(String paramName, String paramValue) {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add(paramName, UriComponent.encode((String)paramValue, (UriComponent.Type)UriComponent.Type.QUERY_PARAM));
        return queryParams;
    }

    protected Object[] callRest(Object[] rowData) throws HopException {
        if (((RestMeta)this.meta).isUrlInField()) {
            ((RestData)this.data).realUrl = ((RestData)this.data).inputRowMeta.getString(rowData, ((RestData)this.data).indexOfUrlField);
        }
        if (((RestMeta)this.meta).isDynamicMethod()) {
            ((RestData)this.data).method = ((RestData)this.data).inputRowMeta.getString(rowData, ((RestData)this.data).indexOfMethod);
            if (Utils.isEmpty((CharSequence)((RestData)this.data).method)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.MethodMissing", (String[])new String[0]));
            }
        }
        WebResource webResource = null;
        ApacheHttpClient4 client = null;
        Object[] newRow = null;
        if (rowData != null) {
            newRow = (Object[])rowData.clone();
        }
        try {
            String body;
            ClientResponse response;
            long startTime;
            block44: {
                UriBuilder builder;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Rest.Log.ConnectingToURL", (String[])new String[]{((RestData)this.data).realUrl}));
                }
                client = ApacheHttpClient4.create((ClientConfig)((RestData)this.data).config);
                if (((RestData)this.data).basicAuthentication != null) {
                    client.addFilter((ClientFilter)((RestData)this.data).basicAuthentication);
                }
                webResource = client.resource(((RestData)this.data).realUrl);
                startTime = System.currentTimeMillis();
                if (((RestData)this.data).useMatrixParams) {
                    builder = webResource.getUriBuilder();
                    for (int i = 0; i < ((RestData)this.data).nrMatrixParams; ++i) {
                        String value = ((RestData)this.data).inputRowMeta.getString(rowData, ((RestData)this.data).indexOfMatrixParamFields[i]);
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.matrixParameterValue", (String[])new String[]{((RestData)this.data).matrixParamNames[i], value}));
                        }
                        builder = builder.matrixParam(((RestData)this.data).matrixParamNames[i], new Object[]{UriComponent.encode((String)value, (UriComponent.Type)UriComponent.Type.QUERY_PARAM)});
                    }
                    webResource = client.resource(builder.build(new Object[0]));
                }
                if (((RestData)this.data).useParams) {
                    for (int i = 0; i < ((RestData)this.data).nrParams; ++i) {
                        String value = ((RestData)this.data).inputRowMeta.getString(rowData, ((RestData)this.data).indexOfParamFields[i]);
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.queryParameterValue", (String[])new String[]{((RestData)this.data).paramNames[i], value}));
                        }
                        webResource = webResource.queryParams((MultivaluedMap)this.createMultivalueMap(((RestData)this.data).paramNames[i], value));
                    }
                }
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.ConnectingToURL", (Object[])new Object[]{webResource.getURI()}));
                }
                builder = webResource.getRequestBuilder();
                String contentType = null;
                if (((RestData)this.data).useHeaders) {
                    for (int i = 0; i < ((RestData)this.data).nrheader; ++i) {
                        String value = ((RestData)this.data).inputRowMeta.getString(rowData, ((RestData)this.data).indexOfHeaderFields[i]);
                        builder = (WebResource.Builder)builder.header(((RestData)this.data).headerNames[i], (Object)value);
                        if ("Content-Type".equals(((RestData)this.data).headerNames[i])) {
                            contentType = value;
                        }
                        if (!this.isDebug()) continue;
                        this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.HeaderValue", (String[])new String[]{((RestData)this.data).headerNames[i], value}));
                    }
                }
                response = null;
                String entityString = null;
                if (((RestData)this.data).useBody) {
                    entityString = Const.NVL((String)((RestData)this.data).inputRowMeta.getString(rowData, ((RestData)this.data).indexOfBodyField), null);
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.BodyValue", (String[])new String[]{entityString}));
                    }
                }
                try {
                    if (((RestData)this.data).method.equals("GET")) {
                        response = (ClientResponse)builder.get(ClientResponse.class);
                        break block44;
                    }
                    if (((RestData)this.data).method.equals("POST")) {
                        response = null != contentType ? (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, (Object)entityString) : (ClientResponse)((WebResource.Builder)builder.type(((RestData)this.data).mediaType)).post(ClientResponse.class, (Object)entityString);
                        break block44;
                    }
                    if (((RestData)this.data).method.equals("PUT")) {
                        response = null != contentType ? (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)entityString) : (ClientResponse)((WebResource.Builder)builder.type(((RestData)this.data).mediaType)).put(ClientResponse.class, (Object)entityString);
                        break block44;
                    }
                    if (((RestData)this.data).method.equals("DELETE")) {
                        response = (ClientResponse)builder.delete(ClientResponse.class);
                        break block44;
                    }
                    if (((RestData)this.data).method.equals("HEAD")) {
                        response = builder.head();
                        break block44;
                    }
                    if (((RestData)this.data).method.equals("OPTIONS")) {
                        response = (ClientResponse)builder.options(ClientResponse.class);
                        break block44;
                    }
                    if (((RestData)this.data).method.equals("PATCH")) {
                        response = null != contentType ? (ClientResponse)((WebResource.Builder)builder.type(contentType)).method("PATCH", ClientResponse.class, (Object)entityString) : (ClientResponse)((WebResource.Builder)builder.type(((RestData)this.data).mediaType)).method("PATCH", ClientResponse.class, (Object)entityString);
                        break block44;
                    }
                    throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.UnknownMethod", (String[])new String[]{((RestData)this.data).method}));
                }
                catch (UniformInterfaceException u) {
                    response = u.getResponse();
                }
            }
            long responseTime = System.currentTimeMillis() - startTime;
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"Rest.Log.ResponseTime", (String[])new String[]{String.valueOf(responseTime), ((RestData)this.data).realUrl}));
            }
            int status = response.getStatus();
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.ResponseCode", (String[])new String[]{"" + status}));
            }
            String headerString = null;
            try {
                body = (String)response.getEntity(String.class);
            }
            catch (UniformInterfaceException ex) {
                body = "";
            }
            MultivaluedMap<String, String> headers = this.searchForHeaders(response);
            JSONObject json = new JSONObject();
            for (Map.Entry entry : headers.entrySet()) {
                String name = (String)entry.getKey();
                List value = (List)entry.getValue();
                if (value.size() > 1) {
                    json.put((Object)name, (Object)value);
                    continue;
                }
                json.put((Object)name, value.get(0));
            }
            headerString = json.toJSONString();
            int returnFieldsOffset = ((RestData)this.data).inputRowMeta.size();
            if (!Utils.isEmpty((CharSequence)((RestData)this.data).resultFieldName)) {
                newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)body);
                ++returnFieldsOffset;
            }
            if (!Utils.isEmpty((CharSequence)((RestData)this.data).resultCodeFieldName)) {
                newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)status);
                ++returnFieldsOffset;
            }
            if (!Utils.isEmpty((CharSequence)((RestData)this.data).resultResponseFieldName)) {
                newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)responseTime);
                ++returnFieldsOffset;
            }
            if (!Utils.isEmpty((CharSequence)((RestData)this.data).resultHeaderFieldName)) {
                newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)headerString);
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.CanNotReadURL", (String[])new String[]{((RestData)this.data).realUrl}), (Throwable)e);
        }
        finally {
            if (webResource != null) {
                webResource = null;
            }
            if (client != null) {
                client.destroy();
            }
        }
        return newRow;
    }

    private void setConfig() throws HopException {
        if (((RestData)this.data).config == null) {
            ((RestData)this.data).config = new DefaultApacheHttpClient4Config();
            if (!Utils.isEmpty((CharSequence)((RestData)this.data).realProxyHost)) {
                ((RestData)this.data).config.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", "http://" + ((RestData)this.data).realProxyHost + ":" + ((RestData)this.data).realProxyPort);
                if (!Utils.isEmpty((CharSequence)((RestData)this.data).realHttpLogin) && !Utils.isEmpty((CharSequence)((RestData)this.data).realHttpPassword)) {
                    AuthScope authScope = new AuthScope(((RestData)this.data).realProxyHost, ((RestData)this.data).realProxyPort);
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(((RestData)this.data).realHttpLogin, ((RestData)this.data).realHttpPassword);
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(authScope, (Credentials)credentials);
                    ((RestData)this.data).config.getProperties().put("com.sun.jersey.impl.client.httpclient.credentialsProvider", credentialsProvider);
                }
            } else if (!Utils.isEmpty((CharSequence)((RestData)this.data).realHttpLogin)) {
                ((RestData)this.data).basicAuthentication = new HTTPBasicAuthFilter(((RestData)this.data).realHttpLogin, ((RestData)this.data).realHttpPassword);
            }
            if (((RestMeta)this.meta).isPreemptive()) {
                ((RestData)this.data).config.getProperties().put("com.sun.jersey.impl.client.httpclient.preemptiveBasicAuthentication", true);
            }
            if (!Utils.isEmpty((CharSequence)((RestData)this.data).trustStoreFile)) {
                try (FileInputStream trustFileStream = new FileInputStream(((RestData)this.data).trustStoreFile);){
                    KeyStore trustStore = KeyStore.getInstance("JKS");
                    trustStore.load(trustFileStream, ((RestData)this.data).trustStorePassword.toCharArray());
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                    tmf.init(trustStore);
                    SSLContext ctx = SSLContext.getInstance("SSL");
                    ctx.init(null, tmf.getTrustManagers(), null);
                    HostnameVerifier hv = (hostname, session) -> {
                        if (this.isDebug()) {
                            this.logDebug("Warning: URL Host: " + hostname + " vs. " + session.getPeerHost());
                        }
                        return true;
                    };
                    ((RestData)this.data).config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hv, ctx));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.NoSuchAlgorithm", (String[])new String[0]), (Throwable)e);
                }
                catch (KeyStoreException e) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.KeyStoreException", (String[])new String[0]), (Throwable)e);
                }
                catch (CertificateException e) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.CertificateException", (String[])new String[0]), (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.FileNotFound", (String[])new String[]{((RestData)this.data).trustStoreFile}), (Throwable)e);
                }
                catch (IOException e) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.IOException", (String[])new String[0]), (Throwable)e);
                }
                catch (KeyManagementException e) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.KeyManagementException", (String[])new String[0]), (Throwable)e);
                }
            }
        }
    }

    protected MultivaluedMap<String, String> searchForHeaders(ClientResponse response) {
        return response.getHeaders();
    }

    public boolean processRow() throws HopException {
        block26: {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                String field;
                int nrargs;
                this.first = false;
                ((RestData)this.data).inputRowMeta = this.getInputRowMeta();
                ((RestData)this.data).outputRowMeta = ((RestData)this.data).inputRowMeta.clone();
                ((RestMeta)this.meta).getFields(((RestData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (((RestMeta)this.meta).isUrlInField()) {
                    if (Utils.isEmpty((CharSequence)((RestMeta)this.meta).getUrlField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"Rest.Log.NoField", (String[])new String[0]));
                        throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Log.NoField", (String[])new String[0]));
                    }
                    if (((RestData)this.data).indexOfUrlField < 0) {
                        String realUrlfieldName = this.resolve(((RestMeta)this.meta).getUrlField());
                        ((RestData)this.data).indexOfUrlField = ((RestData)this.data).inputRowMeta.indexOfValue(realUrlfieldName);
                        if (((RestData)this.data).indexOfUrlField < 0) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{realUrlfieldName}));
                        }
                    }
                } else {
                    ((RestData)this.data).realUrl = this.resolve(((RestMeta)this.meta).getUrl());
                }
                if (((RestMeta)this.meta).isDynamicMethod()) {
                    String field2 = this.resolve(((RestMeta)this.meta).getMethodFieldName());
                    if (Utils.isEmpty((CharSequence)field2)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Exception.MethodFieldMissing", (String[])new String[0]));
                    }
                    ((RestData)this.data).indexOfMethod = ((RestData)this.data).inputRowMeta.indexOfValue(field2);
                    if (((RestData)this.data).indexOfMethod < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{field2}));
                    }
                }
                int n = nrargs = ((RestMeta)this.meta).getHeaderName() == null ? 0 : ((RestMeta)this.meta).getHeaderName().length;
                if (nrargs > 0) {
                    ((RestData)this.data).nrheader = nrargs;
                    ((RestData)this.data).indexOfHeaderFields = new int[nrargs];
                    ((RestData)this.data).headerNames = new String[nrargs];
                    for (int i = 0; i < nrargs; ++i) {
                        ((RestData)this.data).headerNames[i] = this.resolve(((RestMeta)this.meta).getHeaderName()[i]);
                        String field3 = this.resolve(((RestMeta)this.meta).getHeaderField()[i]);
                        if (Utils.isEmpty((CharSequence)field3)) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Exception.HeaderFieldEmpty", (String[])new String[0]));
                        }
                        ((RestData)this.data).indexOfHeaderFields[i] = ((RestData)this.data).inputRowMeta.indexOfValue(field3);
                        if (((RestData)this.data).indexOfHeaderFields[i] >= 0) continue;
                        throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{field3}));
                    }
                    ((RestData)this.data).useHeaders = true;
                }
                if (RestMeta.isActiveParameters(((RestMeta)this.meta).getMethod())) {
                    int nrmatrixparams;
                    int nrparams;
                    int n2 = nrparams = ((RestMeta)this.meta).getParameterField() == null ? 0 : ((RestMeta)this.meta).getParameterField().length;
                    if (nrparams > 0) {
                        ((RestData)this.data).nrParams = nrparams;
                        ((RestData)this.data).paramNames = new String[nrparams];
                        ((RestData)this.data).indexOfParamFields = new int[nrparams];
                        for (int i = 0; i < nrparams; ++i) {
                            ((RestData)this.data).paramNames[i] = this.resolve(((RestMeta)this.meta).getParameterName()[i]);
                            String field4 = this.resolve(((RestMeta)this.meta).getParameterField()[i]);
                            if (Utils.isEmpty((CharSequence)field4)) {
                                throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Exception.ParamFieldEmpty", (String[])new String[0]));
                            }
                            ((RestData)this.data).indexOfParamFields[i] = ((RestData)this.data).inputRowMeta.indexOfValue(field4);
                            if (((RestData)this.data).indexOfParamFields[i] >= 0) continue;
                            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{field4}));
                        }
                        ((RestData)this.data).useParams = true;
                    }
                    int n3 = nrmatrixparams = ((RestMeta)this.meta).getMatrixParameterField() == null ? 0 : ((RestMeta)this.meta).getMatrixParameterField().length;
                    if (nrmatrixparams > 0) {
                        ((RestData)this.data).nrMatrixParams = nrmatrixparams;
                        ((RestData)this.data).matrixParamNames = new String[nrmatrixparams];
                        ((RestData)this.data).indexOfMatrixParamFields = new int[nrmatrixparams];
                        for (int i = 0; i < nrmatrixparams; ++i) {
                            ((RestData)this.data).matrixParamNames[i] = this.resolve(((RestMeta)this.meta).getMatrixParameterName()[i]);
                            String field5 = this.resolve(((RestMeta)this.meta).getMatrixParameterField()[i]);
                            if (Utils.isEmpty((CharSequence)field5)) {
                                throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Exception.MatrixParamFieldEmpty", (String[])new String[0]));
                            }
                            ((RestData)this.data).indexOfMatrixParamFields[i] = ((RestData)this.data).inputRowMeta.indexOfValue(field5);
                            if (((RestData)this.data).indexOfMatrixParamFields[i] >= 0) continue;
                            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{field5}));
                        }
                        ((RestData)this.data).useMatrixParams = true;
                    }
                }
                if (RestMeta.isActiveBody(((RestMeta)this.meta).getMethod()) && !Utils.isEmpty((CharSequence)(field = this.resolve(((RestMeta)this.meta).getBodyField())))) {
                    ((RestData)this.data).indexOfBodyField = ((RestData)this.data).inputRowMeta.indexOfValue(field);
                    if (((RestData)this.data).indexOfBodyField < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{field}));
                    }
                    ((RestData)this.data).useBody = true;
                }
            }
            try {
                Object[] outputRowData = this.callRest(r);
                this.putRow(((RestData)this.data).outputRowMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Rest.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"Rest.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block26;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "Rest001");
            }
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            ((RestData)this.data).resultFieldName = this.resolve(((RestMeta)this.meta).getFieldName());
            ((RestData)this.data).resultCodeFieldName = this.resolve(((RestMeta)this.meta).getResultCodeFieldName());
            ((RestData)this.data).resultResponseFieldName = this.resolve(((RestMeta)this.meta).getResponseTimeFieldName());
            ((RestData)this.data).resultHeaderFieldName = this.resolve(((RestMeta)this.meta).getResponseHeaderFieldName());
            ((RestData)this.data).realProxyHost = this.resolve(((RestMeta)this.meta).getProxyHost());
            ((RestData)this.data).realProxyPort = Const.toInt((String)this.resolve(((RestMeta)this.meta).getProxyPort()), (int)8080);
            ((RestData)this.data).realHttpLogin = this.resolve(((RestMeta)this.meta).getHttpLogin());
            ((RestData)this.data).realHttpPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(((RestMeta)this.meta).getHttpPassword()));
            if (!((RestMeta)this.meta).isDynamicMethod()) {
                ((RestData)this.data).method = this.resolve(((RestMeta)this.meta).getMethod());
                if (Utils.isEmpty((CharSequence)((RestData)this.data).method)) {
                    this.logError(BaseMessages.getString(PKG, (String)"Rest.Error.MethodMissing", (String[])new String[0]));
                    return false;
                }
            }
            ((RestData)this.data).trustStoreFile = this.resolve(((RestMeta)this.meta).getTrustStoreFile());
            ((RestData)this.data).trustStorePassword = this.resolve(((RestMeta)this.meta).getTrustStorePassword());
            String applicationType = Const.NVL((String)((RestMeta)this.meta).getApplicationType(), (String)"");
            ((RestData)this.data).mediaType = applicationType.equals("XML") ? MediaType.APPLICATION_XML_TYPE : (applicationType.equals("JSON") ? MediaType.APPLICATION_JSON_TYPE : (applicationType.equals("OCTET STREAM") ? MediaType.APPLICATION_OCTET_STREAM_TYPE : (applicationType.equals("XHTML") ? MediaType.APPLICATION_XHTML_XML_TYPE : (applicationType.equals("FORM URLENCODED") ? MediaType.APPLICATION_FORM_URLENCODED_TYPE : (applicationType.equals("ATOM XML") ? MediaType.APPLICATION_ATOM_XML_TYPE : (applicationType.equals("SVG XML") ? MediaType.APPLICATION_SVG_XML_TYPE : (applicationType.equals("TEXT XML") ? MediaType.TEXT_XML_TYPE : MediaType.TEXT_PLAIN_TYPE)))))));
            try {
                this.setConfig();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"Rest.Error.Config", (String[])new String[0]), e);
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        ((RestData)this.data).config = null;
        ((RestData)this.data).headerNames = null;
        ((RestData)this.data).indexOfHeaderFields = null;
        ((RestData)this.data).paramNames = null;
        super.dispose();
    }
}

