/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pgpdecryptstream;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.pgpdecryptstream.PGPDecryptStream;
import org.apache.hop.pipeline.transforms.pgpdecryptstream.PGPDecryptStreamData;
import org.w3c.dom.Node;

@Transform(id="PGPDecryptStream", image="pgpdecryptstream.svg", description="i18n::PGPDecryptStream.Description", name="i18n::PGPDecryptStream.Name", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Cryptography", documentationUrl="/pipeline/transforms/pgpdecryptstream.html")
public class PGPDecryptStreamMeta
extends BaseTransformMeta
implements ITransformMeta<PGPDecryptStream, PGPDecryptStreamData> {
    private static final Class<?> PKG = PGPDecryptStreamMeta.class;
    private String gpgLocation;
    private String passhrase;
    private boolean passphraseFromField;
    private String passphraseFieldName;
    private String streamfield;
    private String resultfieldname;

    public void setGPGLocation(String gpgLocation) {
        this.gpgLocation = gpgLocation;
    }

    public String getGPGLocation() {
        return this.gpgLocation;
    }

    public String getStreamField() {
        return this.streamfield;
    }

    public void setStreamField(String streamfield) {
        this.streamfield = streamfield;
    }

    public String getPassphraseFieldName() {
        return this.passphraseFieldName;
    }

    public void setPassphraseFieldName(String passphraseFieldName) {
        this.passphraseFieldName = passphraseFieldName;
    }

    public boolean isPassphraseFromField() {
        return this.passphraseFromField;
    }

    public void setPassphraseFromField(boolean passphraseFromField) {
        this.passphraseFromField = passphraseFromField;
    }

    public String getResultFieldName() {
        return this.resultfieldname;
    }

    public void setResultFieldName(String resultfieldname) {
        this.resultfieldname = resultfieldname;
    }

    public String getPassphrase() {
        return this.passhrase;
    }

    public void setPassphrase(String passhrase) {
        this.passhrase = passhrase;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public Object clone() {
        PGPDecryptStreamMeta retval = (PGPDecryptStreamMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.resultfieldname = "result";
        this.streamfield = null;
        this.passhrase = null;
        this.gpgLocation = null;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!Utils.isEmpty((CharSequence)this.resultfieldname)) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.resultfieldname));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XmlHandler.addTagValue((String)"gpglocation", (String)this.gpgLocation));
        retval.append("    ").append(XmlHandler.addTagValue((String)"passhrase", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.passhrase)));
        retval.append("    " + XmlHandler.addTagValue((String)"streamfield", (String)this.streamfield));
        retval.append("    " + XmlHandler.addTagValue((String)"resultfieldname", (String)this.resultfieldname));
        retval.append("    " + XmlHandler.addTagValue((String)"passphraseFromField", (boolean)this.passphraseFromField));
        retval.append("    " + XmlHandler.addTagValue((String)"passphraseFieldName", (String)this.passphraseFieldName));
        return retval.toString();
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.gpgLocation = XmlHandler.getTagValue((Node)transformNode, (String)"gpglocation");
            this.passhrase = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)"passhrase"));
            this.streamfield = XmlHandler.getTagValue((Node)transformNode, (String)"streamfield");
            this.resultfieldname = XmlHandler.getTagValue((Node)transformNode, (String)"resultfieldname");
            this.passphraseFromField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"passphraseFromField"));
            this.passphraseFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"passphraseFieldName");
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.Exception.UnableToReadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (Utils.isEmpty((CharSequence)this.gpgLocation)) {
            errorMessage = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.GPGLocationMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.GPGLocationOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
        }
        if (!this.isPassphraseFromField()) {
            if (Utils.isEmpty((CharSequence)this.passhrase)) {
                errorMessage = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.PassphraseMissing", (String[])new String[0]);
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                errorMessage = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.PassphraseOK", (String[])new String[0]);
                cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            }
        }
        if (Utils.isEmpty((CharSequence)this.resultfieldname)) {
            errorMessage = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.streamfield)) {
            errorMessage = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.StreamFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.StreamFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PGPDecryptStreamMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public ITransform createTransform(TransformMeta transformMeta, PGPDecryptStreamData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new PGPDecryptStream(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public PGPDecryptStreamData getTransformData() {
        return new PGPDecryptStreamData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

