/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cassandrasstableoutput;

import java.io.File;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cassandrasstableoutput.SSTableOutputMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SSTableOutputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = SSTableOutputMeta.class;
    private final SSTableOutputMeta input;
    private TextVar wYaml;
    private TextVar wDirectory;
    private TextVar wKeyspace;
    private TextVar wTable;
    private Label wlKeyField;
    private CCombo wKeyField;
    private TextVar wBufferSize;
    private Button wbGetFields;

    public SSTableOutputDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String name) {
        super(parent, variables, (BaseTransformMeta)in, tr, name);
        this.input = (SSTableOutputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SSTableOutputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"SSTableOutputDialog.transformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)fd);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fd);
        Label wlYaml = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlYaml);
        wlYaml.setText(BaseMessages.getString(PKG, (String)"SSTableOutputDialog.YAML.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.wTransformName, margin);
        fd.right = new FormAttachment(middle, -margin);
        wlYaml.setLayoutData((Object)fd);
        Button wbYaml = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbYaml);
        wbYaml.setText(BaseMessages.getString(PKG, (String)"SSTableOutputDialog.YAML.Button", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.wTransformName, margin);
        wbYaml.setLayoutData((Object)fd);
        wbYaml.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SSTableOutputDialog.this.shell, 4096);
                String[] extensions = null;
                String[] filterNames = null;
                extensions = new String[2];
                filterNames = new String[2];
                extensions[0] = "*.yaml";
                filterNames[0] = BaseMessages.getString((Class)PKG, (String)"SSTableOutputDialog.FileType.YAML", (String[])new String[0]);
                extensions[1] = "*";
                filterNames[1] = BaseMessages.getString((Class)PKG, (String)"System.FileType.AllFiles", (String[])new String[0]);
                dialog.setFilterExtensions(extensions);
                dialog.setFilterNames(filterNames);
                if (dialog.open() != null) {
                    String path = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                    path = new File(path).toURI().toString();
                    SSTableOutputDialog.this.wYaml.setText(path);
                }
            }
        });
        this.wYaml = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wYaml);
        this.wYaml.addModifyListener(e -> this.wYaml.setToolTipText(this.variables.resolve(this.wYaml.getText())));
        fd = new FormData();
        fd.right = new FormAttachment((Control)wbYaml, 0);
        fd.top = new FormAttachment((Control)this.wTransformName, margin);
        fd.left = new FormAttachment(middle, 0);
        this.wYaml.setLayoutData((Object)fd);
        Label wlDirectory = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlDirectory);
        wlDirectory.setText(BaseMessages.getString(PKG, (String)"SSTableOutputDialog.Directory.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.wYaml, margin);
        fd.right = new FormAttachment(middle, -margin);
        wlDirectory.setLayoutData((Object)fd);
        Button wbDirectory = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbDirectory);
        wbDirectory.setText(BaseMessages.getString(PKG, (String)"SSTableOutputDialog.Directory.Button", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.wYaml, margin);
        wbDirectory.setLayoutData((Object)fd);
        wbDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SSTableOutputDialog.this.shell, 4096);
                if (dialog.open() != null) {
                    String path = dialog.getFilterPath();
                    path = new File(path).toURI().toString();
                    SSTableOutputDialog.this.wDirectory.setText(path);
                }
            }
        });
        this.wDirectory = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDirectory);
        this.wDirectory.addModifyListener(e -> this.wDirectory.setToolTipText(this.variables.resolve(this.wDirectory.getText())));
        fd = new FormData();
        fd.right = new FormAttachment((Control)wbDirectory, 0);
        fd.top = new FormAttachment((Control)this.wYaml, margin);
        fd.left = new FormAttachment(middle, 0);
        this.wDirectory.setLayoutData((Object)fd);
        Label wlKeyspace = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlKeyspace);
        wlKeyspace.setText(BaseMessages.getString(PKG, (String)"SSTableOutputDialog.Keyspace.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.wDirectory, margin);
        fd.right = new FormAttachment(middle, -margin);
        wlKeyspace.setLayoutData((Object)fd);
        this.wKeyspace = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wKeyspace);
        this.wKeyspace.addModifyListener(e -> this.wKeyspace.setToolTipText(this.variables.resolve(this.wKeyspace.getText())));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.wDirectory, margin);
        fd.left = new FormAttachment(middle, 0);
        this.wKeyspace.setLayoutData((Object)fd);
        Label wlTable = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlTable);
        wlTable.setText(BaseMessages.getString(PKG, (String)"SSTableOutputDialog.Table.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.wKeyspace, margin);
        fd.right = new FormAttachment(middle, -margin);
        wlTable.setLayoutData((Object)fd);
        this.wTable = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(e -> this.wTable.setToolTipText(this.variables.resolve(this.wTable.getText())));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.wKeyspace, margin);
        fd.left = new FormAttachment(middle, 0);
        this.wTable.setLayoutData((Object)fd);
        this.wlKeyField = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.wlKeyField);
        this.wlKeyField.setText(BaseMessages.getString(PKG, (String)"SSTableOutputDialog.KeyField.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.wTable, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.wlKeyField.setLayoutData((Object)fd);
        this.wbGetFields = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbGetFields);
        this.wbGetFields.setText(BaseMessages.getString(PKG, (String)"SSTableOutputDialog.GetFields.Button", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.wTable, 0);
        this.wbGetFields.setLayoutData((Object)fd);
        this.wbGetFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SSTableOutputDialog.this.showEnterSelectionDialog();
            }
        });
        this.wKeyField = new CCombo((Composite)this.shell, 2048);
        this.wKeyField.addModifyListener(e -> this.wKeyField.setToolTipText(this.variables.resolve(this.wKeyField.getText())));
        fd = new FormData();
        fd.right = new FormAttachment((Control)this.wbGetFields, -margin);
        fd.top = new FormAttachment((Control)this.wTable, margin);
        fd.left = new FormAttachment(middle, 0);
        this.wKeyField.setLayoutData((Object)fd);
        Label wlBufferSize = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlBufferSize);
        wlBufferSize.setText(BaseMessages.getString(PKG, (String)"SSTableOutputDialog.BufferSize.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.wKeyField, margin);
        fd.right = new FormAttachment(middle, -margin);
        wlBufferSize.setLayoutData((Object)fd);
        this.wBufferSize = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wBufferSize);
        this.wBufferSize.addModifyListener(e -> this.wBufferSize.setToolTipText(this.variables.resolve(this.wBufferSize.getText())));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.wKeyField, margin);
        fd.left = new FormAttachment(middle, 0);
        this.wBufferSize.setLayoutData((Object)fd);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wBufferSize);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void onCql3CheckSelection() {
        this.wbGetFields.setText(BaseMessages.getString(PKG, (String)"SSTableOutputDialog.SelectFields.Button", (String[])new String[0]));
        this.wlKeyField.setText(BaseMessages.getString(PKG, (String)"SSTableOutputDialog.KeyFields.Label", (String[])new String[0]));
    }

    protected void setupFieldsCombo() {
        TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
        if (transformMeta != null) {
            try {
                IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                if (row.size() == 0) {
                    BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"SSTableOutputData.Message.NoIncomingFields.Title", (String[])new String[0]), (String)BaseMessages.getString(PKG, (String)"SSTableOutputData.Message.NoIncomingFields", (String[])new String[0]), (int)33);
                    return;
                }
                this.wKeyField.removeAll();
                for (int i = 0; i < row.size(); ++i) {
                    IValueMeta vm = row.getValueMeta(i);
                    this.wKeyField.add(vm.getName());
                }
            }
            catch (HopException ex) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SSTableOutputData.Message.NoIncomingFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSTableOutputData.Message.NoIncomingFields", (String[])new String[0]), (Exception)((Object)ex));
            }
        }
    }

    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setYamlPath(this.wYaml.getText());
        this.input.setDirectory(this.wDirectory.getText());
        this.input.setCassandraKeyspace(this.wKeyspace.getText());
        this.input.setTableName(this.wTable.getText());
        this.input.setKeyField(this.wKeyField.getText());
        this.input.setBufferSize(this.wBufferSize.getText());
        this.input.setChanged();
        this.dispose();
    }

    protected void cancel() {
        this.transformName = null;
        this.dispose();
    }

    protected void getData() {
        if (!Utils.isEmpty((CharSequence)this.input.getYamlPath())) {
            this.wYaml.setText(this.input.getYamlPath());
        }
        if (!Utils.isEmpty((CharSequence)this.input.getDirectory())) {
            this.wDirectory.setText(this.input.getDirectory());
        }
        if (!Utils.isEmpty((CharSequence)this.input.getCassandraKeyspace())) {
            this.wKeyspace.setText(this.input.getCassandraKeyspace());
        }
        if (!Utils.isEmpty((CharSequence)this.input.getTableName())) {
            this.wTable.setText(this.input.getTableName());
        }
        if (!Utils.isEmpty((CharSequence)this.input.getKeyField())) {
            this.wKeyField.setText(this.input.getKeyField());
        }
        if (!Utils.isEmpty((CharSequence)this.input.getBufferSize())) {
            this.wBufferSize.setText(this.input.getBufferSize());
        }
        this.onCql3CheckSelection();
    }

    protected void showEnterSelectionDialog() {
        TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
        String[] choices = null;
        if (transformMeta != null) {
            try {
                IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                if (row.size() == 0) {
                    BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"SSTableOutputData.Message.NoIncomingFields.Title", (String[])new String[0]), (String)BaseMessages.getString(PKG, (String)"SSTableOutputData.Message.NoIncomingFields", (String[])new String[0]), (int)33);
                    return;
                }
                choices = new String[row.size()];
                for (int i = 0; i < row.size(); ++i) {
                    IValueMeta vm = row.getValueMeta(i);
                    choices[i] = vm.getName();
                }
                EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, choices, BaseMessages.getString(PKG, (String)"CassandraOutputDialog.SelectKeyFieldsDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraOutputDialog.SelectKeyFieldsDialog.Message", (String[])new String[0]));
                dialog.setMulti(true);
                if (!Utils.isEmpty((CharSequence)this.wKeyField.getText())) {
                    String current = this.wKeyField.getText();
                    String[] parts = current.split(",");
                    int[] currentSelection = new int[parts.length];
                    int count = 0;
                    String[] stringArray = parts;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String s = stringArray[i];
                        int index = row.indexOfValue(s.trim());
                        if (index < 0) continue;
                        currentSelection[count++] = index;
                    }
                    dialog.setSelectedNrs(currentSelection);
                }
                dialog.open();
                int[] selected = dialog.getSelectionIndeces();
                if (selected != null && selected.length > 0) {
                    StringBuilder newSelection = new StringBuilder();
                    boolean first = true;
                    for (int i : selected) {
                        if (first) {
                            newSelection.append(choices[i]);
                            first = false;
                            continue;
                        }
                        newSelection.append(",").append(choices[i]);
                    }
                    this.wKeyField.setText(newSelection.toString());
                }
            }
            catch (HopException ex) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CassandraOutputData.Message.NoIncomingFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraOutputData.Message.NoIncomingFields", (String[])new String[0]), (Exception)((Object)ex));
            }
        }
    }
}

