/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cassandrasstableoutput;

import java.io.File;
import java.net.URI;
import java.security.Permission;
import java.util.HashMap;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cassandrasstableoutput.SSTableOutputData;
import org.apache.hop.pipeline.transforms.cassandrasstableoutput.SSTableOutputMeta;
import org.apache.hop.pipeline.transforms.cassandrasstableoutput.writer.AbstractSSTableWriter;
import org.apache.hop.pipeline.transforms.cassandrasstableoutput.writer.SSTableWriterBuilder;

public class SSTableOutput
extends BaseTransform<SSTableOutputMeta, SSTableOutputData>
implements ITransform<SSTableOutputMeta, SSTableOutputData> {
    private static final SecurityManager sm = System.getSecurityManager();
    protected int rowsSeen;
    protected AbstractSSTableWriter writer;
    protected IRowMeta inputMetadata;
    private String[] fieldNames;
    private int[] fieldValueIndices;

    public SSTableOutput(TransformMeta transformMeta, SSTableOutputMeta meta, SSTableOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private void initialize() throws Exception {
        this.first = false;
        this.rowsSeen = 0;
        this.inputMetadata = this.getInputRowMeta();
        String yamlPath = this.resolve(((SSTableOutputMeta)this.getMeta()).getYamlPath());
        String directory = this.resolve(((SSTableOutputMeta)this.getMeta()).getDirectory());
        String keyspace = this.resolve(((SSTableOutputMeta)this.getMeta()).getCassandraKeyspace());
        String table = this.resolve(((SSTableOutputMeta)this.getMeta()).getTableName());
        String keyField = this.resolve(((SSTableOutputMeta)this.getMeta()).getKeyField());
        String bufferSize = this.resolve(((SSTableOutputMeta)this.getMeta()).getBufferSize());
        if (Utils.isEmpty((CharSequence)yamlPath)) {
            throw new Exception(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.NoPathToYAML", (String[])new String[0]));
        }
        this.logBasic(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Message.YAMLPath", (String[])new String[]{yamlPath}));
        File outputDir = Utils.isEmpty((CharSequence)directory) ? new File(System.getProperty("java.io.tmpdir")) : new File(new URI(directory));
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new HopException(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.OutputDirDoesntExist", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)table)) {
            throw new HopException(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.NoTableSpecified", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)keyField)) {
            throw new HopException(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.NoKeySpecified", (String[])new String[0]));
        }
        this.fieldNames = this.inputMetadata.getFieldNames();
        this.fieldValueIndices = new int[this.fieldNames.length];
        for (int i = 0; i < this.fieldNames.length; ++i) {
            this.fieldValueIndices[i] = this.inputMetadata.indexOfValue(this.fieldNames[i]);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        SSTableWriterBuilder builder = new SSTableWriterBuilder().withConfig(yamlPath).withDirectory(outputDir.getAbsolutePath()).withKeyspace(keyspace).withTable(table).withRowMeta(this.getInputRowMeta()).withPrimaryKey(keyField).withCqlVersion(((SSTableOutputMeta)this.getMeta()).getUseCql3() ? 3 : 2);
        try {
            builder.withBufferSize(Integer.parseInt(bufferSize));
        }
        catch (NumberFormatException nfe) {
            this.logBasic(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Message.DefaultBufferSize", (String[])new String[0]));
        }
        this.writer = builder.build();
        try {
            this.disableSystemExit(sm, this.log);
            this.writer.init();
        }
        catch (Exception e) {
            throw new RuntimeException(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.InvalidConfig", (String[])new String[0]), e);
        }
        finally {
            if (System.getSecurityManager() != sm) {
                System.setSecurityManager(sm);
            }
        }
    }

    void disableSystemExit(SecurityManager sm, ILogChannel log) {
        try {
            System.setSecurityManager(new NoSystemExitDelegatingSecurityManager(sm));
        }
        catch (SecurityException se) {
            log.logError(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.JVMExitProtection", (String[])new String[0]), (Throwable)se);
        }
    }

    public boolean processRow() throws HopException {
        if (this.isStopped()) {
            return false;
        }
        Object[] r = this.getRow();
        if (this.first) {
            try {
                this.initialize();
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.WriterInitFailed", (String[])new String[0]), (Throwable)e);
            }
        }
        try {
            if (r == null) {
                this.setOutputDone();
                this.closeWriter();
                return false;
            }
            HashMap<String, Object> record = new HashMap<String, Object>();
            for (int i = 0; i < this.fieldNames.length; ++i) {
                Object value = r[this.fieldValueIndices[i]];
                if (value == null || "".equals(value)) continue;
                record.put(this.fieldNames[i], value);
            }
            this.writer.processRow(record);
            this.incrementLinesWritten();
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.FailedToProcessRow", (String[])new String[0]), e);
            this.putError(this.getInputRowMeta(), r, 1L, e.getMessage(), null, "ERR_SSTABLE_OUTPUT_01");
            this.incrementLinesRejected();
        }
        return true;
    }

    public void setStopped(boolean stopped) {
        super.setStopped(stopped);
        if (stopped) {
            this.closeWriter();
        }
    }

    public void closeWriter() {
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.FailedToCloseWriter", (String[])new String[0]), e);
            }
        }
    }

    private class NoSystemExitDelegatingSecurityManager
    extends SecurityManager {
        private SecurityManager delegate;

        NoSystemExitDelegatingSecurityManager(SecurityManager delegate) {
            this.delegate = delegate;
        }

        @Override
        public void checkPermission(Permission perm) {
            if (this.delegate != null) {
                this.delegate.checkPermission(perm);
            }
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
            if (this.delegate != null) {
                this.delegate.checkPermission(perm, context);
            }
        }

        @Override
        public void checkExit(int status) {
            throw new JVMShutdownAttemptedException();
        }
    }

    private class JVMShutdownAttemptedException
    extends SecurityException {
        private JVMShutdownAttemptedException() {
        }
    }
}

