/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.cassandra.datastax;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TableMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBigNumber;
import org.apache.hop.core.row.value.ValueMetaBinary;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.databases.cassandra.datastax.DriverKeyspace;
import org.apache.hop.databases.cassandra.spi.ITableMetaData;
import org.apache.hop.databases.cassandra.spi.Keyspace;
import org.apache.hop.databases.cassandra.util.Selector;

public class TableMetaData
implements ITableMetaData {
    private DriverKeyspace keyspace;
    private TableMetadata meta;
    private String name;
    private boolean expandCollection = true;

    public TableMetaData(DriverKeyspace keyspace, TableMetadata metadata) {
        this.meta = metadata;
        this.name = this.meta.getName();
        this.setKeyspace(keyspace);
    }

    @Override
    public void setKeyspace(Keyspace keyspace) {
        this.keyspace = (DriverKeyspace)keyspace;
        this.expandCollection = this.keyspace.getConnection().isExpandCollection();
    }

    @Override
    public void setTableName(String tableName) {
        this.name = tableName;
    }

    @Override
    public String getTableName() {
        return this.name;
    }

    @Override
    public String describe() throws Exception {
        return this.meta.exportAsString();
    }

    @Override
    public boolean columnExistsInSchema(String colName) {
        return this.meta.getColumn(colName) != null;
    }

    @Override
    public IValueMeta getValueMetaForKey() {
        List partKeys = this.meta.getPartitionKey();
        if (partKeys.size() > 1) {
            return new ValueMetaString("KEY");
        }
        return this.toValueMeta(((ColumnMetadata)partKeys.get(0)).getName(), ((ColumnMetadata)partKeys.get(0)).getType());
    }

    @Override
    public List<String> getKeyColumnNames() {
        return this.meta.getPrimaryKey().stream().map(col -> col.getName()).collect(Collectors.toList());
    }

    @Override
    public IValueMeta getValueMetaForColumn(String colName) {
        ColumnMetadata column = this.meta.getColumn(colName);
        return this.getValueMetaForColumn(column);
    }

    protected IValueMeta getValueMetaForColumn(ColumnMetadata column) {
        if (column != null) {
            return this.toValueMeta(column.getName(), column.getType());
        }
        return new ValueMetaString(this.name);
    }

    @Override
    public List<IValueMeta> getValueMetasForSchema() {
        return this.meta.getColumns().stream().map(col -> this.getValueMetaForColumn((ColumnMetadata)col)).collect(Collectors.toList());
    }

    @Override
    public IValueMeta getValueMeta(Selector selector) {
        String name = selector.getColumnName();
        return this.getValueMetaForColumn(name);
    }

    @Override
    public List<String> getColumnNames() {
        List colMeta = this.meta.getColumns();
        ArrayList<String> colNames = new ArrayList<String>();
        for (ColumnMetadata c : colMeta) {
            colNames.add(c.getName());
        }
        return colNames;
    }

    @Override
    public DataType getColumnCQLType(String colName) {
        return this.meta.getColumn(colName).getType();
    }

    protected IValueMeta toValueMeta(String name, DataType dataType) {
        if (this.expandCollection && dataType.isCollection() && dataType.getName().equals((Object)DataType.Name.MAP)) {
            dataType = (DataType)dataType.getTypeArguments().get(0);
        }
        switch (dataType.getName()) {
            case BIGINT: 
            case COUNTER: 
            case INT: 
            case SMALLINT: 
            case TINYINT: {
                return new ValueMetaInteger(name);
            }
            case DOUBLE: 
            case FLOAT: {
                return new ValueMetaNumber(name);
            }
            case DATE: 
            case TIMESTAMP: {
                return new ValueMetaDate(name);
            }
            case DECIMAL: 
            case VARINT: {
                return new ValueMetaBigNumber(name);
            }
            case BLOB: {
                return new ValueMetaBinary(name);
            }
            case BOOLEAN: {
                return new ValueMetaBoolean(name);
            }
        }
        return new ValueMetaString(name);
    }
}

