/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.kafka.producer;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.kafka.producer.KafkaProducerOutput;
import org.apache.hop.pipeline.transforms.kafka.producer.KafkaProducerOutputData;
import org.w3c.dom.Node;

@Transform(id="KafkaProducerOutput", image="KafkaProducerOutput.svg", name="i18n::KafkaProducer.TypeLongDesc", description="i18n::KafkaProducer.TypeTooltipDesc", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Streaming", keywords={"kafka,producer,output"}, documentationUrl="/pipeline/transforms/kafkaproducer.html")
@InjectionSupported(localizationPrefix="KafkaProducerOutputMeta.Injection.", groups={"CONFIGURATION_PROPERTIES"})
public class KafkaProducerOutputMeta
extends BaseTransformMeta
implements ITransformMeta<KafkaProducerOutput, KafkaProducerOutputData> {
    public static final String DIRECT_BOOTSTRAP_SERVERS = "directBootstrapServers";
    public static final String CLIENT_ID = "clientId";
    public static final String TOPIC = "topic";
    public static final String KEY_FIELD = "keyField";
    public static final String MESSAGE_FIELD = "messageField";
    public static final String ADVANCED_CONFIG = "advancedConfig";
    public static final String CONFIG_OPTION = "option";
    public static final String OPTION_PROPERTY = "property";
    public static final String OPTION_VALUE = "value";
    @Injection(name="DIRECT_BOOTSTRAP_SERVERS")
    private String directBootstrapServers;
    @Injection(name="CLIENT_ID")
    private String clientId;
    @Injection(name="TOPIC")
    private String topicVal;
    @Injection(name="KEY_FIELD")
    private String keyField;
    @Injection(name="MESSAGE_FIELD")
    private String messageField;
    @Injection(name="NAMES", group="CONFIGURATION_PROPERTIES")
    protected List<String> injectedConfigNames;
    @Injection(name="VALUES", group="CONFIGURATION_PROPERTIES")
    protected List<String> injectedConfigValues;
    private Map<String, String> config = new LinkedHashMap<String, String>();

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) {
        this.setDirectBootstrapServers(XmlHandler.getTagValue((Node)transformNode, (String)DIRECT_BOOTSTRAP_SERVERS));
        this.setClientId(XmlHandler.getTagValue((Node)transformNode, (String)CLIENT_ID));
        this.setTopic(XmlHandler.getTagValue((Node)transformNode, (String)TOPIC));
        this.setKeyField(XmlHandler.getTagValue((Node)transformNode, (String)KEY_FIELD));
        this.setMessageField(XmlHandler.getTagValue((Node)transformNode, (String)MESSAGE_FIELD));
        this.config = new LinkedHashMap<String, String>();
        Optional.ofNullable(XmlHandler.getSubNode((Node)transformNode, (String)ADVANCED_CONFIG)).map(Node::getChildNodes).ifPresent(nodes -> IntStream.range(0, nodes.getLength()).mapToObj(nodes::item).filter(node -> node.getNodeType() == 1).forEach(node -> {
            if (CONFIG_OPTION.equals(node.getNodeName())) {
                this.config.put(node.getAttributes().getNamedItem(OPTION_PROPERTY).getTextContent(), node.getAttributes().getNamedItem(OPTION_VALUE).getTextContent());
            } else {
                this.config.put(node.getNodeName(), node.getTextContent());
            }
        }));
    }

    public void setDefault() {
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
    }

    public KafkaProducerOutput createTransform(TransformMeta transformMeta, KafkaProducerOutputData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new KafkaProducerOutput(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public KafkaProducerOutputData getTransformData() {
        return new KafkaProducerOutputData();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getTopic() {
        return this.topicVal;
    }

    public void setTopic(String topic) {
        this.topicVal = topic;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String getMessageField() {
        return this.messageField;
    }

    public void setMessageField(String messageField) {
        this.messageField = messageField;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XmlHandler.addTagValue((String)DIRECT_BOOTSTRAP_SERVERS, (String)this.directBootstrapServers));
        retval.append("    ").append(XmlHandler.addTagValue((String)TOPIC, (String)this.topicVal));
        retval.append("    ").append(XmlHandler.addTagValue((String)CLIENT_ID, (String)this.clientId));
        retval.append("    ").append(XmlHandler.addTagValue((String)KEY_FIELD, (String)this.keyField));
        retval.append("    ").append(XmlHandler.addTagValue((String)MESSAGE_FIELD, (String)this.messageField));
        retval.append("    ").append(XmlHandler.openTag((String)ADVANCED_CONFIG)).append(Const.CR);
        this.getConfig().forEach((key, value) -> retval.append("        ").append(XmlHandler.addTagValue((String)CONFIG_OPTION, (String)"", (boolean)true, (String[])new String[]{OPTION_PROPERTY, key, OPTION_VALUE, value})));
        retval.append("    ").append(XmlHandler.closeTag((String)ADVANCED_CONFIG)).append(Const.CR);
        return retval.toString();
    }

    public void setDirectBootstrapServers(String directBootstrapServers) {
        this.directBootstrapServers = directBootstrapServers;
    }

    public String getDirectBootstrapServers() {
        return this.directBootstrapServers;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public Map<String, String> getConfig() {
        this.applyInjectedProperties();
        return this.config;
    }

    protected void applyInjectedProperties() {
        if (this.injectedConfigNames != null || this.injectedConfigValues != null) {
            Preconditions.checkState((this.injectedConfigNames != null ? 1 : 0) != 0, (Object)"Options names were not injected");
            Preconditions.checkState((this.injectedConfigValues != null ? 1 : 0) != 0, (Object)"Options values were not injected");
            Preconditions.checkState((this.injectedConfigNames.size() == this.injectedConfigValues.size() ? 1 : 0) != 0, (Object)"Injected different number of options names and value");
            this.setConfig(IntStream.range(0, this.injectedConfigNames.size()).boxed().collect(Collectors.toMap(this.injectedConfigNames::get, this.injectedConfigValues::get, (v1, v2) -> v1, LinkedHashMap::new)));
            this.injectedConfigNames = null;
            this.injectedConfigValues = null;
        }
    }
}

