/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.kafka.producer;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transforms.kafka.producer.KafkaProducerOutputMeta;
import org.apache.hop.pipeline.transforms.kafka.shared.KafkaDialogHelper;
import org.apache.hop.pipeline.transforms.kafka.shared.KafkaFactory;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class KafkaProducerOutputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = KafkaProducerOutputMeta.class;
    private static final ImmutableMap<String, String> DEFAULT_OPTION_VALUES = ImmutableMap.of((Object)"compression.type", (Object)"none");
    private final KafkaFactory kafkaFactory = KafkaFactory.defaultFactory();
    private static final int SHELL_MIN_WIDTH = 527;
    private static final int SHELL_MIN_HEIGHT = 569;
    private final KafkaProducerOutputMeta meta;
    private ModifyListener lsMod;
    private TextVar wClientId;
    private ComboVar wTopic;
    private ComboVar wKeyField;
    private ComboVar wMessageField;
    private TableView optionsTable;
    private CTabFolder wTabFolder;
    private TextVar wBootstrapServers;

    public KafkaProducerOutputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String transformName) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, transformName);
        this.meta = (KafkaProducerOutputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.changed = this.meta.hasChanged();
        this.lsMod = e -> this.meta.setChanged();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.meta);
        this.shell.setMinimumSize(527, 569);
        this.shell.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.Shell.Title", (String[])new String[0]));
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, 0);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(0, 0);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 5);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label topSeparator = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.height = 2;
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wTransformName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        topSeparator.setLayoutData((Object)fdSpacer);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setUnselectedCloseVisible(true);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        KafkaProducerOutputDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)this.props.getMargin(), null);
        Label bottomSeparator = new Label((Composite)this.shell, 258);
        this.props.setLook((Control)bottomSeparator);
        FormData fdBottomSeparator = new FormData();
        fdBottomSeparator.height = 2;
        fdBottomSeparator.left = new FormAttachment(0, 0);
        fdBottomSeparator.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdBottomSeparator.right = new FormAttachment(100, 0);
        bottomSeparator.setLayoutData((Object)fdBottomSeparator);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)topSeparator, 15);
        fdTabFolder.bottom = new FormAttachment((Control)bottomSeparator, -15);
        fdTabFolder.right = new FormAttachment(100, 0);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.buildSetupTab();
        this.buildOptionsTab();
        this.getData();
        this.meta.setChanged(this.changed);
        this.wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void buildSetupTab() {
        CTabItem wSetupTab = new CTabItem(this.wTabFolder, 0);
        wSetupTab.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.SetupTab", (String[])new String[0]));
        Composite wSetupComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wSetupComp);
        FormLayout setupLayout = new FormLayout();
        setupLayout.marginHeight = 15;
        setupLayout.marginWidth = 15;
        wSetupComp.setLayout((Layout)setupLayout);
        Label wlBootstrapServers = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlBootstrapServers);
        wlBootstrapServers.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.BootstrapServers", (String[])new String[0]));
        FormData fdlBootstrapServers = new FormData();
        fdlBootstrapServers.left = new FormAttachment(0, 0);
        fdlBootstrapServers.top = new FormAttachment(0, 0);
        fdlBootstrapServers.right = new FormAttachment(100, 0);
        wlBootstrapServers.setLayoutData((Object)fdlBootstrapServers);
        this.wBootstrapServers = new TextVar(this.variables, wSetupComp, 18436);
        this.props.setLook((Control)this.wBootstrapServers);
        this.wBootstrapServers.addModifyListener(this.lsMod);
        FormData fdBootstrapServers = new FormData();
        fdBootstrapServers.left = new FormAttachment(0, 0);
        fdBootstrapServers.top = new FormAttachment((Control)wlBootstrapServers, this.props.getMargin());
        fdBootstrapServers.right = new FormAttachment(100, 0);
        this.wBootstrapServers.setLayoutData((Object)fdBootstrapServers);
        Label wlClientId = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlClientId);
        wlClientId.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.ClientId", (String[])new String[0]));
        FormData fdlClientId = new FormData();
        fdlClientId.left = new FormAttachment(0, 0);
        fdlClientId.top = new FormAttachment((Control)this.wBootstrapServers, 2 * this.props.getMargin());
        fdlClientId.right = new FormAttachment(100, 0);
        wlClientId.setLayoutData((Object)fdlClientId);
        this.wClientId = new TextVar(this.variables, wSetupComp, 18436);
        this.props.setLook((Control)this.wClientId);
        this.wClientId.addModifyListener(this.lsMod);
        FormData fdClientId = new FormData();
        fdClientId.left = new FormAttachment(0, 0);
        fdClientId.top = new FormAttachment((Control)wlClientId, this.props.getMargin());
        fdClientId.right = new FormAttachment(100, 0);
        this.wClientId.setLayoutData((Object)fdClientId);
        Label wlTopic = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlTopic);
        wlTopic.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.Topic", (String[])new String[0]));
        FormData fdlTopic = new FormData();
        fdlTopic.left = new FormAttachment(0, 0);
        fdlTopic.top = new FormAttachment((Control)this.wClientId, 2 * this.props.getMargin());
        fdlTopic.right = new FormAttachment(100, 0);
        wlTopic.setLayoutData((Object)fdlTopic);
        this.wTopic = new ComboVar(this.variables, wSetupComp, 18436);
        this.props.setLook((Control)this.wTopic);
        this.wTopic.addModifyListener(this.lsMod);
        FormData fdTopic = new FormData();
        fdTopic.left = new FormAttachment(0, 0);
        fdTopic.top = new FormAttachment((Control)wlTopic, this.props.getMargin());
        fdTopic.right = new FormAttachment(100, 0);
        this.wTopic.setLayoutData((Object)fdTopic);
        this.wTopic.getCComboWidget().addListener(15, event -> {
            KafkaDialogHelper kafkaDialogHelper = new KafkaDialogHelper(this.variables, this.wTopic, this.wBootstrapServers, this.kafkaFactory, this.optionsTable, this.meta.getParentTransformMeta());
            kafkaDialogHelper.clusterNameChanged(event);
        });
        Label wlKeyField = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlKeyField);
        wlKeyField.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.KeyField", (String[])new String[0]));
        FormData fdlKeyField = new FormData();
        fdlKeyField.left = new FormAttachment(0, 0);
        fdlKeyField.top = new FormAttachment((Control)this.wTopic, 2 * this.props.getMargin());
        fdlKeyField.right = new FormAttachment(100, 0);
        wlKeyField.setLayoutData((Object)fdlKeyField);
        this.wKeyField = new ComboVar(this.variables, wSetupComp, 18436);
        this.props.setLook((Control)this.wKeyField);
        this.wKeyField.addModifyListener(this.lsMod);
        FormData fdKeyField = new FormData();
        fdKeyField.left = new FormAttachment(0, 0);
        fdKeyField.top = new FormAttachment((Control)wlKeyField, this.props.getMargin());
        fdKeyField.right = new FormAttachment(100, 0);
        this.wKeyField.setLayoutData((Object)fdKeyField);
        Listener lsKeyFocus = e -> KafkaDialogHelper.populateFieldsList(this.variables, this.pipelineMeta, this.wKeyField, this.transformName);
        this.wKeyField.getCComboWidget().addListener(15, lsKeyFocus);
        Label wlMessageField = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlMessageField);
        wlMessageField.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.MessageField", (String[])new String[0]));
        FormData fdlMessageField = new FormData();
        fdlMessageField.left = new FormAttachment(0, 0);
        fdlMessageField.top = new FormAttachment((Control)this.wKeyField, 2 * this.props.getMargin());
        fdlMessageField.right = new FormAttachment(100, 0);
        wlMessageField.setLayoutData((Object)fdlMessageField);
        this.wMessageField = new ComboVar(this.variables, wSetupComp, 18436);
        this.props.setLook((Control)this.wMessageField);
        this.wMessageField.addModifyListener(this.lsMod);
        FormData fdMessageField = new FormData();
        fdMessageField.left = new FormAttachment(0, 0);
        fdMessageField.top = new FormAttachment((Control)wlMessageField, this.props.getMargin());
        fdMessageField.right = new FormAttachment(100, 0);
        this.wMessageField.setLayoutData((Object)fdMessageField);
        Listener lsMessageFocus = e -> KafkaDialogHelper.populateFieldsList(this.variables, this.pipelineMeta, this.wMessageField, this.transformName);
        this.wMessageField.getCComboWidget().addListener(15, lsMessageFocus);
        FormData fdSetupComp = new FormData();
        fdSetupComp.left = new FormAttachment(0, 0);
        fdSetupComp.top = new FormAttachment(0, 0);
        fdSetupComp.right = new FormAttachment(100, 0);
        fdSetupComp.bottom = new FormAttachment(100, 0);
        wSetupComp.setLayoutData((Object)fdSetupComp);
        wSetupComp.layout();
        wSetupTab.setControl((Control)wSetupComp);
    }

    private void buildOptionsTab() {
        CTabItem wOptionsTab = new CTabItem(this.wTabFolder, 0);
        wOptionsTab.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.Options.Tab", (String[])new String[0]));
        Composite wOptionsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wOptionsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginHeight = 15;
        fieldsLayout.marginWidth = 15;
        wOptionsComp.setLayout((Layout)fieldsLayout);
        FormData optionsFormData = new FormData();
        optionsFormData.left = new FormAttachment(0, 0);
        optionsFormData.top = new FormAttachment((Control)wOptionsComp, 0);
        optionsFormData.right = new FormAttachment(100, 0);
        optionsFormData.bottom = new FormAttachment(100, 0);
        wOptionsComp.setLayoutData((Object)optionsFormData);
        this.buildOptionsTable(wOptionsComp);
        wOptionsComp.layout();
        wOptionsTab.setControl((Control)wOptionsComp);
    }

    private void buildOptionsTable(Composite parentWidget) {
        ColumnInfo[] columns = this.getOptionsColumns();
        if (this.meta.getConfig().size() == 0) {
            List<String> list = KafkaDialogHelper.getProducerAdvancedConfigOptionNames();
            LinkedHashMap<String, String> advancedConfig = new LinkedHashMap<String, String>();
            for (String item : list) {
                advancedConfig.put(item, (String)DEFAULT_OPTION_VALUES.getOrDefault((Object)item, (Object)""));
            }
            this.meta.setConfig(advancedConfig);
        }
        int fieldCount = this.meta.getConfig().size();
        this.optionsTable = new TableView(this.variables, parentWidget, 67586, columns, fieldCount, false, this.lsMod, this.props, false);
        this.optionsTable.setSortable(false);
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(0, 0);
        fdData.right = new FormAttachment(100, 0);
        fdData.bottom = new FormAttachment(100, 0);
        Arrays.stream(this.optionsTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(120);
            }
        });
        this.optionsTable.setLayoutData((Object)fdData);
    }

    private ColumnInfo[] getOptionsColumns() {
        ColumnInfo optionName = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.Options.Column.Name", (String[])new String[0]), 1, false, false);
        ColumnInfo value = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.Options.Column.Value", (String[])new String[0]), 1, false, false);
        value.setUsingVariables(true);
        return new ColumnInfo[]{optionName, value};
    }

    private void populateOptionsData() {
        int rowIndex = 0;
        for (Map.Entry<String, String> entry : this.meta.getConfig().entrySet()) {
            TableItem key = this.optionsTable.getTable().getItem(rowIndex++);
            key.setText(1, entry.getKey());
            key.setText(2, entry.getValue());
        }
        this.optionsTable.optimizeTableView();
    }

    private void getData() {
        this.wBootstrapServers.setText(Const.NVL((String)this.meta.getDirectBootstrapServers(), (String)""));
        this.wClientId.setText(Const.NVL((String)this.meta.getClientId(), (String)""));
        this.wTopic.setText(Const.NVL((String)this.meta.getTopic(), (String)""));
        this.wKeyField.setText(Const.NVL((String)this.meta.getKeyField(), (String)""));
        this.wMessageField.setText(Const.NVL((String)this.meta.getMessageField(), (String)""));
        this.populateOptionsData();
    }

    private void cancel() {
        this.meta.setChanged(false);
        this.dispose();
    }

    private void ok() {
        this.transformName = this.wTransformName.getText();
        this.meta.setDirectBootstrapServers(this.wBootstrapServers.getText());
        this.meta.setClientId(this.wClientId.getText());
        this.meta.setTopic(this.wTopic.getText());
        this.meta.setKeyField(this.wKeyField.getText());
        this.meta.setMessageField(this.wMessageField.getText());
        this.meta.setConfig(KafkaDialogHelper.getConfig(this.optionsTable));
        this.dispose();
    }
}

