/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.abort;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.abort.AbortData;
import org.apache.hop.pipeline.transforms.abort.AbortMeta;

public class Abort
extends BaseTransform<AbortMeta, AbortData>
implements ITransform<AbortMeta, AbortData> {
    private static final Class<?> PKG = Abort.class;
    private int nrInputRows;
    private int nrThresholdRows;

    public Abort(TransformMeta transformMeta, AbortMeta meta, AbortData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        if (super.init()) {
            this.nrInputRows = 0;
            String threshold = this.resolve(((AbortMeta)this.meta).getRowThreshold());
            this.nrThresholdRows = Const.toInt((String)threshold, (int)-1);
            if (this.nrThresholdRows < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"Abort.Log.ThresholdInvalid", (String[])new String[]{threshold}));
            }
            return true;
        }
        return false;
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        this.putRow(this.getInputRowMeta(), r);
        ++this.nrInputRows;
        if (this.nrInputRows > this.nrThresholdRows) {
            String abortOptionMessage = BaseMessages.getString(PKG, (String)"AbortDialog.Options.Abort.Label", (String[])new String[0]);
            if (((AbortMeta)this.meta).isAbortWithError()) {
                abortOptionMessage = BaseMessages.getString(PKG, (String)"AbortDialog.Options.AbortWithError.Label", (String[])new String[0]);
            } else if (((AbortMeta)this.meta).isSafeStop()) {
                abortOptionMessage = BaseMessages.getString(PKG, (String)"AbortDialog.Options.SafeStop.Label", (String[])new String[0]);
            }
            this.logError(BaseMessages.getString(PKG, (String)"Abort.Log.Wrote.AbortRow", (String[])new String[]{Long.toString(this.nrInputRows), abortOptionMessage, this.getInputRowMeta().getString(r)}));
            String message = this.resolve(((AbortMeta)this.meta).getMessage());
            if (message == null || message.length() == 0) {
                this.logError(BaseMessages.getString(PKG, (String)"Abort.Log.DefaultAbortMessage", (String[])new String[]{"" + this.nrInputRows}));
            } else {
                this.logError(message);
            }
            if (((AbortMeta)this.meta).isAbortWithError()) {
                this.setErrors(1L);
            }
            this.stopAll();
        } else if (((AbortMeta)this.meta).isAlwaysLogRows()) {
            this.logMinimal(BaseMessages.getString(PKG, (String)"Abort.Log.Wrote.Row", (String[])new String[]{Long.toString(this.nrInputRows), this.getInputRowMeta().getString(r)}));
        } else if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"Abort.Log.Wrote.Row", (String[])new String[]{Long.toString(this.nrInputRows), this.getInputRowMeta().getString(r)}));
        }
        return true;
    }
}

