/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.dropbox;

import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.UploadUploader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.hop.vfs.dropbox.DropboxFileSystem;

public class DropboxFileObject
extends AbstractFileObject<DropboxFileSystem> {
    private final DbxClientV2 client;
    private long size;
    private long lastModified;

    protected DropboxFileObject(AbstractFileName name, DropboxFileSystem fileSystem) throws FileSystemException {
        super(name, (AbstractFileSystem)fileSystem);
        this.client = fileSystem.getClient();
        this.size = 0L;
        this.lastModified = 0L;
        this.injectType(FileType.IMAGINARY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAttach() throws FileSystemException {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.getParent() == null) {
                this.injectType(FileType.FOLDER);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDetach() throws FileSystemException {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            this.size = 0L;
            this.lastModified = 0L;
        }
    }

    protected FileType doGetType() throws Exception {
        return this.getName().isFile() ? FileType.FILE : FileType.FOLDER;
    }

    private List<Metadata> doGetChildren() throws IOException {
        ArrayList<Metadata> childrens = new ArrayList<Metadata>();
        try {
            String path = this.getName().getPath();
            if ("/".equals(path)) {
                path = "";
            }
            ListFolderResult result = this.client.files().listFolder(path);
            while (true) {
                childrens.addAll(result.getEntries());
                if (result.getHasMore()) {
                    result = this.client.files().listFolderContinue(result.getCursor());
                    continue;
                }
                break;
            }
        }
        catch (DbxException e) {
            throw new FileSystemException("Error find childrens of folder ", (Object)this.getName());
        }
        return childrens;
    }

    protected FileObject[] doListChildrenResolved() throws Exception {
        List<Metadata> childrens = this.doGetChildren();
        FileObject[] result = new FileObject[childrens.size()];
        int i = 0;
        DropboxFileSystem fileSystem = (DropboxFileSystem)this.getAbstractFileSystem();
        for (Metadata metadata : childrens) {
            DropboxFileObject file = (DropboxFileObject)fileSystem.resolveFile(metadata.getPathDisplay());
            if (file == null) continue;
            if (metadata instanceof FileMetadata) {
                FileMetadata fileMetadata = (FileMetadata)metadata;
                file.injectType(FileType.FILE);
                file.lastModified = fileMetadata.getClientModified().getTime();
                file.size = fileMetadata.getSize();
            } else if (metadata instanceof FolderMetadata) {
                file.injectType(FileType.FOLDER);
                file.size = 0L;
                file.lastModified = 0L;
            }
            result[i++] = file;
        }
        return result;
    }

    protected String[] doListChildren() throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            String path = this.getName().getPath();
            this.client.files().deleteV2(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRename(FileObject newFile) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            String fromPath = this.getName().getPath();
            String toPath = newFile.getName().getPath();
            this.client.files().moveV2(fromPath, toPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            String path = this.getName().getPath();
            this.client.files().createFolderV2(path);
        }
    }

    protected long doGetContentSize() {
        return this.size;
    }

    protected long doGetLastModifiedTime() {
        return this.lastModified;
    }

    protected InputStream doGetInputStream() throws Exception {
        String path = this.getName().getPath();
        InputStream is = this.client.files().download(path).getInputStream();
        if (is == null) {
            throw new FileNotFoundException((Object)this.getName().toString());
        }
        return is;
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        String path = this.getName().getPath();
        final UploadUploader upload = this.client.files().upload(path);
        return new FilterOutputStream(upload.getOutputStream()){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    upload.finish();
                }
                catch (Exception e) {
                    throw new IOException("Failed to upload " + DropboxFileObject.this.getName(), e);
                }
            }
        };
    }
}

