/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.createfolder;

import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.w3c.dom.Node;

@Action(id="CREATE_FOLDER", name="i18n::ActionCreateFolder.Name", description="i18n::ActionCreateFolder.Description", image="CreateFolder.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", documentationUrl="/workflow/actions/createfolder.html")
public class ActionCreateFolder
extends ActionBase
implements Cloneable,
IAction {
    private String folderName = null;
    private boolean failOfFolderExists = true;

    public ActionCreateFolder(String n) {
        super(n, "");
    }

    public ActionCreateFolder() {
        this("");
    }

    public Object clone() {
        ActionCreateFolder je = (ActionCreateFolder)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(50);
        xml.append(super.getXml());
        xml.append("      ").append(XmlHandler.addTagValue((String)"foldername", (String)this.folderName));
        xml.append("      ").append(XmlHandler.addTagValue((String)"fail_of_folder_exists", (boolean)this.failOfFolderExists));
        return xml.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.folderName = XmlHandler.getTagValue((Node)entrynode, (String)"foldername");
            this.failOfFolderExists = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"fail_of_folder_exists"));
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load action of type 'create folder' from XML node", (Throwable)xe);
        }
    }

    public void setFoldername(String folderName) {
        this.folderName = folderName;
    }

    public String getFoldername() {
        return this.folderName;
    }

    public String getRealFoldername() {
        return this.resolve(this.getFoldername());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        if (this.folderName != null) {
            String realFoldername = this.getRealFoldername();
            FileObject folderObject = null;
            try {
                folderObject = HopVfs.getFileObject((String)realFoldername);
                if (folderObject.exists()) {
                    boolean isFolder = false;
                    if (folderObject.getType() == FileType.FOLDER) {
                        isFolder = true;
                    }
                    if (this.isFailOfFolderExists()) {
                        result.setResult(false);
                        if (isFolder) {
                            this.logError("Folder [" + realFoldername + "] exists, failing.");
                            return result;
                        }
                        this.logError("File [" + realFoldername + "] exists, failing.");
                        return result;
                    }
                    result.setResult(true);
                    if (!this.log.isDetailed()) return result;
                    this.logDetailed("Folder [" + realFoldername + "] already exists, not recreating.");
                    return result;
                }
                folderObject.createFolder();
                if (this.log.isDetailed()) {
                    this.logDetailed("Folder [" + realFoldername + "] created!");
                }
                result.setResult(true);
                return result;
            }
            catch (Exception e) {
                this.logError("Could not create Folder [" + realFoldername + "]", e);
                result.setResult(false);
                result.setNrErrors(1L);
                return result;
            }
            finally {
                if (folderObject != null) {
                    try {
                        folderObject.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.logError("No Foldername is defined.");
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isFailOfFolderExists() {
        return this.failOfFolderExists;
    }

    public void setFailOfFolderExists(boolean failIfFolderExists) {
        this.failOfFolderExists = failIfFolderExists;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileDoesNotExistValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, ctx);
    }
}

