/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tableoutput;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.IProvidesModelerMeta;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tableoutput.TableOutput;
import org.apache.hop.pipeline.transforms.tableoutput.TableOutputData;
import org.apache.hop.pipeline.transforms.tableoutput.TableOutputField;

@Transform(id="TableOutput", image="tableoutput.svg", name="i18n::BaseTransform.TypeLongDesc.TableOutput", description="i18n::BaseTransform.TypeTooltipDesc.TableOutput", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", documentationUrl="/pipeline/transforms/tableoutput.html")
public class TableOutputMeta
extends BaseTransformMeta
implements ITransformMeta<TableOutput, TableOutputData>,
IProvidesModelerMeta {
    private static final Class<?> PKG = TableOutputMeta.class;
    private static final String PARTION_PER_DAY = "DAY";
    private static final String PARTION_PER_MONTH = "MONTH";
    @HopMetadataProperty(key="connection", injectionKeyDescription="TableOutputMeta.Injection.Connection")
    private String connection;
    private DatabaseMeta databaseMeta;
    @HopMetadataProperty(key="schema", injectionKey="TARGET_SCHEMA", injectionKeyDescription="TableOutputMeta.Injection.SchemaName.Field")
    private String schemaName;
    @HopMetadataProperty(key="table", injectionKey="TARGET_TABLE", injectionKeyDescription="TableOutputMeta.Injection.TableName.Field")
    private String tableName;
    @HopMetadataProperty(key="commit", injectionKey="COMMIT_SIZE", injectionKeyDescription="TableOutputMeta.Injection.CommitSize.Field")
    private String commitSize = "1000";
    @HopMetadataProperty(key="truncate", injectionKey="TRUNCATE_TABLE", injectionKeyDescription="TableOutputMeta.Injection.TruncateTable.Field")
    private boolean truncateTable;
    @HopMetadataProperty(key="ignore_errors", injectionKey="IGNORE_INSERT_ERRORS", injectionKeyDescription="TableOutputMeta.Injection.IgnoreErrors.Field")
    private boolean ignoreErrors;
    @HopMetadataProperty(key="use_batch", injectionKey="USE_BATCH_UPDATE", defaultBoolean=true, injectionKeyDescription="TableOutputMeta.Injection.UseBatch.Field")
    private boolean useBatchUpdate = true;
    @HopMetadataProperty(key="partitioning_enabled", injectionKey="PARTITION_OVER_TABLES", injectionKeyDescription="TableOutputMeta.Injection.PartitioningEnabled.Field")
    private boolean partitioningEnabled;
    @HopMetadataProperty(key="partitioning_field", injectionKey="PARTITIONING_FIELD", injectionKeyDescription="TableOutputMeta.Injection.PartitioningField.Field")
    private String partitioningField;
    @HopMetadataProperty(key="partitioning_daily", isExcludedFromInjection=true)
    private boolean partitioningDaily;
    @HopMetadataProperty(key="partitioning_monthly", isExcludedFromInjection=true)
    private boolean partitioningMonthly;
    @HopMetadataProperty(injectionKey="PARTITION_DATA_PER", injectionKeyDescription="TableOutputMeta.Injection.PartitionDataPer.Field")
    private transient String partitionDataPer;
    @HopMetadataProperty(key="tablename_in_field", injectionKey="TABLE_NAME_DEFINED_IN_FIELD", injectionKeyDescription="TableOutputMeta.Injection.TableNameInField.Field")
    private boolean tableNameInField;
    @HopMetadataProperty(key="tablename_field", injectionKey="TABLE_NAME_FIELD", injectionKeyDescription="TableOutputMeta.Injection.TableNameField.Field")
    private String tableNameField;
    @HopMetadataProperty(key="tablename_in_table", injectionKey="STORE_TABLE_NAME", injectionKeyDescription="TableOutputMeta.Injection.TableNameInTable.Field")
    private boolean tableNameInTable;
    @HopMetadataProperty(key="return_keys", injectionKeyDescription="TableOutputMeta.Injection.ReturningGeneratedKeys.Field")
    private boolean returningGeneratedKeys;
    @HopMetadataProperty(key="return_field", injectionKey="RETURN_AUTO_GENERATED_KEY", injectionKeyDescription="TableOutputMeta.Injection.GeneratedKeys.Field")
    private String generatedKeyField;
    @HopMetadataProperty(key="specify_fields", injectionKey="AUTO_GENERATED_KEY_FIELD", injectionKeyDescription="TableOutputMeta.Injection.SpecifyFields.Field")
    private boolean specifyFields;
    @HopMetadataProperty(groupKey="fields", key="field", injectionKey="DATABASE_FIELD", injectionGroupKey="DATABASE_FIELDS", injectionGroupDescription="TableOutputMeta.Injection.Fields", injectionKeyDescription="TableOutputMeta.Injection.Field")
    private List<TableOutputField> fields = new ArrayList<TableOutputField>();

    public List<TableOutputField> getFields() {
        return this.fields;
    }

    public void setFields(List<TableOutputField> fields) {
        this.fields = fields;
    }

    public String getGeneratedKeyField() {
        return this.generatedKeyField;
    }

    public void setGeneratedKeyField(String generatedKeyField) {
        this.generatedKeyField = generatedKeyField;
    }

    public boolean isReturningGeneratedKeys() {
        if (this.getDatabaseMeta() != null) {
            return this.getDatabaseMeta().supportsAutoGeneratedKeys() && this.returningGeneratedKeys;
        }
        return false;
    }

    public void setReturningGeneratedKeys(boolean returningGeneratedKeys) {
        this.returningGeneratedKeys = returningGeneratedKeys;
    }

    public boolean isTableNameInTable() {
        return this.tableNameInTable;
    }

    public void setTableNameInTable(boolean tableNameInTable) {
        this.tableNameInTable = tableNameInTable;
    }

    public String getTableNameField() {
        return this.tableNameField;
    }

    public void setTableNameField(String tableNameField) {
        this.tableNameField = tableNameField;
    }

    public boolean isTableNameInField() {
        return this.tableNameInField;
    }

    public void setTableNameInField(boolean tableNameInField) {
        this.tableNameInField = tableNameInField;
    }

    public boolean isPartitioningDaily() {
        return this.partitioningDaily;
    }

    public void setPartitioningDaily(boolean partitioningDaily) {
        this.partitioningDaily = partitioningDaily;
    }

    public boolean isPartitioningMonthly() {
        return this.partitioningMonthly;
    }

    public void setPartitioningMonthly(boolean partitioningMontly) {
        this.partitioningMonthly = partitioningMontly;
    }

    public boolean isPartitioningEnabled() {
        return this.partitioningEnabled;
    }

    public void setPartitioningEnabled(boolean partitioningEnabled) {
        this.partitioningEnabled = partitioningEnabled;
    }

    public String getPartitioningField() {
        return this.partitioningField;
    }

    public void setPartitioningField(String partitioningField) {
        this.partitioningField = partitioningField;
    }

    public String getPartitionDataPer() {
        return this.partitionDataPer;
    }

    public void setPartitionDataPer(String partitionDataPer) {
        this.partitionDataPer = partitionDataPer;
        this.partitioningDaily = partitionDataPer.equals(PARTION_PER_DAY);
        this.partitioningMonthly = partitionDataPer.equals(PARTION_PER_MONTH);
    }

    public Object clone() {
        return super.clone();
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSizeInt) {
        this.commitSize = Integer.toString(commitSizeInt);
    }

    public void setCommitSize(String commitSize) {
        this.commitSize = commitSize;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    public void setTruncateTable(boolean truncateTable) {
        this.truncateTable = truncateTable;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setSpecifyFields(boolean specifyFields) {
        this.specifyFields = specifyFields;
    }

    public boolean isSpecifyFields() {
        return this.specifyFields;
    }

    public void setUseBatchUpdate(boolean useBatchUpdate) {
        this.useBatchUpdate = useBatchUpdate;
    }

    public boolean isUseBatchUpdate() {
        return this.useBatchUpdate;
    }

    public void setDefault() {
        this.databaseMeta = null;
        this.tableName = "";
        this.commitSize = "1000";
        this.partitioningEnabled = false;
        this.partitioningDaily = false;
        this.partitioningMonthly = true;
        this.partitioningField = "";
        this.tableNameInTable = true;
        this.tableNameField = "";
        this.specifyFields = false;
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.returningGeneratedKeys && this.generatedKeyField != null && this.generatedKeyField.length() > 0) {
            ValueMetaInteger key = new ValueMetaInteger(variables.resolve(this.generatedKeyField));
            key.setOrigin(origin);
            row.addValueMeta((IValueMeta)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (this.databaseMeta != null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.ConnectionExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Database db = new Database(loggingObject, variables, this.databaseMeta);
            try {
                db.connect();
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.ConnectionOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    String realSchemaName = db.resolve(this.schemaName);
                    String realTableName = db.resolve(this.tableName);
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, realSchemaName, realTableName);
                    if (db.checkTableExists(realSchemaName, realTableName)) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.TableAccessible", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        IRowMeta r = db.getTableFieldsMeta(realSchemaName, realTableName);
                        if (r != null) {
                            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.TableOk", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                            remarks.add((ICheckResult)cr);
                            String errorMessage = "";
                            boolean errorFound = false;
                            if (prev != null && prev.size() > 0) {
                                TableOutputField tf;
                                int idx;
                                int i;
                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
                                remarks.add((ICheckResult)cr);
                                if (!this.isSpecifyFields()) {
                                    for (i = 0; i < prev.size(); ++i) {
                                        IValueMeta pv = prev.getValueMeta(i);
                                        idx = r.indexOfValue(pv.getName());
                                        if (idx >= 0) continue;
                                        errorMessage = errorMessage + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                                        errorFound = true;
                                    }
                                    if (errorFound) {
                                        errorMessage = BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsNotFoundInOutput", (String[])new String[]{errorMessage});
                                        cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                    } else {
                                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                    }
                                } else {
                                    for (i = 0; i < this.fields.size(); ++i) {
                                        tf = this.fields.get(i);
                                        idx = r.indexOfValue(tf.getFieldDatabase());
                                        if (idx >= 0) continue;
                                        errorMessage = errorMessage + "\t\t" + tf.getFieldDatabase() + Const.CR;
                                        errorFound = true;
                                    }
                                    if (errorFound) {
                                        errorMessage = BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsSpecifiedNotInTable", (String[])new String[]{errorMessage});
                                        cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                    } else {
                                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                    }
                                }
                                errorMessage = "";
                                if (!this.isSpecifyFields()) {
                                    for (i = 0; i < this.fields.size(); ++i) {
                                        IValueMeta rv = r.getValueMeta(i);
                                        idx = prev.indexOfValue(rv.getName());
                                        if (idx >= 0) continue;
                                        errorMessage = errorMessage + "\t\t" + rv.getName() + " (" + rv.getTypeDesc() + ")" + Const.CR;
                                        errorFound = true;
                                    }
                                    if (errorFound) {
                                        errorMessage = BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                                        cr = new CheckResult(3, errorMessage, (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                    }
                                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                    remarks.add((ICheckResult)cr);
                                }
                                for (i = 0; i < this.fields.size(); ++i) {
                                    tf = this.fields.get(i);
                                    idx = prev.indexOfValue(tf.getFieldStream());
                                    if (idx >= 0) continue;
                                    errorMessage = errorMessage + "\t\t" + tf.getFieldStream() + Const.CR;
                                    errorFound = true;
                                }
                                if (errorFound) {
                                    errorMessage = BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsSpecifiedNotFound", (String[])new String[]{errorMessage});
                                    cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                                    remarks.add((ICheckResult)cr);
                                }
                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                remarks.add((ICheckResult)cr);
                            }
                            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
                            remarks.add((ICheckResult)cr);
                        }
                        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.TableNotAccessible", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.TableError", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.NoTableName", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.UndefinedError", (String[])new String[]{e.getMessage()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.NoConnection", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public ITransform createTransform(TransformMeta transformMeta, TableOutputData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new TableOutput(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public TableOutputData getTransformData() {
        return new TableOutputData();
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) {
        if (this.truncateTable) {
            DatabaseImpact ii = new DatabaseImpact(4, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, "", "", "", "", "Truncate of table");
            impact.add(ii);
        }
        if (prev != null) {
            for (int i = 0; i < prev.size(); ++i) {
                IValueMeta v = prev.getValueMeta(i);
                DatabaseImpact ii = new DatabaseImpact(2, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, v.getName(), v.getName(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) {
        return this.getSqlStatements(variables, pipelineMeta, transformMeta, prev, null, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String tk, boolean useAutoIncrement, String pk) {
        SqlStatement retval = new SqlStatement(transformMeta.getName(), this.databaseMeta, null);
        if (this.databaseMeta != null) {
            if (prev != null && prev.size() > 0) {
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    Database db = new Database(loggingObject, variables, this.databaseMeta);
                    try {
                        db.connect();
                        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                        String crTable = db.getDDL(schemaTable, prev, tk, useAutoIncrement, pk);
                        if (crTable == null || crTable.length() == 0) {
                            crTable = null;
                        }
                        retval.setSql(crTable);
                    }
                    catch (HopDatabaseException dbe) {
                        retval.setError(BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.ErrorConnecting", (String[])new String[]{dbe.getMessage()}));
                    }
                    finally {
                        db.disconnect();
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.NoTable", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.NoInput", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.NoConnection", (String[])new String[0]));
        }
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realTableName = variables.resolve(this.tableName);
        String realSchemaName = variables.resolve(this.schemaName);
        if (this.databaseMeta == null) throw new HopException(BaseMessages.getString(PKG, (String)"TableOutputMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, variables, this.databaseMeta);
        try {
            db.connect();
            if (Utils.isEmpty((CharSequence)realTableName)) throw new HopException(BaseMessages.getString(PKG, (String)"TableOutputMeta.Exception.TableNotSpecified", (String[])new String[0]));
            if (db.checkTableExists(realSchemaName, realTableName)) {
                IRowMeta iRowMeta = db.getTableFieldsMeta(realSchemaName, realTableName);
                return iRowMeta;
            }
            try {
                throw new HopException(BaseMessages.getString(PKG, (String)"TableOutputMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"TableOutputMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public RowMeta getRowMeta(IVariables variables, ITransformData transformData) {
        return (RowMeta)((TableOutputData)transformData).insertRowMeta;
    }

    public List<String> getDatabaseFields() {
        List<String> items = Collections.emptyList();
        if (this.isSpecifyFields()) {
            items = new ArrayList<String>();
            for (TableOutputField tf : this.fields) {
                items.add(tf.getFieldDatabase());
            }
        }
        return items;
    }

    public List<String> getStreamFields() {
        List<String> items = Collections.emptyList();
        if (this.isSpecifyFields()) {
            items = new ArrayList<String>();
            for (TableOutputField tf : this.fields) {
                items.add(tf.getFieldStream());
            }
        }
        return items;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public boolean supportsErrorHandling() {
        if (this.databaseMeta != null) {
            return this.databaseMeta.getIDatabase().supportsErrorHandling();
        }
        return true;
    }

    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }
}

