/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.changefileencoding;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.changefileencoding.ChangeFileEncodingData;
import org.apache.hop.pipeline.transforms.changefileencoding.ChangeFileEncodingMeta;

public class ChangeFileEncoding
extends BaseTransform<ChangeFileEncodingMeta, ChangeFileEncodingData>
implements ITransform<ChangeFileEncodingMeta, ChangeFileEncodingData> {
    private static final Class<?> PKG = ChangeFileEncoding.class;
    private static final String COULD_NOT_FIND_FIELD = "ChangeFileEncoding.Exception.CouldnotFindField";

    public ChangeFileEncoding(TransformMeta transformMeta, ChangeFileEncodingMeta meta, ChangeFileEncodingData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block18: {
            Object[] outputRow = this.getRow();
            if (outputRow == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((ChangeFileEncodingData)this.data).inputRowMeta = this.getInputRowMeta().clone();
                if (Utils.isEmpty((CharSequence)((ChangeFileEncodingMeta)this.meta).getFilenameField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.FilenameFieldMissing", (String[])new String[0]));
                    throw new HopException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.FilenameFieldMissing", (String[])new String[0]));
                }
                if (Utils.isEmpty((CharSequence)((ChangeFileEncodingMeta)this.meta).getTargetFilenameField())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.TargetFilenameFieldMissing", (String[])new String[0]));
                }
                ((ChangeFileEncodingData)this.data).indexOfFileename = ((ChangeFileEncodingData)this.data).inputRowMeta.indexOfValue(((ChangeFileEncodingMeta)this.meta).getFilenameField());
                if (((ChangeFileEncodingData)this.data).indexOfFileename < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)COULD_NOT_FIND_FIELD, (String[])new String[0]) + "[" + ((ChangeFileEncodingMeta)this.meta).getFilenameField() + "]");
                    throw new HopException(BaseMessages.getString(PKG, (String)COULD_NOT_FIND_FIELD, (String[])new String[]{((ChangeFileEncodingMeta)this.meta).getFilenameField()}));
                }
                ((ChangeFileEncodingData)this.data).indexOfTargetFileename = ((ChangeFileEncodingData)this.data).inputRowMeta.indexOfValue(((ChangeFileEncodingMeta)this.meta).getTargetFilenameField());
                if (((ChangeFileEncodingData)this.data).indexOfTargetFileename < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)COULD_NOT_FIND_FIELD, (String[])new String[0]) + "[" + ((ChangeFileEncodingMeta)this.meta).getTargetFilenameField() + "]");
                    throw new HopException(BaseMessages.getString(PKG, (String)COULD_NOT_FIND_FIELD, (String[])new String[]{((ChangeFileEncodingMeta)this.meta).getTargetFilenameField()}));
                }
                ((ChangeFileEncodingData)this.data).sourceEncoding = this.resolve(((ChangeFileEncodingMeta)this.meta).getSourceEncoding());
                ((ChangeFileEncodingData)this.data).targetEncoding = this.resolve(((ChangeFileEncodingMeta)this.meta).getTargetEncoding());
                if (Utils.isEmpty((CharSequence)((ChangeFileEncodingData)this.data).targetEncoding)) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Exception.TargetEncodingEmpty", (String[])new String[0]));
                }
            }
            try {
                String sourceFilename = ((ChangeFileEncodingData)this.data).inputRowMeta.getString(outputRow, ((ChangeFileEncodingData)this.data).indexOfFileename);
                if (Utils.isEmpty((CharSequence)sourceFilename)) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.SourceFileIsEmpty", (String[])new String[]{((ChangeFileEncodingMeta)this.meta).getFilenameField()}));
                }
                String targetFilename = ((ChangeFileEncodingData)this.data).inputRowMeta.getString(outputRow, ((ChangeFileEncodingData)this.data).indexOfTargetFileename);
                if (Utils.isEmpty((CharSequence)targetFilename)) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.TargetFileIsEmpty", (String[])new String[]{((ChangeFileEncodingMeta)this.meta).getTargetFilenameField()}));
                }
                ((ChangeFileEncodingData)this.data).sourceFile = HopVfs.getFileObject((String)sourceFilename);
                if (!((ChangeFileEncodingData)this.data).sourceFile.exists()) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.SourceFileNotExists", (String[])new String[]{sourceFilename}));
                }
                if (((ChangeFileEncodingData)this.data).sourceFile.getType() != FileType.FILE) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.SourceFileNotAFile", (String[])new String[]{sourceFilename}));
                }
                if (!((ChangeFileEncodingData)this.data).sourceFile.getParent().exists()) {
                    if (((ChangeFileEncodingMeta)this.meta).isCreateParentFolder()) {
                        ((ChangeFileEncodingData)this.data).sourceFile.getParent().createFolder();
                    } else {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.ParentFolderNotExist", (String[])new String[]{((ChangeFileEncodingData)this.data).sourceFile.getParent().toString()}));
                    }
                }
                this.changeEncoding(sourceFilename, targetFilename);
                this.putRow(((ChangeFileEncodingData)this.data).inputRowMeta, outputRow);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(outputRow)}));
                }
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block18;
                this.putError(this.getInputRowMeta(), outputRow, 1L, errorMessage, ((ChangeFileEncodingMeta)this.meta).getFilenameField(), "ChangeFileEncoding001");
            }
        }
        return true;
    }

    private void changeEncoding(String sourceFilename, String targetFilename) throws HopException {
        BufferedWriter buffWriter = null;
        BufferedReader buffReader = null;
        try {
            ResultFile resultFile;
            buffWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFilename, false), ((ChangeFileEncodingData)this.data).targetEncoding));
            buffReader = Utils.isEmpty((CharSequence)((ChangeFileEncodingData)this.data).sourceEncoding) ? new BufferedReader(new InputStreamReader(new FileInputStream(sourceFilename))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceFilename), ((ChangeFileEncodingData)this.data).sourceEncoding));
            char[] cBuf = new char[8192];
            int readSize = 0;
            while ((readSize = buffReader.read(cBuf)) != -1) {
                buffWriter.write(cBuf, 0, readSize);
            }
            if (((ChangeFileEncodingMeta)this.meta).isAddSourceResultFilenames()) {
                resultFile = new ResultFile(0, ((ChangeFileEncodingData)this.data).sourceFile, this.getPipelineMeta().getName(), this.getTransformName());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Log.FileAddedResult", (String[])new String[0]));
                this.addResultFile(resultFile);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Log.FilenameAddResult", (String[])new String[]{((ChangeFileEncodingData)this.data).sourceFile.toString()}));
                }
            }
            if (((ChangeFileEncodingMeta)this.meta).isAddTargetResultFilenames()) {
                resultFile = new ResultFile(0, HopVfs.getFileObject((String)targetFilename), this.getPipelineMeta().getName(), this.getTransformName());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Log.FileAddedResult", (String[])new String[0]));
                this.addResultFile(resultFile);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Log.FilenameAddResult", (String[])new String[]{targetFilename}));
                }
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.CreatingFile", (String[])new String[0]), (Throwable)e);
        }
        finally {
            try {
                if (buffWriter != null) {
                    buffWriter.flush();
                    buffWriter.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void dispose() {
        if (((ChangeFileEncodingData)this.data).sourceFile != null) {
            try {
                ((ChangeFileEncodingData)this.data).sourceFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose();
    }
}

