/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.normaliser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.normaliser.Normaliser;
import org.apache.hop.pipeline.transforms.normaliser.NormaliserData;
import org.w3c.dom.Node;

@Transform(id="Normaliser", name="i18n::Normaliser.Name", description="i18n::Normaliser.Description", image="normaliser.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"transform"}, documentationUrl="/pipeline/transforms/rownormaliser.html")
@InjectionSupported(localizationPrefix="NormaliserMeta.Injection.", groups={"FIELDS"})
public class NormaliserMeta
extends BaseTransformMeta
implements ITransformMeta<Normaliser, NormaliserData> {
    private static final Class<?> PKG = NormaliserMeta.class;
    private String typeField;
    @InjectionDeep
    private NormaliserField[] normaliserFields = new NormaliserField[0];

    public String getTypeField() {
        return this.typeField;
    }

    public void setTypeField(String typeField) {
        this.typeField = typeField;
    }

    public NormaliserField[] getNormaliserFields() {
        return this.normaliserFields;
    }

    public void setNormaliserFields(NormaliserField[] normaliserFields) {
        this.normaliserFields = normaliserFields;
    }

    public Set<String> getFieldNames() {
        HashSet<String> fieldNames = new HashSet<String>();
        for (int i = 0; i < this.normaliserFields.length; ++i) {
            String s = this.normaliserFields[i].getName();
            if (s == null) continue;
            fieldNames.add(s.toLowerCase());
        }
        return fieldNames;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int nrFields) {
        this.normaliserFields = new NormaliserField[nrFields];
        for (int i = 0; i < nrFields; ++i) {
            this.normaliserFields[i] = new NormaliserField();
        }
    }

    public Object clone() {
        NormaliserMeta retval = (NormaliserMeta)((Object)super.clone());
        int nrFields = this.normaliserFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            retval.normaliserFields[i] = (NormaliserField)this.normaliserFields[i].clone();
        }
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.typeField = XmlHandler.getTagValue((Node)transformNode, (String)"typefield");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.normaliserFields[i].setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                this.normaliserFields[i].setValue(XmlHandler.getTagValue((Node)fnode, (String)"value"));
                this.normaliserFields[i].setNorm(XmlHandler.getTagValue((Node)fnode, (String)"norm"));
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"NormaliserMeta.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.typeField = "typefield";
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.normaliserFields[i].setName("field" + i);
            this.normaliserFields[i].setValue("value" + i);
            this.normaliserFields[i].setNorm("value" + i);
        }
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        int i;
        ArrayList<String> norm_occ = new ArrayList<String>();
        ArrayList<String> field_occ = new ArrayList<String>();
        int maxlen = 0;
        for (int i2 = 0; i2 < this.normaliserFields.length; ++i2) {
            if (!norm_occ.contains(this.normaliserFields[i2].getNorm())) {
                norm_occ.add(this.normaliserFields[i2].getNorm());
                field_occ.add(this.normaliserFields[i2].getName());
            }
            if (this.normaliserFields[i2].getValue().length() <= maxlen) continue;
            maxlen = this.normaliserFields[i2].getValue().length();
        }
        ValueMetaString typefieldValue = new ValueMetaString(this.typeField);
        typefieldValue.setOrigin(name);
        typefieldValue.setLength(maxlen);
        row.addValueMeta((IValueMeta)typefieldValue);
        for (i = 0; i < norm_occ.size(); ++i) {
            String normname = (String)norm_occ.get(i);
            String fieldname = (String)field_occ.get(i);
            IValueMeta v = row.searchValueMeta(fieldname);
            if (v == null) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"NormaliserMeta.Exception.UnableToFindField", (String[])new String[]{fieldname}));
            }
            v = v.clone();
            v.setName(normname);
            v.setOrigin(name);
            row.addValueMeta(v);
        }
        for (i = 0; i < this.normaliserFields.length; ++i) {
            int idx = row.indexOfValue(this.normaliserFields[i].getName());
            if (idx < 0) continue;
            row.removeValueMeta(idx);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("   " + XmlHandler.addTagValue((String)"typefield", (String)this.typeField));
        retval.append("    <fields>");
        for (int i = 0; i < this.normaliserFields.length; ++i) {
            retval.append("      <field>");
            retval.append("        " + XmlHandler.addTagValue((String)"name", (String)this.normaliserFields[i].getName()));
            retval.append("        " + XmlHandler.addTagValue((String)"value", (String)this.normaliserFields[i].getValue()));
            retval.append("        " + XmlHandler.addTagValue((String)"norm", (String)this.normaliserFields[i].getNorm()));
            retval.append("        </field>");
        }
        retval.append("      </fields>");
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.TransformReceivingFieldsOK", (String[])new String[]{prev.size() + ""}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            boolean first = true;
            errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.normaliserFields.length; ++i) {
                String lufield = this.normaliserFields[i].getName();
                IValueMeta v = prev.searchValueMeta(lufield);
                if (v != null) continue;
                if (first) {
                    first = false;
                    errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.FieldsNotFound", (String[])new String[0]) + Const.CR;
                }
                errorFound = true;
                errorMessage = errorMessage + "\t\t" + lufield + Const.CR;
            }
            cr = errorFound ? new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.CouldNotReadFieldsFromPreviousTransform", (String[])new String[0]) + Const.CR;
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.TransformReceivingInfoOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public Normaliser createTransform(TransformMeta transformMeta, NormaliserData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new Normaliser(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public NormaliserData getTransformData() {
        return new NormaliserData();
    }

    public static class NormaliserField
    implements Cloneable {
        @Injection(name="NAME", group="FIELDS")
        private String name;
        @Injection(name="VALUE", group="FIELDS")
        private String value;
        @Injection(name="NORMALISED", group="FIELDS")
        private String norm;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getNorm() {
            return this.norm;
        }

        public void setNorm(String norm) {
            this.norm = norm;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.norm == null ? 0 : this.norm.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NormaliserField other = (NormaliserField)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.norm == null ? other.norm != null : !this.norm.equals(other.norm)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public Object clone() {
            try {
                NormaliserField retval = (NormaliserField)super.clone();
                return retval;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

