/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.normaliser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.normaliser.NormaliserMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class NormaliserDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = NormaliserMeta.class;
    private static final int NAME_INDEX = 1;
    private static final int VALUE_INDEX = 2;
    private static final int NORM_INDEX = 3;
    private Text wTypefield;
    private TableView wFields;
    private final NormaliserMeta input;
    private ColumnInfo[] colinf;
    private final Map<String, Integer> inputFields;

    public NormaliserDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (NormaliserMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"NormaliserDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"NormaliserDialog.GetFields.Button", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.get());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"NormaliserDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlTypefield = new Label((Composite)this.shell, 131072);
        wlTypefield.setText(BaseMessages.getString(PKG, (String)"NormaliserDialog.TypeField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTypefield);
        FormData fdlTypefield = new FormData();
        fdlTypefield.left = new FormAttachment(0, 0);
        fdlTypefield.right = new FormAttachment(middle, -margin);
        fdlTypefield.top = new FormAttachment((Control)this.wTransformName, margin);
        wlTypefield.setLayoutData((Object)fdlTypefield);
        this.wTypefield = new Text((Composite)this.shell, 18436);
        this.wTypefield.setText("");
        this.props.setLook((Control)this.wTypefield);
        this.wTypefield.addModifyListener(lsMod);
        FormData fdTypefield = new FormData();
        fdTypefield.left = new FormAttachment(middle, 0);
        fdTypefield.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTypefield.right = new FormAttachment(100, 0);
        this.wTypefield.setLayoutData((Object)fdTypefield);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"NormaliserDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wTypefield, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int fieldsCols = 3;
        int fieldsRows = this.input.getNormaliserFields().length;
        this.colinf = new ColumnInfo[3];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"NormaliserDialog.ColumnInfo.Fieldname", (String[])new String[0]), 2, new String[]{""}, false);
        this.colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"NormaliserDialog.ColumnInfo.Type", (String[])new String[0]), 1, false);
        this.colinf[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"NormaliserDialog.ColumnInfo.NewField", (String[])new String[0]), 1, false);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, this.colinf, fieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    public void getData() {
        if (this.input.getTypeField() != null) {
            this.wTypefield.setText(this.input.getTypeField());
        }
        for (int i = 0; i < this.input.getNormaliserFields().length; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            if (this.input.getNormaliserFields()[i].getName() != null) {
                item.setText(1, this.input.getNormaliserFields()[i].getName());
            }
            if (this.input.getNormaliserFields()[i].getValue() != null) {
                item.setText(2, this.input.getNormaliserFields()[i].getValue());
            }
            if (this.input.getNormaliserFields()[i].getNorm() == null) continue;
            item.setText(3, this.input.getNormaliserFields()[i].getNorm());
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setTypeField(this.wTypefield.getText());
        int nrFields = this.wFields.nrNonEmpty();
        this.input.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.input.getNormaliserFields()[i].setName(item.getText(1));
            this.input.getNormaliserFields()[i].setValue(item.getText(2));
            this.input.getNormaliserFields()[i].setNorm(item.getText(3));
        }
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"NormaliserDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"NormaliserDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

