/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cubeoutput;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cubeoutput.CubeOutput;
import org.apache.hop.pipeline.transforms.cubeoutput.CubeOutputData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="CubeOutput", image="cubeoutput.svg", name="i18n::CubeOutput.Name", description="i18n::CubeOutput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", documentationUrl="/pipeline/transforms/cubeoutput.html")
public class CubeOutputMeta
extends BaseTransformMeta
implements ITransformMeta<CubeOutput, CubeOutputData> {
    private static final Class<?> PKG = CubeOutputMeta.class;
    private String filename;
    private boolean addToResultFilenames;
    private boolean doNotOpenNewFileInit;

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isAddToResultFiles() {
        return this.addToResultFilenames;
    }

    public void setAddToResultFiles(boolean addtoresultfilenamesin) {
        this.addToResultFilenames = addtoresultfilenamesin;
    }

    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpenNewFileInit = doNotOpenNewFileInit;
    }

    public Object clone() {
        CubeOutputMeta retval = (CubeOutputMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.filename = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"name");
            this.addToResultFilenames = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"add_to_result_filenames"));
            this.doNotOpenNewFileInit = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"do_not_open_newfile_init"));
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"CubeOutputMeta.Exception.UnableToLoadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.filename = "file.cube";
        this.addToResultFilenames = false;
        this.doNotOpenNewFileInit = false;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    <file>").append(Const.CR);
        retval.append("      ").append(XmlHandler.addTagValue((String)"name", (String)this.filename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.addToResultFilenames));
        retval.append("      ").append(XmlHandler.addTagValue((String)"do_not_open_newfile_init", (boolean)this.doNotOpenNewFileInit));
        retval.append("    </file>").append(Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CubeOutputMeta.CheckResult.ReceivingFields", (String[])new String[]{String.valueOf(prev.size())}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"CubeOutputMeta.CheckResult.FileSpecificationsNotChecked", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public CubeOutput createTransform(TransformMeta transformMeta, CubeOutputData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new CubeOutput(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public CubeOutputData getTransformData() {
        return new CubeOutputData();
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.filename));
            if (fileObject.exists()) {
                this.filename = iResourceNaming.nameResource(fileObject, variables, true);
                return this.filename;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

