/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cubeoutput;

import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transforms.cubeoutput.CubeOutputMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CubeOutputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = CubeOutputMeta.class;
    private TextVar wFilename;
    private Button wAddToResult;
    private Button wDoNotOpenNewFileInit;
    private final CubeOutputMeta input;

    public CubeOutputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (CubeOutputMeta)((Object)in);
        this.pipelineMeta = pipelineMeta;
        this.transformName = sname != null ? sname : BaseMessages.getString(PKG, (String)"CubeOutputDialog.DefaultTransformName", (String[])new String[0]);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CubeOutputDialog.Shell.Text", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"CubeOutputDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlFilename = new Label((Composite)this.shell, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"CubeOutputDialog.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)this.wTransformName, margin + 5);
        fdlFilename.right = new FormAttachment(middle, -margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbFilename = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbFilename);
        wbFilename.setText(BaseMessages.getString(PKG, (String)"CubeOutputDialog.Browse.Button", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wTransformName, margin + 5);
        wbFilename.setLayoutData((Object)fdbFilename);
        this.wFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment((Control)this.wTransformName, margin + 5);
        fdFilename.right = new FormAttachment((Control)wbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        Label wlDoNotOpenNewFileInit = new Label((Composite)this.shell, 131072);
        wlDoNotOpenNewFileInit.setText(BaseMessages.getString(PKG, (String)"CubeOutputDialog.DoNotOpenNewFileInit.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDoNotOpenNewFileInit);
        FormData fdlDoNotOpenNewFileInit = new FormData();
        fdlDoNotOpenNewFileInit.left = new FormAttachment(0, 0);
        fdlDoNotOpenNewFileInit.top = new FormAttachment((Control)this.wFilename, 2 * margin);
        fdlDoNotOpenNewFileInit.right = new FormAttachment(middle, -margin);
        wlDoNotOpenNewFileInit.setLayoutData((Object)fdlDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit = new Button((Composite)this.shell, 32);
        this.wDoNotOpenNewFileInit.setToolTipText(BaseMessages.getString(PKG, (String)"CubeOutputDialog.DoNotOpenNewFileInit.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wDoNotOpenNewFileInit);
        FormData fdDoNotOpenNewFileInit = new FormData();
        fdDoNotOpenNewFileInit.left = new FormAttachment(middle, 0);
        fdDoNotOpenNewFileInit.top = new FormAttachment((Control)wlDoNotOpenNewFileInit, 0, 0x1000000);
        fdDoNotOpenNewFileInit.right = new FormAttachment(100, 0);
        this.wDoNotOpenNewFileInit.setLayoutData((Object)fdDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CubeOutputDialog.this.input.setChanged();
            }
        });
        Label wlAddToResult = new Label((Composite)this.shell, 131072);
        wlAddToResult.setText(BaseMessages.getString(PKG, (String)"CubeOutputDialog.AddFileToResult.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddToResult);
        FormData fdlAddToResult = new FormData();
        fdlAddToResult.left = new FormAttachment(0, 0);
        fdlAddToResult.top = new FormAttachment((Control)this.wDoNotOpenNewFileInit, margin);
        fdlAddToResult.right = new FormAttachment(middle, -margin);
        wlAddToResult.setLayoutData((Object)fdlAddToResult);
        this.wAddToResult = new Button((Composite)this.shell, 32);
        this.wAddToResult.setToolTipText(BaseMessages.getString(PKG, (String)"CubeOutputDialog.AddFileToResult.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAddToResult);
        FormData fdAddToResult = new FormData();
        fdAddToResult.left = new FormAttachment(middle, 0);
        fdAddToResult.top = new FormAttachment((Control)wlAddToResult, 0, 0x1000000);
        fdAddToResult.right = new FormAttachment(100, 0);
        this.wAddToResult.setLayoutData((Object)fdAddToResult);
        SelectionAdapter lsSelR = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CubeOutputDialog.this.input.setChanged();
            }
        };
        this.wAddToResult.addSelectionListener((SelectionListener)lsSelR);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wAddToResult);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.cube", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"CubeOutputDialog.FilterNames.Options.CubeFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CubeOutputDialog.FilterNames.Options.AllFiles", (String[])new String[0])}, (boolean)true));
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.input.getFilename() != null) {
            this.wFilename.setText(this.input.getFilename());
        }
        this.wDoNotOpenNewFileInit.setSelection(this.input.isDoNotOpenNewFileInit());
        this.wAddToResult.setSelection(this.input.isAddToResultFiles());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setAddToResultFiles(this.wAddToResult.getSelection());
        this.input.setDoNotOpenNewFileInit(this.wDoNotOpenNewFileInit.getSelection());
        this.input.setFilename(this.wFilename.getText());
        this.dispose();
    }
}

