/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.mssqlnative;

import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.util.Utils;
import org.apache.hop.databases.mssql.MsSqlServerDatabaseMeta;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

@DatabaseMetaPlugin(type="MSSQLNATIVE", typeDescription="MS SQL Server (Native)")
@GuiPlugin(id="GUI-MSSQLServerNativeDatabaseMeta")
public class MsSqlServerNativeDatabaseMeta
extends MsSqlServerDatabaseMeta
implements IGuiPluginCompositeWidgetsListener {
    public static final String ID_INTEGRATED_SECURITY_WIDGET = "usingIntegratedSecurity";
    @GuiWidgetElement(id="usingIntegratedSecurity", order="21", parentId="DatabaseMeta-PluginSpecific-Options", type=GuiElementType.CHECKBOX, label="i18n:org.apache.hop.ui.core.database:DatabaseDialog.label.UseIntegratedSecurity")
    @HopMetadataProperty
    private boolean usingIntegratedSecurity;

    public void widgetsCreated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetsPopulated(GuiCompositeWidgets compositeWidgets) {
        this.enableField(compositeWidgets);
    }

    public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
        this.enableField(compositeWidgets);
    }

    public void persistContents(GuiCompositeWidgets compositeWidgets) {
    }

    private void enableField(GuiCompositeWidgets compositeWidgets) {
        String[] ids;
        ArrayList<Control> controls = new ArrayList<Control>();
        for (String id : ids = new String[]{"username-label", "username-widget", "password-label", "password-widget"}) {
            Control control = (Control)compositeWidgets.getWidgetsMap().get(id);
            if (control == null) continue;
            controls.add(control);
        }
        Button wIntegratedSecurity = (Button)compositeWidgets.getWidgetsMap().get(ID_INTEGRATED_SECURITY_WIDGET);
        boolean enable = !wIntegratedSecurity.getSelection();
        for (Control control : controls) {
            control.setEnabled(enable);
        }
    }

    public boolean isUsingIntegratedSecurity() {
        return this.usingIntegratedSecurity;
    }

    public void setUsingIntegratedSecurity(boolean usingIntegratedSecurity) {
        this.usingIntegratedSecurity = usingIntegratedSecurity;
    }

    public String getDriverClass() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    public String getURL(String serverName, String port, String databaseName) {
        StringBuilder sb = new StringBuilder("jdbc:sqlserver://");
        sb.append(serverName);
        if (!Utils.isEmpty((CharSequence)port) && Const.toInt((String)port, (int)-1) > 0) {
            sb.append(':');
            sb.append(port);
        } else if (!Utils.isEmpty((CharSequence)this.getInstanceName())) {
            sb.append('\\');
            sb.append(this.getInstanceName());
        }
        if (!Utils.isEmpty((CharSequence)databaseName)) {
            sb.append(";databaseName=");
            sb.append(databaseName);
        }
        if (this.usingIntegratedSecurity) {
            sb.append(";integratedSecurity=");
            sb.append(String.valueOf(this.usingIntegratedSecurity));
        }
        return sb.toString();
    }

    public boolean supportsGetBlob() {
        return false;
    }

    public boolean isMsSqlServerNativeVariant() {
        return true;
    }

    public String getStartQuote() {
        return "";
    }

    public String getEndQuote() {
        return "";
    }

    public String getSchemaTableCombination(String schemaName, String tablePart) {
        if (this.isUsingDoubleDecimalAsSchemaTableSeparator()) {
            return schemaName + ".." + tablePart;
        }
        return '[' + schemaName + ']' + "." + tablePart;
    }
}

