/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.storage;

import org.apache.beam.sdk.extensions.gcp.storage.GcsCreateOptions;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_GcsCreateOptions
extends GcsCreateOptions {
    private final String mimeType;
    private final @Nullable Integer gcsUploadBufferSizeBytes;

    private AutoValue_GcsCreateOptions(String mimeType, @Nullable Integer gcsUploadBufferSizeBytes) {
        this.mimeType = mimeType;
        this.gcsUploadBufferSizeBytes = gcsUploadBufferSizeBytes;
    }

    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public @Nullable Integer gcsUploadBufferSizeBytes() {
        return this.gcsUploadBufferSizeBytes;
    }

    public String toString() {
        return "GcsCreateOptions{mimeType=" + this.mimeType + ", gcsUploadBufferSizeBytes=" + this.gcsUploadBufferSizeBytes + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GcsCreateOptions) {
            GcsCreateOptions that = (GcsCreateOptions)((Object)o);
            return this.mimeType.equals(that.mimeType()) && (this.gcsUploadBufferSizeBytes == null ? that.gcsUploadBufferSizeBytes() == null : this.gcsUploadBufferSizeBytes.equals(that.gcsUploadBufferSizeBytes()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.mimeType.hashCode();
        h$ *= 1000003;
        return h$ ^= this.gcsUploadBufferSizeBytes == null ? 0 : this.gcsUploadBufferSizeBytes.hashCode();
    }

    static final class Builder
    extends GcsCreateOptions.Builder {
        private String mimeType;
        private @Nullable Integer gcsUploadBufferSizeBytes;

        Builder() {
        }

        public GcsCreateOptions.Builder setMimeType(String mimeType) {
            if (mimeType == null) {
                throw new NullPointerException("Null mimeType");
            }
            this.mimeType = mimeType;
            return this;
        }

        @Override
        public GcsCreateOptions.Builder setGcsUploadBufferSizeBytes(@Nullable Integer gcsUploadBufferSizeBytes) {
            this.gcsUploadBufferSizeBytes = gcsUploadBufferSizeBytes;
            return this;
        }

        @Override
        public GcsCreateOptions build() {
            String missing = "";
            if (this.mimeType == null) {
                missing = missing + " mimeType";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GcsCreateOptions(this.mimeType, this.gcsUploadBufferSizeBytes);
        }
    }
}

