/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.googlebigquery;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.i18n.BaseMessages;

@DatabaseMetaPlugin(type="GOOGLEBIGQUERY", typeDescription="Google BigQuery")
@GuiPlugin(id="GUI-GoogleBigQueryDatabaseMeta")
public class GoogleBigQueryDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    private static final Class<?> PKG = GoogleBigQueryDatabaseMeta.class;

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public String getDriverClass() {
        return "com.simba.googlebigquery.jdbc42.Driver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:bigquery://" + hostname + ":" + (StringUtil.isEmpty((String)port) ? "443" : port) + ";" + (StringUtil.isEmpty((String)databaseName) ? "" : "ProjectId=" + databaseName) + ";";
    }

    public String getExtraOptionsHelpText() {
        return "https://cloud.google.com/bigquery/partners/simba-drivers/";
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 9: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 3: {
                retval = retval + "DATE";
                break;
            }
            case 4: {
                retval = retval + "BOOL";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                retval = precision == 0 ? retval + "INT64" : retval + "FLOAT64";
                if (!fieldname.equalsIgnoreCase(tk) && !fieldname.equalsIgnoreCase(pk)) break;
                retval = retval + " NOT NULL";
                break;
            }
            case 2: {
                retval = retval + "STRING";
                break;
            }
            case 8: {
                retval = retval + "BYTES";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return null;
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return null;
    }

    public String getLimitClause(int nrRows) {
        return " LIMIT " + nrRows;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " LIMIT 0";
    }

    public String getSqlTableExists(String tableName) {
        return this.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        return this.getSqlQueryColumnFields(columnname, tableName);
    }

    public String getSqlQueryColumnFields(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName + " LIMIT 0";
    }

    public boolean supportsAutoInc() {
        return false;
    }

    public boolean supportsAutoGeneratedKeys() {
        return false;
    }

    public boolean supportsTimeStampToDateConversion() {
        return false;
    }

    public boolean supportsBooleanDataType() {
        return true;
    }

    public boolean isRequiringTransactionsOnQueries() {
        return false;
    }

    public String getExtraOptionSeparator() {
        return ";";
    }

    public String getExtraOptionIndicator() {
        return "";
    }

    public String getStartQuote() {
        return "`";
    }

    public String getEndQuote() {
        return "`";
    }

    public boolean supportsBitmapIndex() {
        return false;
    }

    public boolean supportsViews() {
        return true;
    }

    public boolean supportsSynonyms() {
        return false;
    }

    public String[] getReservedWords() {
        return new String[]{"ALL", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERT_ROWS_MODIFIED", "AT", "BETWEEN", "COLLATE", "CONTAINS", "CREATE", "CROSS", "CUBE", "CURRENT", "DEFAULT", "DEFINE", "DESC", "DISTINCT", "ELSE", "END", "ENUM", "ESCAPE", "EXCEPT", "EXCLUDE", "EXISTS", "EXTRACT", "FALSE", "FETCH", "FOLLOWING", "FOR", "FROM", "FULL", "GROUP", "GROUPING", "GROUPS", "HASH", "HAVING", "IF", "IGNORE", "IN", "INNER", "INTERSECT", "INTERVAL", "INTO", "IS", "JOIN", "LATERAL", "LEFT", "LIKE", "LIMIT", "LOOKUP", "MERGE", "NATURAL", "NEW", "NO", "NOT", "NULL", "NULLS", "OF", "ON", "OR", "ORDER", "OUTER", "OVER", "PARTITION", "PRECEDING", "PROTO", "RANGE", "RECURSIVE", "RESPECT", "RIGHT", "ROLLUP", "ROWS", "SELECT", "SET", "SOME", "STRUCT", "TABLESAMPLE", "THEN", "TO", "TREAT", "TRUE", "UNBOUNDED", "UNION", "UNNEST", "USING", "WHEN", "WHERE", "WINDOW", "WITH", "WITHIN", "BY", "CASE", "CAST"};
    }

    public boolean supportsStandardTableOutput() {
        return false;
    }

    public String getUnsupportedTableOutputMessage() {
        return BaseMessages.getString(PKG, (String)"GoogleBigQueryDatabaseMeta.UnsupportedTableOutputMessage", (String[])new String[0]);
    }
}

