/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.execprocess;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.execprocess.ExecProcess;
import org.apache.hop.pipeline.transforms.execprocess.ExecProcessData;
import org.w3c.dom.Node;

@Transform(id="ExecProcess", image="execprocess.svg", name="i18n::BaseTransform.TypeLongDesc.ExecProcess", description="i18n::BaseTransform.TypeTooltipDesc.ExecProcess", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", documentationUrl="/pipeline/transforms/execprocess.html")
public class ExecProcessMeta
extends BaseTransformMeta
implements ITransformMeta<ExecProcess, ExecProcessData> {
    private static final Class<?> PKG = ExecProcessMeta.class;
    private String processfield;
    private String resultfieldname;
    private String errorfieldname;
    private String exitvaluefieldname;
    private boolean failwhennotsuccess;
    public String outputLineDelimiter = "";
    private boolean argumentsInFields;
    private String[] argumentFieldNames;

    public ExecProcessMeta() {
        this.allocate(0);
    }

    public void allocate(int argumentCount) {
        this.argumentFieldNames = new String[argumentCount];
    }

    public String getProcessField() {
        return this.processfield;
    }

    public void setProcessField(String processfield) {
        this.processfield = processfield;
    }

    public String getResultFieldName() {
        return this.resultfieldname;
    }

    public void setResultFieldName(String resultfieldname) {
        this.resultfieldname = resultfieldname;
    }

    public String getErrorFieldName() {
        return this.errorfieldname;
    }

    public void setErrorFieldName(String errorfieldname) {
        this.errorfieldname = errorfieldname;
    }

    public String getExitValueFieldName() {
        return this.exitvaluefieldname;
    }

    public void setExitValueFieldName(String exitvaluefieldname) {
        this.exitvaluefieldname = exitvaluefieldname;
    }

    public boolean isFailWhenNotSuccess() {
        return this.failwhennotsuccess;
    }

    public void setFailWhenNotSuccess(boolean failwhennotsuccess) {
        this.failwhennotsuccess = failwhennotsuccess;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public Object clone() {
        ExecProcessMeta retval = (ExecProcessMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.resultfieldname = "Result output";
        this.errorfieldname = "Error output";
        this.exitvaluefieldname = "Exit value";
        this.failwhennotsuccess = false;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        String realexitvaluefieldname;
        String realerrofieldname;
        String realOutputFieldname = variables.resolve(this.resultfieldname);
        if (!Utils.isEmpty((CharSequence)realOutputFieldname)) {
            ValueMetaString v = new ValueMetaString(realOutputFieldname);
            v.setLength(100, -1);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(realerrofieldname = variables.resolve(this.errorfieldname)))) {
            ValueMetaString v = new ValueMetaString(realerrofieldname);
            v.setLength(100, -1);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(realexitvaluefieldname = variables.resolve(this.exitvaluefieldname)))) {
            ValueMetaInteger v = new ValueMetaInteger(realexitvaluefieldname);
            v.setLength(10, 0);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XmlHandler.addTagValue((String)"processfield", (String)this.processfield));
        retval.append("    " + XmlHandler.addTagValue((String)"resultfieldname", (String)this.resultfieldname));
        retval.append("    " + XmlHandler.addTagValue((String)"errorfieldname", (String)this.errorfieldname));
        retval.append("    " + XmlHandler.addTagValue((String)"exitvaluefieldname", (String)this.exitvaluefieldname));
        retval.append("    " + XmlHandler.addTagValue((String)"failwhennotsuccess", (boolean)this.failwhennotsuccess));
        retval.append("    " + XmlHandler.addTagValue((String)"outputlinedelimiter", (String)this.outputLineDelimiter));
        retval.append("    ").append(XmlHandler.addTagValue((String)"argumentsInFields", (boolean)this.argumentsInFields));
        retval.append("    ").append(XmlHandler.openTag((String)"argumentFields")).append(Const.CR);
        for (int i = 0; i < this.argumentFieldNames.length; ++i) {
            retval.append("      ").append(XmlHandler.openTag((String)"argumentField")).append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"argumentFieldName", (String)this.argumentFieldNames[i]));
            retval.append("      ").append(XmlHandler.closeTag((String)"argumentField")).append(Const.CR);
        }
        retval.append("    ").append(XmlHandler.closeTag((String)"argumentFields")).append(Const.CR);
        return retval.toString();
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.processfield = XmlHandler.getTagValue((Node)transformNode, (String)"processfield");
            this.resultfieldname = XmlHandler.getTagValue((Node)transformNode, (String)"resultfieldname");
            this.errorfieldname = XmlHandler.getTagValue((Node)transformNode, (String)"errorfieldname");
            this.exitvaluefieldname = XmlHandler.getTagValue((Node)transformNode, (String)"exitvaluefieldname");
            this.failwhennotsuccess = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"failwhennotsuccess"));
            this.outputLineDelimiter = XmlHandler.getTagValue((Node)transformNode, (String)"outputlinedelimiter");
            if (this.outputLineDelimiter == null) {
                this.outputLineDelimiter = "";
            }
            this.argumentsInFields = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"argumentsInFields"));
            Node argumentFieldsNode = XmlHandler.getSubNode((Node)transformNode, (String)"argumentFields");
            if (argumentFieldsNode == null) {
                this.argumentFieldNames = new String[0];
            } else {
                int argumentFieldCount = XmlHandler.countNodes((Node)argumentFieldsNode, (String)"argumentField");
                this.argumentFieldNames = new String[argumentFieldCount];
                for (int i = 0; i < argumentFieldCount; ++i) {
                    Node fnode = XmlHandler.getSubNodeByNr((Node)argumentFieldsNode, (String)"argumentField", (int)i);
                    this.argumentFieldNames[i] = XmlHandler.getTagValue((Node)fnode, (String)"argumentFieldName");
                }
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ExecProcessMeta.Exception.UnableToReadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (Utils.isEmpty((CharSequence)this.resultfieldname)) {
            errorMessage = BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
        }
        remarks.add((ICheckResult)cr);
        if (Utils.isEmpty((CharSequence)this.processfield)) {
            errorMessage = BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ProcessFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ProcessFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
        }
        remarks.add((ICheckResult)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public ExecProcess createTransform(TransformMeta transformMeta, ExecProcessData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new ExecProcess(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public ExecProcessData getTransformData() {
        return new ExecProcessData();
    }

    public boolean supportsErrorHandling() {
        return this.failwhennotsuccess;
    }

    public void setOutputLineDelimiter(String value) {
        this.outputLineDelimiter = value;
    }

    public String getOutputLineDelimiter() {
        return this.outputLineDelimiter;
    }

    public boolean isArgumentsInFields() {
        return this.argumentsInFields;
    }

    public void setArgumentsInFields(boolean argumentsInFields) {
        this.argumentsInFields = argumentsInFields;
    }

    public String[] getArgumentFieldNames() {
        return this.argumentFieldNames;
    }

    public void setArgumentFieldNames(String[] argumentFieldNames) {
        this.argumentFieldNames = argumentFieldNames;
    }
}

