/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.execprocess;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.execprocess.ExecProcessData;
import org.apache.hop.pipeline.transforms.execprocess.ExecProcessMeta;
import org.apache.hop.pipeline.transforms.execprocess.ProcessResult;

public class ExecProcess
extends BaseTransform<ExecProcessMeta, ExecProcessData>
implements ITransform<ExecProcessMeta, ExecProcessData> {
    private static final Class<?> PKG = ExecProcessMeta.class;

    public ExecProcess(TransformMeta transformMeta, ExecProcessMeta meta, ExecProcessData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block18: {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((ExecProcessData)this.data).previousRowMeta = this.getInputRowMeta().clone();
                ((ExecProcessData)this.data).NrPrevFields = ((ExecProcessData)this.data).previousRowMeta.size();
                ((ExecProcessData)this.data).outputRowMeta = ((ExecProcessData)this.data).previousRowMeta;
                ((ExecProcessMeta)this.meta).getFields(((ExecProcessData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (Utils.isEmpty((CharSequence)((ExecProcessMeta)this.meta).getProcessField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"ExecProcess.Error.ProcessFieldMissing", (String[])new String[0]));
                    throw new HopException(BaseMessages.getString(PKG, (String)"ExecProcess.Error.ProcessFieldMissing", (String[])new String[0]));
                }
                if (((ExecProcessData)this.data).indexOfProcess < 0) {
                    ((ExecProcessData)this.data).indexOfProcess = ((ExecProcessData)this.data).previousRowMeta.indexOfValue(((ExecProcessMeta)this.meta).getProcessField());
                    if (((ExecProcessData)this.data).indexOfProcess < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"ExecProcess.Exception.CouldnotFindField", (String[])new String[0]) + "[" + ((ExecProcessMeta)this.meta).getProcessField() + "]");
                        throw new HopException(BaseMessages.getString(PKG, (String)"ExecProcess.Exception.CouldnotFindField", (String[])new String[]{((ExecProcessMeta)this.meta).getProcessField()}));
                    }
                }
                if (((ExecProcessMeta)this.meta).isArgumentsInFields() && ((ExecProcessData)this.data).indexOfArguments == null) {
                    ((ExecProcessData)this.data).indexOfArguments = new int[((ExecProcessMeta)this.meta).getArgumentFieldNames().length];
                    for (int i = 0; i < ((ExecProcessData)this.data).indexOfArguments.length; ++i) {
                        String fieldName = ((ExecProcessMeta)this.meta).getArgumentFieldNames()[i];
                        ((ExecProcessData)this.data).indexOfArguments[i] = ((ExecProcessData)this.data).previousRowMeta.indexOfValue(fieldName);
                        if (((ExecProcessData)this.data).indexOfArguments[i] >= 0) continue;
                        this.logError(BaseMessages.getString(PKG, (String)"ExecProcess.Exception.CouldnotFindField", (String[])new String[0]) + "[" + fieldName + "]");
                        throw new HopException(BaseMessages.getString(PKG, (String)"ExecProcess.Exception.CouldnotFindField", (String[])new String[]{fieldName}));
                    }
                }
            }
            Object[] outputRow = RowDataUtil.allocateRowData((int)((ExecProcessData)this.data).outputRowMeta.size());
            for (int i = 0; i < ((ExecProcessData)this.data).NrPrevFields; ++i) {
                outputRow[i] = r[i];
            }
            String processString = ((ExecProcessData)this.data).previousRowMeta.getString(r, ((ExecProcessData)this.data).indexOfProcess);
            ProcessResult processResult = new ProcessResult();
            try {
                if (Utils.isEmpty((CharSequence)processString)) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ExecProcess.ProcessEmpty", (String[])new String[0]));
                }
                if (((ExecProcessMeta)this.meta).isArgumentsInFields()) {
                    ArrayList<String> cmdArray = new ArrayList<String>();
                    cmdArray.add(processString);
                    for (int i = 0; i < ((ExecProcessData)this.data).indexOfArguments.length; ++i) {
                        String argString = ((ExecProcessData)this.data).previousRowMeta.getString(r, ((ExecProcessData)this.data).indexOfArguments[i]);
                        cmdArray.add(Const.NVL((String)argString, (String)""));
                    }
                    this.execProcess(cmdArray.toArray(new String[0]), processResult);
                } else {
                    this.execProcess(processString, processResult);
                }
                if (((ExecProcessMeta)this.meta).isFailWhenNotSuccess() && processResult.getExistStatus() != 0L) {
                    String errorString = processResult.getErrorStream();
                    if (Utils.isEmpty((CharSequence)errorString)) {
                        errorString = processResult.getOutputStream();
                    }
                    throw new HopException(errorString);
                }
                int rowIndex = ((ExecProcessData)this.data).NrPrevFields;
                outputRow[rowIndex++] = processResult.getOutputStream();
                outputRow[rowIndex++] = processResult.getErrorStream();
                outputRow[rowIndex++] = processResult.getExistStatus();
                this.putRow(((ExecProcessData)this.data).outputRowMeta, outputRow);
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"ExecProcess.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (HopException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ExecProcess.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block18;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, ((ExecProcessMeta)this.meta).getResultFieldName(), "ExecProcess001");
            }
        }
        return true;
    }

    private void execProcess(String process, ProcessResult processresult) throws HopException {
        this.execProcess(new String[]{process}, processresult);
    }

    private void execProcess(String[] process, ProcessResult processresult) throws HopException {
        Process p = null;
        try {
            String errorMsg = null;
            try {
                p = !((ExecProcessMeta)this.meta).isArgumentsInFields() ? ((ExecProcessData)this.data).runtime.exec(process[0]) : ((ExecProcessData)this.data).runtime.exec(process);
            }
            catch (Exception e) {
                errorMsg = e.getMessage();
            }
            if (p == null) {
                processresult.setErrorStream(errorMsg);
            } else {
                processresult.setOutputStream(this.getOutputString(new BufferedReader(new InputStreamReader(p.getInputStream()))));
                processresult.setErrorStream(this.getOutputString(new BufferedReader(new InputStreamReader(p.getErrorStream()))));
                p.waitFor();
                processresult.setExistStatus(p.exitValue());
            }
        }
        catch (IOException ioe) {
            throw new HopException("IO exception while running the process " + Arrays.toString(process) + "!", (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new HopException("Interrupted exception while running the process " + Arrays.toString(process) + "!", (Throwable)ie);
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    private String getOutputString(BufferedReader b) throws IOException {
        String line;
        StringBuilder retvalBuff = new StringBuilder();
        String delim = ((ExecProcessMeta)this.meta).getOutputLineDelimiter();
        delim = delim == null ? "" : this.resolve(delim);
        while ((line = b.readLine()) != null) {
            if (retvalBuff.length() > 0) {
                retvalBuff.append(delim);
            }
            retvalBuff.append(line);
        }
        return retvalBuff.toString();
    }

    public boolean init() {
        if (super.init()) {
            if (Utils.isEmpty((CharSequence)((ExecProcessMeta)this.meta).getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"ExecProcess.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            ((ExecProcessData)this.data).runtime = Runtime.getRuntime();
            return true;
        }
        return false;
    }
}

