/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getfilenames;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getfilenames.GetFileNames;
import org.apache.hop.pipeline.transforms.getfilenames.GetFileNamesData;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.w3c.dom.Node;

@Transform(id="GetFileNames", image="getfilenames.svg", name="i18n::BaseTransform.TypeLongDesc.GetFileNames", description="i18n::BaseTransform.TypeTooltipDesc.GetFileNames", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/getfilenames.html")
public class GetFileNamesMeta
extends BaseTransformMeta
implements ITransformMeta<GetFileNames, GetFileNamesData> {
    private static final Class<?> PKG = GetFileNamesMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private static final String NO = "N";
    private static final String YES = "Y";
    private String[] fileName;
    private String[] fileMask;
    private String[] excludeFileMask;
    private String[] fileRequired;
    private String[] includeSubFolders;
    private FileInputList.FileTypeFilter fileTypeFilter;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private String dynamicFilenameField;
    private String dynamicWildcardField;
    private String dynamicExcludeWildcardField;
    private boolean filefield;
    private boolean dynamicIncludeSubFolders;
    private boolean isaddresult;
    private long rowLimit;
    private boolean doNotFailIfNoFile;

    public boolean isdoNotFailIfNoFile() {
        return this.doNotFailIfNoFile;
    }

    public void setdoNotFailIfNoFile(boolean doNotFailIfNoFile) {
        this.doNotFailIfNoFile = doNotFailIfNoFile;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setDynamicFilenameField(String dynamicFilenameField) {
        this.dynamicFilenameField = dynamicFilenameField;
    }

    public void setDynamicWildcardField(String dynamicWildcardField) {
        this.dynamicWildcardField = dynamicWildcardField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getDynamicFilenameField() {
        return this.dynamicFilenameField;
    }

    public String getDynamicWildcardField() {
        return this.dynamicWildcardField;
    }

    public String getDynamicExcludeWildcardField() {
        return this.dynamicExcludeWildcardField;
    }

    public void setDynamicExcludeWildcardField(String dynamicExcludeWildcardField) {
        this.dynamicExcludeWildcardField = dynamicExcludeWildcardField;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public boolean isFileField() {
        return this.filefield;
    }

    public void setFileField(boolean filefield) {
        this.filefield = filefield;
    }

    public boolean isDynamicIncludeSubFolders() {
        return this.dynamicIncludeSubFolders;
    }

    public void setDynamicIncludeSubFolders(boolean dynamicIncludeSubFolders) {
        this.dynamicIncludeSubFolders = dynamicIncludeSubFolders;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public String[] getExcludeFileMask() {
        return this.excludeFileMask;
    }

    public void setFileRequired(String[] fileRequiredin) {
        this.fileRequired = new String[fileRequiredin.length];
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        this.includeSubFolders = new String[includeSubFoldersin.length];
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    @Deprecated
    public void setFilterFileType(int filtertypevalue) {
        this.fileTypeFilter = FileInputList.FileTypeFilter.getByOrdinal((int)filtertypevalue);
    }

    public void setFilterFileType(FileInputList.FileTypeFilter filter) {
        this.fileTypeFilter = filter;
    }

    public FileInputList.FileTypeFilter getFileTypeFilter() {
        return this.fileTypeFilter;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        GetFileNamesMeta retval = (GetFileNamesMeta)((Object)super.clone());
        int nrfiles = this.fileName.length;
        retval.allocate(nrfiles);
        System.arraycopy(this.fileName, 0, retval.fileName, 0, nrfiles);
        System.arraycopy(this.fileMask, 0, retval.fileMask, 0, nrfiles);
        System.arraycopy(this.excludeFileMask, 0, retval.excludeFileMask, 0, nrfiles);
        System.arraycopy(this.fileRequired, 0, retval.fileRequired, 0, nrfiles);
        System.arraycopy(this.includeSubFolders, 0, retval.includeSubFolders, 0, nrfiles);
        return retval;
    }

    public void allocate(int nrfiles) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
    }

    public void setDefault() {
        int nrfiles = 0;
        this.doNotFailIfNoFile = false;
        this.fileTypeFilter = FileInputList.FileTypeFilter.FILES_AND_FOLDERS;
        this.isaddresult = true;
        this.filefield = false;
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.dynamicFilenameField = "";
        this.dynamicWildcardField = "";
        this.dynamicIncludeSubFolders = false;
        this.dynamicExcludeWildcardField = "";
        this.allocate(nrfiles);
        for (int i = 0; i < nrfiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = NO;
            this.includeSubFolders[i] = NO;
        }
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString filename = new ValueMetaString("filename");
        filename.setLength(500);
        filename.setPrecision(-1);
        filename.setOrigin(name);
        row.addValueMeta((IValueMeta)filename);
        ValueMetaString shortFilename = new ValueMetaString("short_filename");
        shortFilename.setLength(500);
        shortFilename.setPrecision(-1);
        shortFilename.setOrigin(name);
        row.addValueMeta((IValueMeta)shortFilename);
        ValueMetaString path = new ValueMetaString("path");
        path.setLength(500);
        path.setPrecision(-1);
        path.setOrigin(name);
        row.addValueMeta((IValueMeta)path);
        ValueMetaString type = new ValueMetaString("type");
        type.setLength(500);
        type.setPrecision(-1);
        type.setOrigin(name);
        row.addValueMeta((IValueMeta)type);
        ValueMetaBoolean exists = new ValueMetaBoolean("exists");
        exists.setOrigin(name);
        row.addValueMeta((IValueMeta)exists);
        ValueMetaBoolean ishidden = new ValueMetaBoolean("ishidden");
        ishidden.setOrigin(name);
        row.addValueMeta((IValueMeta)ishidden);
        ValueMetaBoolean isreadable = new ValueMetaBoolean("isreadable");
        isreadable.setOrigin(name);
        row.addValueMeta((IValueMeta)isreadable);
        ValueMetaBoolean iswriteable = new ValueMetaBoolean("iswriteable");
        iswriteable.setOrigin(name);
        row.addValueMeta((IValueMeta)iswriteable);
        ValueMetaDate lastmodifiedtime = new ValueMetaDate("lastmodifiedtime");
        lastmodifiedtime.setOrigin(name);
        row.addValueMeta((IValueMeta)lastmodifiedtime);
        ValueMetaInteger size = new ValueMetaInteger("size");
        size.setOrigin(name);
        row.addValueMeta((IValueMeta)size);
        ValueMetaString extension = new ValueMetaString("extension");
        extension.setOrigin(name);
        row.addValueMeta((IValueMeta)extension);
        ValueMetaString uri = new ValueMetaString("uri");
        uri.setOrigin(name);
        row.addValueMeta((IValueMeta)uri);
        ValueMetaString rooturi = new ValueMetaString("rooturi");
        rooturi.setOrigin(name);
        row.addValueMeta((IValueMeta)rooturi);
        if (this.includeRowNumber) {
            ValueMetaInteger v = new ValueMetaInteger(variables.resolve(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    <filter>").append(Const.CR);
        retval.append("      ").append(XmlHandler.addTagValue((String)"filterfiletype", (String)this.fileTypeFilter.toString()));
        retval.append("    </filter>").append(Const.CR);
        retval.append("    ").append(XmlHandler.addTagValue((String)"doNotFailIfNoFile", (boolean)this.doNotFailIfNoFile));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XmlHandler.addTagValue((String)"isaddresult", (boolean)this.isaddresult));
        retval.append("    ").append(XmlHandler.addTagValue((String)"filefield", (boolean)this.filefield));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"filename_Field", (String)this.dynamicFilenameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"wildcard_Field", (String)this.dynamicWildcardField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"exclude_wildcard_Field", (String)this.dynamicExcludeWildcardField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"dynamic_include_subfolders", (boolean)this.dynamicIncludeSubFolders));
        retval.append("    ").append(XmlHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    <file>").append(Const.CR);
        for (int i = 0; i < this.fileName.length; ++i) {
            retval.append("      ").append(XmlHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"exclude_filemask", (String)this.excludeFileMask[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append("    </file>").append(Const.CR);
        return retval.toString();
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            Node filternode = XmlHandler.getSubNode((Node)transformNode, (String)"filter");
            Node filterfiletypenode = XmlHandler.getSubNode((Node)filternode, (String)"filterfiletype");
            this.fileTypeFilter = FileInputList.FileTypeFilter.getByName((String)XmlHandler.getNodeValue((Node)filterfiletypenode));
            this.doNotFailIfNoFile = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"doNotFailIfNoFile"));
            this.includeRowNumber = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"rownum"));
            this.isaddresult = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"isaddresult"));
            this.filefield = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"filefield"));
            this.rowNumberField = XmlHandler.getTagValue((Node)transformNode, (String)"rownum_field");
            this.dynamicFilenameField = XmlHandler.getTagValue((Node)transformNode, (String)"filename_Field");
            this.dynamicWildcardField = XmlHandler.getTagValue((Node)transformNode, (String)"wildcard_Field");
            this.dynamicExcludeWildcardField = XmlHandler.getTagValue((Node)transformNode, (String)"exclude_wildcard_Field");
            this.dynamicIncludeSubFolders = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"dynamic_include_subfolders"));
            this.rowLimit = Const.toLong((String)XmlHandler.getTagValue((Node)transformNode, (String)"limit"), (long)0L);
            Node filenode = XmlHandler.getSubNode((Node)transformNode, (String)"file");
            int nrfiles = XmlHandler.countNodes((Node)filenode, (String)"name");
            this.allocate(nrfiles);
            for (int i = 0; i < nrfiles; ++i) {
                Node filenamenode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = XmlHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XmlHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XmlHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XmlHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XmlHandler.getNodeValue((Node)includeSubFoldersnode);
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    private boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    private FileInputList.FileTypeFilter[] buildFileTypeFiltersArray(String[] fileName) {
        FileInputList.FileTypeFilter[] filters = new FileInputList.FileTypeFilter[fileName.length];
        for (int i = 0; i < fileName.length; ++i) {
            filters[i] = this.getFileTypeFilter();
        }
        return filters;
    }

    public String[] getFilePaths(IVariables variables) {
        return FileInputList.createFilePathList((IVariables)variables, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean(), (FileInputList.FileTypeFilter[])this.buildFileTypeFiltersArray(this.fileName));
    }

    public FileInputList getFileList(IVariables variables) {
        return FileInputList.createFileList((IVariables)variables, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean(), (FileInputList.FileTypeFilter[])this.buildFileTypeFiltersArray(this.fileName));
    }

    public FileInputList getDynamicFileList(IVariables variables, String[] filename, String[] filemask, String[] excludefilemask, String[] filerequired, boolean[] includesubfolders) {
        return FileInputList.createFileList((IVariables)variables, (String[])filename, (String[])filemask, (String[])excludefilemask, (String[])filerequired, (boolean[])includesubfolders, (FileInputList.FileTypeFilter[])this.buildFileTypeFiltersArray(filename));
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (this.filefield) {
            CheckResult cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.InputOk", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.InputErrorKo", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            cr = Utils.isEmpty((CharSequence)this.dynamicFilenameField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.FolderFieldnameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.FolderFieldnameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.NoInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            FileInputList fileList = this.getFileList(variables);
            cr = fileList.nrOfFiles() == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.ExpectedFilesError", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.ExpectedFilesOk", (String[])new String[]{"" + fileList.nrOfFiles()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, TransformMeta transformMeta) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference((IResourceHolder)transformMeta);
        references.add(reference);
        String[] files = this.getFilePaths(variables);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                reference.getEntries().add(new ResourceEntry(files[i], ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public GetFileNames createTransform(TransformMeta transformMeta, GetFileNamesData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new GetFileNames(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public GetFileNamesData getTransformData() {
        return new GetFileNamesData();
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.filefield) {
                for (int i = 0; i < this.fileName.length; ++i) {
                    FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.fileName[i]));
                    this.fileName[i] = iResourceNaming.nameResource(fileObject, variables, Utils.isEmpty((CharSequence)this.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

