/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.sqlite;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="SQLITE", typeDescription="SQLite")
@GuiPlugin(id="GUI-SQLiteDatabaseMeta")
public class SqliteDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getNotFoundTK(boolean useAutoinc) {
        if (this.supportsAutoInc() && useAutoinc) {
            return 1;
        }
        return super.getNotFoundTK(useAutoinc);
    }

    public String getDriverClass() {
        return "org.sqlite.JDBC";
    }

    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:sqlite:" + databaseName;
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public boolean supportsBitmapIndex() {
        return false;
    }

    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " MODIFY " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = retval + "DATETIME";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = retval + "INTEGER PRIMARY KEY AUTOINCREMENT";
                    break;
                }
                if (precision != 0 || length < 0 || length > 18) {
                    retval = retval + "NUMERIC";
                    break;
                }
                retval = retval + "INTEGER";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = retval + "BLOB";
                    break;
                }
                retval = retval + "TEXT";
                break;
            }
            case 8: {
                retval = retval + "BLOB";
                break;
            }
            default: {
                retval = retval + "UNKNOWN";
            }
        }
        if (addCr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public boolean supportsErrorHandling() {
        return false;
    }

    public boolean isSqliteVariant() {
        return true;
    }
}

