/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.workflowexecutor;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transforms.workflowexecutor.WorkflowExecutorMeta;
import org.apache.hop.pipeline.transforms.workflowexecutor.WorkflowExecutorParameters;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ColumnsResizer;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.workflow.HopWorkflowFileType;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class WorkflowExecutorDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = WorkflowExecutorMeta.class;
    private static int FIELD_DESCRIPTION = 1;
    private static int FIELD_NAME = 2;
    private WorkflowExecutorMeta workflowExecutorMeta;
    private Label wlPath;
    private TextVar wPath;
    private Button wbBrowse;
    protected Label wlRunConfiguration;
    protected ComboVar wRunConfiguration;
    private CTabFolder wTabFolder;
    private WorkflowMeta executorWorkflowMeta = null;
    protected boolean jobModified;
    private ModifyListener lsMod;
    private Button wInheritAll;
    private TableView wWorkflowExecutorParameters;
    private Label wlGroupSize;
    private TextVar wGroupSize;
    private Label wlGroupField;
    private CCombo wGroupField;
    private Label wlGroupTime;
    private TextVar wGroupTime;
    private Label wlExecutionResultTarget;
    private CCombo wExecutionResultTarget;
    private TableItem tiExecutionTimeField;
    private TableItem tiExecutionResultField;
    private TableItem tiExecutionNrErrorsField;
    private TableItem tiExecutionLinesReadField;
    private TableItem tiExecutionLinesWrittenField;
    private TableItem tiExecutionLinesInputField;
    private TableItem tiExecutionLinesOutputField;
    private TableItem tiExecutionLinesRejectedField;
    private TableItem tiExecutionLinesUpdatedField;
    private TableItem tiExecutionLinesDeletedField;
    private TableItem tiExecutionFilesRetrievedField;
    private TableItem tiExecutionExitStatusField;
    private TableItem tiExecutionLogTextField;
    private TableItem tiExecutionLogChannelIdField;
    private ColumnInfo[] parameterColumns;
    private Label wlResultFilesTarget;
    private CCombo wResultFilesTarget;
    private Label wlResultFileNameField;
    private TextVar wResultFileNameField;
    private Label wlResultRowsTarget;
    private CCombo wResultRowsTarget;
    private Label wlResultFields;
    private TableView wResultRowsFields;
    private Button wGetParameters;
    private HopWorkflowFileType<WorkflowMeta> fileType = HopGui.getDataOrchestrationPerspective().getWorkflowFileType();

    public WorkflowExecutorDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.workflowExecutorMeta = (WorkflowExecutorMeta)((Object)in);
        this.jobModified = false;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.workflowExecutorMeta);
        this.lsMod = e -> {
            this.workflowExecutorMeta.setChanged();
            this.setFlags();
        };
        this.changed = this.workflowExecutorMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.Shell.Title", (String[])new String[0]));
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        WorkflowExecutorDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)this.props.getMargin(), null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, 0);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.right = new FormAttachment((Control)wicon, -5);
        this.fdTransformName.left = new FormAttachment(0, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 5);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wTransformName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        this.wlPath = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlPath);
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.Workflow.Label", (String[])new String[0]));
        FormData fdlJobformation = new FormData();
        fdlJobformation.left = new FormAttachment(0, 0);
        fdlJobformation.top = new FormAttachment((Control)spacer, 20);
        fdlJobformation.right = new FormAttachment(50, 0);
        this.wlPath.setLayoutData((Object)fdlJobformation);
        this.wbBrowse = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbBrowse);
        this.wbBrowse.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.Browse.Label", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.right = new FormAttachment(100, 0);
        fdBrowse.top = new FormAttachment((Control)this.wlPath, Const.isOSX() ? 0 : 5);
        this.wbBrowse.setLayoutData((Object)fdBrowse);
        this.wbBrowse.addListener(13, e -> this.selectWorkflowFile());
        this.wPath = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPath);
        FormData fdJobformation = new FormData();
        fdJobformation.left = new FormAttachment(0, 0);
        fdJobformation.top = new FormAttachment((Control)this.wlPath, 5);
        fdJobformation.right = new FormAttachment((Control)this.wbBrowse, -this.props.getMargin());
        this.wPath.setLayoutData((Object)fdJobformation);
        this.wlRunConfiguration = new Label((Composite)this.shell, 16384);
        this.wlRunConfiguration.setText("Run configuration");
        this.props.setLook((Control)this.wlRunConfiguration);
        FormData fdlRunConfiguration = new FormData();
        fdlRunConfiguration.left = new FormAttachment(0, 0);
        fdlRunConfiguration.top = new FormAttachment((Control)this.wPath, PropsUi.getInstance().getMargin());
        fdlRunConfiguration.right = new FormAttachment(50, 0);
        this.wlRunConfiguration.setLayoutData((Object)fdlRunConfiguration);
        this.wRunConfiguration = new ComboVar(this.variables, (Composite)this.shell, 18432);
        this.props.setLook((Control)this.wlRunConfiguration);
        FormData fdRunConfiguration = new FormData();
        fdRunConfiguration.left = new FormAttachment(0, 0);
        fdRunConfiguration.top = new FormAttachment((Control)this.wlRunConfiguration, PropsUi.getInstance().getMargin());
        fdRunConfiguration.right = new FormAttachment(100, 0);
        this.wRunConfiguration.setLayoutData((Object)fdRunConfiguration);
        this.props.setLook((Control)this.wRunConfiguration);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setUnselectedCloseVisible(true);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wRunConfiguration, 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.addParametersTab();
        this.addExecutionResultTab();
        this.addRowGroupTab();
        this.addResultRowsTab();
        this.addResultFilesTab();
        this.getData();
        this.workflowExecutorMeta.setChanged(this.changed);
        this.wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"ui/images/workflowexecutor.svg", (int)48, (int)48);
    }

    private void selectWorkflowFile() {
        String curFile = this.variables.resolve(this.wPath.getText());
        String parentFolder = null;
        try {
            parentFolder = HopVfs.getFileObject((String)this.variables.resolve(this.pipelineMeta.getFilename())).getParent().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String filename = BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wPath, (IVariables)this.variables, (String[])this.fileType.getFilterExtensions(), (String[])this.fileType.getFilterNames(), (boolean)true);
            if (filename != null) {
                this.loadWorkflowFile(filename);
                if (parentFolder != null && filename.startsWith(parentFolder)) {
                    filename = filename.replace(parentFolder, "${Internal.Entry.Current.Folder}");
                }
                this.wPath.setText(filename);
            }
            if (filename != null) {
                this.replaceNameWithBaseFilename(filename);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ErrorLoadingWorkflow.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ErrorLoadingWorkflow.DialogMessage", (String[])new String[0]), e);
        }
    }

    private void loadWorkflowFile(String fname) throws HopException {
        this.executorWorkflowMeta = new WorkflowMeta(this.variables.resolve(fname));
        this.executorWorkflowMeta.clearChanged();
    }

    private void loadWorkflow() throws HopException {
        String filename = this.wPath.getText();
        if (Utils.isEmpty((CharSequence)filename)) {
            return;
        }
        if (!filename.endsWith(".hwf")) {
            filename = filename + ".hwf";
            this.wPath.setText(filename);
        }
        this.loadWorkflowFile(filename);
    }

    public void getData() {
        this.wPath.setText(Const.NVL((String)this.workflowExecutorMeta.getFilename(), (String)""));
        try {
            List runConfigurations = this.metadataProvider.getSerializer(WorkflowRunConfiguration.class).listObjectNames();
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiRunConfiguration.id, (Object)new Object[]{runConfigurations, "workflow"});
            }
            catch (HopException hopException) {
                // empty catch block
            }
            this.wRunConfiguration.setItems(runConfigurations.toArray(new String[0]));
            this.wRunConfiguration.setText(Const.NVL((String)this.workflowExecutorMeta.getRunConfigurationName(), (String)""));
            if (Utils.isEmpty((CharSequence)this.workflowExecutorMeta.getRunConfigurationName())) {
                this.wRunConfiguration.select(0);
            } else {
                this.wRunConfiguration.setText(this.workflowExecutorMeta.getRunConfigurationName());
            }
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting workflow run configurations", (Throwable)e);
        }
        try {
            Object[] prevTransforms = this.pipelineMeta.getTransformNames();
            Arrays.sort(prevTransforms);
            this.wExecutionResultTarget.setItems((String[])prevTransforms);
            this.wResultFilesTarget.setItems((String[])prevTransforms);
            this.wResultRowsTarget.setItems((String[])prevTransforms);
            String[] inputFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta).getFieldNames();
            this.parameterColumns[1].setComboValues(inputFields);
            this.wGroupField.setItems(inputFields);
        }
        catch (Exception e) {
            this.log.logError("couldn't get previous transform list", (Throwable)e);
        }
        this.wGroupSize.setText(Const.NVL((String)this.workflowExecutorMeta.getGroupSize(), (String)""));
        this.wGroupTime.setText(Const.NVL((String)this.workflowExecutorMeta.getGroupTime(), (String)""));
        this.wGroupField.setText(Const.NVL((String)this.workflowExecutorMeta.getGroupField(), (String)""));
        this.wExecutionResultTarget.setText(this.workflowExecutorMeta.getExecutionResultTargetTransformMeta() == null ? "" : this.workflowExecutorMeta.getExecutionResultTargetTransformMeta().getName());
        this.tiExecutionTimeField.setText(FIELD_NAME, Const.NVL((String)this.workflowExecutorMeta.getExecutionTimeField(), (String)""));
        this.tiExecutionResultField.setText(FIELD_NAME, Const.NVL((String)this.workflowExecutorMeta.getExecutionResultField(), (String)""));
        this.tiExecutionNrErrorsField.setText(FIELD_NAME, Const.NVL((String)this.workflowExecutorMeta.getExecutionNrErrorsField(), (String)""));
        this.tiExecutionLinesReadField.setText(FIELD_NAME, Const.NVL((String)this.workflowExecutorMeta.getExecutionLinesReadField(), (String)""));
        this.tiExecutionLinesWrittenField.setText(FIELD_NAME, Const.NVL((String)this.workflowExecutorMeta.getExecutionLinesWrittenField(), (String)""));
        this.tiExecutionLinesInputField.setText(FIELD_NAME, Const.NVL((String)this.workflowExecutorMeta.getExecutionLinesInputField(), (String)""));
        this.tiExecutionLinesOutputField.setText(FIELD_NAME, Const.NVL((String)this.workflowExecutorMeta.getExecutionLinesOutputField(), (String)""));
        this.tiExecutionLinesRejectedField.setText(FIELD_NAME, Const.NVL((String)this.workflowExecutorMeta.getExecutionLinesRejectedField(), (String)""));
        this.tiExecutionLinesUpdatedField.setText(FIELD_NAME, Const.NVL((String)this.workflowExecutorMeta.getExecutionLinesUpdatedField(), (String)""));
        this.tiExecutionLinesDeletedField.setText(FIELD_NAME, Const.NVL((String)this.workflowExecutorMeta.getExecutionLinesDeletedField(), (String)""));
        this.tiExecutionFilesRetrievedField.setText(FIELD_NAME, Const.NVL((String)this.workflowExecutorMeta.getExecutionFilesRetrievedField(), (String)""));
        this.tiExecutionExitStatusField.setText(FIELD_NAME, Const.NVL((String)this.workflowExecutorMeta.getExecutionExitStatusField(), (String)""));
        this.tiExecutionLogTextField.setText(FIELD_NAME, Const.NVL((String)this.workflowExecutorMeta.getExecutionLogTextField(), (String)""));
        this.tiExecutionLogChannelIdField.setText(FIELD_NAME, Const.NVL((String)this.workflowExecutorMeta.getExecutionLogChannelIdField(), (String)""));
        this.wResultFilesTarget.setText(this.workflowExecutorMeta.getResultFilesTargetTransformMeta() == null ? "" : this.workflowExecutorMeta.getResultFilesTargetTransformMeta().getName());
        this.wResultFileNameField.setText(Const.NVL((String)this.workflowExecutorMeta.getResultFilesFileNameField(), (String)""));
        this.wResultRowsTarget.setText(this.workflowExecutorMeta.getResultRowsTargetTransformMeta() == null ? "" : this.workflowExecutorMeta.getResultRowsTargetTransformMeta().getName());
        for (int i = 0; i < this.workflowExecutorMeta.getResultRowsField().length; ++i) {
            TableItem item = new TableItem(this.wResultRowsFields.table, 0);
            item.setText(1, Const.NVL((String)this.workflowExecutorMeta.getResultRowsField()[i], (String)""));
            item.setText(2, ValueMetaFactory.getValueMetaName((int)this.workflowExecutorMeta.getResultRowsType()[i]));
            int length = this.workflowExecutorMeta.getResultRowsLength()[i];
            item.setText(3, length < 0 ? "" : Integer.toString(length));
            int precision = this.workflowExecutorMeta.getResultRowsPrecision()[i];
            item.setText(4, precision < 0 ? "" : Integer.toString(precision));
        }
        this.wResultRowsFields.removeEmptyRows();
        this.wResultRowsFields.setRowNums();
        this.wResultRowsFields.optWidth(true);
        this.wTabFolder.setSelection(0);
        try {
            this.loadWorkflow();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setFlags();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void addParametersTab() {
        CTabItem wParametersTab = new CTabItem(this.wTabFolder, 0);
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.Parameters.Title", (String[])new String[0]));
        wParametersTab.setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.Parameters.Tooltip", (String[])new String[0]));
        Composite wParametersComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wParametersComposite);
        FormLayout parameterTabLayout = new FormLayout();
        parameterTabLayout.marginWidth = 15;
        parameterTabLayout.marginHeight = 15;
        wParametersComposite.setLayout((Layout)parameterTabLayout);
        this.wGetParameters = new Button(wParametersComposite, 8);
        this.wGetParameters.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.Parameters.GetParameters", (String[])new String[0]));
        this.props.setLook((Control)this.wGetParameters);
        FormData fdGetParameters = new FormData();
        fdGetParameters.bottom = new FormAttachment(100, 0);
        fdGetParameters.right = new FormAttachment(100, 0);
        this.wGetParameters.setLayoutData((Object)fdGetParameters);
        this.wGetParameters.setSelection(this.workflowExecutorMeta.getParameters().isInheritingAllVariables());
        this.wGetParameters.addListener(13, e -> this.getParametersFromWorkflow(null));
        this.parameterColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.Parameters.column.Variable", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.Parameters.column.Field", (String[])new String[0]), 2, new String[0], false), new ColumnInfo(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.Parameters.column.Input", (String[])new String[0]), 1, false, false)};
        this.parameterColumns[1].setUsingVariables(true);
        WorkflowExecutorParameters parameters = this.workflowExecutorMeta.getParameters();
        this.wWorkflowExecutorParameters = new TableView(this.variables, wParametersComposite, 67588, this.parameterColumns, parameters.getVariable().length, this.lsMod, this.props);
        this.props.setLook((Control)this.wWorkflowExecutorParameters);
        FormData fdJobExecutors = new FormData();
        fdJobExecutors.left = new FormAttachment(0, 0);
        fdJobExecutors.right = new FormAttachment(100, 0);
        fdJobExecutors.top = new FormAttachment(0, 0);
        fdJobExecutors.bottom = new FormAttachment((Control)this.wGetParameters, -10);
        this.wWorkflowExecutorParameters.setLayoutData((Object)fdJobExecutors);
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            TableItem tableItem = this.wWorkflowExecutorParameters.table.getItem(i);
            tableItem.setText(1, Const.NVL((String)parameters.getVariable()[i], (String)""));
            tableItem.setText(2, Const.NVL((String)parameters.getField()[i], (String)""));
            tableItem.setText(3, Const.NVL((String)parameters.getInput()[i], (String)""));
        }
        this.wWorkflowExecutorParameters.setRowNums();
        this.wWorkflowExecutorParameters.optWidth(true);
        this.wInheritAll = new Button(wParametersComposite, 32);
        this.wInheritAll.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.Parameters.InheritAll", (String[])new String[0]));
        this.props.setLook((Control)this.wInheritAll);
        FormData fdInheritAll = new FormData();
        fdInheritAll.left = new FormAttachment(0, 0);
        fdInheritAll.top = new FormAttachment((Control)this.wWorkflowExecutorParameters, 15);
        this.wInheritAll.setLayoutData((Object)fdInheritAll);
        this.wInheritAll.setSelection(this.workflowExecutorMeta.getParameters().isInheritingAllVariables());
        FormData fdParametersComposite = new FormData();
        fdParametersComposite.left = new FormAttachment(0, 0);
        fdParametersComposite.top = new FormAttachment(0, 0);
        fdParametersComposite.right = new FormAttachment(100, 0);
        fdParametersComposite.bottom = new FormAttachment(100, 0);
        wParametersComposite.setLayoutData((Object)fdParametersComposite);
        wParametersComposite.layout();
        wParametersTab.setControl((Control)wParametersComposite);
    }

    protected void getParametersFromWorkflow(WorkflowMeta inputWorkflowMeta) {
        try {
            if (inputWorkflowMeta == null) {
                this.loadWorkflow();
                inputWorkflowMeta = this.executorWorkflowMeta;
            }
            String[] parameters = inputWorkflowMeta.listParameters();
            for (int i = 0; i < parameters.length; ++i) {
                TableItem item = new TableItem(this.wWorkflowExecutorParameters.table, 0);
                item.setText(1, Const.NVL((String)parameters[i], (String)""));
            }
            this.wWorkflowExecutorParameters.removeEmptyRows();
            this.wWorkflowExecutorParameters.setRowNums();
            this.wWorkflowExecutorParameters.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ErrorLoadingSpecifiedJob.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ErrorLoadingSpecifiedJob.Message", (String[])new String[0]), e);
        }
    }

    private void addRowGroupTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.RowGroup.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.RowGroup.Tooltip", (String[])new String[0]));
        Composite wInputComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlGroupSize = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlGroupSize);
        this.wlGroupSize.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.GroupSize.Label", (String[])new String[0]));
        FormData fdlGroupSize = new FormData();
        fdlGroupSize.top = new FormAttachment(0, 0);
        fdlGroupSize.left = new FormAttachment(0, 0);
        this.wlGroupSize.setLayoutData((Object)fdlGroupSize);
        this.wGroupSize = new TextVar(this.variables, wInputComposite, 18436);
        this.props.setLook((Control)this.wGroupSize);
        this.wGroupSize.addModifyListener(this.lsMod);
        FormData fdGroupSize = new FormData();
        fdGroupSize.width = 250;
        fdGroupSize.top = new FormAttachment((Control)this.wlGroupSize, 5);
        fdGroupSize.left = new FormAttachment(0, 0);
        this.wGroupSize.setLayoutData((Object)fdGroupSize);
        this.wlGroupField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlGroupField);
        this.wlGroupField.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.GroupField.Label", (String[])new String[0]));
        FormData fdlGroupField = new FormData();
        fdlGroupField.top = new FormAttachment((Control)this.wGroupSize, 10);
        fdlGroupField.left = new FormAttachment(0, 0);
        this.wlGroupField.setLayoutData((Object)fdlGroupField);
        this.wGroupField = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wGroupField);
        this.wGroupField.addModifyListener(this.lsMod);
        FormData fdGroupField = new FormData();
        fdGroupField.width = 250;
        fdGroupField.top = new FormAttachment((Control)this.wlGroupField, 5);
        fdGroupField.left = new FormAttachment(0, 0);
        this.wGroupField.setLayoutData((Object)fdGroupField);
        this.wlGroupTime = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlGroupTime);
        this.wlGroupTime.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.GroupTime.Label", (String[])new String[0]));
        FormData fdlGroupTime = new FormData();
        fdlGroupTime.top = new FormAttachment((Control)this.wGroupField, 10);
        fdlGroupTime.left = new FormAttachment(0, 0);
        this.wlGroupTime.setLayoutData((Object)fdlGroupTime);
        this.wGroupTime = new TextVar(this.variables, wInputComposite, 18436);
        this.props.setLook((Control)this.wGroupTime);
        this.wGroupTime.addModifyListener(this.lsMod);
        FormData fdGroupTime = new FormData();
        fdGroupTime.width = 250;
        fdGroupTime.top = new FormAttachment((Control)this.wlGroupTime, 5);
        fdGroupTime.left = new FormAttachment(0, 0);
        this.wGroupTime.setLayoutData((Object)fdGroupTime);
        wTab.setControl((Control)wInputComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addExecutionResultTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionResults.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionResults.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlExecutionResultTarget = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionResultTarget);
        this.wlExecutionResultTarget.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionResultTarget.Label", (String[])new String[0]));
        FormData fdlExecutionResultTarget = new FormData();
        fdlExecutionResultTarget.top = new FormAttachment(0, 0);
        fdlExecutionResultTarget.left = new FormAttachment(0, 0);
        this.wlExecutionResultTarget.setLayoutData((Object)fdlExecutionResultTarget);
        this.wExecutionResultTarget = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionResultTarget);
        this.wExecutionResultTarget.addModifyListener(this.lsMod);
        FormData fdExecutionResultTarget = new FormData();
        fdExecutionResultTarget.width = 250;
        fdExecutionResultTarget.top = new FormAttachment((Control)this.wlExecutionResultTarget, 5);
        fdExecutionResultTarget.left = new FormAttachment(0, 0);
        this.wExecutionResultTarget.setLayoutData((Object)fdExecutionResultTarget);
        ColumnInfo[] executionResultColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.ExecutionResults.FieldDescription.Label", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.ExecutionResults.FieldName.Label", (String[])new String[0]), 1, false, false)};
        executionResultColumns[1].setUsingVariables(true);
        TableView wExecutionResults = new TableView(this.variables, wInputComposite, 67588, executionResultColumns, 14, true, this.lsMod, this.props, false);
        this.props.setLook((Control)wExecutionResults);
        FormData fdExecutionResults = new FormData();
        fdExecutionResults.left = new FormAttachment(0);
        fdExecutionResults.right = new FormAttachment(100);
        fdExecutionResults.top = new FormAttachment((Control)this.wExecutionResultTarget, 10);
        fdExecutionResults.bottom = new FormAttachment(100);
        wExecutionResults.setLayoutData((Object)fdExecutionResults);
        wExecutionResults.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 50, 50}));
        int index = 0;
        this.tiExecutionTimeField = wExecutionResults.table.getItem(index++);
        this.tiExecutionResultField = wExecutionResults.table.getItem(index++);
        this.tiExecutionNrErrorsField = wExecutionResults.table.getItem(index++);
        this.tiExecutionLinesReadField = wExecutionResults.table.getItem(index++);
        this.tiExecutionLinesWrittenField = wExecutionResults.table.getItem(index++);
        this.tiExecutionLinesInputField = wExecutionResults.table.getItem(index++);
        this.tiExecutionLinesOutputField = wExecutionResults.table.getItem(index++);
        this.tiExecutionLinesRejectedField = wExecutionResults.table.getItem(index++);
        this.tiExecutionLinesUpdatedField = wExecutionResults.table.getItem(index++);
        this.tiExecutionLinesDeletedField = wExecutionResults.table.getItem(index++);
        this.tiExecutionFilesRetrievedField = wExecutionResults.table.getItem(index++);
        this.tiExecutionExitStatusField = wExecutionResults.table.getItem(index++);
        this.tiExecutionLogTextField = wExecutionResults.table.getItem(index++);
        this.tiExecutionLogChannelIdField = wExecutionResults.table.getItem(index++);
        this.tiExecutionTimeField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionTimeField.Label", (String[])new String[0]));
        this.tiExecutionResultField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionResultField.Label", (String[])new String[0]));
        this.tiExecutionNrErrorsField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionNrErrorsField.Label", (String[])new String[0]));
        this.tiExecutionLinesReadField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionLinesReadField.Label", (String[])new String[0]));
        this.tiExecutionLinesWrittenField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionLinesWrittenField.Label", (String[])new String[0]));
        this.tiExecutionLinesInputField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionLinesInputField.Label", (String[])new String[0]));
        this.tiExecutionLinesOutputField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionLinesOutputField.Label", (String[])new String[0]));
        this.tiExecutionLinesRejectedField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionLinesRejectedField.Label", (String[])new String[0]));
        this.tiExecutionLinesUpdatedField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionLinesUpdatedField.Label", (String[])new String[0]));
        this.tiExecutionLinesDeletedField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionLinesDeletedField.Label", (String[])new String[0]));
        this.tiExecutionFilesRetrievedField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionFilesRetrievedField.Label", (String[])new String[0]));
        this.tiExecutionExitStatusField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionExitStatusField.Label", (String[])new String[0]));
        this.tiExecutionLogTextField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionLogTextField.Label", (String[])new String[0]));
        this.tiExecutionLogChannelIdField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ExecutionLogChannelIdField.Label", (String[])new String[0]));
        this.wWorkflowExecutorParameters.setRowNums();
        this.wWorkflowExecutorParameters.optWidth(true);
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addResultFilesTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ResultFiles.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ResultFiles.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlResultFilesTarget = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlResultFilesTarget);
        this.wlResultFilesTarget.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ResultFilesTarget.Label", (String[])new String[0]));
        FormData fdlResultFilesTarget = new FormData();
        fdlResultFilesTarget.top = new FormAttachment(0, 0);
        fdlResultFilesTarget.left = new FormAttachment(0, 0);
        this.wlResultFilesTarget.setLayoutData((Object)fdlResultFilesTarget);
        this.wResultFilesTarget = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wResultFilesTarget);
        this.wResultFilesTarget.addModifyListener(this.lsMod);
        FormData fdResultFilesTarget = new FormData();
        fdResultFilesTarget.width = 250;
        fdResultFilesTarget.top = new FormAttachment((Control)this.wlResultFilesTarget, 5);
        fdResultFilesTarget.left = new FormAttachment(0, 0);
        this.wResultFilesTarget.setLayoutData((Object)fdResultFilesTarget);
        this.wlResultFileNameField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlResultFileNameField);
        this.wlResultFileNameField.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ResultFileNameField.Label", (String[])new String[0]));
        FormData fdlResultFileNameField = new FormData();
        fdlResultFileNameField.top = new FormAttachment((Control)this.wResultFilesTarget, 10);
        fdlResultFileNameField.left = new FormAttachment(0, 0);
        this.wlResultFileNameField.setLayoutData((Object)fdlResultFileNameField);
        this.wResultFileNameField = new TextVar(this.variables, wInputComposite, 18436);
        this.props.setLook((Control)this.wResultFileNameField);
        this.wResultFileNameField.addModifyListener(this.lsMod);
        FormData fdResultFileNameField = new FormData();
        fdResultFileNameField.width = 250;
        fdResultFileNameField.top = new FormAttachment((Control)this.wlResultFileNameField, 5);
        fdResultFileNameField.left = new FormAttachment(0, 0);
        this.wResultFileNameField.setLayoutData((Object)fdResultFileNameField);
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addResultRowsTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ResultRows.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ResultRows.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlResultRowsTarget = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlResultRowsTarget);
        this.wlResultRowsTarget.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ResultRowsTarget.Label", (String[])new String[0]));
        FormData fdlResultRowsTarget = new FormData();
        fdlResultRowsTarget.top = new FormAttachment(0, 0);
        fdlResultRowsTarget.left = new FormAttachment(0, 0);
        this.wlResultRowsTarget.setLayoutData((Object)fdlResultRowsTarget);
        this.wResultRowsTarget = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wResultRowsTarget);
        this.wResultRowsTarget.addModifyListener(this.lsMod);
        FormData fdResultRowsTarget = new FormData();
        fdResultRowsTarget.width = 250;
        fdResultRowsTarget.top = new FormAttachment((Control)this.wlResultRowsTarget, 5);
        fdResultRowsTarget.left = new FormAttachment(0, 0);
        this.wResultRowsTarget.setLayoutData((Object)fdResultRowsTarget);
        this.wlResultFields = new Label(wInputComposite, 0);
        this.wlResultFields.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ResultFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlResultFields);
        FormData fdlResultFields = new FormData();
        fdlResultFields.left = new FormAttachment(0, 0);
        fdlResultFields.top = new FormAttachment((Control)this.wResultRowsTarget, 10);
        this.wlResultFields.setLayoutData((Object)fdlResultFields);
        int nrRows = this.workflowExecutorMeta.getResultRowsField() != null ? this.workflowExecutorMeta.getResultRowsField().length : 1;
        ColumnInfo[] ciResultFields = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ColumnInfo.Field", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false)};
        this.wResultRowsFields = new TableView(this.variables, wInputComposite, 68354, ciResultFields, nrRows, false, this.lsMod, this.props, false);
        FormData fdResultFields = new FormData();
        fdResultFields.left = new FormAttachment(0, 0);
        fdResultFields.top = new FormAttachment((Control)this.wlResultFields, 5);
        fdResultFields.right = new FormAttachment(100, 0);
        fdResultFields.bottom = new FormAttachment(100, 0);
        this.wResultRowsFields.setLayoutData((Object)fdResultFields);
        this.wResultRowsFields.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 25, 25, 25, 25}));
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void setFlags() {
        if (this.wlGroupSize == null || this.wlGroupSize == null || this.wlGroupField == null || this.wGroupField == null || this.wlGroupTime == null || this.wGroupTime == null) {
            return;
        }
        boolean enableSize = Const.toInt((String)this.variables.resolve(this.wGroupSize.getText()), (int)-1) >= 0;
        boolean enableField = !Utils.isEmpty((CharSequence)this.wGroupField.getText());
        this.wlGroupSize.setEnabled(true);
        this.wGroupSize.setEnabled(true);
        this.wlGroupField.setEnabled(!enableSize);
        this.wGroupField.setEnabled(!enableSize);
        this.wlGroupTime.setEnabled(!enableSize && !enableField);
        this.wGroupTime.setEnabled(!enableSize && !enableField);
    }

    private void cancel() {
        this.transformName = null;
        this.workflowExecutorMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        try {
            this.loadWorkflow();
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ErrorLoadingSpecifiedJob.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ErrorLoadingSpecifiedJob.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        this.workflowExecutorMeta.setFilename(this.wPath.getText());
        this.workflowExecutorMeta.setRunConfigurationName(this.wRunConfiguration.getText());
        this.collectInformation();
        this.workflowExecutorMeta.searchInfoAndTargetTransforms(this.pipelineMeta.getTransforms());
        this.workflowExecutorMeta.setChanged(true);
        this.dispose();
    }

    private void collectInformation() {
        WorkflowExecutorParameters parameters = this.workflowExecutorMeta.getParameters();
        int nrLines = this.wWorkflowExecutorParameters.nrNonEmpty();
        String[] variables = new String[nrLines];
        String[] fields = new String[nrLines];
        String[] input = new String[nrLines];
        parameters.setVariable(variables);
        parameters.setField(fields);
        parameters.setInput(input);
        for (int i = 0; i < nrLines; ++i) {
            TableItem item = this.wWorkflowExecutorParameters.getNonEmpty(i);
            variables[i] = item.getText(1);
            fields[i] = item.getText(2);
            input[i] = item.getText(3);
        }
        parameters.setInheritingAllVariables(this.wInheritAll.getSelection());
        this.workflowExecutorMeta.setGroupSize(this.wGroupSize.getText());
        this.workflowExecutorMeta.setGroupField(this.wGroupField.getText());
        this.workflowExecutorMeta.setGroupTime(this.wGroupTime.getText());
        this.workflowExecutorMeta.setExecutionResultTargetTransform(this.wExecutionResultTarget.getText());
        this.workflowExecutorMeta.setExecutionResultTargetTransformMeta(this.pipelineMeta.findTransform(this.wExecutionResultTarget.getText()));
        this.workflowExecutorMeta.setExecutionTimeField(this.tiExecutionTimeField.getText(FIELD_NAME));
        this.workflowExecutorMeta.setExecutionResultField(this.tiExecutionResultField.getText(FIELD_NAME));
        this.workflowExecutorMeta.setExecutionNrErrorsField(this.tiExecutionNrErrorsField.getText(FIELD_NAME));
        this.workflowExecutorMeta.setExecutionLinesReadField(this.tiExecutionLinesReadField.getText(FIELD_NAME));
        this.workflowExecutorMeta.setExecutionLinesWrittenField(this.tiExecutionLinesWrittenField.getText(FIELD_NAME));
        this.workflowExecutorMeta.setExecutionLinesInputField(this.tiExecutionLinesInputField.getText(FIELD_NAME));
        this.workflowExecutorMeta.setExecutionLinesOutputField(this.tiExecutionLinesOutputField.getText(FIELD_NAME));
        this.workflowExecutorMeta.setExecutionLinesRejectedField(this.tiExecutionLinesRejectedField.getText(FIELD_NAME));
        this.workflowExecutorMeta.setExecutionLinesUpdatedField(this.tiExecutionLinesUpdatedField.getText(FIELD_NAME));
        this.workflowExecutorMeta.setExecutionLinesDeletedField(this.tiExecutionLinesDeletedField.getText(FIELD_NAME));
        this.workflowExecutorMeta.setExecutionFilesRetrievedField(this.tiExecutionFilesRetrievedField.getText(FIELD_NAME));
        this.workflowExecutorMeta.setExecutionExitStatusField(this.tiExecutionExitStatusField.getText(FIELD_NAME));
        this.workflowExecutorMeta.setExecutionLogTextField(this.tiExecutionLogTextField.getText(FIELD_NAME));
        this.workflowExecutorMeta.setExecutionLogChannelIdField(this.tiExecutionLogChannelIdField.getText(FIELD_NAME));
        this.workflowExecutorMeta.setResultFilesTargetTransform(this.wResultFilesTarget.getText());
        this.workflowExecutorMeta.setResultFilesTargetTransformMeta(this.pipelineMeta.findTransform(this.wResultFilesTarget.getText()));
        this.workflowExecutorMeta.setResultFilesFileNameField(this.wResultFileNameField.getText());
        this.workflowExecutorMeta.setResultRowsTargetTransform(this.wResultRowsTarget.getText());
        this.workflowExecutorMeta.setResultRowsTargetTransformMeta(this.pipelineMeta.findTransform(this.wResultRowsTarget.getText()));
        int nrFields = this.wResultRowsFields.nrNonEmpty();
        this.workflowExecutorMeta.setResultRowsField(new String[nrFields]);
        this.workflowExecutorMeta.setResultRowsType(new int[nrFields]);
        this.workflowExecutorMeta.setResultRowsLength(new int[nrFields]);
        this.workflowExecutorMeta.setResultRowsPrecision(new int[nrFields]);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wResultRowsFields.getNonEmpty(i);
            this.workflowExecutorMeta.getResultRowsField()[i] = item.getText(1);
            this.workflowExecutorMeta.getResultRowsType()[i] = ValueMetaFactory.getIdForValueMeta((String)item.getText(2));
            this.workflowExecutorMeta.getResultRowsLength()[i] = Const.toInt((String)item.getText(3), (int)-1);
            this.workflowExecutorMeta.getResultRowsPrecision()[i] = Const.toInt((String)item.getText(4), (int)-1);
        }
    }
}

