/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory;

import java.io.Serializable;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.util.Preconditions;

public class JvmMetaspaceAndOverhead
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MemorySize metaspace;
    private final MemorySize overhead;

    public JvmMetaspaceAndOverhead(MemorySize jvmMetaspace, MemorySize jvmOverhead) {
        this.metaspace = (MemorySize)Preconditions.checkNotNull((Object)jvmMetaspace);
        this.overhead = (MemorySize)Preconditions.checkNotNull((Object)jvmOverhead);
    }

    MemorySize getTotalJvmMetaspaceAndOverheadSize() {
        return this.getMetaspace().add(this.getOverhead());
    }

    public MemorySize getMetaspace() {
        return this.metaspace;
    }

    public MemorySize getOverhead() {
        return this.overhead;
    }
}

