/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.taskmanager.UnresolvedTaskManagerLocation;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerLocation
implements Comparable<TaskManagerLocation>,
Serializable {
    private static final long serialVersionUID = -8254407801276350716L;
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerLocation.class);
    private final ResourceID resourceID;
    private final InetAddress inetAddress;
    private final HostNameSupplier hostNameSupplier;
    private final int dataPort;
    private String stringRepresentation;

    @VisibleForTesting
    public TaskManagerLocation(ResourceID resourceID, InetAddress inetAddress, int dataPort, HostNameSupplier hostNameSupplier) {
        Preconditions.checkArgument((dataPort > 0 || dataPort == -1 ? 1 : 0) != 0, (Object)"dataPort must be > 0, or -1 (local)");
        this.resourceID = (ResourceID)Preconditions.checkNotNull((Object)resourceID);
        this.inetAddress = (InetAddress)Preconditions.checkNotNull((Object)inetAddress);
        this.dataPort = dataPort;
        this.hostNameSupplier = (HostNameSupplier)Preconditions.checkNotNull((Object)hostNameSupplier);
    }

    @VisibleForTesting
    public TaskManagerLocation(ResourceID resourceID, InetAddress inetAddress, int dataPort) {
        this(resourceID, inetAddress, dataPort, new DefaultHostNameSupplier(inetAddress));
    }

    public static TaskManagerLocation fromUnresolvedLocation(UnresolvedTaskManagerLocation unresolvedLocation, ResolutionMode resolutionMode) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(unresolvedLocation.getExternalAddress());
        switch (resolutionMode) {
            case RETRIEVE_HOST_NAME: {
                return new TaskManagerLocation(unresolvedLocation.getResourceID(), inetAddress, unresolvedLocation.getDataPort(), new DefaultHostNameSupplier(inetAddress));
            }
            case USE_IP_ONLY: {
                return new TaskManagerLocation(unresolvedLocation.getResourceID(), inetAddress, unresolvedLocation.getDataPort(), new IpOnlyHostNameSupplier(inetAddress));
            }
        }
        throw new UnsupportedOperationException("Unsupported resolution mode provided.");
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }

    public int dataPort() {
        return this.dataPort;
    }

    public InetAddress address() {
        return this.inetAddress;
    }

    public String addressString() {
        return this.inetAddress.toString();
    }

    public String getFQDNHostname() {
        return this.hostNameSupplier.getFqdnHostName();
    }

    public String getHostname() {
        return this.hostNameSupplier.getHostName();
    }

    private static String getFqdnHostName(InetAddress inetAddress) {
        String fqdnHostName;
        try {
            fqdnHostName = inetAddress.getCanonicalHostName();
        }
        catch (Throwable t) {
            LOG.warn("Unable to determine the canonical hostname. Input split assignment (such as for HDFS files) may be non-local when the canonical hostname is missing.");
            LOG.debug("getCanonicalHostName() Exception:", t);
            fqdnHostName = inetAddress.getHostAddress();
        }
        return fqdnHostName;
    }

    public static String getHostName(InetAddress inetAddress) {
        String hostName;
        String fqdnHostName = TaskManagerLocation.getFqdnHostName(inetAddress);
        if (fqdnHostName.equals(inetAddress.getHostAddress())) {
            hostName = fqdnHostName;
            LOG.warn("No hostname could be resolved for the IP address {}, using IP address as host name. Local input split assignment (such as for HDFS files) may be impacted.", (Object)inetAddress.getHostAddress());
        } else {
            hostName = NetUtils.getHostnameFromFQDN((String)fqdnHostName);
        }
        return hostName;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = String.format("%s @ %s (dataPort=%d)", this.resourceID, this.getFQDNHostname(), this.dataPort);
        }
        return this.stringRepresentation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == TaskManagerLocation.class) {
            TaskManagerLocation that = (TaskManagerLocation)obj;
            return this.resourceID.equals(that.resourceID) && this.inetAddress.equals(that.inetAddress) && this.dataPort == that.dataPort;
        }
        return false;
    }

    public int hashCode() {
        return this.resourceID.hashCode() + 17 * this.inetAddress.hashCode() + 129 * this.dataPort;
    }

    @Override
    public int compareTo(@Nonnull TaskManagerLocation o) {
        byte[] otherAddress;
        int resourceIdCmp = this.resourceID.getResourceIdString().compareTo(o.resourceID.getResourceIdString());
        if (resourceIdCmp != 0) {
            return resourceIdCmp;
        }
        byte[] thisAddress = this.inetAddress.getAddress();
        if (thisAddress.length < (otherAddress = o.inetAddress.getAddress()).length) {
            return -1;
        }
        if (thisAddress.length > otherAddress.length) {
            return 1;
        }
        for (int i = 0; i < thisAddress.length; ++i) {
            byte tb = thisAddress[i];
            byte ob = otherAddress[i];
            if (tb < ob) {
                return -1;
            }
            if (tb <= ob) continue;
            return 1;
        }
        if (this.dataPort < o.dataPort) {
            return -1;
        }
        if (this.dataPort > o.dataPort) {
            return 1;
        }
        return 0;
    }

    public static enum ResolutionMode {
        RETRIEVE_HOST_NAME,
        USE_IP_ONLY;

    }

    @VisibleForTesting
    public static class IpOnlyHostNameSupplier
    implements HostNameSupplier {
        private final InetAddress inetAddress;

        public IpOnlyHostNameSupplier(InetAddress inetAddress) {
            this.inetAddress = inetAddress;
        }

        @Override
        public String getHostName() {
            return this.inetAddress.getHostAddress();
        }

        @Override
        public String getFqdnHostName() {
            return this.inetAddress.getHostAddress();
        }
    }

    @VisibleForTesting
    public static class DefaultHostNameSupplier
    implements HostNameSupplier {
        private final InetAddress inetAddress;
        private String hostName;
        private String fqdnHostName;

        public DefaultHostNameSupplier(InetAddress inetAddress) {
            this.inetAddress = inetAddress;
        }

        @Override
        public String getHostName() {
            if (this.hostName == null) {
                this.hostName = TaskManagerLocation.getHostName(this.inetAddress);
            }
            return this.hostName;
        }

        @Override
        public String getFqdnHostName() {
            if (this.fqdnHostName == null) {
                this.fqdnHostName = TaskManagerLocation.getFqdnHostName(this.inetAddress);
            }
            return this.fqdnHostName;
        }
    }

    public static interface HostNameSupplier
    extends Serializable {
        public String getHostName();

        public String getFqdnHostName();
    }
}

