/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.InternalPriorityQueue;
import org.apache.flink.runtime.state.KeyExtractorFunction;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.KeyGroupedInternalPriorityQueue;
import org.apache.flink.runtime.state.PriorityComparator;
import org.apache.flink.runtime.state.heap.HeapPriorityQueue;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.IOUtils;

public class KeyGroupPartitionedPriorityQueue<T, PQ extends InternalPriorityQueue<T> & HeapPriorityQueueElement>
implements InternalPriorityQueue<T>,
KeyGroupedInternalPriorityQueue<T> {
    @Nonnull
    private final HeapPriorityQueue<PQ> heapOfKeyGroupedHeaps;
    @Nonnull
    private final PQ[] keyGroupedHeaps;
    @Nonnull
    private final KeyExtractorFunction<T> keyExtractor;
    @Nonnegative
    private final int totalKeyGroups;
    @Nonnegative
    private final int firstKeyGroup;

    public KeyGroupPartitionedPriorityQueue(@Nonnull KeyExtractorFunction<T> keyExtractor, @Nonnull PriorityComparator<T> elementPriorityComparator, @Nonnull PartitionQueueSetFactory<T, PQ> orderedCacheFactory, @Nonnull KeyGroupRange keyGroupRange, @Nonnegative int totalKeyGroups) {
        this.keyExtractor = keyExtractor;
        this.totalKeyGroups = totalKeyGroups;
        this.firstKeyGroup = keyGroupRange.getStartKeyGroup();
        this.keyGroupedHeaps = new InternalPriorityQueue[keyGroupRange.getNumberOfKeyGroups()];
        this.heapOfKeyGroupedHeaps = new HeapPriorityQueue(new InternalPriorityQueueComparator(elementPriorityComparator), keyGroupRange.getNumberOfKeyGroups());
        for (int i = 0; i < this.keyGroupedHeaps.length; ++i) {
            PQ keyGroupSubHeap = orderedCacheFactory.create(this.firstKeyGroup + i, totalKeyGroups, keyExtractor, elementPriorityComparator);
            this.keyGroupedHeaps[i] = keyGroupSubHeap;
            this.heapOfKeyGroupedHeaps.add((PQ)((HeapPriorityQueueElement)keyGroupSubHeap));
        }
    }

    @Override
    @Nullable
    public T poll() {
        InternalPriorityQueue headList = (InternalPriorityQueue)this.heapOfKeyGroupedHeaps.peek();
        Object head = headList.poll();
        this.heapOfKeyGroupedHeaps.adjustModifiedElement((HeapPriorityQueueElement)((Object)headList));
        return head;
    }

    @Override
    @Nullable
    public T peek() {
        return ((InternalPriorityQueue)this.heapOfKeyGroupedHeaps.peek()).peek();
    }

    @Override
    public boolean add(@Nonnull T toAdd) {
        PQ list = this.getKeyGroupSubHeapForElement(toAdd);
        if (list.add(toAdd)) {
            this.heapOfKeyGroupedHeaps.adjustModifiedElement((HeapPriorityQueueElement)list);
            return toAdd.equals(this.peek());
        }
        return false;
    }

    @Override
    public boolean remove(@Nonnull T toRemove) {
        PQ list = this.getKeyGroupSubHeapForElement(toRemove);
        T oldHead = this.peek();
        if (list.remove(toRemove)) {
            this.heapOfKeyGroupedHeaps.adjustModifiedElement((HeapPriorityQueueElement)list);
            return toRemove.equals(oldHead);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.peek() == null;
    }

    @Override
    public int size() {
        int sizeSum = 0;
        for (PQ list : this.keyGroupedHeaps) {
            sizeSum += list.size();
        }
        return sizeSum;
    }

    @Override
    public void addAll(@Nullable Collection<? extends T> toAdd) {
        if (toAdd == null) {
            return;
        }
        for (T element : toAdd) {
            this.add(element);
        }
    }

    @Override
    @Nonnull
    public CloseableIterator<T> iterator() {
        return new KeyGroupConcatenationIterator((InternalPriorityQueue[])this.keyGroupedHeaps);
    }

    private PQ getKeyGroupSubHeapForElement(T element) {
        return this.keyGroupedHeaps[this.computeKeyGroupIndex(element)];
    }

    private int computeKeyGroupIndex(T element) {
        Object extractKeyFromElement = this.keyExtractor.extractKeyFromElement(element);
        int keyGroupId = KeyGroupRangeAssignment.assignToKeyGroup(extractKeyFromElement, this.totalKeyGroups);
        return this.globalKeyGroupToLocalIndex(keyGroupId);
    }

    private int globalKeyGroupToLocalIndex(int keyGroupId) {
        return keyGroupId - this.firstKeyGroup;
    }

    @Override
    @Nonnull
    public Set<T> getSubsetForKeyGroup(int keyGroupId) {
        HashSet<Object> result = new HashSet<Object>();
        PQ partitionQueue = this.keyGroupedHeaps[this.globalKeyGroupToLocalIndex(keyGroupId)];
        try (CloseableIterator iterator = partitionQueue.iterator();){
            while (iterator.hasNext()) {
                result.add(iterator.next());
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Exception while iterating key group.", (Throwable)e);
        }
        return result;
    }

    public static interface PartitionQueueSetFactory<T, PQS extends InternalPriorityQueue<T> & HeapPriorityQueueElement> {
        @Nonnull
        public PQS create(@Nonnegative int var1, @Nonnegative int var2, @Nonnull KeyExtractorFunction<T> var3, @Nonnull PriorityComparator<T> var4);
    }

    private static final class InternalPriorityQueueComparator<T, Q extends InternalPriorityQueue<T>>
    implements PriorityComparator<Q> {
        @Nonnull
        private final PriorityComparator<T> elementPriorityComparator;

        InternalPriorityQueueComparator(@Nonnull PriorityComparator<T> elementPriorityComparator) {
            this.elementPriorityComparator = elementPriorityComparator;
        }

        @Override
        public int comparePriority(Q o1, Q o2) {
            Object left = o1.peek();
            Object right = o2.peek();
            if (left == null) {
                return right == null ? 0 : 1;
            }
            return right == null ? -1 : this.elementPriorityComparator.comparePriority(left, right);
        }
    }

    private static final class KeyGroupConcatenationIterator<T, PQS extends InternalPriorityQueue<T> & HeapPriorityQueueElement>
    implements CloseableIterator<T> {
        @Nonnull
        private final PQS[] keyGroupLists;
        @Nonnegative
        private int index;
        @Nonnull
        private CloseableIterator<T> current;

        private KeyGroupConcatenationIterator(@Nonnull PQS[] keyGroupLists) {
            this.keyGroupLists = keyGroupLists;
            this.index = 0;
            this.current = CloseableIterator.empty();
        }

        public boolean hasNext() {
            boolean currentHasNext = this.current.hasNext();
            while (!currentHasNext && this.index < this.keyGroupLists.length) {
                IOUtils.closeQuietly(this.current);
                this.current = this.keyGroupLists[this.index++].iterator();
                currentHasNext = this.current.hasNext();
            }
            return currentHasNext;
        }

        public T next() {
            return (T)this.current.next();
        }

        public void close() throws Exception {
            this.current.close();
        }
    }
}

